package com.ejianc.business.proequipmentcorppur.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetHandleDetailEntity;
import com.ejianc.business.proequipmentcorppur.asset.vo.AssetHandleVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.proequipmentcorppur.asset.mapper.AssetHandleMapper;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetHandleEntity;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetHandleService;

import java.util.ArrayList;
import java.util.List;

/**
 *  设备处置
 * 
 * @author generator
 * 
 */
@Service("handleService")
public class AssetHandleServiceImpl extends BaseServiceImpl<AssetHandleMapper, AssetHandleEntity> implements IAssetHandleService {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ICostDetailApi costDetailApi;


    @Override
    public CommonResponse<AssetHandleVO> pushCost(AssetHandleVO handleVO) {
        AssetHandleEntity handleEntity = baseMapper.selectById(handleVO.getId());
        if (CollectionUtils.isNotEmpty(handleVO.getHandleDetailList())) {
            List<AssetHandleDetailEntity> handleDetailEntities = BeanMapper.mapList(handleVO.getHandleDetailList(), AssetHandleDetailEntity.class);
            handleEntity.setHandleDetailList(handleDetailEntities);
        }
        super.saveOrUpdate(handleEntity, false);
        //推送数据
        this.costPush(handleEntity);
        return CommonResponse.success(BeanMapper.map(handleVO, AssetHandleVO.class));
    }

    @Override
    public void costPush(AssetHandleEntity handleEntity) {
        logger.info("开始costPush");
        List<AssetHandleDetailEntity> allotOutDetailEntities = handleEntity.getHandleDetailList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(allotOutDetailEntities)) {
            for (AssetHandleDetailEntity entity : allotOutDetailEntities) {
                if (null == entity.getSubjectId() || null == entity.getWbsId()) {
                    newRelationFlag = "0";
                    logger.info("getSubjectId"+entity.getSubjectId());
                    logger.info("getWbsId"+entity.getWbsId());
                    break;
                }
            }
        }
        if (ListUtil.isEmpty(allotOutDetailEntities)) {
            newRelationFlag = "0";
        }
        logger.info("newRelationFlag"+newRelationFlag);
        //更新是否关联
        LambdaUpdateWrapper<AssetHandleEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(AssetHandleEntity::getId, handleEntity.getId());
        updateWrapper.set(AssetHandleEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);

        //判断之前的单据是否关联
        String oldRelationFlag = handleEntity.getRelationFlag();
        //之前已关联
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                logger.info("之前已关联"+newRelationFlag);
                saveCost(handleEntity);
            }
            if (!"1".equals(newRelationFlag)) {
                //删除成本中心之前的数据
                logger.info("删除成本中心之前的数据-调拨出库Id---{}",handleEntity.getId());
                CommonResponse<String> commonResponse = costDetailApi.deleteSubject(handleEntity.getId());
                logger.info("结果"+ JSONObject.toJSONString(commonResponse));
                if(!commonResponse.isSuccess()){
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        //之前未关联
        if ("0".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                logger.info("之前未关联"+newRelationFlag);
                saveCost(handleEntity);
            }
        }
    }
    private void saveCost(AssetHandleEntity handleEntity) {
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<AssetHandleDetailEntity> handleDetailList = handleEntity.getHandleDetailList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(handleDetailList)) {
            for (AssetHandleDetailEntity entity : handleDetailList) {
                CostDetailVO costDetailVO = new CostDetailVO();
                costDetailVO.setSubjectId(entity.getSubjectId());
                costDetailVO.setSubjectCode(entity.getSubjectCode());
                costDetailVO.setSubjectName(entity.getSubjectName());
                costDetailVO.setWbsId(entity.getWbsId());
                costDetailVO.setWbsCode(entity.getWbsCode());
                costDetailVO.setWbsName(entity.getWbsName());
                costDetailVO.setSourceId(entity.getHandleId());
                costDetailVO.setSourceDetailId(entity.getId());
                costDetailVO.setHappenTaxMny(entity.getHandleDiffTaxMny());
                costDetailVO.setHappenMny(entity.getHandleTaxMny());
                costDetailVO.setHappenDate(handleEntity.getHandleDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setSourceType("ASSET_HANDLE");
                costDetailVO.setSourceTabType("ASSET_HANDLE_SUB");
                costDetailVO.setProjectId(handleEntity.getProjectId());
                //新加的
                costDetailVO.setSourceBillCode(handleEntity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.固定资产设备处置.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-proequipmentp-frontend/#/handle/handleCard?id="+handleEntity.getId());
                costDetailVOList.add(costDetailVO);
            }
        }

        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            logger.info("推送数据--------"+JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(stringCommonResponse));
            if (stringCommonResponse.isSuccess()) {
            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
}
