package com.ejianc.business.proequipmentcorprent.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorprent.ac.enums.BillPushStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.bean.*;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorprent.rent.service.*;
import com.ejianc.business.proequipmentcorprent.rent.vo.*;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.*;

@Service("rentEquipmentStop") 
public class RentEquipmentStopBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IRentParameterService rentParameterService;
	@Autowired
	private IRentEquipmentStopService stopService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IRentEquipmentStopService rentEquipmentStopService;
	@Autowired
	private IShareCooperateApi shareCooperateApi;
	@Autowired
	private IRentParameterDetailService rentParameterDetailService;
	@Autowired
	private IProSupplierApi proSupplierApi;
	private final String PUSH_DELETE_URL = "/ejc-supbusiness-web/openapi/equipmentStop/deleteStop";
	private final String OPERATE = "RENT-PROEQUIPMENT-ASTOP";
	@Autowired
	private IRentAcceptanceService rentAcceptanceService;
	private static final String BILL_TYPE = "BT220221000000004";//停用单 单据类型
	private static final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/equipmentStop/saveStop";

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		RentEquipmentStopEntity entity = rentEquipmentStopService.selectById(billId);
		if(BillPushStatusEnum.推送成功.getStatus().equals(entity.getBillPushFlag())){
			//推送供方
			//对单据进行加锁
			CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
			if (!ejcCloudSystemCode.isSuccess()) {
				throw new BusinessException("获取当前系统编码失败！");
			}
			Map<String,Object> map = new HashMap<>();
			map.put("sourceId",billId);
			map.put("systemId",ejcCloudSystemCode.getData());
			String dataInfo = JSONObject.toJSONString(map);
			Boolean updateSupplierStatus = rentAcceptanceService.updateSupplierStatus(billId, dataInfo,PUSH_DELETE_URL,RequestMethod.POST,
					entity.getSupplierId().toString(),OPERATE,BILL_TYPE);
			if (!updateSupplierStatus){
				throw new BusinessException("单据推送失败！");
			}
			entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
			rentEquipmentStopService.saveOrUpdate(entity,false);
		}
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("到设备停用了.....{}",billId);
		RentEquipmentStopEntity stopEntity =stopService.selectById(billId);

		List<RentEquipmentStopSubEntity> subEntityList = stopEntity.getRentEquipmentStopSubList();
		List<RentParameterEntity> parameterList = new ArrayList<>();
		for(RentEquipmentStopSubEntity subEntity:subEntityList) {
			// 主表赋值
			RentParameterEntity parameterEntity = new RentParameterEntity();
			parameterEntity.setId(subEntity.getSourceId());
			parameterEntity.setStopDate(stopEntity.getTypeDate());
			parameterEntity.setOperationDate(new Date());
			parameterEntity.setEquipmentState(RentEquipmentStateEnum.停用.getCode());//启动状态
			// 处理子表
			List<RentParameterDetailEntity> parameterDetailList = new ArrayList<>();
			RentParameterDetailEntity detailEntity = new RentParameterDetailEntity();
			detailEntity.setSourceType(RentParameterTypeEnum.停用单.getCode());
			detailEntity.setSourceId(stopEntity.getId());
			detailEntity.setOperationDate(stopEntity.getTypeDate());
			detailEntity.setEquipmentState(RentEquipmentStateEnum.停用.getCode());
			detailEntity.setParameterId(subEntity.getSourceId());
			parameterDetailList.add(detailEntity);

			parameterEntity.setRentParameterDetailList(parameterDetailList);
			parameterList.add(parameterEntity);
		}
		rentParameterService.changeParameter(parameterList, RentParameterTypeEnum.停用单.getCode());
		//TODO 推送供方暂时注释掉
//		//推送供方验收单处理
//		PushRentEquipmentStopVO supplierPushCheckVO = BeanMapper.map(stopEntity, PushRentEquipmentStopVO.class);
//		supplierPushCheckVO.setSourceId(stopEntity.getId());
//		List<PushRentEquipmentStopSubVO> pushRentEquipmentStopSubVOS = BeanMapper.mapList(stopEntity.getRentEquipmentStopSubList(), PushRentEquipmentStopSubVO.class);
//
//		for (PushRentEquipmentStopSubVO supplierPushCheckDetailVO : pushRentEquipmentStopSubVOS){
//			supplierPushCheckDetailVO.setSourceId(stopEntity.getId());
//			supplierPushCheckDetailVO.setSourceDetailId(supplierPushCheckDetailVO.getId());
//			supplierPushCheckDetailVO.setId(null);
//		}
//		supplierPushCheckVO.setEquipmentStopDetailList(pushRentEquipmentStopSubVOS);
//		//设置单据当前系统信息
//		CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
//		if (!ejcCloudSystemCode.isSuccess()) {
////			throw new BusinessException("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
//			logger.error("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
//		}
//		else {
//			//设置当前系统ID
//			supplierPushCheckVO.setSystemId(ejcCloudSystemCode.getData());
//			String dataInfo = JSONObject.toJSONString(supplierPushCheckVO);
//			//查询该单据是否支持协同分享，则向供方协同服务推送该单据
//			CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(billTypeCode);
//			if (!cooperateResp.isSuccess()) {
//				logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", BILL_TYPE, cooperateResp.getMsg());
//			}
//			else {
//				boolean b = rentAcceptanceService.pushBillToSupCenter(dataInfo, stopEntity.getSupplierId(),
//						stopEntity.getId(), BILL_TYPE, cooperateResp.getData(), PUSH_SAVE_URL);
//				if (!b) {
//					logger.error("推送供方失败！单据信息：{}", dataInfo);
//				}
//				else {
//					stopEntity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
//				}
//			}
//		}

		stopService.updateById(stopEntity);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		RentEquipmentStopEntity stopEntity =stopService.selectById(billId);
		EquipmentNewDateVO equipmentNewDateVO =rentParameterService.selectAbandonDate(stopEntity.getContractId(),stopEntity.getTypeDate());
		if(equipmentNewDateVO != null){
			if(!stopEntity.getId().equals(equipmentNewDateVO.getId())){
				return CommonResponse.error("弃审失败:请先弃审设备" + equipmentNewDateVO.getType() + "单据在弃审本单据");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		logger.info("到设备停用弃审流程.....{}",billId);
		RentEquipmentStopEntity stopEntity =stopService.selectById(billId);

		List<RentEquipmentStopSubEntity> subEntityList = stopEntity.getRentEquipmentStopSubList();
//		List<RentParameterEntity> parameterList = new ArrayList<>();
		List<Long> parameterIdList = new ArrayList<>();
		for(RentEquipmentStopSubEntity subEntity:subEntityList){
//			RentParameterEntity parameterEntity =rentParameterService.selectById(subEntity.getSourceId());//来源
//			parameterEntity.setStopDate(subEntity.getTypeDate());
//			parameterEntity.setOperationDate(new Date());
//			parameterEntity.setEquipmentState(2);//启动状态
//			parameterList.add(parameterEntity);
			parameterIdList.add(subEntity.getSourceId());
		}
//		rentParameterService.saveOrUpdateBatch(parameterList);
		rentParameterService.cancelParameter(parameterIdList, RentParameterTypeEnum.停用单.getCode(),
				stopEntity.getId());

		//推送供方
		//对单据进行加锁
		//TODO 推送供方暂时注释掉
//		CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
//		if (!ejcCloudSystemCode.isSuccess()) {
//			throw new BusinessException("获取当前系统编码失败！");
//		}
//		Map<String,Object> map = new HashMap<>();
//		map.put("sourceId",billId);
//		map.put("systemId",ejcCloudSystemCode.getData());
//		String dataInfo = JSONObject.toJSONString(map);
//		Boolean updateSupplierStatus = rentAcceptanceService.updateSupplierStatus(billId, dataInfo,PUSH_DELETE_URL,RequestMethod.POST,
//				stopEntity.getSupplierId().toString(),OPERATE,BILL_TYPE);
//		if (!updateSupplierStatus){
//			throw new BusinessException("单据推送失败！");
//		}
		stopEntity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
		rentEquipmentStopService.saveOrUpdate(stopEntity,false);

		return CommonResponse.success();
	}

}
