package com.ejianc.business.proequipmentcorprent.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.proequipmentcorprent.ac.bean.ContractEntity;
import com.ejianc.business.proequipmentcorprent.ac.enums.BillPushStatusEnum;
import com.ejianc.business.proequipmentcorprent.ac.vo.ContractVO;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentSettlementEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentSettlementRentalEntity;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentalSettlementStateEnum;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentContractService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentRentalService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentSettlementService;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentContractVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentSettlementVO;
import com.ejianc.business.proequipmentcorprent.settle.bean.SettleEntity;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.proequipmentcorprent.temporary.contract.bean.TemporaryContractEntity;
import com.ejianc.business.proequipmentcorprent.temporary.contract.service.ITemporaryContractService;
import com.ejianc.business.proequipmentcorprent.temporary.settlement.bean.TemporarySettlementEntity;
import com.ejianc.business.proequipmentcorprent.temporary.settlement.service.ITemporarySettlementService;
import com.ejianc.business.proequipmentcorprent.temporary.settlement.vo.TemporarySettlementVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.business.proequipmentcorprent.rent.enums.PerformanceStatusEnum;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@Service("rentSettlement") 
public class RentSettlementBpmServiceImpl implements ICommonBusinessService {

    @Autowired
    private IBillTypeApi billTypeApi;
	@Autowired
	private IRentSettlementService service;
	@Autowired
	private IRentContractService contractService;//租赁合同
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IExecutionApi executionApi;
	@Autowired
	private IRentRentalService rentRentalService;
	@Autowired
	private ICostDetailApi costDetailApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//结算单  根据 合同状态校验
		RentSettlementEntity entity = service.selectById(billId);
		if(entity.getContractId()!=null){
			RentContractEntity contractEntity = contractService.selectById(entity.getContractId());
			if(PerformanceStatusEnum.已冻结.getCode().equals(contractEntity.getContractPerformanceState()) || PerformanceStatusEnum.已作废.getCode().equals(contractEntity.getContractPerformanceState())){
				throw new BusinessException("合同{"+contractEntity.getContractName()+"},状态为："+ PerformanceStatusEnum.getEnumByCode(contractEntity.getContractPerformanceState()).getDescription()+"不可进行此操作！");
			}
		}
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}
		return CommonResponse.success();

	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		//结算单  根据 合同状态校验
		RentSettlementEntity entity = service.selectById(billId);
		if(entity.getContractId()!=null){
			RentContractEntity contractEntity = contractService.selectById(entity.getContractId());
			if(PerformanceStatusEnum.已冻结.getCode().equals(contractEntity.getContractPerformanceState()) || PerformanceStatusEnum.已作废.getCode().equals(contractEntity.getContractPerformanceState())){
				throw new BusinessException("合同{"+contractEntity.getContractName()+"},状态为："+ PerformanceStatusEnum.getEnumByCode(contractEntity.getContractPerformanceState()).getDescription()+"不可进行此操作！");
			}
		}
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//结算单  根据 合同状态校验
		RentSettlementEntity entity = service.selectById(billId);
		if(entity.getContractId()!=null){
			RentContractEntity contractEntity = contractService.selectById(entity.getContractId());
			if(PerformanceStatusEnum.已冻结.getCode().equals(contractEntity.getContractPerformanceState()) || PerformanceStatusEnum.已作废.getCode().equals(contractEntity.getContractPerformanceState())){
				throw new BusinessException("合同{"+contractEntity.getContractName()+"},状态为："+ PerformanceStatusEnum.getEnumByCode(contractEntity.getContractPerformanceState()).getDescription()+"不可进行此操作！");
			}
		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state) || BillStateEnum.PASSED_STATE
				.getBillStateCode().equals(state)) {
			logger.info("审批通过业务开始！");
			//结算单
			RentSettlementEntity entity = service.selectById(billId);
			//推送结算池所用vo
			RentSettlementVO settlementVO = BeanMapper.map(entity, RentSettlementVO.class);
			//修改合同状态  结算类型，0-过程,1-最终
			if (entity.getContractId() != null && entity.getSettlementType() == 1) {
				RentContractEntity rentContractEntity = contractService.selectById(entity.getContractId());
				rentContractEntity.setContractPerformanceState(PerformanceStatusEnum.已终止.getCode());
				contractService.saveOrUpdate(rentContractEntity);
				logger.info("修改合同状态！" + JSONObject.toJSONString(rentContractEntity));
			}
			//推送合同池
			service.updateContractPoolSettle(settlementVO,true);
			//租金占用
			if(CollectionUtils.isNotEmpty(entity.getRentSettlementRentalList())){
				List<RentSettlementRentalEntity> rentalList = entity.getRentSettlementRentalList();
				List<Long> ids = rentalList.stream().filter(t -> t.getSourceId() != null).map(RentSettlementRentalEntity::getSourceId).collect(Collectors.toList());
				rentRentalService.updateRentalSettlementState(ids, RentalSettlementStateEnum.已结算.getCode());
			}
			// 最终结算推送目标成本
//			if (entity.getSettlementType()!=null && entity.getSettlementType()==1){
//				logger.info("推送目标成本开始");
//				CommonResponse<String> response = executionApi.aggPush(service.targetCost(entity));
//				logger.info("推送目标成本入参：" + JSONObject.toJSONString(service.targetCost(entity)));
//				if (!response.isSuccess()){
//					logger.error("推送目标成本失败: , {}", response.getMsg());
//					throw new BusinessException(response.getMsg());
//				}
//
//			}
			//推送结算池
			boolean pool = service.pushSettleToPool(settlementVO);
			if (!pool) {
				throw new BusinessException("推送结算失败");
			}
//			logger.info("推送成本---");
//			service.costPush(entity);

            //TODO 推送供方暂时注释掉
			boolean pushFlag  = false;
//			//推送供方
//			boolean pushFlag = service.pushBillToSupCenter(entity);
//			logger.info("获取推送供方结果--"+pushFlag);
			if(!pushFlag){
				entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
			}else{
				entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
			}
			service.saveOrUpdate(entity,false);
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		CommonResponse<String> res = billTypeApi.checkQuote(billTypeCode, billId);
		logger.info("平台返回查询被引用情况"+res.isSuccess()+"----"+res.getMsg());
		if(!res.isSuccess()) {
			return CommonResponse.error("当前单据已被下游业务引用，不能弃审！");
		}
		RentSettlementEntity entity = service.selectById(billId);
		if(entity.getSignStatus()==1){
			throw new BusinessException("已签字不能撤回！");
		}
		if(entity.getContractId()!=null){
			LambdaQueryWrapper<RentSettlementEntity> lambda = new LambdaQueryWrapper<>();
			lambda.eq(RentSettlementEntity::getContractId, entity.getContractId());
			lambda.orderByDesc(RentSettlementEntity::getCreateTime);
			List<RentSettlementEntity> list = service.list(lambda);
			RentSettlementEntity settlementEntity = list.get(0);
			if(!entity.getId().equals(settlementEntity.getId())){
				throw new BusinessException("只能撤回最新的结算单！");
			}
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		RentSettlementEntity entity = service.selectById(billId);
		//修改合同状态  结算类型，0-过程,1-最终
		if(entity.getContractId()!=null && entity.getSettlementType()==1){
			RentContractEntity contractEntity = contractService.selectById(entity.getContractId());
			contractEntity.setContractPerformanceState(PerformanceStatusEnum.履约中.getCode());
			contractService.saveOrUpdate(contractEntity);
			logger.info("修改合同状态！" + JSONObject.toJSONString(contractEntity));
		}
		//推送合同池
		service.updateContractPoolSettle(BeanMapper.map(entity, RentSettlementVO.class),false);
		//租金占用
		if(CollectionUtils.isNotEmpty(entity.getRentSettlementRentalList())){
			List<RentSettlementRentalEntity> rentalList = entity.getRentSettlementRentalList();
			List<Long> ids = rentalList.stream().filter(t -> t.getSourceId() != null).map(RentSettlementRentalEntity::getSourceId).collect(Collectors.toList());
			rentRentalService.updateRentalSettlementState(ids, RentalSettlementStateEnum.未结算.getCode());
		}
		// 删除目标成本
//		if (entity.getSettlementType()!=null && entity.getSettlementType()==1) {
//			List<TotalExecutionVO> totalExecutionVOList = new ArrayList<>();
//			ExecutionVO executionVO = service.targetCost(entity);
//			totalExecutionVOList.add(executionVO.getTotalVO());
//			CommonResponse<String> response = executionApi.aggDel(totalExecutionVOList);
//			logger.info("删除目标成本结果" + JSONObject.toJSONString(response));
//			if (!response.isSuccess()) {
//				throw new BusinessException("目标成本删除失败！");
//			}
//		}
		//结算池撤回
		boolean pool = service.delSettleFromPool(billId);
		if(!pool){
			throw new BusinessException("弃审推送结算池失败！");
		}
		logger.info("弃审推送成本---");
		logger.info("删除成本中心之前的数据-Id---{}",entity.getId());
		CommonResponse<String> stringCommonResponse = costDetailApi.deleteSubject(entity.getId());
		logger.info("结果"+ JSONObject.toJSONString(stringCommonResponse));
		if(!stringCommonResponse.isSuccess()){
			throw new BusinessException(stringCommonResponse.getMsg());
		}
		//推送供方
		if(BillPushStatusEnum.推送成功.getStatus().equals(entity.getBillPushFlag())){
			CommonResponse<String> commonResponse = service.updatePushBill(entity);
			logger.info("供方结果"+ JSONObject.toJSONString(commonResponse));
			if(!commonResponse.isSuccess()){
				throw new BusinessException(commonResponse.getMsg());
			}
		}
		//更新是否关联
		LambdaUpdateWrapper<RentSettlementEntity> updateWrapper = new LambdaUpdateWrapper<>();
		updateWrapper.in(RentSettlementEntity::getId, entity.getId());
		updateWrapper.set(RentSettlementEntity::getRelationFlag, "0");//(1:是，0：否)
		updateWrapper.set(RentSettlementEntity::getBillPushFlag, BillPushStatusEnum.未成功推送.getStatus());
		service.update(updateWrapper);
		return CommonResponse.success();
	}

}
