package com.ejianc.business.proequipmentcorprent.temporary.contract.service;

import com.ejianc.business.proequipmentcorprent.rent.vo.RentContractChangeVO;
import com.ejianc.business.proequipmentcorprent.temporary.contract.vo.TemporaryContractChangeVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.proequipmentcorprent.temporary.contract.bean.TemporaryContractChangeEntity;

/**
 * 临时设备租赁合同-合同变更表
 * 
 * @author generator
 * 
 */
public interface ITemporaryContractChangeService extends IBaseService<TemporaryContractChangeEntity> {
    /**
     * 保存或者修改
     * @param temporaryContractChangeVO
     */
    public TemporaryContractChangeVO saveOrUpdates(TemporaryContractChangeVO temporaryContractChangeVO);

    public TemporaryContractChangeVO addConvertByConId(Long contractId, Long changeId);

    /**
     * 查询详情
     * @param id
     * @return
     */
    public TemporaryContractChangeVO queryDetailRecord(Long id);

    /**
     * 根据合同id查询是否可以变更
     * @param contractId
     * @return
     */
    public Boolean editChangeFlag(Long contractId);
    public void queryBpm(Long contractId);

    /**
     * 线下签订变更调用
     * @param billId
     * @param billTypeCode
     * @param commitState
     * @return
     */
    CommonResponse<String> effectiveSaveWriteContract(Long billId, String billTypeCode, Boolean commitState);

    /**
     * 删除
     * @param id
     * @return
     */
    public CommonResponse<String> deleteById(Long id);
}
