package com.ejianc.business.proequipmentcorppur.asset.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.proequipmentcorppur.asset.bean.AssetMaintainMaterialEntity;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetMaintainArtificialEntity;
/**
 * 设备维修保养
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proequipmentcorp_asset_maintain")
public class AssetMaintainEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    @TableField(value="bill_code")
    private String billCode; // 单据编码
    @TableField(value="org_id")
    private Long orgId; // 所属单位ID
    @TableField(value="org_name")
    private String orgName; // 所属单位
    @TableField(value="maintain_time")
    private Date maintainTime; // 维修保养日期
    @TableField(value="maintain_cost")
    private BigDecimal maintainCost; // 维修保养费用
    @TableField(value="material_cost")
    private BigDecimal materialCost; // 材料费
    @TableField(value="artificial_cost")
    private BigDecimal artificialCost; // 人工费
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="material_type_name")
    private String materialTypeName; // 设备分类名称
    @TableField(value="the_maintain_cost")
    private BigDecimal theMaintainCost; // 本次维修保养费用
    @TableField(value="maintain_num")
    private Integer maintainNum; // 维修保养总数量
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中

    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_code")
    private String orgCode; // 项目组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="department_name")
    private String departmentName; // 经办人部门
    @TableField(value="department_id")
    private Long departmentId; // 经办人部门id


    @TableField(exist=false)
    @SubEntity(serviceName="assetMaintainMaterialService",pidName ="maintainId")
    private List<AssetMaintainMaterialEntity> assetMaintainMaterialList = new ArrayList<>(); // 设备维修保养-材料费
    @TableField(exist=false)
    @SubEntity(serviceName="assetMaintainArtificialService",pidName ="maintainId")
    private List<AssetMaintainArtificialEntity> assetMaintainArtificialList = new ArrayList<>(); // 设备维修保养-人工费

    @TableField(exist=false)
    @SubEntity(serviceName="assetMaintainEquipmentService",pidName ="maintainId")
    private List<AssetMaintainEquipmentEntity> assetMaintainEquipmentList = new ArrayList<>(); // 设备维修保养-设备
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Date getMaintainTime() {
        return maintainTime;
    }

    public void setMaintainTime(Date maintainTime) {
        this.maintainTime = maintainTime;
    }
    public BigDecimal getMaintainCost() {
        return maintainCost;
    }

    public void setMaintainCost(BigDecimal maintainCost) {
        this.maintainCost = maintainCost;
    }
    public BigDecimal getMaterialCost() {
        return materialCost;
    }

    public void setMaterialCost(BigDecimal materialCost) {
        this.materialCost = materialCost;
    }
    public BigDecimal getArtificialCost() {
        return artificialCost;
    }

    public void setArtificialCost(BigDecimal artificialCost) {
        this.artificialCost = artificialCost;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    

    public List<AssetMaintainMaterialEntity> getAssetMaintainMaterialList() {
        return assetMaintainMaterialList;
    }

    public void setAssetMaintainMaterialList(List<AssetMaintainMaterialEntity> assetMaintainMaterialList) {
        this.assetMaintainMaterialList = assetMaintainMaterialList;
    }

    public List<AssetMaintainArtificialEntity> getAssetMaintainArtificialList() {
        return assetMaintainArtificialList;
    }

    public void setAssetMaintainArtificialList(List<AssetMaintainArtificialEntity> assetMaintainArtificialList) {
        this.assetMaintainArtificialList = assetMaintainArtificialList;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public List<AssetMaintainEquipmentEntity> getAssetMaintainEquipmentList() {
        return assetMaintainEquipmentList;
    }

    public void setAssetMaintainEquipmentList(List<AssetMaintainEquipmentEntity> assetMaintainEquipmentList) {
        this.assetMaintainEquipmentList = assetMaintainEquipmentList;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public BigDecimal getTheMaintainCost() {
        return theMaintainCost;
    }

    public void setTheMaintainCost(BigDecimal theMaintainCost) {
        this.theMaintainCost = theMaintainCost;
    }

    public Integer getMaintainNum() {
        return maintainNum;
    }

    public void setMaintainNum(Integer maintainNum) {
        this.maintainNum = maintainNum;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
}
