package com.ejianc.business.proequipmentcorprent.temporary.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractChangeEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractEntity;
import com.ejianc.business.proequipmentcorprent.rent.enums.ChangeStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.DraftTypeEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.SignatureStatusEnum;
import com.ejianc.business.proequipmentcorprent.temporary.contract.bean.TemporaryContractChangeEntity;
import com.ejianc.business.proequipmentcorprent.temporary.contract.bean.TemporaryContractEntity;
import com.ejianc.business.proequipmentcorprent.temporary.contract.service.ITemporaryContractChangeService;
import com.ejianc.business.proequipmentcorprent.temporary.contract.service.ITemporaryContractService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.response.BillStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

@Service("temporaryContractChange") 
public class TemporaryContractChangeBpmServiceImpl implements ICommonBusinessService {
    @Autowired
	private ITemporaryContractService contractService;
    @Autowired
	private ITemporaryContractChangeService temporaryContractChangeService;
	@Autowired
	private SessionManager sessionManager;

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IBillTypeApi billTypeApi;
	/**
	 * 提交前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		TemporaryContractChangeEntity e = temporaryContractChangeService.selectById(billId);
		UserContext userContext = sessionManager.getUserContext();

		e.setCommitDate(new Date());
		e.setCommitUserCode(userContext.getUserCode());
		e.setCommitUserName(userContext.getUserName());
		temporaryContractChangeService.saveOrUpdate(e, false);
		return CommonResponse.success("变更回调处理完成！");
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return doBpmBack(billId, state, billTypeCode);
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		TemporaryContractChangeEntity changeEntity = temporaryContractChangeService.selectById(billId);
		logger.info("变更单终审审批前变更表数据------------->: {}", JSONObject.toJSONString(changeEntity));
		if (null != changeEntity && !(changeEntity.getBillState().equals(BillStateEnum.UNCOMMITED_STATE.getBillStateCode()) || changeEntity.getBillState().equals(BillStateEnum.UNAPPROVED.getBillStateCode()))){
			return CommonResponse.error("该单据已被修改，请勿重复提交！");
		}
		return CommonResponse.success("变更单终审审批前回调处理成功！");	}

	/**
	 * 终审审核完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		/**更新变更的审批时间  begin */
		TemporaryContractChangeEntity changeEntity = temporaryContractChangeService.selectById(billId);
		TemporaryContractEntity contractEntity = contractService.selectById(changeEntity.getContractId());
		if (null != contractEntity && !contractEntity.getContractPerformanceState().equals(PerformanceStatusEnum.履约中.getCode())){
			return CommonResponse.error("当前变更合同所属的主合同状态不是履约中，该变更合同不能进行提交操作！");
		}
		Boolean commitState = false;
		if(state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
			commitState = true;
			//直审设置单据提交人信息
			changeEntity.setCommitDate(new Date());
			changeEntity.setCommitUserCode(sessionManager.getUserContext().getUserCode());
			changeEntity.setCommitUserName(sessionManager.getUserContext().getUserName());
		}

		if (DraftTypeEnum.线下签订.getCode().toString().equals(changeEntity.getChangeDraftType())){
			//调用生效回写服务
			return temporaryContractChangeService.effectiveSaveWriteContract(billId, billTypeCode, commitState);
		}else {
			//变更单更新
			if (commitState){
				temporaryContractChangeService.saveOrUpdate(changeEntity);
			}

			//回写主合同信息
			contractEntity.setChangeStatus(ChangeStatusEnum.变更单据审批通过.getCode());
			contractService.saveOrUpdate(contractEntity, false);
			logger.info("更新合同表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(contractEntity));
		}
		return CommonResponse.success("审批回调合同成功！");
	}

	/**
	 * 弃审前事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}
	/**
	 * @param billId
	 * @param state
	 * @param billTypeCode
	 * @return
	 */
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> doBpmBack(Long billId, Integer state, String billTypeCode) {
		CommonResponse<String> resp = null;
		//提交通过、且未签章则可弃审
		TemporaryContractChangeEntity changeEntity = temporaryContractChangeService.selectById(billId);

		if (!(SignatureStatusEnum.未签章.getCode().equals(changeEntity.getSignatureState()))){
			return CommonResponse.error("当前单据已有签章流程，不能撤回！");
		}
		changeEntity.setCommitDate(null);
		changeEntity.setCommitUserCode(null);
		changeEntity.setCommitUserName(null);
		temporaryContractChangeService.saveOrUpdate(changeEntity);
		logger.info("撤回更新变更表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(changeEntity));

		TemporaryContractEntity contractEntity = contractService.selectById(changeEntity.getContractId());
		contractEntity.setChangeStatus(ChangeStatusEnum.变更中.getCode());
		contractService.saveOrUpdate(contractEntity, false);
		logger.info("撤回更新合同表数据成功,contractEntity---------->: {}", JSONObject.toJSONString(contractEntity));
		return CommonResponse.success("执行变更单撤回回调逻辑成功！");
	}
}
