/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorppur.acceptance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorppur.acceptance.bean.PurchaseAcceptanceEntity;
import com.ejianc.business.proequipmentcorppur.acceptance.bean.PurchaseAcceptanceSubEntity;
import com.ejianc.business.proequipmentcorppur.acceptance.mapper.PurchaseAcceptanceMapper;
import com.ejianc.business.proequipmentcorppur.acceptance.service.IPurchaseAcceptanceService;
import com.ejianc.business.proequipmentcorppur.acceptance.service.IPurchaseAcceptanceSubService;
import com.ejianc.business.proequipmentcorppur.acceptance.vo.PurchaseAcceptanceVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseAcceptanceService")
public class PurchaseAcceptanceServiceImpl
extends BaseServiceImpl<PurchaseAcceptanceMapper, PurchaseAcceptanceEntity>
implements IPurchaseAcceptanceService {
    @Autowired
    private IPurchaseAcceptanceSubService purchaseAcceptanceSubService;

    @Override
    public IPage<PurchaseAcceptanceVO> refPurchaseAcceptanceData(QueryParam param, Long contractId, Integer pageNumber, Integer pageSize) {
        Page page = new Page((long)param.getPageIndex(), (long)param.getPageSize());
        List<PurchaseAcceptanceVO> list = ((PurchaseAcceptanceMapper)this.baseMapper).refPurchaseAcceptanceData((QueryWrapper<PurchaseAcceptanceVO>)PurchaseAcceptanceServiceImpl.changeToQueryWrapper((QueryParam)param), contractId, (IPage<PurchaseAcceptanceVO>)page);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return pageData;
    }

    @Override
    public Integer countBillNum(Long projectId, Date checkDate) {
        LambdaQueryWrapper lambdaQuery = Wrappers.lambdaQuery();
        ((LambdaQueryWrapper)lambdaQuery.eq(PurchaseAcceptanceEntity::getProjectId, (Object)projectId)).eq(PurchaseAcceptanceEntity::getAcceptanceDate, (Object)checkDate);
        return super.count((Wrapper)lambdaQuery);
    }

    @Override
    public PurchaseAcceptanceVO saveOrUpdateAccepts(PurchaseAcceptanceEntity entity) {
        this.validateSave(entity);
        this.saveOrUpdate((Object)entity, false);
        return (PurchaseAcceptanceVO)BeanMapper.map((Object)((Object)entity), PurchaseAcceptanceVO.class);
    }

    private String validateSave(PurchaseAcceptanceEntity entity) {
        if (CollectionUtils.isNotEmpty(entity.getPurchaseAcceptanceSubList())) {
            List<PurchaseAcceptanceSubEntity> subList = entity.getPurchaseAcceptanceSubList();
            ArrayList<Long> delRowIds = new ArrayList<Long>();
            for (int i = 0; i < subList.size(); ++i) {
                PurchaseAcceptanceSubEntity sub = entity.getPurchaseAcceptanceSubList().get(i);
                if ("del".equals(sub.getRowState())) {
                    delRowIds.add(sub.getId());
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)sub.getEquipmentFactoryCode())) {
                    sub.setEquipmentFactoryCode(PurchaseAcceptanceServiceImpl.randomCode() + "");
                }
                for (int j = i + 1; j < subList.size(); ++j) {
                    PurchaseAcceptanceSubEntity subEntity = subList.get(j);
                    if (!sub.getEquipmentFactoryCode().equals(subEntity.getEquipmentFactoryCode())) continue;
                    throw new BusinessException("\u8bbe\u5907\u51fa\u5382\u7f16\u7801\u91cd\u590d" + subEntity.getEquipmentFactoryCode());
                }
                List<PurchaseAcceptanceSubEntity> dbByCodeList = this.selectFactoryCode(sub.getEquipmentFactoryCode());
                for (PurchaseAcceptanceSubEntity acceptanceSubEntity : dbByCodeList) {
                    if (delRowIds.contains(acceptanceSubEntity.getId()) || null != sub.getId() && acceptanceSubEntity.getId().equals(sub.getId())) continue;
                    throw new BusinessException("\u8bbe\u5907\u51fa\u5382\u7f16\u7801\u91cd\u590d" + acceptanceSubEntity.getEquipmentFactoryCode());
                }
            }
        }
        return null;
    }

    private static Long randomCode() {
        SecureRandom secureRandom = null;
        try {
            secureRandom = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        secureRandom.setSeed(1000000L);
        return (long)secureRandom.nextInt(10000) + System.currentTimeMillis();
    }

    public List<PurchaseAcceptanceSubEntity> selectFactoryCode(String factoryCode) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)"0");
        queryWrapper.eq((Object)"equipment_factory_code", (Object)factoryCode);
        return this.purchaseAcceptanceSubService.list((Wrapper)queryWrapper);
    }
}

