/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorppur.asset.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetAdjustDetailEntity;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetAmortizeEntity;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetAdjustDetailService;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetAmortizeService;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetRecordService;
import com.ejianc.business.proequipmentcorppur.asset.vo.AssetAmortizeDetailVO;
import com.ejianc.business.proequipmentcorppur.asset.vo.AssetAmortizeVO;
import com.ejianc.business.proequipmentcorppur.consts.AssetAmortizeEnum;
import com.ejianc.business.proequipmentcorppur.decorator.IAssetRecord;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IShareEquipmentApi;
import com.ejianc.foundation.share.vo.EquipmentVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"assetAmortize"})
@Api(value="\u56fa\u5b9a\u8d44\u4ea7\u644a\u9500", tags={"\u56fa\u5b9a\u8d44\u4ea7\u644a\u9500"})
public class AssetAmortizeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IShareEquipmentApi shareEquipmentApi;
    private static final String BILL_CODE = "CORP_EQUIPMENT_AMORTIZE";
    @Autowired
    private IAssetAmortizeService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAssetRecordService assetRecordService;
    @Autowired
    private IAssetAdjustDetailService assetAdjustDetailService;

    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Boolean> test() {
        AssetAmortizeVO assetAmortizeVO = new AssetAmortizeVO();
        assetAmortizeVO.setId(Long.valueOf(1L));
        AssetAmortizeDetailVO assetAmortizeDetailVO = new AssetAmortizeDetailVO();
        assetAmortizeDetailVO.setAssetName("ceshi");
        assetAmortizeDetailVO.setEquipmentName("\u6d4b\u8bd5\u554a");
        assetAmortizeVO.setDetailList(Arrays.asList(assetAmortizeDetailVO));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)this.assetRecordService.saveRecord((IAssetRecord)assetAmortizeVO));
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u8005\u4fee\u6539")
    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AssetAmortizeVO> saveOrUpdate(@ApiParam(name="saveOrUpdateVO", required=true) @RequestBody AssetAmortizeVO saveOrUpdateVO) {
        List detailList;
        AssetAmortizeEntity entity = (AssetAmortizeEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, AssetAmortizeEntity.class));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(AssetAmortizeEntity::getOrgId, (Object)saveOrUpdateVO.getOrgId());
        queryWrapper.ne(saveOrUpdateVO.getId() != null, BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        queryWrapper.notIn(AssetAmortizeEntity::getBillState, Arrays.asList(BillStateEnum.COMMITED_STATE.getBillStateCode(), BillStateEnum.PASSED_STATE.getBillStateCode()));
        int count = this.service.count((Wrapper)queryWrapper);
        if (count > 0) {
            throw new BusinessException("\u8be5\u644a\u9500\u5355\u4f4d\u4e0b\u5b58\u5728\u672a\u751f\u6548\u7684\u644a\u9500\u5355\uff01");
        }
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
                entity.setProportionFlag("0");
                entity.setRelationFlag("0");
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)(detailList = saveOrUpdateVO.getDetailList()))) {
            HashSet<String> categoryName = new HashSet<String>();
            for (AssetAmortizeDetailVO detailVO : detailList) {
                if ("del".equals(detailVO.getRowState())) continue;
                categoryName.add(detailVO.getEquipmentTypeName());
            }
            String categoryNameStr = StringUtils.join((Object[])categoryName.toArray(), (String)",");
            if (StringUtils.isNotEmpty((CharSequence)categoryNameStr) && categoryNameStr.length() > 1000) {
                categoryNameStr = categoryNameStr.substring(0, 1000);
            }
            entity.setCategoryName(categoryNameStr);
        }
        this.service.saveOrUpdate((Object)entity, false);
        AssetAmortizeVO vo = (AssetAmortizeVO)BeanMapper.map((Object)((Object)entity), AssetAmortizeVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5")
    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<AssetAmortizeVO> queryDetail(@RequestParam Long id) {
        AssetAmortizeEntity entity = (AssetAmortizeEntity)((Object)this.service.selectById(id));
        AssetAmortizeVO vo = (AssetAmortizeVO)BeanMapper.map((Object)((Object)entity), AssetAmortizeVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e")
    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<AssetAmortizeVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (AssetAmortizeVO assetAmortizeVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<AssetAmortizeVO>> queryList(@RequestBody QueryParam param) {
        Object value;
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "orgName", "employeeName", "categoryName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        Parameter amortizeDatePara = (Parameter)param.getParams().get("amortizeDate");
        if (amortizeDatePara != null && (value = amortizeDatePara.getValue()) != null) {
            String[] split = String.valueOf(value).split(",");
            amortizeDatePara.setValue((Object)(split[0] + "-01," + split[1] + "-31"));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List assetAmortizeVOS = BeanMapper.mapList((Iterable)page.getRecords(), AssetAmortizeVO.class);
        assetAmortizeVOS.forEach(t -> t.setSourceTypeName(AssetAmortizeEnum.getNameByCode((Integer)t.getSourceType())));
        pageData.setRecords(assetAmortizeVOS);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @ApiOperation(value="\u5bfc\u51fa")
    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        param.setPageIndex(1);
        param.setPageSize(-1);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.addAll(Arrays.asList("billCode", "orgName", "employeeName", "categoryName"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        List list = this.service.queryList(param);
        List assetAmortizeVOS = BeanMapper.mapList((Iterable)list, AssetAmortizeVO.class);
        assetAmortizeVOS.forEach(t -> {
            t.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)t.getBillState()).getDescription());
            t.setSourceTypeName(AssetAmortizeEnum.getNameByCode((Integer)t.getSourceType()));
        });
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", assetAmortizeVOS);
        ExcelExport.getInstance().export("AssetAmortize-export.xlsx", beans, response);
    }

    @ApiOperation(value="\u53c2\u7167")
    @RequestMapping(value={"/refAssetAmortizeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<AssetAmortizeVO>> refAssetAmortizeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), AssetAmortizeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/getLastAmortizeDate"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> getLastAmortizeDate(Long orgId, Long billId) {
        QueryWrapper assetAmortizeEntityQueryWrapper = new QueryWrapper();
        assetAmortizeEntityQueryWrapper.select(new String[]{"date_format( MAX( amortize_date ), '%Y-%m' ) lastDate"});
        assetAmortizeEntityQueryWrapper.eq((Object)"org_id", (Object)orgId);
        assetAmortizeEntityQueryWrapper.eq(billId != null, (Object)"id", (Object)billId);
        Map map = this.service.getMap((Wrapper)assetAmortizeEntityQueryWrapper);
        Object lastDate = map != null ? map.get("lastDate") : null;
        String lastAmortizeDate = lastDate != null ? String.valueOf(lastDate) : null;
        return CommonResponse.success((String)"\u67e5\u8be2\u4e0a\u6b21\u644a\u9500\u5468\u671f\u6210\u529f\uff01", (Object)lastAmortizeDate);
    }

    @ApiOperation(value="\u6839\u636e\u6750\u6599\u6e05\u5355\u83b7\u53d6\u672c\u6b21\u644a\u9500\u91d1\u989d")
    @RequestMapping(value={"/getAmortizeMnyAndSubject"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AssetAmortizeVO> getAmortizeMnyAndSubject(@ApiParam(name="assetAmortizeVO", required=true) @RequestBody AssetAmortizeVO assetAmortizeVO) {
        CommonResponse listCommonResponse;
        Date amortizeDate = assetAmortizeVO.getAmortizeDate();
        List detailList = assetAmortizeVO.getDetailList();
        if (CollectionUtils.isEmpty((Collection)detailList)) {
            return CommonResponse.success((String)"\u672a\u9009\u62e9\u5728\u573a\u8bbe\u5907\uff01", (Object)assetAmortizeVO);
        }
        this.logger.info("\u5224\u65ad\u5b50\u8868\u6570\u636e\u662f\u5426\u8d44\u4ea7\u8c03\u6574\u672a\u5b8c\u6210\uff01");
        List equipmentIdList = detailList.stream().map(AssetAmortizeDetailVO::getEquipmentId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(equipmentIdList)) {
            QueryParam adjustDetailQueryParam = new QueryParam();
            adjustDetailQueryParam.getParams().put("equipmentId", new Parameter("in", equipmentIdList));
            List assetAdjustDetailEntities = this.assetAdjustDetailService.queryList(adjustDetailQueryParam);
            if (CollectionUtils.isNotEmpty((Collection)assetAdjustDetailEntities) && assetAdjustDetailEntities.size() > 0) {
                String equipmentCodeNames = "";
                for (AssetAdjustDetailEntity assetAdjustDetailEntity : assetAdjustDetailEntities) {
                    equipmentCodeNames = equipmentCodeNames + "[" + assetAdjustDetailEntity.getEquipmentCode() + "]";
                }
                return CommonResponse.error((String)("\u8bbe\u5907" + equipmentCodeNames + "\u8c03\u6574\u672a\u5b8c\u6210\uff0c\u8bf7\u5b8c\u6210\u540e\u518d\u9009\u62e9\uff01"));
            }
        }
        this.service.getAmortizeSet(detailList, assetAmortizeVO.getOrgId());
        this.service.caclAmortizeMny(detailList, amortizeDate);
        if (CollectionUtils.isNotEmpty((Collection)assetAmortizeVO.getIdList()) && (listCommonResponse = this.shareEquipmentApi.queryEquipmentItemByIds(assetAmortizeVO.getIdList())).isSuccess()) {
            List data = (List)listCommonResponse.getData();
            for (EquipmentVO equipmentVO : data) {
                for (AssetAmortizeDetailVO detailVO : detailList) {
                    if (!equipmentVO.getId().equals(detailVO.getEquipmentId()) || equipmentVO.getSubjectId() == null) continue;
                    detailVO.setSubjectId(equipmentVO.getSubjectId());
                    detailVO.setSubjectName(equipmentVO.getSubjectName());
                    detailVO.setSubjectCode(equipmentVO.getCode());
                }
            }
        }
        assetAmortizeVO.setDetailList(detailList);
        return CommonResponse.success((String)"\u6839\u636e\u6750\u6599\u6e05\u5355\u83b7\u53d6\u672c\u6b21\u644a\u9500\u91d1\u989d\uff01", (Object)assetAmortizeVO);
    }

    @RequestMapping(value={"/pushCost"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<AssetAmortizeVO> pushCost(AssetAmortizeVO assetAmortizeVO) {
        return this.service.pushCost(assetAmortizeVO);
    }
}

