/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.ac.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorprent.ac.bean.ChangeEntity;
import com.ejianc.business.proequipmentcorprent.ac.bean.ContractEntity;
import com.ejianc.business.proequipmentcorprent.ac.enums.ChangeStatusEnum;
import com.ejianc.business.proequipmentcorprent.ac.enums.DraftTypeEnum;
import com.ejianc.business.proequipmentcorprent.ac.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorprent.ac.service.IChangeService;
import com.ejianc.business.proequipmentcorprent.ac.service.IContractService;
import com.ejianc.business.proequipmentcorprent.rent.enums.SignatureStatusEnum;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="change")
public class ChangeBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IChangeService changeService;
    @Autowired
    private IContractService contractService;
    @Autowired
    private SessionManager sessionManager;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ChangeEntity changeEntity = (ChangeEntity)((Object)this.changeService.selectById(billId));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(changeEntity.getContractId()));
        if (null != contractEntity && !contractEntity.getPerformanceStatus().equals(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode())) {
            return CommonResponse.error((String)"\u5f53\u524d\u53d8\u66f4\u5408\u540c\u6240\u5c5e\u7684\u4e3b\u5408\u540c\u72b6\u6001\u4e0d\u662f\u5c65\u7ea6\u4e2d\uff0c\u8be5\u53d8\u66f4\u5408\u540c\u4e0d\u80fd\u8fdb\u884c\u63d0\u4ea4\u64cd\u4f5c\uff01");
        }
        Boolean commitState = false;
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode())) {
            commitState = true;
            changeEntity.setCommitDate(new Date());
            changeEntity.setCommitUserCode(this.sessionManager.getUserContext().getUserCode());
            changeEntity.setCommitUserName(this.sessionManager.getUserContext().getUserName());
        }
        if (DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().toString().equals(changeEntity.getChangeDraftType())) {
            CommonResponse<String> response = this.changeService.effectiveSaveWriteContract(billId, billTypeCode, commitState, false);
            if (!response.isSuccess()) {
                this.logger.info("\u5408\u540c\u751f\u6548\u56de\u5199\u5931\u8d25\uff01\u5931\u8d25\u539f\u56e0\uff1a{}", (Object)JSONObject.toJSONString(response));
                throw new BusinessException("\u5408\u540c\u5ba1\u6838\u5931\u8d25\uff01");
            }
        } else {
            if (commitState.booleanValue()) {
                this.changeService.saveOrUpdate((Object)changeEntity);
            }
            contractEntity.setChangeStatus(ChangeStatusEnum.\u53d8\u66f4\u5355\u636e\u5ba1\u6279\u901a\u8fc7.getCode());
            this.contractService.saveOrUpdate((Object)contractEntity, false);
            this.logger.info("\u66f4\u65b0\u5408\u540c\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        }
        this.changeService.asyncWatermarkById(billId);
        return CommonResponse.success((String)"\u5ba1\u6279\u56de\u8c03\u5408\u540c\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return this.bpmBackCheck(billId, state, billTypeCode);
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        ChangeEntity changeEntity = (ChangeEntity)((Object)this.changeService.selectById(billId));
        this.changeService.updateTotalChangeDataByContractId(changeEntity, "back");
        return CommonResponse.success();
    }

    private CommonResponse<String> bpmBackCheck(Long billId, Integer state, String billTypeCode) {
        ChangeEntity contractChangeEntity = (ChangeEntity)((Object)this.changeService.selectById(billId));
        ArrayList<String> statusList = new ArrayList<String>();
        statusList.add(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u9000\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u64a4\u56de.getCode());
        statusList.add(SignatureStatusEnum.\u5df2\u8fc7\u671f.getCode());
        if (!DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().toString().equals(contractChangeEntity.getChangeDraftType()) && !statusList.contains(contractChangeEntity.getSignatureStatus())) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u6709\u7b7e\u7ae0\u6d41\u7a0b\uff0c\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(contractChangeEntity.getSignatureStatus())) {
            contractChangeEntity.setSignatureStatus(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
        }
        if (DraftTypeEnum.\u7ebf\u4e0b\u7b7e\u8ba2.getCode().toString().equals(contractChangeEntity.getChangeDraftType()) && SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(contractChangeEntity.getSignatureStatus())) {
            return CommonResponse.error((String)"\u5408\u540c\u53d8\u66f4\u5df2\u751f\u6548\uff0c\u4e0d\u80fd\u64a4\u56de!");
        }
        contractChangeEntity.setCommitDate(null);
        contractChangeEntity.setCommitUserCode(null);
        contractChangeEntity.setCommitUserName(null);
        this.changeService.saveOrUpdate((Object)contractChangeEntity);
        this.logger.info("\u64a4\u56de\u66f4\u65b0\u53d8\u66f4\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractChangeEntity)));
        ContractEntity contractEntity = (ContractEntity)((Object)this.contractService.selectById(contractChangeEntity.getContractId()));
        contractEntity.setChangeStatus(ChangeStatusEnum.\u53d8\u66f4\u4e2d.getCode());
        this.contractService.saveOrUpdate((Object)contractEntity, false);
        this.logger.info("\u64a4\u56de\u66f4\u65b0\u5408\u540c\u8868\u6570\u636e\u6210\u529f,contractEntity---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        return CommonResponse.success((String)"\u5f03\u5ba1/\u64a4\u56de\u524d\u6821\u9a8c\u56de\u8c03\u6210\u529f\uff01");
    }
}

