/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.rent.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterEntity;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentContractService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterService;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentParameterVO;
import com.ejianc.business.proequipmentcorprent.userecord.bean.UseRecordSubEntity;
import com.ejianc.business.proequipmentcorprent.userecord.service.IUseRecordSubService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"rentParameter"})
public class RentParameterController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IRentParameterService service;
    @Autowired
    private IRentContractService rentContractService;
    @Autowired
    private IUseRecordSubService useRecordSubService;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<RentParameterVO> saveOrUpdate(@RequestBody RentParameterVO saveOrUpdateVO) {
        RentParameterEntity entity = (RentParameterEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, RentParameterEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        RentParameterVO vo = (RentParameterVO)BeanMapper.map((Object)((Object)entity), RentParameterVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<RentParameterVO> queryDetail(Long id) {
        RentParameterEntity entity = (RentParameterEntity)((Object)this.service.selectById(id));
        RentParameterVO vo = (RentParameterVO)BeanMapper.map((Object)((Object)entity), RentParameterVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentParameterVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (RentParameterVO rentParameterVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RentParameterVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("equipmentState", new Parameter("ne", (Object)RentEquipmentStateEnum.\u9000\u573a.getCode()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RentParameterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List orgVOList = null;
        if (!param.getParams().containsKey("orgId")) {
            orgVOList = (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
            ArrayList commonOrgIds = new ArrayList();
            ArrayList departmentIds = new ArrayList();
            orgVOList.stream().forEach(org -> {
                if (5 == org.getOrgType()) {
                    departmentIds.add(org.getId());
                } else {
                    commonOrgIds.add(org.getId());
                }
            });
            if (CollectionUtils.isNotEmpty(commonOrgIds)) {
                param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
            } else if (CollectionUtils.isNotEmpty(departmentIds)) {
                param.getParams().put("orgId", new Parameter("in", departmentIds));
            }
        }
        List list = this.service.queryList(param);
        HashMap beans = new HashMap();
        List listVo = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            listVo = BeanMapper.mapList((Iterable)list, RentParameterVO.class);
            listVo.forEach(vo -> {
                vo.setRentHarborTypeName(vo.getRentHarborType() == 1 ? "\u5185\u79df" : "\u5916\u79df");
                if (vo.getEquipmentState() == 1) {
                    vo.setEquipmentStateName("\u8fdb\u573a");
                }
                if (vo.getEquipmentState() == 2) {
                    vo.setEquipmentStateName("\u542f\u7528");
                }
                if (vo.getEquipmentState() == 3) {
                    vo.setEquipmentStateName("\u505c\u7528");
                }
                if (vo.getEquipmentState() == 4) {
                    vo.setEquipmentStateName("\u9000\u573a");
                }
            });
        }
        beans.put("records", listVo);
        ExcelExport.getInstance().export("rentParameter-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refRentParameterData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RentParameterVO>> refRentParameterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Long contractId = null;
        param.getFuzzyFields().add("categoryName");
        param.getFuzzyFields().add("equipmentName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            contractId = _con.getLong("contractId");
        }
        if (contractId == null) {
            throw new BusinessException("\u5408\u540cid\u4e0d\u80fd\u5fc5\u987b\u4f20\uff01");
        }
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getParams().put("equipmentState", new Parameter("in", (Object)"1,2"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RentParameterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refRentParameterStopData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RentParameterVO>> refRentParameterStopData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Long contractId = null;
        param.getFuzzyFields().add("categoryName");
        param.getFuzzyFields().add("equipmentName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            contractId = _con.getLong("contractId");
        }
        if (contractId == null) {
            throw new BusinessException("\u5408\u540cid\u4e0d\u80fd\u5fc5\u987b\u4f20\uff01");
        }
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getParams().put("equipmentState", new Parameter("eq", (Object)"3"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RentParameterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/queryContractList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<RentParameterVO>> queryContractList(@RequestBody QueryParam param) {
        param.getFuzzyFields().add("categoryName");
        param.getFuzzyFields().add("equipmentName");
        Long contractId = null;
        if (param.getParams().get("contractId") == null) {
            throw new BusinessException("\u8bf7\u9009\u62e9\u5408\u540c");
        }
        contractId = Long.parseLong((String)((Parameter)param.getParams().get("contractId")).getValue());
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RentParameterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refRentEquipmentStart"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RentParameterVO>> refRentEquipmentStart(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("equipmentCode");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("equipmentName");
        Long contractId = null;
        param.getParams().put("rentTypeId", new Parameter("in", (Object)"1,2"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            contractId = _con.getLong("contractId");
        }
        if (contractId == null) {
            throw new BusinessException("\u5408\u540cid\u4e0d\u80fd\u5fc5\u987b\u4f20\uff01");
        }
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getParams().put("useType", new Parameter("eq", (Object)"2"));
        param.getParams().put("equipmentState", new Parameter("in", (Object)"2"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RentParameterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refRentEquipmentStop"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RentParameterVO>> refRentEquipmentStop(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("equipmentCode");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("equipmentName");
        Long contractId = null;
        param.getParams().put("rentTypeId", new Parameter("in", (Object)"1,2"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            contractId = _con.getLong("contractId");
        }
        if (contractId == null) {
            throw new BusinessException("\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getParams().put("useType", new Parameter("eq", (Object)"2"));
        param.getParams().put("equipmentState", new Parameter("eq", (Object)"3"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), RentParameterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refRentEquipmentQuantities"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<RentParameterVO>> refRentEquipmentQuantities(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("equipmentCode");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("equipmentName");
        Long contractId = null;
        String flag = null;
        param.getParams().put("rentTypeId", new Parameter("eq", (Object)"3"));
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            contractId = _con.getLong("contractId");
            flag = _con.getString("flag");
        }
        if (contractId == null) {
            throw new BusinessException("\u5408\u540cid\u4e0d\u80fd\u5fc5\u987b\u4f20\uff01");
        }
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        RentContractEntity rentContractEntity = (RentContractEntity)((Object)this.rentContractService.selectById(contractId));
        param.getParams().put("equipmentState", new Parameter("eq", (Object)"2"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List rentParameterVOS = BeanMapper.mapList((Iterable)page.getRecords(), RentParameterVO.class);
        if (CollectionUtils.isNotEmpty((Collection)rentParameterVOS) && null != rentContractEntity) {
            for (Object rentParameterVO : rentParameterVOS) {
                rentParameterVO.setContractTaxRate(rentContractEntity.getContractTax());
            }
        }
        pageData.setRecords(rentParameterVOS);
        if ("1".equals(flag)) {
            ArrayList<Long> ids = new ArrayList<Long>();
            for (RentParameterVO vo : pageData.getRecords()) {
                ids.add(vo.getId());
            }
            if (CollectionUtils.isNotEmpty(ids)) {
                QueryParam useRecordParam = new QueryParam();
                useRecordParam.getParams().put("equipmentId", new Parameter("in", ids));
                List useRecordSubEntities = this.useRecordSubService.queryList(useRecordParam);
                for (RentParameterVO vo : pageData.getRecords()) {
                    for (UseRecordSubEntity entity : useRecordSubEntities) {
                        if (!vo.getId().equals(entity.getEquipmentId())) continue;
                        if (vo.getCumulativeWorkload() == null) {
                            vo.setCumulativeWorkload(entity.getBillingWorkload());
                            continue;
                        }
                        vo.setCumulativeWorkload(vo.getCumulativeWorkload().add(entity.getBillingWorkload()));
                    }
                }
            }
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/test"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<String> test() throws ParseException {
        Long id = 560782506967318602L;
        String time = "2022-03-21";
        Date date = null;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        date = formatter.parse(time);
        return this.service.selectValidationNewDate(id, date, null);
    }
}

