/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.rent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorprent.ac.enums.BillPushStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentEquipmentStopEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentEquipmentStopSubEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterDetailEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterEntity;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentAcceptanceService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentEquipmentStopService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterDetailService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterService;
import com.ejianc.business.proequipmentcorprent.rent.vo.EquipmentNewDateVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="rentEquipmentStop")
public class RentEquipmentStopBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IRentParameterService rentParameterService;
    @Autowired
    private IRentEquipmentStopService stopService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentEquipmentStopService rentEquipmentStopService;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Autowired
    private IRentParameterDetailService rentParameterDetailService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    private final String PUSH_DELETE_URL = "/ejc-supbusiness-web/openapi/equipmentStop/deleteStop";
    private final String OPERATE = "RENT-PROEQUIPMENT-ASTOP";
    @Autowired
    private IRentAcceptanceService rentAcceptanceService;
    private static final String BILL_TYPE = "BT220221000000004";
    private static final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/equipmentStop/saveStop";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        RentEquipmentStopEntity entity = (RentEquipmentStopEntity)((Object)this.rentEquipmentStopService.selectById(billId));
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(entity.getBillPushFlag())) {
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25\uff01");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sourceId", billId);
            map.put("systemId", ejcCloudSystemCode.getData());
            String dataInfo = JSONObject.toJSONString(map);
            Boolean updateSupplierStatus = this.rentAcceptanceService.updateSupplierStatus(billId, dataInfo, "/ejc-supbusiness-web/openapi/equipmentStop/deleteStop", RequestMethod.POST, entity.getSupplierId().toString(), "RENT-PROEQUIPMENT-ASTOP", BILL_TYPE);
            if (!updateSupplierStatus.booleanValue()) {
                throw new BusinessException("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff01");
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            this.rentEquipmentStopService.saveOrUpdate((Object)entity, false);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5230\u8bbe\u5907\u505c\u7528\u4e86.....{}", (Object)billId);
        RentEquipmentStopEntity stopEntity = (RentEquipmentStopEntity)((Object)this.stopService.selectById(billId));
        List<RentEquipmentStopSubEntity> subEntityList = stopEntity.getRentEquipmentStopSubList();
        ArrayList<RentParameterEntity> parameterList = new ArrayList<RentParameterEntity>();
        for (RentEquipmentStopSubEntity subEntity : subEntityList) {
            RentParameterEntity parameterEntity = new RentParameterEntity();
            parameterEntity.setId(subEntity.getSourceId());
            parameterEntity.setStopDate(stopEntity.getTypeDate());
            parameterEntity.setOperationDate(new Date());
            parameterEntity.setEquipmentState(RentEquipmentStateEnum.\u505c\u7528.getCode());
            parameterEntity.setUseType(2);
            ArrayList<RentParameterDetailEntity> parameterDetailList = new ArrayList<RentParameterDetailEntity>();
            RentParameterDetailEntity detailEntity = new RentParameterDetailEntity();
            detailEntity.setSourceType(RentParameterTypeEnum.\u505c\u7528\u5355.getCode());
            detailEntity.setSourceId(stopEntity.getId());
            detailEntity.setOperationDate(stopEntity.getTypeDate());
            detailEntity.setEquipmentState(RentEquipmentStateEnum.\u505c\u7528.getCode());
            detailEntity.setParameterId(subEntity.getSourceId());
            parameterDetailList.add(detailEntity);
            parameterEntity.setRentParameterDetailList(parameterDetailList);
            parameterList.add(parameterEntity);
        }
        this.rentParameterService.changeParameter(parameterList, RentParameterTypeEnum.\u505c\u7528\u5355.getCode());
        this.stopService.updateById((Object)stopEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        RentEquipmentStopEntity stopEntity = (RentEquipmentStopEntity)((Object)this.stopService.selectById(billId));
        EquipmentNewDateVO equipmentNewDateVO = this.rentParameterService.selectAbandonDate(stopEntity.getContractId(), stopEntity.getTypeDate());
        if (equipmentNewDateVO != null && !stopEntity.getId().equals(equipmentNewDateVO.getId())) {
            return CommonResponse.error((String)("\u5f03\u5ba1\u5931\u8d25:\u8bf7\u5148\u5f03\u5ba1\u8bbe\u5907" + equipmentNewDateVO.getType() + "\u5355\u636e\u5728\u5f03\u5ba1\u672c\u5355\u636e"));
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        this.logger.info("\u5230\u8bbe\u5907\u505c\u7528\u5f03\u5ba1\u6d41\u7a0b.....{}", (Object)billId);
        RentEquipmentStopEntity stopEntity = (RentEquipmentStopEntity)((Object)this.stopService.selectById(billId));
        List<RentEquipmentStopSubEntity> subEntityList = stopEntity.getRentEquipmentStopSubList();
        ArrayList<Long> parameterIdList = new ArrayList<Long>();
        for (RentEquipmentStopSubEntity subEntity : subEntityList) {
            parameterIdList.add(subEntity.getSourceId());
        }
        this.rentParameterService.cancelParameter(parameterIdList, RentParameterTypeEnum.\u505c\u7528\u5355.getCode(), stopEntity.getId());
        stopEntity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        this.rentEquipmentStopService.saveOrUpdate((Object)stopEntity, false);
        return CommonResponse.success();
    }
}

