package com.ejianc.business.proequipmentcorpout.order.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorpout.order.service.IOutOrderService;
import com.ejianc.business.proequipmentcorpout.order.vo.OutOrderVO;
import com.ejianc.framework.core.response.CommonResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

@RestController
@RequestMapping("/api/outOrder/")
@Api(value = "设备公司租出订单API接口", tags = {"设备公司租出订单API接口"})
public class OutCorpOrderApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOutOrderService outRmatOrderService;

    @ApiOperation("保存推送的订单数据")
    @RequestMapping(value = "/saveOrder", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> saveOrder(@RequestBody OutOrderVO saveOrUpdateVO) {
        logger.info("订单数据--"+ JSONObject.toJSONString(saveOrUpdateVO));
        outRmatOrderService.saveOrder(saveOrUpdateVO);
        return CommonResponse.success("操作成功！");
    }
    @ApiOperation("删除推送的订单数据")
    @RequestMapping(value = "/deleteOrder", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> deleteOrder(@RequestBody OutOrderVO saveOrUpdateVO) {
        logger.info("订单数据--"+JSONObject.toJSONString(saveOrUpdateVO));
        outRmatOrderService.deleteOrder(saveOrUpdateVO);
        return CommonResponse.success("操作成功！");
    }
    @ApiOperation("订单关闭")
    @RequestMapping(value = "/updateOrderCloseFlag", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> updateOrderCloseFlag(@RequestBody OutOrderVO saveOrUpdateVO) {
        logger.info("订单数据--"+JSONObject.toJSONString(saveOrUpdateVO));
        String s = outRmatOrderService.updateOrderCloseFlag(saveOrUpdateVO);
        return CommonResponse.success("操作成功！",s);
    }
}
