package com.ejianc.business.proequipmentcorppur.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorppur.acceptance.bean.PurchaseAcceptanceEntity;
import com.ejianc.business.proequipmentcorppur.acceptance.bean.PurchaseAcceptanceSubEntity;
import com.ejianc.business.proequipmentcorppur.acceptance.service.IPurchaseAcceptanceService;
import com.ejianc.business.proequipmentcorppur.asset.bean.AmortizeSetEntity;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetEntity;
import com.ejianc.business.proequipmentcorppur.asset.mapper.AssetMapper;
import com.ejianc.business.proequipmentcorppur.asset.service.IAmortizeSetService;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetRecordService;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetService;
import com.ejianc.business.proequipmentcorppur.asset.vo.AmortizeSetVO;
import com.ejianc.business.proequipmentcorppur.asset.vo.AssetVO;
import com.ejianc.business.proequipmentcorppur.constants.PurCommonBillTypeEnum;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.DetailExecutionVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;

/**
 *  固定资产
 * 
 * @author generator
 * 
 */
@Service("assetService")
public class AssetServiceImpl extends BaseServiceImpl<AssetMapper, AssetEntity> implements IAssetService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchaseAcceptanceService purchaseAcceptanceService;
    @Autowired
    private IAssetService assetService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IAssetRecordService assetRecordService;
    @Autowired
    private IAmortizeSetService  amortizeSetService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private AssetMapper assetMapper;
    @Value("${common.env.base-host}")
    private String BaseHost;

    private static final String BILL_CODE = "ASSET_Bli_CODE";//此处需要根据实际修改
    private static final String BILL_TYPE = "EJCBT202206000070";//单据类型编码

    @Override
    public void pushAsset(Long billId) {
        PurchaseAcceptanceEntity purchaseAcceptanceEntity = purchaseAcceptanceService.selectById(billId);

        QueryWrapper<AssetEntity> dbQuery = new QueryWrapper<>();
        dbQuery.eq("leave_factory_code", purchaseAcceptanceEntity.getLeaveFactoryCode());
        AssetEntity dbEntity = super.getOne(dbQuery);
        AssetEntity entity = null;
        List<PurchaseAcceptanceSubEntity> purchaseAcceptanceSubList = purchaseAcceptanceEntity.getPurchaseAcceptanceSubList();
        if (CollectionUtils.isEmpty(purchaseAcceptanceSubList)){
            throw new BusinessException("验收设备列表为空！");
        }
        //一只只能验收一台设备
        PurchaseAcceptanceSubEntity purchaseAcceptanceSubEntity = purchaseAcceptanceSubList.get(0);

        if(purchaseAcceptanceEntity.getAcceptanceStandardSectionFlag() == 0) {
            //设备验收，则查询该出厂编码对应的设备是否已做过验收
            if(null != dbEntity) {
                throw new BusinessException("该出厂编码设备已被验收！");
            }
            entity = new AssetEntity();
            entity.setEquipmentStandardNum(null != purchaseAcceptanceSubEntity.getCurAcceptStandardSectionNum() ? purchaseAcceptanceSubEntity.getCurAcceptStandardSectionNum() : 0);

            if (Optional.ofNullable(purchaseAcceptanceEntity).isPresent()){
                //封装数据 组织信息
                entity.setOrgId(purchaseAcceptanceEntity.getParentOrgId());
                entity.setOrgName(purchaseAcceptanceEntity.getParentOrgName());
                entity.setOrgCode(purchaseAcceptanceEntity.getParentOrgCode());
                entity.setParentOrgId(purchaseAcceptanceEntity.getOrgId());
                entity.setParentOrgName(purchaseAcceptanceEntity.getOrgName());
                entity.setParentOrgCode(purchaseAcceptanceEntity.getOrgCode());
                entity.setPropertyRightCompanyId(purchaseAcceptanceEntity.getPropertyRightCompanyId());
                entity.setPropertyRightCompany(purchaseAcceptanceEntity.getPropertyRightCompany());
                entity.setManageCompanyId(purchaseAcceptanceEntity.getManageCompanyId());
                entity.setManageCompany(purchaseAcceptanceEntity.getManageCompany());
                entity.setPropertyRightCompany(purchaseAcceptanceEntity.getPropertyRightCompany());
                //封装数据 项目信息
                entity.setProjectId(purchaseAcceptanceEntity.getProjectId());
                entity.setProjectName(purchaseAcceptanceEntity.getProjectName());
                //设置编制人
                entity.setEmployeeId(sessionManager.getUserContext().getUserId());
                entity.setEmployeeName(sessionManager.getUserContext().getUserName());
                entity.setDepartmentId(sessionManager.getUserContext().getDeptId());
                entity.setDepartmentName(sessionManager.getUserContext().getDeptName());

                if(purchaseAcceptanceEntity.getAcceptanceType() == 0) {
                    //验收方式为 直入直出，设备状态为在用
                    entity.setEquipmentStatus(1);
                    //租出状态为 启用
                    entity.setRentState(1);
                    entity.setUseEquipmentStandardNum(entity.getEquipmentStandardNum());
                } else {
                    //验收方式为 验收入库，设备状态为闲置
                    entity.setEquipmentStatus(3);
                    //租出状态为 停用
                    entity.setRentState(2);
                }

                //原值 净值
                entity.setOriginalValueTax(purchaseAcceptanceSubEntity.getPurchasePrice());
                BigDecimal tax = ComputeUtil.safeMultiply(purchaseAcceptanceSubEntity.getPurchasePrice(), ComputeUtil.safeDiv(purchaseAcceptanceSubEntity.getTaxRate(),new BigDecimal(100)));
                BigDecimal originalValue = ComputeUtil.safeSub(purchaseAcceptanceSubEntity.getPurchasePrice(), tax);
                entity.setOriginalValue(originalValue);
                entity.setTaxRate(purchaseAcceptanceSubEntity.getTaxRate());
                entity.setNetWorth(originalValue);
                entity.setNetWorthTax(purchaseAcceptanceSubEntity.getPurchasePrice());

                //封装设备信息
                entity.setEquipmentId(purchaseAcceptanceSubEntity.getEquipmentId());
                entity.setEquipmentName(purchaseAcceptanceSubEntity.getEquipmentName());
                entity.setEquipmentCode(purchaseAcceptanceSubEntity.getEquipmentCode());
                entity.setEquipmentTypeId(purchaseAcceptanceSubEntity.getEquipmentTypeId());
                entity.setEquipmentTypeName(purchaseAcceptanceSubEntity.getEquipmentType());
                entity.setEquipmentTypeCode(purchaseAcceptanceSubEntity.getEquipmentCode());
                entity.setSpec(purchaseAcceptanceSubEntity.getSpec());
                entity.setUnit(purchaseAcceptanceSubEntity.getCompany());

                entity.setAssetStatus(0);
                //大于2000 资产类型 1:固定资产 2:普通资产
                if (purchaseAcceptanceSubEntity.getPurchasePrice().compareTo(new BigDecimal(2000)) != -1){
                    entity.setAssetType(1);
                }else {
                    entity.setAssetType(2);
                }
                Map<Long, Long> amortizeSetmap = new HashMap<>();
                amortizeSetmap.put(purchaseAcceptanceSubEntity.getEquipmentId(),purchaseAcceptanceSubEntity.getEquipmentTypeId());
                logger.info("调用固定资产摊销设置:"+JSONObject.toJSONString(entity));
                Map<Long, AmortizeSetEntity> amortizeMap = amortizeSetService.getSet(amortizeSetmap, entity.getOrgId());
                logger.info("固定资产摊销设置:"+JSONObject.toJSONString(amortizeMap));
                AmortizeSetEntity amortizeSetEntity = amortizeMap.get(purchaseAcceptanceSubEntity.getEquipmentId());
                if (amortizeSetEntity!=null){
                    BigDecimal residualValueRate = amortizeSetEntity.getResidualValueRate();
                    entity.setResidualValueRate(residualValueRate);
                    logger.info("调用固定资产摊销设置残值率残值率:"+residualValueRate);
                    BigDecimal residualValueTax = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(residualValueRate,new BigDecimal(100)),
                            purchaseAcceptanceSubEntity.getPurchasePrice());
                    BigDecimal residualValue = ComputeUtil.safeMultiply(ComputeUtil.safeDiv(residualValueRate,new BigDecimal(100)),
                            originalValue);
                    entity.setResidualValueTax(residualValueTax);
                    entity.setResidualValue(residualValue);
                    entity.setAmortizeType(1);
                }

                //设置设备出厂编码
                entity.setLeaveFactoryCode(purchaseAcceptanceSubEntity.getEquipmentFactoryCode());
                entity.setFinancePushFlag(purchaseAcceptanceEntity.getFinancePushFlag());
                // 来源 1：验收 2：期初 3：调拨
                entity.setSourceType(1);
                entity.setFinancePushState(0);
                entity.setCheckDate(purchaseAcceptanceEntity.getAcceptanceDate());
                //设备出厂指标
                entity.setProductionDate(purchaseAcceptanceEntity.getProductionDate());
                entity.setManufacturer(purchaseAcceptanceEntity.getManufacturer());
                entity.setCertificateNum(purchaseAcceptanceEntity.getCertificateNum());

                entity.setRandomTool(purchaseAcceptanceEntity.getRandomTool());
                entity.setAbility(purchaseAcceptanceEntity.getAbility());
                entity.setWeight(purchaseAcceptanceEntity.getWeight());
                entity.setPower(purchaseAcceptanceEntity.getPower());
                entity.setOwnWeight(purchaseAcceptanceEntity.getOwnWeight());
                entity.setAppearanceSize(purchaseAcceptanceEntity.getAppearanceSize());
                entity.setModelExplain(purchaseAcceptanceEntity.getModelExplain());
                entity.setSupplierId(purchaseAcceptanceEntity.getSupplierId());
                entity.setSupplierName(purchaseAcceptanceEntity.getSupplierName());
                entity.setPurchaseAcceptanceId(purchaseAcceptanceEntity.getId());
                entity.setBillState(1);
                //复制附件

                //将编码设置与出厂编码一致
                entity.setBillCode(entity.getLeaveFactoryCode());

//                AssetVO vo = BeanMapper.map(entity, AssetVO.class);
//                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),vo);
//                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//                if(billCode.isSuccess()) {
//                    entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
//                }else{
//                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//                }
            }
            logger.info("推送设备卡片的信息:"+JSONObject.toJSONString(entity));
            boolean b = assetService.saveOrUpdate(entity, false);
            CommonResponse<String> commonResponse =
                    attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(purchaseAcceptanceEntity.getId()),
                            PurCommonBillTypeEnum.设备公司设备验收.getBillTypeCode(), "photoPath", String.valueOf(entity.getId()), PurCommonBillTypeEnum.设备公司设备自有台帐.getBillTypeCode(),
                            "ASSET002");
            logger.info("复制图片:"+commonResponse.isSuccess());
            logger.info("复制图片返回的内容:"+commonResponse.getData());
            //从验收过来生成设备流转记录
            if (b){
                AssetVO vo = BeanMapper.map(entity, AssetVO.class);
                logger.info("设备验收推送设备流转记录的信息:"+JSONObject.toJSONString(vo));
                assetRecordService.saveRecord(vo);
            }
        } else {
            //标准节验收，则查询该出厂编码对应的设备是否做过设备验收
            if(null == dbEntity) {
                throw new BusinessException("该出厂编码设备未被验收，无法执行标准节验收！");
            }
            entity = dbEntity;

            //设置新的标准节数量
            entity.setEquipmentStandardNum(null != entity.getEquipmentStandardNum() ? entity.getEquipmentStandardNum() : 0 + purchaseAcceptanceSubEntity.getCurAcceptStandardSectionNum());
            if(purchaseAcceptanceEntity.getAcceptanceType() == 1) {
                //验收方式为直入直出时，同时也要增加使用的数量
                entity.setUseEquipmentStandardNum(null != entity.getUseEquipmentStandardNum() ? entity.getUseEquipmentStandardNum() : 0 + purchaseAcceptanceSubEntity.getCurAcceptStandardSectionNum());
            }

            assetService.saveOrUpdate(entity, false);
        }
        //TODO  当验收方式为 直入直出时，往项目设备验收推送一条数据
    }

    @Override
    public List<AssetVO> queryAssetPage(Page<AssetVO> page, QueryWrapper wrapper,List<Long> orgIds) {
        return assetMapper.queryAssetPage(page,wrapper,orgIds);
    }

    @Override
    public ExecutionVO targetCost(AssetVO assetVO){
        logger.info("推送目标责任成本数据：");
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        List<DetailExecutionVO> detailList = new ArrayList<>();
        totalVO.setSourceId(assetVO.getId());
        totalVO.setTenantId(assetVO.getTenantId());
        totalVO.setBillCode(assetVO.getBillCode());
        totalVO.setOrgId(assetVO.getOrgId());
        totalVO.setBillType(BILL_TYPE);
        totalVO.setBussinessType(BussinessTypeEnum.固定资产卡片.getCode());
        totalVO.setBillCategory(BillCategoryEnum.其他.getCode());
        if (assetVO.getProjectId()==null){
            throw new BusinessException("目标成本推送失败,请更换项目");
        }else {
            totalVO.setProjectId(assetVO.getProjectId());
        }
        if (assetVO.getOrgId()==null){
            throw new BusinessException("目标成本推送失败,请更换项目");
        }else {
            totalVO.setOrgId(assetVO.getOrgId());
        }
        totalVO.setMoney(assetVO.getEstimateAmortizeMny()); //预计摊销金额
        totalVO.setTaxMoney(assetVO.getEstimateAmortizeMny()); //预计摊销金额
        totalVO.setLinkUrl(BaseHost + "ejc-proequipmentp-frontend/#/asset/assetCard?id=" + assetVO.getId());
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    /**
     * 根据设备编号、残值率修改设备的残值
     * @param amortizeSetVO 摊销设置VO
     */
    @Override
    public void updateAssetResidualValue(AmortizeSetVO amortizeSetVO) {
        QueryParam param = new QueryParam();
        param.getParams().put("equipmentCode", new Parameter(QueryParam.EQ, amortizeSetVO.getEquipmentCode()));
        //管理单位id是否等于组织id
        param.getParams().put("manageCompanyId", new Parameter(QueryParam.EQ, amortizeSetVO.getOrgId()));

        List<AssetEntity> assetList = super.queryList(param);
        if (CollectionUtils.isNotEmpty(assetList)){
            for (AssetEntity assetEntity : assetList) {
                logger.info("修改设备残值率、残值:" + amortizeSetVO.getResidualValueRate());
                BigDecimal rate = ComputeUtil.safeDiv(amortizeSetVO.getResidualValueRate(), new BigDecimal(100));
                BigDecimal residualValueTax = ComputeUtil.safeMultiply(rate,
                        assetEntity.getOriginalValueTax());
                BigDecimal residualValue = ComputeUtil.safeMultiply(rate,
                        assetEntity.getOriginalValue());


                assetEntity.setResidualValueRate(amortizeSetVO.getResidualValueRate());
                assetEntity.setResidualValueTax(residualValueTax);
                assetEntity.setResidualValue(residualValue);

            }
            logger.info("本次修改设备" + assetList.size() + "个");
            super.saveOrUpdateBatch(assetList);
        }

    }
}
