package com.ejianc.business.proequipmentcorprent.order.service;

import com.ejianc.business.proequipmentcorprent.order.vo.RentOrderVO;
import com.ejianc.business.proequipmentcorprent.order.vo.SupRentOrderVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.proequipmentcorprent.order.bean.RentOrderEntity;

/**
 * 租赁订单
 * 
 * @author generator
 * 
 */
public interface IRentOrderService extends IBaseService<RentOrderEntity> {
    RentOrderVO queryDetail(Long id);

    RentOrderVO saveOrUpdates(RentOrderVO saveOrUpdateVO);

    CommonResponse<String> updateOrderFlag(RentOrderVO orderVO);

    CommonResponse<RentOrderVO> updateReceived(SupRentOrderVO orderVO);

    CommonResponse<RentOrderVO> updateDeliverState(SupRentOrderVO orderVO);

    /**
     * 单据推送到供方协同服务
     *
     * @param rentOrderEntity 待推送单据
     * @param billTypeCode 待推送单据的单据类型编码
     * @return
     */
    boolean pushBillToSupCenter(RentOrderEntity rentOrderEntity, String billTypeCode);

    /**
     * 将推送至供方的单据作废
     *
     * @param rentOrderEntity
     * @param billTypeCode
     * @return
     */
    CommonResponse<String> updatePushBill(RentOrderEntity rentOrderEntity, String billTypeCode,String url);
}
