package com.ejianc.business.proequipmentcorpout.contract.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.api.ICommonSNAPI;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.CommonSNVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractChangeEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractFreezeEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractRelieveEntity;
import com.ejianc.business.proequipmentcorpout.contract.constants.OutRentConstants;
import com.ejianc.business.proequipmentcorpout.contract.enums.*;
import com.ejianc.business.proequipmentcorpout.contract.mapper.OutRentContractMapper;
import com.ejianc.business.proequipmentcorpout.contract.service.*;
import com.ejianc.business.proequipmentcorpout.contract.utils.ListCallable;
import com.ejianc.business.proequipmentcorpout.contract.utils.MaterialConstant;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentContractChangeVO;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentContractEquipmentAllVO;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentContractVO;
import com.ejianc.business.profinance.api.IPaymentApplyApi;
import com.ejianc.business.profinance.vo.ContractPaymentResultVO;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.tender.api.ITenderRentApi;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.tender.common.vo.TenderPicketageDetailVO;
import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.*;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;
import java.util.*;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;

/**
 * 租赁合同
 * 
 * @author generator
 * 
 */
@Service("outRentContractService")
public class OutRentContractServiceImpl extends BaseServiceImpl<OutRentContractMapper, OutRentContractEntity> implements IOutRentContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private OutRentContractMapper outRentContractMapper;
    @Autowired
    private IOutRentContractChangeService outRentContractChangeService;
    @Autowired
    private IOutRentContractFreezeService outRentContractFreezeService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IParamCheckApi paramCheckApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private ITenderRentApi tenderApi;
    @Autowired
    private IPaymentApplyApi paymentApplyApi;
    @Value("${common.env.base-host}")
    private String BaseHost;
    //定标结果未占用状态
    int unOccupyState = 0;
    //定标结果已占用状态
    int occupyState = 1;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOutRentContractRelieveService outRentContractRelieveService;

    private final String OutRent_CONTRACT = "EJCBT202210000034";

//    private static final String BILL_CODE = "OutRentCORP_CONTRACT";//此处需要根据实际修改
//    private static final String BILL_CODE_YNJT = "OutRent_CONTRACT_YNJT01";//云南建投编码规则
    private static final String GenerateSourceType = "SPZLSPZR10086";//编码流水号业务类型
    @Value("${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;
    @Autowired
    private ICommonSNAPI commonSNAPI;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String CHECK_SUP_CODE = "P-oOnHR591";//设备租赁补充金额控制
    private static final String CHECK_PLAN_CODE = "P-i91Xpi92";//设备租赁总计划金额控制
    private static final String CONTRACT_FILING_CODE = "P-eg7rBO0134"; //合同归档控制

    @Autowired
    private IOutRentContractService service;
//    @Autowired
//    private IOutRentTotalPlanService outRentTotalPlanService;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IOutRentContractChangeService contractChangeService;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;

    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";
    @Autowired
    ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IOutRentContractAsyncService outRentContractAsyncService;

    /**
     * 保存补充协议
     * @param outRentContractVO
     * @return
     */
    @Override
    public OutRentContractVO saveOrUpdateSupplement(OutRentContractVO outRentContractVO, String authority) {
        List<OutRentContractEntity> entities = null;
        List<OutRentContractChangeEntity> entitiesc = null;
        Long tenantId = InvocationInfoProxy.getTenantid();
        //主合同
        OutRentContractEntity outRentContractEntity = service.selectById(outRentContractVO.getMainContractId());
        if(null == outRentContractEntity) {
            throw new BusinessException("未找到主合同，不能创建补充协议！");
        }
        // parentOrgCode如果是空的，则需要查询赋值
        if (StringUtils.isEmpty(outRentContractVO.getParentOrgCode()) && outRentContractVO.getParentOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(outRentContractVO.getParentOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                outRentContractVO.setParentOrgCode(orgVO.getCode());
            }
        }
        OutRentContractEntity entity = BeanMapper.map(outRentContractVO, OutRentContractEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
//            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),outRentContractVO);
//            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//            if(billCode.isSuccess()) {
                entity.setSignatureState(SignatureStatusEnum.未签章.getCode());
                entity.setSupplementFlag(1);
                entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
//                entity.setMainContractCreateDate(new Date());
//                if(StringUtils.isEmpty(entity.getCode())){
//                    entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//                }
            QueryParam param = new QueryParam();
            param.getParams().put("main_contract_id", new Parameter("eq", outRentContractVO.getMainContractId()));
            List<Integer> billStateList = new ArrayList<>();
            billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
            billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
            param.getParams().put("bill_state", new Parameter(QueryParam.IN, billStateList));
            List<OutRentContractEntity> supplementList = service.queryList(param, false);

            if (StringUtils.isBlank(entity.getCode())){
                String supplementNum = "";
                if (supplementList.size() < 9) {
                    supplementNum += "0" + (supplementList.size() + 1);
                }else {
                    supplementNum += (supplementList.size() + 1);
                }
                entity.setCode(outRentContractEntity.getCode() + "2" + supplementNum);
            }
//            }else{
//                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//            }

        }

        //修改  校验合同编号是否重复   需校验合同表和变更表(状态为变更中)同时唯一
        if (outRentContractVO.getId() != null && outRentContractVO.getId() > 0) {

            LambdaQueryWrapper<OutRentContractEntity> lambda = Wrappers.<OutRentContractEntity>lambdaQuery();
            lambda.eq(OutRentContractEntity::getCode, outRentContractVO.getCode());
            lambda.eq(OutRentContractEntity::getTenantId, tenantId);
            lambda.ne(OutRentContractEntity::getId, outRentContractVO.getId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("code", new Parameter(QueryParam.EQ, outRentContractVO.getCode()));
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.NE, outRentContractVO.getId()));
            entitiesc = contractChangeService.queryList(queryParam, false);
        } else {
            //校验：补充协议只能存在一条未生效的
            QueryParam param = new QueryParam();
            param.getParams().put("main_contract_id", new Parameter("eq", outRentContractVO.getMainContractId()));
            List<OutRentContractEntity> supplementList = super.queryList(param, false);
            supplementList.stream().forEach(e -> {
                if (!(e.getSignatureState().equals(SignatureStatusEnum.已签章.getCode()) &&
                        (e.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode())
                                || e.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())))) {
                    //存在未生效的补充协议
                    throw new BusinessException("该合同已存在未生效的补充协议!");
                }
            });

            //校验合同编号是否重复
            LambdaQueryWrapper<OutRentContractEntity> lambda = Wrappers.<OutRentContractEntity>lambdaQuery();
            lambda.eq(OutRentContractEntity::getTenantId, tenantId);
            lambda.eq(OutRentContractEntity::getCode, outRentContractVO.getCode());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
//            queryParam.getParams().put("supplement_flag",new Parameter("eq",0));//过滤补合同充协议
            queryParam.getParams().put("code", new Parameter(QueryParam.EQ, outRentContractVO.getCode()));
            entitiesc = contractChangeService.queryList(queryParam, false);

            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
        }
        if ((entities != null && entities.size() > 0) || (entitiesc != null && entitiesc.size() > 0)) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }

        // 校验其他单据
        this.checkContract(outRentContractVO.getMainContractId(), outRentContractVO.getId());
        entity.setBaseMny(outRentContractVO.getContractMny() == null ? BigDecimal.ZERO : outRentContractVO.getContractMny());
        entity.setBaseTaxMny(outRentContractVO.getContractTaxMny() == null ? BigDecimal.ZERO : outRentContractVO.getContractTaxMny());
        entity.setBeforeChangeMny(outRentContractVO.getContractMny() == null ? BigDecimal.ZERO : outRentContractVO.getContractMny());
        entity.setBeforeChangeTaxMny(outRentContractVO.getContractTaxMny() == null ? BigDecimal.ZERO : outRentContractVO.getContractTaxMny());

        if (entity.getContractFileId() != null) {
            if (entity.getId() != null) {
                OutRentContractEntity contract = service.getById(entity.getId());
                //如果改合同上次修改的起草方式不是线上起草  且 这次改为线上起草，则删除附件
                if (contract != null && !DraftTypeEnum.线上起草.getCode().toString().equals(contract.getDraftType()) && DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())) {
                    service.delContractFile(entity.getContractFileId(), authority);
                    entity.setContractFileId(null);
                    entity.setContractFile(null);
                }
            } else {
                //如果是新建合同，且起草方式为线上起草则删除附件
                if (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())) {
                    service.delContractFile(entity.getContractFileId(), authority);
                    entity.setContractFileId(null);
                    entity.setContractFile(null);
                }
            }
        }

        super.saveOrUpdate(entity, false);
        OutRentContractVO vo = BeanMapper.map(entity, OutRentContractVO.class);
        return vo;
    }
    /**
     * 校验合同是否能做其他业务
     * 合同只能存在一个未生效的下游业务
     *
     * @param id      合同id
     * @param otherId 其他单据id
     */
    @Override
    public boolean checkContract(Long id, Long otherId) {
        List<Integer> billStateList = Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                BillStateEnum.UNAPPROVED.getBillStateCode(),
                BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        // 集采合同只能本机做合同变更、补充协议等操作
        OutRentContractEntity contractEntity = super.selectById(id);
        // 校验补充协议
        // 存在非审批通过或非签章通过的补充协议，不允许做其他业务
//        queryParam.getParams().put("supplementFlag", new Parameter(QueryParam.EQ, 1));
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter(QueryParam.EQ, id));
        if (otherId != null) {
            supplementQueryParam.getParams().put("id", new Parameter(QueryParam.NE, otherId));
        }
        supplementQueryParam.getParams().put("signatureState", new Parameter(QueryParam.NE, SignatureStatusEnum.已签章.getCode()));
        List<OutRentContractEntity> supplementContractList = super.queryList(supplementQueryParam, false);
        // 存在未生效的补充协议，则抛出异常
        if (CollectionUtils.isNotEmpty(supplementContractList)) {
            throw new BusinessException("存在未生效的补充协议！");
        }

        // 校验变更合同
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, id));
//        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, billStateList));
        queryParam.getParams().put("signatureState", new Parameter(QueryParam.NE, SignatureStatusEnum.已签章.getCode()));
        // 做修改时，排除当前单据的id
        if (otherId != null) {
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, otherId));
        }
        List<OutRentContractChangeEntity> contractChangeEntityList = contractChangeService.queryList(queryParam, false);
        // 存在未生效的变更合同，则抛出异常
        if (CollectionUtils.isNotEmpty(contractChangeEntityList)) {
            throw new BusinessException("存在未生效的变更合同！");
        }


       // 校验解除合同
        QueryParam queryRelParam = new QueryParam();
        queryRelParam.getParams().put("contractId", new Parameter(QueryParam.EQ, id));
//        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, billStateList));
        queryRelParam.getParams().put("signature_state", new Parameter(QueryParam.NE, SignatureStatusEnum.已签章.getCode()));
        // 查询合同解除
        List<OutRentContractRelieveEntity> relieveEntityList = outRentContractRelieveService.queryList(queryRelParam, false);
        // 存在未生效的合同解除，则抛出异常
        if (CollectionUtils.isNotEmpty(relieveEntityList)) {
            throw new BusinessException("存在未生效的合同解除单据！");
        }
        // 查询合同冻结、解冻
        // 清除签章条件
        queryParam.getParams().remove("signatureState");
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, billStateList));
        List<OutRentContractFreezeEntity> freezeEntityList = outRentContractFreezeService.queryList(queryParam, false);
        // 存在未生效的合同冻结、解冻，则抛出异常
        if (CollectionUtils.isNotEmpty(freezeEntityList)) {
            throw new BusinessException("存在未生效的合同冻结或合同解冻单据！");
        }
        return true;
    }
    @Override
    public OutRentContractVO addConvertByConId(Long contractId) {

        OutRentContractEntity entity = super.selectById(contractId);
        OutRentContractVO supplementVO = new OutRentContractVO();

        supplementVO.setTargetResultId(entity.getTargetResultId());
        supplementVO.setTargetResultName(entity.getTargetResultName());
        supplementVO.setPartyHandleUser(entity.getPartyHandleUser());
        supplementVO.setPartyHandleUserName(entity.getPartyHandleUserName());
        supplementVO.setPartyPhone(entity.getPartyPhone());
        supplementVO.setSupplierHandleUser(entity.getSupplierHandleUser());
        supplementVO.setSupplierHandleUserName(entity.getSupplierHandleUserName());
        supplementVO.setSupplierPhone(entity.getSupplierPhone());
        supplementVO.setMainContractCode(entity.getCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setMainContractName(entity.getContractName());//主合同名称
        supplementVO.setContractType(entity.getContractType());
        supplementVO.setContractTypeName(entity.getContractTypeName());
        supplementVO.setProjectId(entity.getProjectId());
        supplementVO.setProjectName(entity.getProjectName());
        supplementVO.setProjectAddress(entity.getProjectAddress());
        supplementVO.setPartyId(entity.getPartyId());
        supplementVO.setPartyName(entity.getPartyName());
        supplementVO.setSupplierId(entity.getSupplierId());
        supplementVO.setSupplierName(entity.getSupplierName());
        supplementVO.setOrgId(entity.getOrgId());
        supplementVO.setOrgName(entity.getOrgName());
        supplementVO.setParentOrgId(entity.getParentOrgId());
        supplementVO.setParentOrgName(entity.getParentOrgName());
        supplementVO.setParentOrgCode(entity.getParentOrgCode());
        supplementVO.setSignedDate(new Date());
        supplementVO.setSupplementFlag(OutRentContractVO.CONTRACT_TYPE_SUPPLEMENT);
        supplementVO.setSignatureState(SignatureStatusEnum.未签章.getCode().toString());
        supplementVO.setContractPerformanceState(PerformanceStatusEnum.未签订.getCode().toString());
        supplementVO.setDraftType(DraftTypeEnum.上传合同.getCode().toString());
        supplementVO.setName(entity.getContractName() + "补充协议");
        supplementVO.setMainContractCreateDate(entity.getMainContractCreateDate());
        supplementVO.setContractType(entity.getContractType());
        supplementVO.setMeterRentType(entity.getMeterRentType());
        supplementVO.setMeterRentTypeName(entity.getMeterRentTypeName());
        supplementVO.setContractName(entity.getContractName() + "补充协议");
        supplementVO.setCompanyId(entity.getCompanyId());
        supplementVO.setCompanyName(entity.getCompanyName());
        supplementVO.setRentType(entity.getRentType());
        supplementVO.setRentTypeName(entity.getRentTypeName());
        supplementVO.setRentHarborType(entity.getRentHarborType());
        supplementVO.setFilingStatus(FilingStatusEnum.未归档.getTypeCode());

        return supplementVO;
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        OutRentContractEntity contractEntity = super.selectById(id);
        // 非履约中合同不允许新增补充协议
        if(!PerformanceStatusEnum.履约中.getCode().equals(contractEntity.getContractPerformanceState())){
            return false;
        }
        /*
            一个主合同仅有一个未生效得补充协议
            单据生效： 当单据审批通过，且签章状态为已签章
         */
        LambdaQueryWrapper<OutRentContractEntity> lambda = new LambdaQueryWrapper<>();
        lambda.eq(OutRentContractEntity::getMainContractId, id);
        lambda.eq(OutRentContractEntity::getSupplementFlag, 1);
        lambda.and(l -> l.ne(OutRentContractEntity::getSignatureState, String.valueOf(SignatureStatusEnum.已签章.getCode())).or(c -> c.notIn(OutRentContractEntity::getBillState, BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode())));
        List<OutRentContractEntity> supplementList = super.list(lambda);
        return supplementList.size() == 0;
    }
    @Override
    public ExecutionVO targetCost(OutRentContractVO contractVO, String linkUrl) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getCode());
        totalVO.setBillType(OutRentConstants.BILL_TYPE_OUT_CONTRACT);
        totalVO.setBussinessType(BussinessTypeEnum.设备租赁合同.getCode());
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setProjectId(contractVO.getProjectId());
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setMoney(contractVO.getContractMny());
        totalVO.setTaxMoney(contractVO.getContractTaxMny());
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        return executionVO;
    }
    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Object> resp = new HashMap<>();
        QueryWrapper wrapper = changeToQueryWrapper(param);
        wrapper.select("sum(base_tax_mny) as baseTaxMny, sum(contract_tax_mny) as contractTaxMny");
        resp = super.getMap(wrapper);
        if (null == resp) {
            resp = new HashMap<>();
            resp.put("baseTaxMny", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;
    }

    /**
     * 补充协议详情
     * @param id
     * @return
     */
    @Override
    public OutRentContractVO querySupplementRecord(Long id) {
        OutRentContractEntity contractEntity = super.selectById(id);
        OutRentContractVO contractVO = new OutRentContractVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        contractVO.setId(id);
        contractVO.setContractTaxMny(contractTaxMny);
        contractVO.setChangeStatus(contractEntity.getChangeStatus());
        contractVO.setContractType(contractEntity.getContractType());
        QueryWrapper<OutRentContractEntity> query = new QueryWrapper<>();
        query.eq("main_contract_id", id);
        query.eq("contract_performance_state", PerformanceStatusEnum.履约中.getCode());
        query.orderByDesc("create_time");
        List<OutRentContractEntity> supplementEntities = super.list(query);

        contractVO.setSupplementList(BeanMapper.mapList(supplementEntities, OutRentContractVO.class));
        //补充协议次数
        contractVO.setSupplementNum(supplementEntities.size());
        //设置累计补充总金额
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(supplementEntities)){
            for (OutRentContractEntity c : supplementEntities){
                if (c.getContractTaxMny() != null){
                    allSupplementAmt = c.getContractTaxMny().add(allSupplementAmt);
                }
            }
        }
        contractVO.setAllSupplementMny(allSupplementAmt);
        //设置补充金额比例
        contractVO.setSupplementMnyRate(BigDecimal.ZERO.compareTo(contractTaxMny) != 0 ? (allSupplementAmt.divide(contractTaxMny, 8, BigDecimal.ROUND_HALF_UP)).multiply(new BigDecimal(100)) : BigDecimal.ZERO);

        //判断能否新增补充协议
        if (SignatureStatusEnum.已签章.getCode().equals(contractEntity.getSignatureState())
                && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState()))
                && (!(PerformanceStatusEnum.已作废.getCode().equals(contractEntity.getContractPerformanceState()) || PerformanceStatusEnum.已冻结.getCode().equals(contractEntity.getContractPerformanceState())))){
            contractVO.setEditFlag(this.addSupplementFlag(id));
        }
        return contractVO;
    }

    /**
     * 推送合同项目池
     *
     * @param contractVO 需要推送的合同数据
     */
    @Override
    public void pushContract(OutRentContractVO contractVO) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert(contractVO, data);
            data.setSourceType(ContractTypeEnum.设备公司设备租赁合同.getTypeCode());
            data.setContractProperty(ContractPropertyEnum.支出合同.getPropertyCode());

            data.setPcCardUrl("/ejc-proequipmentcorp-frontend/#/leaseContract/cardList?id=" + contractVO.getId() + "&showTitle=true&supplementFlag="+contractVO.getSupplementFlag());
            logger.info("开始推送合同池>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            logger.info("推送数据：{}", JSONObject.toJSONString(data));
            CommonResponse<ContractPoolVO> transDataResp = contractPoolApi.saveOrUpdateContract(data);
            logger.info("推送合同池结束，推送结果：{}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", transDataResp.isSuccess());
            if (!transDataResp.isSuccess()) {
                logger.error("合同id-{}推送合同池失败，{}", contractVO.getId(), transDataResp.getMsg());
            }
        }
        catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", contractVO.getId(), e);
        }
    }

    @Override
    public String validateContract(Long contractId, String billType, Long billId, String type) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic(ComplexParam.AND);
        c1.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));
        ComplexParam c2 = new ComplexParam();
        c2.setLogic(ComplexParam.OR);
        c2.getParams().put("bill_state", new Parameter(QueryParam.IN, "1,3"));
        c2.getParams().put("signature_state", new Parameter(QueryParam.NE, SignatureStatusEnum.已签章.getCode()));
        c1.getComplexParams().add(c2);

        // 同一个合同只能存在一个自由态或审批中的单据
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("main_contract_id", new Parameter(QueryParam.EQ, contractId));
        queryParam.getComplexParams().add(c1);


        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam2.getComplexParams().add(c1);


        QueryParam queryParam3 = new QueryParam();
        queryParam3.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam3.getParams().put("bill_state", new Parameter(QueryParam.NOT_IN, "1,3"));

        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        QueryParam param = BeanMapper.map(queryParam, QueryParam.class);
        QueryParam param2 = BeanMapper.map(queryParam2, QueryParam.class);
        QueryParam param3 = Utils.deepCopy(queryParam3);// 深拷贝
        if(billId != null){
            param.getParams().put("id", new Parameter(QueryParam.NE, billId));
            param2.getParams().put("id", new Parameter(QueryParam.NE, billId));
            param3.getParams().put("id", new Parameter(QueryParam.NE, billId));
        }

        Future<JSONArray> future1 = ListCallable.excute(threadPool, MaterialConstant.补充协议.equals(billType) ? param : queryParam, service); // 补充协议
        Future<JSONArray> future2 = ListCallable.excute(threadPool, MaterialConstant.变更单.equals(billType) ? param2 : queryParam2, contractChangeService); // 变更单
        Future<JSONArray> future3 = ListCallable.excute(threadPool, MaterialConstant.解除单.equals(billType) ? param2 : queryParam2, outRentContractRelieveService); // 解除单
        Future<JSONArray> future4 = ListCallable.excute(threadPool, MaterialConstant.冻结单.equals(billType) ? param3 : queryParam3, outRentContractFreezeService); // 冻结单

        List<OutRentContractEntity> supplementList = new ArrayList<>(); // 补充协议
        List<OutRentContractChangeEntity> changeList = new ArrayList<>(); // 变更单
        List<OutRentContractRelieveEntity> relieveList = new ArrayList<>(); // 解除单
        List<OutRentContractFreezeEntity> freezeList = new ArrayList<>(); // 冻结单

        try {
            supplementList = JSONObject.parseArray(future1.get().toJSONString(), OutRentContractEntity.class);
            changeList = JSONObject.parseArray(future2.get().toJSONString(), OutRentContractChangeEntity.class);
            relieveList = JSONObject.parseArray(future3.get().toJSONString(), OutRentContractRelieveEntity.class);
            freezeList = JSONObject.parseArray(future4.get().toJSONString(), OutRentContractFreezeEntity.class);
        } catch (Exception e) {
            logger.error("查询数据异常", e);
        } finally {
            threadPool.shutdown();
        }
        if(ListUtil.isNotEmpty(supplementList)){
            throw new BusinessException("当前合同存在非审批通过态或未签章的补充协议，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(changeList)){
            throw new BusinessException("当前合同存在非审批通过态或未签章的变更单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(freezeList)){
            throw new BusinessException("当前合同存在非审批通过态的冻结单，不允许" + type + "!");
        }
        if(CollectionUtils.isNotEmpty(relieveList)){
            throw new BusinessException("当前合同存在非审批通过态或未签章的解除单，不允许" + type + "!");
        }

        return "校验通过！";
    }

    /**
     * 重置单据基础字段
     *
     * @param entity
     */
    private void clearBaseFields(OutRentContractEntity entity) {
        entity.setId(null);
        entity.setCreateTime(null);
        entity.setCreateUserCode(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
    }

    /**
     * 查询子表数据
     * @return
     */
    @Override
    public IPage<OutRentContractEquipmentAllVO> queryEquipmentSubList(Map<String, Object> param ) {
        IPage<OutRentContractEquipmentAllVO> page = new Page<OutRentContractEquipmentAllVO>();


        /** 数据隔离 本下 */
        //param.put("orgIds",iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList()));
        param.put("tenantId", InvocationInfoProxy.getTenantid());

        Integer count = outRentContractMapper.countNumber(param);
        if(count>0){
            List<OutRentContractEquipmentAllVO> appEntity = outRentContractMapper.queryEquipmentSubList(param);
            page.setRecords(appEntity);
        }else{
            page.setRecords(new ArrayList<>());
        }
        if(param.get("pageIndex")!=null){
            page.setCurrent(Integer.parseInt(param.get("pageIndex").toString()));
            page.setSize(Integer.parseInt(param.get("pageSize").toString()));
            page.setTotal(count);
        }
        return page;
    }

    @Override
    public Boolean delContractFile(Long contractFileId, String authority) {
        Map<String, Object> params = new HashMap<>();
        Map<String, String> header = new HashMap<>();
        params.put("ids", contractFileId.toString());
        header.put("authority", authority);

        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get(BaseHost + "ejc-file-web/attachment/delete", params, header, 10000, 10000);
        } catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse<String> delResp = JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            logger.info("在线起草，删除上传合同返回信息：" + delResp.getMsg());
        }
        return true;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<OutRentContractVO> vos) {
        vos.forEach(contractVO ->{
            OutRentContractEntity contractEntity = super.getById(contractVO.getId());
            if (null != contractEntity.getTargetResultId()){
                CommonResponse<String>  tender = tenderApi.updateById(contractEntity.getTargetResultId(), 0);
                logger.info("定标结果占用状态修改为未占用状态信息：" + tender.getMsg());
            }
        });
        this.removeByIds(vos.stream().map(OutRentContractVO::getId).collect(Collectors.toList()),false);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public OutRentContractEntity selectCode(String code) {
        QueryWrapper<OutRentContractEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("code", code);
        queryWrapper.eq("dr","0");
        List<OutRentContractEntity> list =outRentContractMapper.selectList(queryWrapper);
        if(CollectionUtils.isNotEmpty(list)){
            return list.get(0);
        }
        return null;
    }

    /**
     * 弃审后删除合同池中的合同
     *
     * @param contractVO 需要删除的合同数据
     */
    @Override
    public void pushDelContract(OutRentContractVO contractVO) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert(contractVO, data);
            data.setSourceType(ContractTypeEnum.设备公司设备租赁合同.getTypeCode());
            data.setContractProperty(ContractPropertyEnum.支出合同.getPropertyCode());
            data.setSourceId(contractVO.getId());
            logger.info("开始删除合同池合同>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            logger.info("推送数据：{}", JSONObject.toJSONString(data));
            CommonResponse<String> transDataResp = contractPoolApi.deleteContract(data);
            logger.info("删除合同池合同结束，删除结果：{}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", transDataResp.isSuccess());
            if (!transDataResp.isSuccess()) {
                logger.error("合同id-{}推送合同池失败，{}", contractVO.getId(), transDataResp.getMsg());
            }
        }
        catch (Exception e) {
            logger.error("合同-{}推送合同池失败，", contractVO.getId(), e);
        }
    }

    @Override
    public CommonResponse<OutRentContractVO> saveOrUpdate(OutRentContractVO outRentContractVO,String authority,Boolean isControl) {
        List<OutRentContractEntity> entities = null;
        List<OutRentContractChangeEntity> entitiesc = null;
        Long tenantId = InvocationInfoProxy.getTenantid();
        // parentOrgCode如果是空的，则需要查询赋值
//        if (StringUtils.isEmpty(outRentContractVO.getParentOrgCode()) && outRentContractVO.getParentOrgId() != null) {
//            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(outRentContractVO.getParentOrgId());
//            if (orgResponse.isSuccess()) {
//                OrgVO orgVO = orgResponse.getData();
//                outRentContractVO.setParentOrgCode(orgVO.getCode());
//            }
//        }
//        // orgCode如果是空的，则需要查询赋值
//        if (StringUtils.isEmpty(outRentContractVO.getOrgCode()) && outRentContractVO.getOrgId() != null) {
//            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(outRentContractVO.getOrgId());
//            if (orgResponse.isSuccess()) {
//                OrgVO orgVO = orgResponse.getData();
//                outRentContractVO.setOrgCode(orgVO.getCode());
//            }
//        }
        if (outRentContractVO.getOrgId() != null && (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(outRentContractVO.getOrgCode()) || com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(outRentContractVO.getParentOrgCode()))) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(outRentContractVO.getOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                outRentContractVO.setOrgCode(orgVO.getCode());
                if(StringUtils.isEmpty(outRentContractVO.getOrgName())){
                    outRentContractVO.setOrgName(orgVO.getName());
                }
                // 项目部
                if(5 == orgVO.getOrgType()){
                    CommonResponse<OrgVO> parentOrgResponse = iOrgApi.getOneById(orgVO.getParentId());
                    if (parentOrgResponse.isSuccess()) {
                        OrgVO parentOrgVO = parentOrgResponse.getData();
                        outRentContractVO.setParentOrgId(parentOrgVO.getId());
                        outRentContractVO.setParentOrgCode(parentOrgVO.getCode());
                        outRentContractVO.setParentOrgName(parentOrgVO.getName());
                    }
                }
                // 非项目部
                else {
                    outRentContractVO.setParentOrgId(outRentContractVO.getOrgId());
                    outRentContractVO.setParentOrgCode(outRentContractVO.getOrgCode());
                    outRentContractVO.setParentOrgName(outRentContractVO.getOrgName());
                }
            }
        }
        OutRentContractEntity entity = BeanMapper.map(outRentContractVO, OutRentContractEntity.class);
        //起草方式为使用合同模板时，将合同文件同步标识置为未同步
        if(DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType()) || DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(entity.getDraftType())) {
            entity.setContractFileSyncFlag(false);
        }
        if (!isControl){
            // 回写定标结果占据状态
            if (entity.getTargetResultId() != null) {
                // 校验 本合同金额+定标已签合同金额 是否大于 定标金额
                validateTargetMny(entity);
            }
            //定标回写占用
            //占用状态0-未占用,1-已占用,2-已完成
            if (entity.getId() == null && entity.getTargetResultId() != null) {
                  updateTargetResult(entity, 0);
            }
            if (entity.getId() != null && entity.getTargetResultId() != null) {
                OutRentContractEntity outRentContractEntity = super.selectById(entity.getId());
                // 如果是合同修改，先对修改前合同做反向操作，再进行占用
                updateTargetResult(outRentContractEntity, 1);
                updateTargetResult(entity, 0);
            }
            if(entity.getId() == null || entity.getId() == 0){
//                BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),outRentContractVO);
//                CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
//                if(billCode.isSuccess()) {
                    entity.setSignatureState(SignatureStatusEnum.未签章.getCode());
                    entity.setSupplementFlag(0);
                    entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
                    entity.setMainContractCreateDate(new Date());
//                }else{
//                    throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
//                }

            }
            if(StringUtils.isEmpty(entity.getCode())){
                switch (GenerateBillCodeType) {
                    case "common":
                        CommonResponse<String> billCode = billCodeApi.generateBillCode(BillCodeParam.build(OutRentConstants.BILL_CODE_OUT_CONTRACT, InvocationInfoProxy.getTenantid(), outRentContractVO));
                        if (!billCode.isSuccess()) {
                            logger.error("保存合同失败，自动生成合同合同失败: {}", billCode.getMsg());
                            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                        }
                        entity.setCode(billCode.getData());
                        break;
                    case "ynjt":
                        CommonResponse<String> billCodeFirstPart = billCodeApi.generateBillCode(BillCodeParam.build(OutRentConstants.BILL_CODE_OUT_CONTRACT_YNJT, InvocationInfoProxy.getTenantid(), outRentContractVO));
                        if(!billCodeFirstPart.isSuccess()) {
                            logger.error("保存合同失败，自动生成合同合同失败: {}", billCodeFirstPart.getMsg());
                            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                        }
                        //根据合同基层单位后三位查询查询流水号
                        CommonSNVO commonSNVO = new CommonSNVO();
                        commonSNVO.setSnLength(4);
                        commonSNVO.setTenantId(InvocationInfoProxy.getTenantid());
                        commonSNVO.setDimension(entity.getParentOrgCode().substring(entity.getParentOrgCode().length() - 3));
                        commonSNVO.setSourceType(GenerateSourceType);
                        CommonResponse<String> snResp = commonSNAPI.getNext(commonSNVO);
                        if(!snResp.isSuccess()) {
                            throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
                        }
                        entity.setCode(billCodeFirstPart.getData() + entity.getParentOrgCode().substring(entity.getParentOrgCode().length() - 3) + snResp.getData());
                        outRentContractVO.setCode(entity.getCode());
                        break;
                }
//                        entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }
        }

        //修改  校验合同编号是否重复   需校验合同表和变更表(状态为变更中)同时唯一
        if (outRentContractVO.getId() != null && outRentContractVO.getId() > 0) {

            LambdaQueryWrapper<OutRentContractEntity> lambda = Wrappers.<OutRentContractEntity>lambdaQuery();
            lambda.eq(OutRentContractEntity::getCode, outRentContractVO.getCode());
            lambda.eq(OutRentContractEntity::getTenantId, tenantId);
            lambda.ne(OutRentContractEntity::getId, outRentContractVO.getId());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", 0));//过滤补合同充协议
            queryParam.getParams().put("code", new Parameter(QueryParam.EQ, outRentContractVO.getCode()));
            queryParam.getParams().put("contract_id", new Parameter(QueryParam.NE, outRentContractVO.getId()));
            entitiesc = contractChangeService.queryList(queryParam, false);
        } else {
            //校验合同编号是否重复
            LambdaQueryWrapper<OutRentContractEntity> lambda = Wrappers.<OutRentContractEntity>lambdaQuery();
            lambda.eq(OutRentContractEntity::getTenantId, tenantId);
            lambda.eq(OutRentContractEntity::getCode, outRentContractVO.getCode());
            entities = super.list(lambda);

            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter(QueryParam.EQ, tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", 0));//过滤补合同充协议
            queryParam.getParams().put("code", new Parameter(QueryParam.EQ, outRentContractVO.getCode()));
            entitiesc = contractChangeService.queryList(queryParam, false);

            entity.setId(IdWorker.getId());
            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.未变更.getCode());
            entity.setMainContractCreateDate(new Date());
        }
        if ((entities != null && entities.size() > 0) || (entitiesc != null && entitiesc.size() > 0)) {
            throw new BusinessException("存在相同编码，不允许保存!");
        }

        //设置合同初始金额
        entity.setBaseMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        //设置变更前金额
        entity.setBeforeChangeMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
//        if (entity.getContractFileId() != null && !isControl) {
//            if (entity.getId() != null) {
//                OutRentContractEntity contract = service.getById(entity.getId());
//                //如果改合同上次修改的起草方式不是线上起草  且 这次改为线上起草，则删除附件
//                if (contract != null && !DraftTypeEnum.线上起草.getCode().toString().equals(contract.getDraftType()) && DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())) {
//                    service.delContractFile(entity.getContractFileId(), authority);
//                    entity.setContractFileId(null);
//                    entity.setContractFile(null);
//                }
//            } else {
//                //如果是新建合同，且起草方式为线上起草则删除附件
//                if (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType())) {
//                    service.delContractFile(entity.getContractFileId(), authority);
//                    entity.setContractFileId(null);
//                    entity.setContractFile(null);
//                }
//            }
//        }
        // 1、合同保存方法增加逻辑
        if (entity.getContractFileId() != null) {
            //合同旧数据
            OutRentContractEntity contract = service.getById(entity.getId());
            if (contract != null && (
                    //如果当前合同是线上起草，而且合同分类做了变更，那么删除附件
                    !contract.getContractType().equals(entity.getContractType())
                            //如果改合同上次修改的起草方式不是线上起草  且 这次改为线上起草，则删除附件
                            || !(DraftTypeEnum.线上起草.getCode().toString().equals(contract.getDraftType())
                            || DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(contract.getDraftType()))
            ) && (DraftTypeEnum.线上起草.getCode().toString().equals(entity.getDraftType()) ||
                    DraftTypeEnum.线上起草不使用电子签章.getCode().toString().equals(entity.getDraftType())
            )) {
                if (Boolean.FALSE.equals(isControl) && null != contract.getContractFileId()) {
                    delContractFile(contract.getContractFileId(), authority);
                }
                entity.setContractFileId(null);
                entity.setContractFile(null);
            }
        }
        if (!isControl){
            if (outRentContractVO.getId() != null && outRentContractVO.getTargetResultId() != null) {
                OutRentContractEntity outRentContractEntity = super.selectById(outRentContractVO.getId());
                CommonResponse<String> stringCommonResponse = tenderApi.updateById(outRentContractEntity.getTargetResultId(), 0);
                tenderApi.updateById(outRentContractVO.getTargetResultId(), 1);
            }

            //设置归档状态
            if (entity.getFilingStatus()==null){
                entity.setFilingRef(0);
            }

            super.saveOrUpdate(entity, false);

            //目标成本推送
//            String linkUrl = BaseHost + "ejc-proequipment-frontend/#/leaseContract/card?id=" + entity.getId();
//            ExecutionVO executionVO = service.targetCost(BeanMapper.map(entity, OutRentContractVO.class),linkUrl);
//            logger.info("目标成本推送数据"+ JSON.toJSONString(executionVO));
//            CommonResponse<String> response = executionApi.aggPush(executionVO);
//            if (!response.isSuccess()){
//                throw new BusinessException("目标成本推送失败,"+response.getMsg());
//            }
        }

        OutRentContractVO vo = BeanMapper.map(entity, OutRentContractVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);

    }

    @Override
    public ParamsCheckVO targetCostCtrl(OutRentContractVO contractVO, String authority) {
        OutRentContractVO contractVO1 = saveOrUpdate(contractVO,authority, true).getData();
        //目标成本推送
        String linkUrl = BaseHost + "ejc-proequipment-frontend/#/leaseContract/card?id=" + contractVO1.getId();
        ExecutionVO executionVO = service.targetCost(contractVO1,linkUrl);
        logger.error("ss" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
        //参数控制
        ParamsCheckVO paramsCheckVO = checkParams(contractVO1, response.getData());
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        OutRentContractVO contractVO = queryDetail(id);
        String linkUrl = BaseHost + "ejc-proequipment-frontend/#/leaseContract/card?id=" + contractVO.getId();
        ExecutionVO executionVO = service.targetCost(contractVO,linkUrl);
        logger.error("ss" + JSONObject.toJSONString(executionVO));
        CommonResponse<ParamsCheckVO> response = executionApi.ctrlCheckVO(executionVO);
//参数控制
        ParamsCheckVO paramsCheckVO = checkParams(contractVO, response.getData());
        return paramsCheckVO;
    }

    @Override
    public OutRentContractVO queryDetail(Long id) {
        OutRentContractEntity entity = service.selectById(id);
        OutRentContractVO vo = BeanMapper.map(entity, OutRentContractVO.class);
        return vo;
    }

    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        //有解除单推送解除数据
//        ExecutionVO executionVO = new ExecutionVO();
        OutRentContractEntity outRentContractEntity = service.selectById(id);
        if (ContractStatusEnum.已作废.getCode().toString().equals(outRentContractEntity.getContractPerformanceState())){
            //查询解除单
            QueryWrapper<OutRentContractRelieveEntity> relieveQueryWrapper = new QueryWrapper<OutRentContractRelieveEntity>();
            relieveQueryWrapper.eq("contract_id", id);
            OutRentContractRelieveEntity outRentContractRelieveEntity = outRentContractRelieveService.getOne(relieveQueryWrapper);
            ExecutionVO executionVO = outRentContractRelieveService.targetCost(outRentContractRelieveEntity);
            logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
            CommonResponse<String> response = executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("目标成本推送失败," + response.getMsg());
            }
        }

        //有变更单推送变更单数据,否则推送主合同数据
        QueryWrapper<OutRentContractChangeEntity> outRentContractChangeEntityQueryWrapper = new QueryWrapper<OutRentContractChangeEntity>();
        outRentContractChangeEntityQueryWrapper.eq("contract_id", id).orderByDesc("create_time");
        ExecutionVO executionVO = new ExecutionVO();
        List<OutRentContractChangeEntity> contractChangeEntityList = outRentContractChangeService.list(outRentContractChangeEntityQueryWrapper);
        if(contractChangeEntityList.size() > 0){
            OutRentContractChangeEntity outRentContractChangeEntity = outRentContractChangeService.selectById(contractChangeEntityList.get(0).getId());
            executionVO = outRentContractChangeService.targetCost(BeanMapper.map(outRentContractChangeEntity, OutRentContractChangeVO.class),null);
        }else {
            //目标成本推送
            OutRentContractVO outRentContractVO = service.queryDetail(id);
            String linkUrl = BaseHost + "ejc-proequipment-frontend/#/leaseContract/card?id=" + outRentContractVO.getId();
            executionVO = service.targetCost(outRentContractVO, linkUrl);
        }

        logger.info("目标成本推送数据" + JSON.toJSONString(executionVO));
        CommonResponse<String> response = executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("目标成本推送失败," + response.getMsg());
        }
        return CommonResponse.success("目标成本推送成功");
    }

    //单据参数控制
    @Override
    public ParamsCheckVO checkParams(OutRentContractVO vo, ParamsCheckVO paramsCheckVO2){
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*添加参数控制区域---*/
//        if(CollectionUtils.isNotEmpty(this.checkParamsConstruction(vo))){
//            paramsCheckVOS.addAll(this.checkParamsConstruction(vo));//施工合同控制
//        }
        paramsCheckVOS.addAll(this.checkParamsMnyPlan( vo));//总计划控制补充、主合同金额
        if(vo.getSupplementFlag()!=null && Objects.equals(vo.getSupplementFlag(), OutRentContractVO.CONTRACT_TYPE_SUPPLEMENT)){
            paramsCheckVOS.addAll(this.checkParamsMnySup(vo));//合同金额控制补充协同金额
        }
        if(paramsCheckVO2!=null){//组合成本参数
            paramsCheckVOS.add(paramsCheckVO2);
        }
        /*添加参数控制区域---*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }
    //施工合同参数控制
    @Override
    public List<ParamsCheckVO>  checkParamsConstruction(OutRentContractVO vo) {
        CommonResponse<List<ParamsCheckVO> > response = paramCheckApi.paramsCheck(vo.getProjectId(), vo.getId(), vo.getContractTaxMny(),vo.getOrgId());
        logger.info("施工合同控制信息返回："+JSONObject.toJSONString(response.getData()));
        if(!response.isSuccess()){
            throw new BusinessException("获取施工参数控制信息失败!"+response.getMsg());
        }
        return response.getData();
    }
    /**
     * 单据管控-补充协议金额大于合同金额
     * @return
     */
    @Override
    public List<ParamsCheckVO> checkParamsMnySup(OutRentContractVO vo) {
        BigDecimal contractTaxMnySup = vo.getContractTaxMny()==null?BigDecimal.ZERO:vo.getContractTaxMny();//本次补充协议金额
        OutRentContractEntity contractEntity = super.selectById(vo.getMainContractId());
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny()==null?BigDecimal.ZERO:contractEntity.getContractTaxMny();//初始合同金额
        BigDecimal totalSupMoney =  contractTaxMnySup;//累计补充金额  默认赋值本次
        //查询累计补充金额
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter(QueryParam.EQ, vo.getMainContractId()));
        if (vo.getId() != null) {
            supplementQueryParam.getParams().put("id", new Parameter(QueryParam.NE, vo.getId()));
        }
        supplementQueryParam.getParams().put("mainContractId", new Parameter(QueryParam.EQ, vo.getMainContractId()));
        supplementQueryParam.getParams().put("signatureState", new Parameter(QueryParam.EQ, SignatureStatusEnum.已签章.getCode()));
        List<OutRentContractEntity> supplementContractList = super.queryList(supplementQueryParam, false);
        if(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(supplementContractList)){
            for (OutRentContractEntity entity : supplementContractList) {
                totalSupMoney = ComputeUtil.safeAdd(entity.getContractTaxMny(),totalSupMoney);//累加变更金额
            }
        }
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
//        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_SUP_CODE);
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_SUP_CODE,vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("协议金额控制信息返回："+JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(contractTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalSupMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("补充协议超合同金额");
                        paramsCheckDsVO.setWarnName("累计补充协议金额大于合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次补充协议金额：").append(contractTaxMnySup.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次补充协议金额：").append(totalSupMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，合同金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalSupMoney, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }

        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }
    /**
     * 单据管控-合同金额大于总计划金额
     * @return
     */
    @Override
    public List<ParamsCheckVO> checkParamsMnyPlan(OutRentContractVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        BigDecimal contractTaxMny = vo.getContractTaxMny()==null?BigDecimal.ZERO:vo.getContractTaxMny();//本次合同金额
        BigDecimal planTaxMny = BigDecimal.ZERO;//总计划金额
        BigDecimal totalMoney =  contractTaxMny;//累计合同金额  默认赋值本次
        //查询总计划
//        LambdaQueryWrapper<OutRentTotalPlanEntity> planLambda = new LambdaQueryWrapper<>();
//        planLambda.eq(OutRentTotalPlanEntity::getProjectId, vo.getProjectId());
//        planLambda.in(OutRentTotalPlanEntity::getBillState,1,3);
//        planLambda.eq(OutRentTotalPlanEntity::getDr,0);
//        List<OutRentTotalPlanEntity> planList = outRentTotalPlanService.list(planLambda);
//        if(CollectionUtils.isNotEmpty(planList)){
//            planTaxMny = planList.stream().filter(e -> e.getTemporaryAmount() != null).map(OutRentTotalPlanEntity::getTemporaryAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
//        }else {
//            return paramsCheckVOList;
//        }
        //查询合同
        LambdaQueryWrapper<OutRentContractEntity> Lambda = new LambdaQueryWrapper<>();
        Lambda.eq(OutRentContractEntity::getProjectId, vo.getProjectId());
        Lambda.orderByDesc(OutRentContractEntity::getCreateTime);
        if (vo.getId() != null) {
            Lambda.ne(OutRentContractEntity::getId, vo.getId());//除本次
        }
        List<OutRentContractEntity> list = super.list(Lambda);//查询项目下所有合同
        if(CollectionUtils.isNotEmpty(list)){
            List<Long> collect = list.stream().map(OutRentContractEntity::getId).collect(Collectors.toList());
            List<OutRentContractChangeVO> contractChangeList = baseMapper.getRentContractChangeList(collect);//查询未生效的变更单
            Map<Long, OutRentContractChangeVO> mapChange = contractChangeList.stream().filter(t -> t.getContractId() != null).collect(Collectors.toMap(OutRentContractChangeVO::getContractId, item -> item, (v1, v2) -> v2));
//            List<OutRentSettlementVO> settlementList = baseMapper.getRentSettlementList(collect);//查询最后一个结算单
//            Map<Long, OutRentSettlementVO> mapSettle = settlementList.stream().filter(t -> t.getContractId() != null).collect(Collectors.toMap(OutRentSettlementVO::getContractId, item -> item, (v1, v2) -> v2));
            for (OutRentContractEntity entity : list) {
                BigDecimal zero = BigDecimal.ZERO;//要累加的金额
                if (PerformanceStatusEnum.已终止.getCode().equals(entity.getContractPerformanceState()) ||PerformanceStatusEnum.已作废.getCode().equals(entity.getContractPerformanceState())){
                    //合同已终止、已结束、已作废：取合同结算金额）  即最终结算或 最后一次结算  累计结算金额
//                    if(mapSettle.containsKey(entity.getId())){
//                        zero = mapSettle.get(entity.getId()).getCurrentSettlementTaxMny();
//                    }// 校验变更合同
                }else if(mapChange.containsKey(entity.getId())){//有为生效的变更单  取最新变更单金额
                    zero = mapChange.get(entity.getId()).getContractTaxMny();
                }else {//没有未生效的变更单   合同状态为 未签订、履约中、已冻结取签订金额
                    zero = entity.getContractTaxMny();
                }
                totalMoney = ComputeUtil.safeAdd(zero,totalMoney);//累加变更金额
            }
        }
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PLAN_CODE,vo.getOrgId());
//        CommonResponse<BillParamVO> billParamByCode = paramConfigApi.getBillParamByCode(CHECK_PLAN_CODE);
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("总计划金额控制信息返回："+JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(planTaxMny, roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    if (totalMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("租赁金额超总计划金额");
                        paramsCheckDsVO.setWarnName("租赁金额超总计划金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次合同金额：").append(contractTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次累计合同金额：").append(totalMoney.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，总计划金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalMoney, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }


        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }
    /**
     * 删除文件中心水印文件
     *
     * @param watermarkFileId 水印合同附件id
     * @return boolean 是否删除标识
     */
    @Override
    public boolean delWatermarkContractFile(Long watermarkFileId) {
        Assert.notNull(watermarkFileId, "水印合同附件不能为空！");
        CommonResponse<String> res = attachmentApi.delete(String.valueOf(watermarkFileId));
        if (!res.isSuccess()) {
            logger.error("删除文件中心水印文件失败，原因：{}，水印文件id：{}", res.getMsg(), watermarkFileId);
            throw new BusinessException("删除文件中心水印文件失败，原因：" + res.getMsg() + "，水印文件id：" + watermarkFileId);
        }
        return true;
    }

    @Override
    public ContractPaymentResultVO queryPaymentApplyList(Long id) {
        CommonResponse<ContractPaymentResultVO> res = paymentApplyApi.queryJsonByContractId(id);
        if (!res.isSuccess()){
            logger.error("获取付款详情失败!");
        }
        return res.getData();
    }
    /**
     * 占用/释放 定标结果
     *
     * @param vo   合同vo
     * @param type 0占用，1释放
     */
    @Override
    public void updateTargetResult(OutRentContractEntity vo, Integer type) {
        if (vo.getTargetResultId() == null){
            return;
        }

        TenderPicketageVO picketageVO = new TenderPicketageVO();
        picketageVO.setId(vo.getTargetResultId()); // 定标参照id
        picketageVO.setContractMoneyTax(vo.getContractTaxMny()); // 合同金额（含税）
        picketageVO.setContractMoney(vo.getContractMny()); // 合同金额
        List<TenderPicketageDetailVO> list = new ArrayList<>();
        picketageVO.setTenderPicketageDetailList(list);
        CommonResponse<String> response;
        String typeStr = 0 == type ? "占用" : "释放";
        logger.info("{}定标结果请求参数：{}", typeStr, JSONObject.toJSONString(picketageVO));
        // 占用
        if (0 == type) {
            response = tenderApi.updateStatus(picketageVO);
        }
        // 释放
        else {
            response = tenderApi.delUpdateStatus(picketageVO);
        }
        logger.info("{}定标结果请求结果：{}", typeStr, JSONObject.toJSONString(response));
        if (!response.isSuccess()) {
            throw new BusinessException(typeStr + "定标结果失败！");
        }
    }
    @Override
    public Boolean validateTargetMny(OutRentContractEntity entity) {
        LambdaQueryWrapper<OutRentContractEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(OutRentContractEntity::getTargetResultId, entity.getTargetResultId());
        if (entity.getId() != null) {
            wrapper.ne(OutRentContractEntity::getId, entity.getId());
        }
        List<OutRentContractEntity> list = this.list(wrapper);

        BigDecimal sumContractTaxMny = list.stream().map(OutRentContractEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        sumContractTaxMny = ComputeUtil.safeAdd(sumContractTaxMny, entity.getContractTaxMny());

        if (sumContractTaxMny.compareTo(entity.getTargetTaxMny()) > 0) {
            throw new BusinessException("合同累计签订金额超过定标金额，不可保存！");
        }

        return true;
    }
    /**
     * 根据定标结果id查询对应合同
     *
     * @param targetResultIdList 定标结果id
     * @return 查询结果
     */
    @Override
    public List<SignContractVo> queryContractByTargetResultId(List<String> targetResultIdList) {
        List<SignContractVo> rtnList = new ArrayList<>();
        if (CollectionUtils.isEmpty(targetResultIdList)) return rtnList;
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("targetResultId", new Parameter(QueryParam.IN, targetResultIdList));
        queryParam.getOrderMap().put("signedDate", QueryParam.DESC);
        List<OutRentContractEntity> entityList = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty(entityList)) return rtnList;
        for (OutRentContractEntity entity : entityList) {
            SignContractVo vo = new SignContractVo();
            vo.setBillCode(entity.getCode());
            vo.setContractId(entity.getId());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());
            vo.setSupplierName(entity.getSupplierName());
            vo.setContractMny(entity.getContractMny());
            vo.setContractTaxMny(entity.getContractTaxMny());
            vo.setSignDate(entity.getSignedDate());
            vo.setBillState(entity.getBillState());
            String url = "/ejc-proequipmentcorp-frontend/#/leaseContract/cardList?id=" + entity.getId() + "&showTitle=true";
            vo.setLinkUrl(url);
            rtnList.add(vo);
        }

        return rtnList;
    }

    /**
     * 根据合同id给水印文件赋值
     *
     * @param id 合同id
     */
    @Override
    public void asyncWatermarkById(Long id) {
        OutRentContractEntity contractEntity = super.selectById(id);
        // 合同添加水印
        // 水印系统参数
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("获取水印系统参数请求失败，失败原因：" + response.getMsg());
        }
        String valueData = response.getData().getValueData();
        Assert.hasText(valueData, "获取的水印系统参数不能为空!");

        // 是否限制： 0:不限制，1:限制
        logger.info("valueData"+valueData);
        if ("0".equals(valueData)) {
            logger.info("valueData"+valueData);
            // 转换水印参数配置：默认规则
            WatermarkVO watermarkVO = signatureCommonApi.fetchWatermarkConfig(contractEntity.getContractFileId(), contractEntity.getId(),
                    contractEntity.getCode(), OutRentConstants.BILL_TYPE_OUT_CONTRACT, OutRentConstants.FILE_SOURCE_TYPE_OUT_CONTRACT_WATER);
            Assert.notNull(watermarkVO, "获取水印系统参数失败!");
            // 获取上下文并异步调用添加水印
            HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, String> headers = new HashMap<>();
            headers.put("authority", request.getHeader("authority"));
            headers.put("ejc-token", request.getHeader("ejc-token"));
            outRentContractAsyncService.fetchWatermarkAttachment(headers, watermarkVO);
        }
    }
    /**
     * 获取合同归档控制参数  没有获取到参数默认不限制
     *
     * @return 合同归档控制参数(0：不限制，1：部分限制，2：全部限制)
     */
    @Override
    public String getContractFilingCode() {
        // 合同归档参数控制
        CommonResponse<ParamRegisterSetVO> response = paramConfigApi.getByCode(CONTRACT_FILING_CODE);
        logger.info("合同归档控制参数查询结果：{}", JSONObject.toJSONString(response));
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("获取合同归档控制参数请求失败，失败原因：" + response.getMsg());
        }
        String valueData = response.getData().getValueData();
//        Assert.hasText(valueData, "获取的合同归档控制参数不能为空!");
        return com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotEmpty(valueData) ? valueData : "0";
    }

    /**
     * 根据合同归档控制参数，校验合同能否新增变更、补充协议
     *
     * @param contractId 合同id
     * @return true：可以新增，false：不能新增
     */
    @Override
    public boolean checkContractFiling(Long contractId) {
        String valueData = this.getContractFilingCode();
        OutRentContractEntity outRentContractEntity = super.selectById(contractId);
        // 不限制
        if("0".equals(valueData)){
            return true;
        }
        // 部分限制、全部限制，合同未归档，都不能新增合同变更、补充协议
        else {
            return FilingStatusEnum.已归档.getTypeCode().equals(outRentContractEntity.getFilingStatus());
        }
    }

}
