package com.ejianc.business.proequipmentcorprent.ac.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorprent.ac.bean.ChangeEntity;
import com.ejianc.business.proequipmentcorprent.ac.bean.ContractEntity;
import com.ejianc.business.proequipmentcorprent.ac.enums.SignatureStatusEnum;
import com.ejianc.business.proequipmentcorprent.ac.service.IChangeService;
import com.ejianc.business.proequipmentcorprent.ac.service.IContractService;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractChangeEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractEntity;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.api.ISignatureManageApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * 合同文件管理控制
 *
 * @author CJ
 * @Description: 合同文件管理控制
 * @date 2021/11/26 14:16
 */
@RestController
@RequestMapping("/contractFileUpdate/")
public class ContractFileController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IContractService contractService;

    @Autowired
    private ISignatureManageApi signatureManageApi;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;

    private static final String BILL_TYPE = "EJCBT202204000008";//合同单据编码

    private static final String CHANGE_BILL_TYPE = "EJCBT202204000010";//变更合同单据编码

    @Autowired
    private IChangeService changeService;

    /**
     * 合同附件信息更新
     *
     * @param updateData {
     *   billId 单据Id
     *   sourceType 单据业务类型
     *   billType 单据类型
     *   fileId 文件Id
     *   fileSize 文件大小（以B为单位）
     *   fileName 文件名称
     *   fileOnlinePath 文件在线预览地址
     *   imgServerPath 文件服务地址
     *   formatPathStr 文件格式化地址
     * }
     * @return
     */
    @PostMapping(value = "updateFileInfo")
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        JSONObject resp = new JSONObject();

        ContractEntity contract = contractService.selectById(updateData.getLong("billId"));
        contract.setContractFileId(updateData.getLong("fileId"));
        contract.setContractFileHighlightId(updateData.getLong("fileId"));
        contract.setContractFilePath(updateData.getString("fileOnlinePath"));
        contract.setContractFileHighlightPath(updateData.getString("fileOnlinePath"));

        //将合同文件同步状态设置为已同步
        contract.setContractFileSyncFlag(true);

        contractService.saveOrUpdate(contract, false);

        resp.put("message", "合同文件信息更新成功");
        resp.put("billData", contract);
        return CommonResponse.success("合同文件信息更新成功！",resp);
    }

    /**
     * 获取合同签章完的文件信息
     *
     * @param billId 合同Id
     * @param billType 单据类型：contract-主合同/变更协议, contractChange-合同变更、协议变更
     * @return
     */
    @GetMapping(value = "getSignedFileInfo")
    public CommonResponse<JSONObject> getSignedFileInfo(@RequestParam(value = "billId") Long billId, @RequestParam(value = "billType") String billType) {
        JSONObject resp = new JSONObject();
        String contractBillTypeStr = "contract";
        ArrayList<ContractVO> cvs = new ArrayList<>();
        ContractVO cv = new ContractVO(); // 签章中的合同vo
        if(contractBillTypeStr.equals(billType)){
            ContractEntity contract = contractService.selectById(billId);
            Assert.notNull(contract, "查询不到主合同详情");
            cv.setContractId(contract.getId());
            cv.setContractName(contract.getContractName());
            cv.setSourceType(billType);
            cv.setBillType(BILL_TYPE);
        }
        else {
            ChangeEntity contractChange = changeService.selectById(billId);
            cv.setContractId(contractChange.getId());
            cv.setContractName(contractChange.getContractName());
            cv.setSourceType(billType);
            cv.setBillType(CHANGE_BILL_TYPE);
        }
        cvs.add(cv);

//        CommonResponse<List<SignMgrPreviewVO>> signResp = signatureManageApi.previewContract(billId, Arrays.asList(new String[]{SignatureStatusEnum.已签章.getCode()}));
        CommonResponse<List<SignMgrPreviewVO>> signResp = signatureCommonApi.fetchSignedContract(cvs);
        if(!signResp.isSuccess()) {
            logger.error("获取单据id-{}，billType-{}签章文件信息失败: {}", billId, billType, signResp.getMsg());
            return CommonResponse.error("获取合同签章文件信息失败!");
        }

        List<SignMgrPreviewVO> fileList = signResp.getData();
        if(CollectionUtils.isEmpty(fileList)) {
            return CommonResponse.error("为获取到合同签章文件信息！");
        }

        SignMgrPreviewVO signedFileInfo = signResp.getData().get(0);
        if(contractBillTypeStr.equals(billType)) {
            ContractEntity contract = contractService.selectById(billId);
            contract.setSignedFileId(signedFileInfo.getFileId());
            contractService.saveOrUpdate(contract, false);
        } else {
            ChangeEntity contractChange = changeService.selectById(billId);
            contractChange.setSignedFileId(signedFileInfo.getFileId());
            changeService.saveOrUpdate(contractChange, false);
        }

        resp.put("fileId", signedFileInfo.getFileId());
        resp.put("filePath", signedFileInfo.getFilePath());
        resp.put("fileTruePath", signedFileInfo.getTruePath());

        return CommonResponse.success("查询成功！", resp);
    }
}
