/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorpout.outLedger.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorpout.constants.MeterRentTypeEnum;
import com.ejianc.business.proequipmentcorpout.constants.RentOutStatusEnum;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterService;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/equipOutRentLedger/"})
public class OutRentParameterController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOutRentParameterService service;

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutRentParameterVO> queryDetail(Long id) {
        OutRentParameterEntity entity = (OutRentParameterEntity)((Object)this.service.selectById(id));
        OutRentParameterVO vo = (OutRentParameterVO)BeanMapper.map((Object)((Object)entity), OutRentParameterVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutRentParameterVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OutRentParameterVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("equipLeaveFactoryCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("rentName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("outOrgName");
        fuzzyFields.add("equipmentTypeName");
        fuzzyFields.add("spec");
        fuzzyFields.add("unit");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutRentParameterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("equipLeaveFactoryCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("rentName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("outOrgName");
        fuzzyFields.add("equipmentTypeName");
        fuzzyFields.add("spec");
        fuzzyFields.add("unit");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List vos = BeanMapper.mapList((Iterable)list, OutRentParameterVO.class);
        if (CollectionUtils.isNotEmpty((Collection)vos)) {
            vos.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                vo.setRentCalculationTypeName(MeterRentTypeEnum.getEnumByCode((String)vo.getMeterRentType()).getName());
                vo.setRentOutStatusName(RentOutStatusEnum.getEnumByCode((Integer)vo.getRentOutStatus()).getName());
            });
        }
        beans.put("records", vos);
        ExcelExport.getInstance().export("EquipRentOutLedger-export.xlsx", beans, response);
    }
}

