/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorpout.outrent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorpout.outrent.Enums.OutRentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorpout.outrent.bean.OutRentEquipmentStartEntity;
import com.ejianc.business.proequipmentcorpout.outrent.bean.OutRentEquipmentStartSubEntity;
import com.ejianc.business.proequipmentcorpout.outrent.service.IOutRentEquipmentStartService;
import com.ejianc.business.proequipmentcorprent.ac.enums.BillPushStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterDetailEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterEntity;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentAcceptanceService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterDetailService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterService;
import com.ejianc.business.proequipmentcorprent.rent.vo.EquipmentNewDateVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

@Service(value="outRentEquipmentStart")
public class OutRentEquipmentStartBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IOutRentEquipmentStartService outRentEquipmentStartService;
    @Autowired
    private IRentParameterService rentParameterService;
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Autowired
    private IRentParameterDetailService rentParameterDetailService;
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private IRentAcceptanceService rentAcceptanceService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String BILL_TYPE = "BT220221000000003";
    private static final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/equipmentStart/saveStart";
    private final String PUSH_DELETE_URL = "/ejc-supbusiness-web/openapi/equipmentStart/deleteStart";
    private final String OPERATE = "RENT-PROEQUIPMENT-START";

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OutRentEquipmentStartEntity entity = (OutRentEquipmentStartEntity)((Object)this.outRentEquipmentStartService.selectById(billId));
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(entity.getBillPushFlag())) {
            CommonResponse ejcCloudSystemCode = this.proSupplierApi.getEjcCloudSystemCode();
            if (!ejcCloudSystemCode.isSuccess()) {
                throw new BusinessException("\u83b7\u53d6\u5f53\u524d\u7cfb\u7edf\u7f16\u7801\u5931\u8d25\uff01");
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("sourceId", billId);
            map.put("systemId", ejcCloudSystemCode.getData());
            String dataInfo = JSONObject.toJSONString(map);
            Boolean updateSupplierStatus = this.rentAcceptanceService.updateSupplierStatus(billId, dataInfo, "/ejc-supbusiness-web/openapi/equipmentStart/deleteStart", RequestMethod.POST, entity.getSupplierId().toString(), "RENT-PROEQUIPMENT-START", BILL_TYPE);
            if (!updateSupplierStatus.booleanValue()) {
                throw new BusinessException("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff01");
            }
            entity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
            this.outRentEquipmentStartService.saveOrUpdate((Object)entity, false);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OutRentEquipmentStartEntity startEntity = (OutRentEquipmentStartEntity)((Object)this.outRentEquipmentStartService.selectById(billId));
        List<OutRentEquipmentStartSubEntity> subEntityList = startEntity.getOutRentEquipmentStartSubList();
        ArrayList<RentParameterEntity> parameterList = new ArrayList<RentParameterEntity>();
        for (OutRentEquipmentStartSubEntity subEntity : subEntityList) {
            RentParameterEntity parameterEntity = new RentParameterEntity();
            parameterEntity.setId(subEntity.getSourceId());
            parameterEntity.setStartDate(startEntity.getTypeDate());
            parameterEntity.setOperationDate(new Date());
            parameterEntity.setEquipmentState(OutRentEquipmentStateEnum.\u542f\u7528.getCode());
            parameterEntity.setUseType(1);
            ArrayList<RentParameterDetailEntity> parameterDetailList = new ArrayList<RentParameterDetailEntity>();
            RentParameterDetailEntity detailEntity = new RentParameterDetailEntity();
            detailEntity.setSourceType(RentParameterTypeEnum.\u542f\u7528\u5355.getCode());
            detailEntity.setSourceId(startEntity.getId());
            detailEntity.setOperationDate(startEntity.getTypeDate());
            detailEntity.setEquipmentState(OutRentEquipmentStateEnum.\u542f\u7528.getCode());
            detailEntity.setParameterId(subEntity.getSourceId());
            parameterDetailList.add(detailEntity);
            parameterEntity.setRentParameterDetailList(parameterDetailList);
            parameterList.add(parameterEntity);
        }
        this.rentParameterService.changeParameter(parameterList, RentParameterTypeEnum.\u542f\u7528\u5355.getCode());
        this.outRentEquipmentStartService.updateById((Object)startEntity);
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OutRentEquipmentStartEntity startEntity = (OutRentEquipmentStartEntity)((Object)this.outRentEquipmentStartService.selectById(billId));
        EquipmentNewDateVO equipmentNewDateVO = this.rentParameterService.selectAbandonDate(startEntity.getContractId(), startEntity.getTypeDate());
        if (equipmentNewDateVO != null && !startEntity.getId().equals(equipmentNewDateVO.getId())) {
            return CommonResponse.error((String)("\u5f03\u5ba1\u5931\u8d25:\u8bf7\u5148\u5f03\u5ba1\u8bbe\u5907" + equipmentNewDateVO.getType() + "\u5355\u636e\u5728\u5f03\u5ba1\u672c\u5355\u636e"));
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OutRentEquipmentStartEntity startEntity = (OutRentEquipmentStartEntity)((Object)this.outRentEquipmentStartService.selectById(billId));
        List<OutRentEquipmentStartSubEntity> subEntityList = startEntity.getOutRentEquipmentStartSubList();
        ArrayList<Long> parameterIdList = new ArrayList<Long>();
        for (OutRentEquipmentStartSubEntity subEntity : subEntityList) {
            parameterIdList.add(subEntity.getSourceId());
        }
        this.rentParameterService.cancelParameter(parameterIdList, RentParameterTypeEnum.\u542f\u7528\u5355.getCode(), startEntity.getId());
        startEntity.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        this.outRentEquipmentStartService.saveOrUpdate((Object)startEntity, false);
        return CommonResponse.success();
    }
}

