/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorppur.asset.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorppur.acceptance.bean.PurchaseAcceptanceEntity;
import com.ejianc.business.proequipmentcorppur.acceptance.bean.PurchaseAcceptanceSubEntity;
import com.ejianc.business.proequipmentcorppur.acceptance.service.IPurchaseAcceptanceService;
import com.ejianc.business.proequipmentcorppur.asset.bean.AmortizeSetEntity;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetEntity;
import com.ejianc.business.proequipmentcorppur.asset.mapper.AssetMapper;
import com.ejianc.business.proequipmentcorppur.asset.service.IAmortizeSetService;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetRecordService;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetService;
import com.ejianc.business.proequipmentcorppur.asset.vo.AmortizeSetVO;
import com.ejianc.business.proequipmentcorppur.asset.vo.AssetVO;
import com.ejianc.business.proequipmentcorppur.constants.PurCommonBillTypeEnum;
import com.ejianc.business.proequipmentcorppur.decorator.IAssetRecord;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="assetService")
public class AssetServiceImpl
extends BaseServiceImpl<AssetMapper, AssetEntity>
implements IAssetService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IPurchaseAcceptanceService purchaseAcceptanceService;
    @Autowired
    private IAssetService assetService;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IAssetRecordService assetRecordService;
    @Autowired
    private IAmortizeSetService amortizeSetService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private AssetMapper assetMapper;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    private static final String BILL_CODE = "ASSET_Bli_CODE";
    private static final String BILL_TYPE = "EJCBT202206000070";

    @Override
    public void pushAsset(Long billId) {
        PurchaseAcceptanceEntity purchaseAcceptanceEntity = (PurchaseAcceptanceEntity)((Object)this.purchaseAcceptanceService.selectById(billId));
        QueryWrapper dbQuery = new QueryWrapper();
        dbQuery.eq((Object)"leave_factory_code", (Object)purchaseAcceptanceEntity.getLeaveFactoryCode());
        AssetEntity dbEntity = (AssetEntity)((Object)super.getOne((Wrapper)dbQuery));
        AssetEntity entity = null;
        List<PurchaseAcceptanceSubEntity> purchaseAcceptanceSubList = purchaseAcceptanceEntity.getPurchaseAcceptanceSubList();
        if (CollectionUtils.isEmpty(purchaseAcceptanceSubList)) {
            throw new BusinessException("\u9a8c\u6536\u8bbe\u5907\u5217\u8868\u4e3a\u7a7a\uff01");
        }
        PurchaseAcceptanceSubEntity purchaseAcceptanceSubEntity = purchaseAcceptanceSubList.get(0);
        if (purchaseAcceptanceEntity.getAcceptanceStandardSectionFlag() == 0) {
            if (null != dbEntity) {
                throw new BusinessException("\u8be5\u51fa\u5382\u7f16\u7801\u8bbe\u5907\u5df2\u88ab\u9a8c\u6536\uff01");
            }
            entity = new AssetEntity();
            entity.setEquipmentStandardNum(null != purchaseAcceptanceSubEntity.getCurAcceptStandardSectionNum() ? purchaseAcceptanceSubEntity.getCurAcceptStandardSectionNum() : 0);
            if (Optional.ofNullable(purchaseAcceptanceEntity).isPresent()) {
                entity.setOrgId(purchaseAcceptanceEntity.getParentOrgId());
                entity.setOrgName(purchaseAcceptanceEntity.getParentOrgName());
                entity.setOrgCode(purchaseAcceptanceEntity.getParentOrgCode());
                entity.setParentOrgId(purchaseAcceptanceEntity.getOrgId());
                entity.setParentOrgName(purchaseAcceptanceEntity.getOrgName());
                entity.setParentOrgCode(purchaseAcceptanceEntity.getOrgCode());
                entity.setPropertyRightCompanyId(purchaseAcceptanceEntity.getPropertyRightCompanyId());
                entity.setPropertyRightCompany(purchaseAcceptanceEntity.getPropertyRightCompany());
                entity.setManageCompanyId(purchaseAcceptanceEntity.getManageCompanyId());
                entity.setManageCompany(purchaseAcceptanceEntity.getManageCompany());
                entity.setPropertyRightCompany(purchaseAcceptanceEntity.getPropertyRightCompany());
                entity.setProjectId(purchaseAcceptanceEntity.getProjectId());
                entity.setProjectName(purchaseAcceptanceEntity.getProjectName());
                entity.setEmployeeId(this.sessionManager.getUserContext().getUserId());
                entity.setEmployeeName(this.sessionManager.getUserContext().getUserName());
                entity.setDepartmentId(this.sessionManager.getUserContext().getDeptId());
                entity.setDepartmentName(this.sessionManager.getUserContext().getDeptName());
                if (purchaseAcceptanceEntity.getAcceptanceType() == 0) {
                    entity.setEquipmentStatus(1);
                    entity.setRentState(1);
                    entity.setUseEquipmentStandardNum(entity.getEquipmentStandardNum());
                } else {
                    entity.setEquipmentStatus(3);
                    entity.setRentState(2);
                }
                entity.setOriginalValueTax(purchaseAcceptanceSubEntity.getPurchasePrice());
                BigDecimal tax = ComputeUtil.safeMultiply((BigDecimal)purchaseAcceptanceSubEntity.getPurchasePrice(), (BigDecimal)ComputeUtil.safeDiv((BigDecimal)purchaseAcceptanceSubEntity.getTaxRate(), (BigDecimal)new BigDecimal(100)));
                BigDecimal originalValue = ComputeUtil.safeSub((BigDecimal)purchaseAcceptanceSubEntity.getPurchasePrice(), (BigDecimal)tax);
                entity.setOriginalValue(originalValue);
                entity.setTaxRate(purchaseAcceptanceSubEntity.getTaxRate());
                entity.setNetWorth(originalValue);
                entity.setNetWorthTax(purchaseAcceptanceSubEntity.getPurchasePrice());
                entity.setEquipmentId(purchaseAcceptanceSubEntity.getEquipmentId());
                entity.setEquipmentName(purchaseAcceptanceSubEntity.getEquipmentName());
                entity.setEquipmentCode(purchaseAcceptanceSubEntity.getEquipmentCode());
                entity.setEquipmentTypeId(purchaseAcceptanceSubEntity.getEquipmentTypeId());
                entity.setEquipmentTypeName(purchaseAcceptanceSubEntity.getEquipmentType());
                entity.setEquipmentTypeCode(purchaseAcceptanceSubEntity.getEquipmentCode());
                entity.setSpec(purchaseAcceptanceSubEntity.getSpec());
                entity.setUnit(purchaseAcceptanceSubEntity.getCompany());
                entity.setAssetStatus(0);
                if (purchaseAcceptanceSubEntity.getPurchasePrice().compareTo(new BigDecimal(2000)) != -1) {
                    entity.setAssetType(1);
                } else {
                    entity.setAssetType(2);
                }
                HashMap<Long, Long> amortizeSetmap = new HashMap<Long, Long>();
                amortizeSetmap.put(purchaseAcceptanceSubEntity.getEquipmentId(), purchaseAcceptanceSubEntity.getEquipmentTypeId());
                this.logger.info("\u8c03\u7528\u56fa\u5b9a\u8d44\u4ea7\u644a\u9500\u8bbe\u7f6e:" + JSONObject.toJSONString((Object)((Object)entity)));
                Map<Long, AmortizeSetEntity> amortizeMap = this.amortizeSetService.getSet(amortizeSetmap, entity.getOrgId());
                this.logger.info("\u56fa\u5b9a\u8d44\u4ea7\u644a\u9500\u8bbe\u7f6e:" + JSONObject.toJSONString(amortizeMap));
                AmortizeSetEntity amortizeSetEntity = amortizeMap.get(purchaseAcceptanceSubEntity.getEquipmentId());
                if (amortizeSetEntity != null) {
                    BigDecimal residualValueRate = amortizeSetEntity.getResidualValueRate();
                    entity.setResidualValueRate(residualValueRate);
                    this.logger.info("\u8c03\u7528\u56fa\u5b9a\u8d44\u4ea7\u644a\u9500\u8bbe\u7f6e\u6b8b\u503c\u7387\u6b8b\u503c\u7387:" + residualValueRate);
                    BigDecimal residualValueTax = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)residualValueRate, (BigDecimal)new BigDecimal(100)), (BigDecimal)purchaseAcceptanceSubEntity.getPurchasePrice());
                    BigDecimal residualValue = ComputeUtil.safeMultiply((BigDecimal)ComputeUtil.safeDiv((BigDecimal)residualValueRate, (BigDecimal)new BigDecimal(100)), (BigDecimal)originalValue);
                    entity.setResidualValueTax(residualValueTax);
                    entity.setResidualValue(residualValue);
                    entity.setAmortizeType(1);
                }
                entity.setLeaveFactoryCode(purchaseAcceptanceSubEntity.getEquipmentFactoryCode());
                entity.setFinancePushFlag(purchaseAcceptanceEntity.getFinancePushFlag());
                entity.setSourceType(1);
                entity.setFinancePushState(0);
                entity.setCheckDate(purchaseAcceptanceEntity.getAcceptanceDate());
                entity.setProductionDate(purchaseAcceptanceEntity.getProductionDate());
                entity.setManufacturer(purchaseAcceptanceEntity.getManufacturer());
                entity.setCertificateNum(purchaseAcceptanceEntity.getCertificateNum());
                entity.setRandomTool(purchaseAcceptanceEntity.getRandomTool());
                entity.setAbility(purchaseAcceptanceEntity.getAbility());
                entity.setWeight(purchaseAcceptanceEntity.getWeight());
                entity.setPower(purchaseAcceptanceEntity.getPower());
                entity.setOwnWeight(purchaseAcceptanceEntity.getOwnWeight());
                entity.setAppearanceSize(purchaseAcceptanceEntity.getAppearanceSize());
                entity.setModelExplain(purchaseAcceptanceEntity.getModelExplain());
                entity.setSupplierId(purchaseAcceptanceEntity.getSupplierId());
                entity.setSupplierName(purchaseAcceptanceEntity.getSupplierName());
                entity.setPurchaseAcceptanceId(purchaseAcceptanceEntity.getId());
                entity.setBillState(1);
                entity.setBillCode(entity.getLeaveFactoryCode());
            }
            this.logger.info("\u63a8\u9001\u8bbe\u5907\u5361\u7247\u7684\u4fe1\u606f:" + JSONObject.toJSONString((Object)((Object)entity)));
            boolean b = this.assetService.saveOrUpdate((Object)entity, false);
            CommonResponse commonResponse = this.attachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(purchaseAcceptanceEntity.getId()), PurCommonBillTypeEnum.\u8bbe\u5907\u516c\u53f8\u8bbe\u5907\u9a8c\u6536.getBillTypeCode(), "photoPath", String.valueOf(entity.getId()), PurCommonBillTypeEnum.\u8bbe\u5907\u516c\u53f8\u8bbe\u5907\u81ea\u6709\u53f0\u5e10.getBillTypeCode(), "ASSET002");
            this.logger.info("\u590d\u5236\u56fe\u7247:" + commonResponse.isSuccess());
            this.logger.info("\u590d\u5236\u56fe\u7247\u8fd4\u56de\u7684\u5185\u5bb9:" + (String)commonResponse.getData());
            if (b) {
                AssetVO vo = (AssetVO)BeanMapper.map((Object)((Object)entity), AssetVO.class);
                this.logger.info("\u8bbe\u5907\u9a8c\u6536\u63a8\u9001\u8bbe\u5907\u6d41\u8f6c\u8bb0\u5f55\u7684\u4fe1\u606f:" + JSONObject.toJSONString((Object)vo));
                this.assetRecordService.saveRecord((IAssetRecord)vo);
            }
        } else {
            if (null == dbEntity) {
                throw new BusinessException("\u8be5\u51fa\u5382\u7f16\u7801\u8bbe\u5907\u672a\u88ab\u9a8c\u6536\uff0c\u65e0\u6cd5\u6267\u884c\u6807\u51c6\u8282\u9a8c\u6536\uff01");
            }
            entity.setEquipmentStandardNum(null != (entity = dbEntity).getEquipmentStandardNum() ? entity.getEquipmentStandardNum() : 0 + purchaseAcceptanceSubEntity.getCurAcceptStandardSectionNum());
            if (purchaseAcceptanceEntity.getAcceptanceType() == 1) {
                entity.setUseEquipmentStandardNum(null != entity.getUseEquipmentStandardNum() ? entity.getUseEquipmentStandardNum() : 0 + purchaseAcceptanceSubEntity.getCurAcceptStandardSectionNum());
            }
            this.assetService.saveOrUpdate((Object)entity, false);
        }
    }

    @Override
    public List<AssetVO> queryAssetPage(Page<AssetVO> page, QueryWrapper wrapper, List<Long> orgIds) {
        return this.assetMapper.queryAssetPage(page, wrapper, orgIds);
    }

    @Override
    public ExecutionVO targetCost(AssetVO assetVO) {
        this.logger.info("\u63a8\u9001\u76ee\u6807\u8d23\u4efb\u6210\u672c\u6570\u636e\uff1a");
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        ArrayList detailList = new ArrayList();
        totalVO.setSourceId(assetVO.getId());
        totalVO.setTenantId(assetVO.getTenantId());
        totalVO.setBillCode(assetVO.getBillCode());
        totalVO.setOrgId(assetVO.getOrgId());
        totalVO.setBillType(BILL_TYPE);
        totalVO.setBussinessType(BussinessTypeEnum.\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247.getCode());
        totalVO.setBillCategory(BillCategoryEnum.\u5176\u4ed6.getCode());
        if (assetVO.getProjectId() == null) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25,\u8bf7\u66f4\u6362\u9879\u76ee");
        }
        totalVO.setProjectId(assetVO.getProjectId());
        if (assetVO.getOrgId() == null) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25,\u8bf7\u66f4\u6362\u9879\u76ee");
        }
        totalVO.setOrgId(assetVO.getOrgId());
        totalVO.setMoney(assetVO.getEstimateAmortizeMny());
        totalVO.setTaxMoney(assetVO.getEstimateAmortizeMny());
        totalVO.setLinkUrl(this.BaseHost + "ejc-proequipmentp-frontend/#/asset/assetCard?id=" + assetVO.getId());
        executionVO.setTotalVO(totalVO);
        executionVO.setDetailList(detailList);
        return executionVO;
    }

    @Override
    public void updateAssetResidualValue(AmortizeSetVO amortizeSetVO) {
        QueryParam param = new QueryParam();
        param.getParams().put("equipmentCode", new Parameter("eq", (Object)amortizeSetVO.getEquipmentCode()));
        param.getParams().put("manageCompanyId", new Parameter("eq", (Object)amortizeSetVO.getOrgId()));
        List assetList = super.queryList(param);
        if (CollectionUtils.isNotEmpty((Collection)assetList)) {
            for (AssetEntity assetEntity : assetList) {
                this.logger.info("\u4fee\u6539\u8bbe\u5907\u6b8b\u503c\u7387\u3001\u6b8b\u503c:" + amortizeSetVO.getResidualValueRate());
                BigDecimal rate = ComputeUtil.safeDiv((BigDecimal)amortizeSetVO.getResidualValueRate(), (BigDecimal)new BigDecimal(100));
                BigDecimal residualValueTax = ComputeUtil.safeMultiply((BigDecimal)rate, (BigDecimal)assetEntity.getOriginalValueTax());
                BigDecimal residualValue = ComputeUtil.safeMultiply((BigDecimal)rate, (BigDecimal)assetEntity.getOriginalValue());
                assetEntity.setResidualValueRate(amortizeSetVO.getResidualValueRate());
                assetEntity.setResidualValueTax(residualValueTax);
                assetEntity.setResidualValue(residualValue);
            }
            this.logger.info("\u672c\u6b21\u4fee\u6539\u8bbe\u5907" + assetList.size() + "\u4e2a");
            super.saveOrUpdateBatch((Collection)assetList);
        }
    }
}

