/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.temporary.contract.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.proequipmentcorprent.rent.enums.ChangeStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.DraftTypeEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.SignatureStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentContractVO;
import com.ejianc.business.proequipmentcorprent.temporary.contract.bean.TemporaryClauseEntity;
import com.ejianc.business.proequipmentcorprent.temporary.contract.bean.TemporaryContractEntity;
import com.ejianc.business.proequipmentcorprent.temporary.contract.bean.TemporaryEquipmentDetailedEntity;
import com.ejianc.business.proequipmentcorprent.temporary.contract.bean.TemporaryOtherEntity;
import com.ejianc.business.proequipmentcorprent.temporary.contract.bean.TemporaryPaymentClauseEntity;
import com.ejianc.business.proequipmentcorprent.temporary.contract.mapper.TemporaryContractMapper;
import com.ejianc.business.proequipmentcorprent.temporary.contract.service.ITemporaryContractService;
import com.ejianc.business.proequipmentcorprent.temporary.contract.vo.TemporaryContractVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="temporaryContractService")
public class TemporaryContractServiceImpl
extends BaseServiceImpl<TemporaryContractMapper, TemporaryContractEntity>
implements ITemporaryContractService {
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private TemporaryContractMapper contractMapper;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private ITemporaryContractService service;
    @Autowired
    private IBillCodeApi billCodeApi;
    private static final String BILL_CODE = "TEMPORARY_CONTRACT";

    @Override
    public TemporaryContractVO saveOrUpdateSupplement(TemporaryContractVO temporaryContractVO) {
        TemporaryContractEntity entity = null;
        if (temporaryContractVO.getId() == null) {
            QueryParam param = new QueryParam();
            param.getParams().put("main_contract_id", new Parameter("eq", (Object)temporaryContractVO.getMainContractId()));
            List supplementList = this.queryList(param, false);
            if (CollectionUtils.isNotEmpty((Collection)supplementList)) {
                for (TemporaryContractEntity temporaryContract : supplementList) {
                    if (temporaryContract.getSignatureState().equals(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()) && (temporaryContract.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) || temporaryContract.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode()))) continue;
                    throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae!");
                }
            }
            String supplementNum = "";
            supplementNum = supplementList.size() < 9 ? supplementNum + "0" + (supplementList.size() + 1) : supplementNum + (supplementList.size() + 1);
            TemporaryContractEntity mainContract = (TemporaryContractEntity)((Object)this.selectById(temporaryContractVO.getMainContractId()));
            if (null == mainContract) {
                throw new BusinessException("\u672a\u627e\u5230\u4e3b\u5408\u540c\uff0c\u4e0d\u80fd\u521b\u5efa\u8865\u5145\u534f\u8bae\uff01");
            }
            entity = (TemporaryContractEntity)((Object)BeanMapper.map((Object)((Object)mainContract), TemporaryContractEntity.class));
            this.clearBaseFields(entity);
            entity.setSignatureState(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            entity.setCode(entity.getCode() + "2" + supplementNum);
            entity.setName(temporaryContractVO.getName());
            entity.setSignedDate(temporaryContractVO.getSignedDate());
            entity.setPartyHandleUser(temporaryContractVO.getPartyHandleUser());
            entity.setPartyHandleUserName(temporaryContractVO.getPartyHandleUserName());
            entity.setPartyPhone(temporaryContractVO.getPartyPhone());
            entity.setSupplierHandleUser(temporaryContractVO.getSupplierHandleUser());
            entity.setSupplierPhone(temporaryContractVO.getSupplierPhone());
            entity.setContractPerformanceState(temporaryContractVO.getContractPerformanceState());
            entity.setDraftType(temporaryContractVO.getDraftType());
            entity.setContractFile(temporaryContractVO.getContractFile());
            entity.setContractFileId(temporaryContractVO.getContractFileId());
            entity.setSupplementDescribe(temporaryContractVO.getSupplementDescribe());
            entity.setContractTaxMny(temporaryContractVO.getContractTaxMny() == null ? BigDecimal.ZERO : temporaryContractVO.getContractTaxMny());
            entity.setContractMny(temporaryContractVO.getContractMny() == null ? BigDecimal.ZERO : temporaryContractVO.getContractMny());
            entity.setContractTax(temporaryContractVO.getContractTax() == null ? BigDecimal.ZERO : temporaryContractVO.getContractTax());
            entity.setTemporaryClauseList(BeanMapper.mapList((Iterable)temporaryContractVO.getTemporaryClauseList(), TemporaryClauseEntity.class));
            entity.setTemporaryPaymentClauseList(BeanMapper.mapList((Iterable)temporaryContractVO.getTemporaryPaymentClauseList(), TemporaryPaymentClauseEntity.class));
            entity.setTemporaryEquipmentDetailedList(BeanMapper.mapList((Iterable)temporaryContractVO.getTemporaryEquipmentDetailedList(), TemporaryEquipmentDetailedEntity.class));
            entity.setTemporaryOtherList(BeanMapper.mapList((Iterable)temporaryContractVO.getTemporaryOtherList(), TemporaryOtherEntity.class));
            entity.setChangingTax(null);
            entity.setChangeCode(null);
            entity.setChangeVersion(null);
            entity.setChangeId(null);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            entity.setContractName(mainContract.getContractName() + "\u2014\u2014\u8865\u5145\u534f\u8bae");
            entity.setSupplementFlag(1);
            entity.setMainContractId(temporaryContractVO.getMainContractId());
            entity.setMainContractCode(temporaryContractVO.getMainContractCode());
            entity.setMainContractName(temporaryContractVO.getMainContractName());
        } else {
            entity = (TemporaryContractEntity)((Object)BeanMapper.map((Object)temporaryContractVO, TemporaryContractEntity.class));
        }
        entity.setBaseMny(entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getBeforeChangeMny());
        entity.setBeforeChangeTaxMny(entity.getBeforeChangeTaxMny());
        entity.setAttachIds(temporaryContractVO.getAttachIds());
        this.saveOrUpdate((Object)entity, false);
        TemporaryContractEntity entity1 = (TemporaryContractEntity)((Object)this.selectById(entity.getId()));
        TemporaryContractVO vo = (TemporaryContractVO)BeanMapper.map((Object)((Object)entity1), TemporaryContractVO.class);
        return vo;
    }

    private void clearBaseFields(TemporaryContractEntity entity) {
        entity.setId(null);
        entity.setCreateTime(null);
        entity.setCreateUserCode(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
    }

    @Override
    public TemporaryContractVO addConvertByConId(Long contractId) {
        TemporaryContractEntity entity = (TemporaryContractEntity)((Object)super.selectById((Serializable)contractId));
        TemporaryContractVO supplementVO = new TemporaryContractVO();
        supplementVO.setMainContractCode(entity.getCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setMainContractName(entity.getContractName());
        supplementVO.setSupplementFlag(RentContractVO.CONTRACT_TYPE_SUPPLEMENT);
        supplementVO.setProjectName(entity.getProjectName());
        supplementVO.setProjectId(entity.getProjectId());
        supplementVO.setSupplierId(entity.getSupplierId());
        supplementVO.setSupplierName(entity.getSupplierName());
        supplementVO.setPartyId(entity.getPartyId());
        supplementVO.setPartyName(entity.getPartyName());
        supplementVO.setDraftType(DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().toString());
        supplementVO.setName(entity.getContractName() + "\u8865\u5145\u534f\u8bae");
        supplementVO.setCompanyId(entity.getCompanyId());
        supplementVO.setCompanyName(entity.getCompanyName());
        supplementVO.setRentType(entity.getRentType());
        supplementVO.setRentTypeName(entity.getRentTypeName());
        supplementVO.setTaxRate(entity.getTaxRate());
        supplementVO.setSignedDate(new Date());
        return supplementVO;
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(TemporaryContractEntity::getMainContractId, (Object)id);
        lambda.eq(TemporaryContractEntity::getSupplementFlag, (Object)RentContractVO.CONTRACT_TYPE_SUPPLEMENT);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(TemporaryContractEntity::getSignatureState, (Object)String.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()))).or(c -> (LambdaQueryWrapper)c.notIn(TemporaryContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()}))).or(c -> (LambdaQueryWrapper)c.eq(TemporaryContractEntity::getContractPerformanceState, (Object)String.valueOf(PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode()))));
        List supplementList = super.list((Wrapper)lambda);
        return supplementList.size() == 0;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Integer> resp = new HashMap();
        QueryWrapper wrapper = TemporaryContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(contract_mny) as baseTaxMny, sum(contract_tax_mny) as contractTaxMny"});
        resp = super.getMap((Wrapper)wrapper);
        if (null == resp) {
            resp = new HashMap();
            resp.put("baseTaxMny", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;
    }

    @Override
    public TemporaryContractVO querySupplementRecord(Long id) {
        TemporaryContractEntity contractEntity = (TemporaryContractEntity)((Object)super.selectById((Serializable)id));
        TemporaryContractVO contractVO = new TemporaryContractVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        contractVO.setId(id);
        contractVO.setContractTaxMny(contractTaxMny);
        contractVO.setChangeStatus(contractEntity.getChangeStatus());
        contractVO.setContractType(contractEntity.getContractType());
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"main_contract_id", (Object)id);
        query.eq((Object)"contract_performance_state", (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        query.orderByDesc((Object)"create_time");
        List supplementEntities = super.list((Wrapper)query);
        contractVO.setSupplementList(BeanMapper.mapList((Iterable)supplementEntities, TemporaryContractVO.class));
        contractVO.setSupplementNum(Integer.valueOf(supplementEntities.size()));
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)supplementEntities)) {
            for (TemporaryContractEntity c : supplementEntities) {
                if (c.getContractTaxMny() == null) continue;
                allSupplementAmt = c.getContractTaxMny().add(allSupplementAmt);
            }
        }
        contractVO.setAllSupplementMny(allSupplementAmt);
        contractVO.setSupplementMnyRate(BigDecimal.ZERO.compareTo(contractTaxMny) != 0 ? allSupplementAmt.divide(contractTaxMny, 8, 4).multiply(new BigDecimal(100)) : BigDecimal.ZERO);
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(contractEntity.getSignatureState()) && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState())) && !PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode().equals(contractEntity.getContractPerformanceState()) && !PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(contractEntity.getContractPerformanceState())) {
            contractVO.setEditFlag(this.addSupplementFlag(id));
        }
        return contractVO;
    }

    @Override
    public Boolean delContractFile(Long contractFileId, String authority) {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> header = new HashMap<String, String>();
        params.put("ids", contractFileId.toString());
        header.put("authority", authority);
        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get((String)(this.BaseHost + "ejc-file-web/attachment/delete"), params, header, (int)10000, (int)10000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse delResp = (CommonResponse)JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            this.logger.info("\u5728\u7ebf\u8d77\u8349\uff0c\u5220\u9664\u4e0a\u4f20\u5408\u540c\u8fd4\u56de\u4fe1\u606f\uff1a" + delResp.getMsg());
        }
        return true;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<TemporaryContractVO> vos) {
        this.removeByIds(vos.stream().map(TemporaryContractVO::getId).collect(Collectors.toList()), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public TemporaryContractEntity selectCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code", (Object)code);
        queryWrapper.eq((Object)"dr", (Object)"0");
        List list = this.contractMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (TemporaryContractEntity)((Object)list.get(0));
        }
        return null;
    }

    @Override
    public void pushContract(TemporaryContractVO contractVO) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)contractVO, (Object)data);
            data.setSourceType(ContractTypeEnum.\u4e34\u65f6\u8bbe\u5907.getTypeCode());
            data.setContractProperty(ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode());
            data.setPcCardUrl("/ejc-proequipment-frontend/#/rentalTemporary/card?id=" + contractVO.getId() + "&supplementFlag=" + contractVO.getSupplementFlag() + "&targetType=" + contractVO.getCalibrationResultId() + "&performanceStatus=" + contractVO.getContractPerformanceState());
            this.logger.info("\u5f00\u59cb\u63a8\u9001\u5408\u540c\u6c60>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.logger.info("\u63a8\u9001\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)data));
            CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            this.logger.info("\u63a8\u9001\u5408\u540c\u6c60\u7ed3\u675f\uff0c\u63a8\u9001\u7ed3\u679c\uff1a{}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", (Object)transDataResp.isSuccess());
            if (!transDataResp.isSuccess()) {
                this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)contractVO.getId(), (Object)transDataResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)contractVO.getId(), (Object)e);
        }
    }

    @Override
    public void pushDelContract(TemporaryContractVO contractVO) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)contractVO, (Object)data);
            data.setSourceType(ContractTypeEnum.\u4e34\u65f6\u8bbe\u5907.getTypeCode());
            this.logger.info("\u5f00\u59cb\u5220\u9664\u5408\u540c\u6c60\u5408\u540c>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.logger.info("\u63a8\u9001\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)data));
            CommonResponse transDataResp = this.contractPoolApi.deleteContract(data);
            this.logger.info("\u5220\u9664\u5408\u540c\u6c60\u5408\u540c\u7ed3\u675f\uff0c\u5220\u9664\u7ed3\u679c\uff1a{}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", (Object)transDataResp.isSuccess());
            if (!transDataResp.isSuccess()) {
                this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)contractVO.getId(), (Object)transDataResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)contractVO.getId(), (Object)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public TemporaryContractVO insertOrUpdate(TemporaryContractVO saveOrUpdateVO, String authority, boolean isControl) {
        TemporaryContractEntity vContractEntity;
        TemporaryContractEntity entity = (TemporaryContractEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, TemporaryContractEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            if (!isControl) {
                BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
                CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
                if (!billCode.isSuccess()) throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                entity.setSignatureState(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
                entity.setSupplementFlag(0);
                entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
                entity.setMainContractCreateDate(new Date());
                if (StringUtils.isEmpty((CharSequence)entity.getCode())) {
                    entity.setCode((String)billCode.getData());
                }
            } else {
                entity.setId(IdWorker.getId());
                entity.setSignatureState(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
                entity.setSupplementFlag(0);
                entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
                entity.setMainContractCreateDate(new Date());
            }
        }
        entity.setBaseMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        if (entity.getContractFileId() != null && !isControl) {
            if (entity.getId() != null) {
                TemporaryContractEntity contract = (TemporaryContractEntity)((Object)this.service.getById(entity.getId()));
                if (contract != null && !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(contract.getDraftType()) && DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType())) {
                    this.service.delContractFile(entity.getContractFileId(), authority);
                    entity.setContractFileId(null);
                    entity.setContractFile(null);
                }
            } else if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType())) {
                this.service.delContractFile(entity.getContractFileId(), authority);
                entity.setContractFileId(null);
                entity.setContractFile(null);
            }
        }
        if ((vContractEntity = this.service.selectCode(entity.getCode())) != null) {
            if (saveOrUpdateVO.getId() == null) {
                throw new BusinessException("\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u91cd\u590d:" + entity.getCode());
            }
            if (!saveOrUpdateVO.getId().equals(vContractEntity.getId())) {
                throw new BusinessException("\u5408\u540c\u7f16\u7801\u4e0d\u80fd\u91cd\u590d:" + entity.getCode());
            }
        }
        if (isControl) return (TemporaryContractVO)BeanMapper.map((Object)((Object)entity), TemporaryContractVO.class);
        this.service.saveOrUpdate((Object)entity, false);
        return (TemporaryContractVO)BeanMapper.map((Object)((Object)entity), TemporaryContractVO.class);
    }

    @Override
    public TemporaryContractVO queryDetail(Long id) {
        TemporaryContractEntity entity = (TemporaryContractEntity)((Object)this.service.selectById(id));
        TemporaryContractVO vo = (TemporaryContractVO)BeanMapper.map((Object)((Object)entity), TemporaryContractVO.class);
        return vo;
    }
}

