/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorpout.contract.service.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractChangeEntity;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractChangeAsyncService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractChangeService;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.vo.WatermarkVO;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.google.common.base.Stopwatch;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.retry.annotation.Backoff;
import org.springframework.retry.annotation.Recover;
import org.springframework.retry.annotation.Retryable;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="outContractChangeAsyncService")
public class OutRentContractChangeAsyncServiceImpl
implements IOutRentContractChangeAsyncService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    @Autowired
    private IOutRentContractChangeService service;
    @Autowired
    private IParamConfigApi paramConfigApi;
    @Autowired
    ISignatureCommonApi signatureCommonApi;
    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";

    @Override
    public void asyncWatermarkById(Long id) {
        OutRentContractChangeEntity changeEntity = (OutRentContractChangeEntity)((Object)this.service.selectById(id));
        this.logger.info("\u5f00\u59cb\u83b7\u53d6\u6c34\u5370\u53c2\u6570\u4fe1\u606f\uff0c\u53d8\u66f4\u5408\u540cid\uff1a{}--------", (Object)id);
        CommonResponse response = this.paramConfigApi.getByCode(WATERMARK_CHECK_PARAM_NAME);
        this.logger.info("\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        Assert.hasText((String)valueData, (String)"\u83b7\u53d6\u7684\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        if ("0".equals(valueData)) {
            WatermarkVO watermarkVO = this.signatureCommonApi.fetchWatermarkConfig(changeEntity.getChangeFileId(), changeEntity.getId(), changeEntity.getCode(), "EJCBT202210000059", "equipmentCorpOutRent");
            Assert.notNull((Object)watermarkVO, (String)"\u83b7\u53d6\u6c34\u5370\u7cfb\u7edf\u53c2\u6570\u5931\u8d25!");
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("authority", request.getHeader("authority"));
            headers.put("ejc-token", request.getHeader("ejc-token"));
            this.fetchWatermarkAttachment(headers, watermarkVO);
        }
    }

    @Override
    @Async(value="commonTask")
    @Retryable(maxAttempts=3, backoff=@Backoff(delay=2000L, multiplier=1.5), stateful=true)
    public void fetchWatermarkAttachment(HashMap<String, String> headers, WatermarkVO watermarkVO) {
        this.logger.info("\u5f02\u6b65\u83b7\u53d6\u6c34\u5370\u6587\u4ef6\u9644\u4ef6\u4fe1\u606f\u5f00\u59cb\uff0c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)watermarkVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        Stopwatch start = Stopwatch.createStarted();
        String body = ((HttpRequest)HttpRequest.post((String)(this.BaseHost + "ejc-signaturemanage-web/common/fetchWatermarkAttachment")).addHeaders(headers)).body(JSON.toJSONString((Object)watermarkVO)).timeout(60000).execute().body();
        AttachmentVO attachmentVO = (AttachmentVO)JSON.parseObject((String)body, AttachmentVO.class);
        this.logger.info("\u5f02\u6b65\u83b7\u53d6\u6c34\u5370\u6587\u4ef6\u9644\u4ef6\u4fe1\u606f\u7ed3\u675f\uff0c\u8bf7\u6c42\u7b7e\u7ae0\u4e2d\u5fc3\u8017\u65f6\u300c{}\u300d\u79d2\uff0c\u6587\u4ef6\u4e2d\u5fc3\u7684\u6c34\u5370\u6587\u4ef6\u4fe1\u606f\uff1a{}", (Object)start.stop().elapsed(TimeUnit.SECONDS), (Object)JSON.toJSONString((Object)attachmentVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        start.reset().start();
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)watermarkVO.getBillId());
        updateWrapper.set((Object)"watermark_contract_file_id", (Object)attachmentVO.getId());
        boolean flag = this.service.update((Wrapper)updateWrapper);
        if (flag) {
            this.logger.info("\u83b7\u53d6\u6c34\u5370\u6587\u4ef6\u9644\u4ef6\u4fe1\u606f\u5e76\u66f4\u65b0\u5408\u540c\u6210\u529f\uff0c\u5199\u5165\u6570\u636e\u5e93\u8017\u65f6\u300c{}\u300d\u79d2\uff0c\u5408\u540cid\uff1a{}\uff0c\u539f\u5408\u540c\u6587\u4ef6id\uff1a{}\uff0c\u6c34\u5370\u5408\u540c\u6587\u4ef6id\uff1a{}", new Object[]{start.stop().elapsed(TimeUnit.SECONDS), watermarkVO.getBillId(), watermarkVO.getFileId(), attachmentVO.getId()});
        }
    }

    @Recover
    public void recordWatermark(Exception e, HashMap<String, String> headers, WatermarkVO watermarkVO) {
        this.logger.error("\u83b7\u53d6\u6c34\u5370\u6587\u4ef6\u9644\u4ef6\u4fe1\u606f\u5e76\u66f4\u65b0\u5408\u540c\u5931\u8d25\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)watermarkVO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
    }
}

