/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorpout.contract.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.contractbase.api.ICommonSNAPI;
import com.ejianc.business.contractbase.api.IParamCheckApi;
import com.ejianc.business.contractbase.api.ITemplateCategoryApi;
import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractPropertyEnum;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.vo.CommonSNVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.proequipmentcorpout.constants.OutRentConstants;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractChangeEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractFreezeEntity;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractRelieveEntity;
import com.ejianc.business.proequipmentcorpout.contract.enums.ChangeStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.ContractStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.DraftTypeEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.SignatureStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.mapper.OutRentContractMapper;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractChangeService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractFreezeService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractRelieveService;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.business.proequipmentcorpout.contract.utils.ListCallable;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentContractChangeVO;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentContractEquipmentAllVO;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentContractVO;
import com.ejianc.business.proequipmentcorpout.proxy.bean.ProxyContractEntity;
import com.ejianc.business.proequipmentcorpout.proxy.service.IProxyContractService;
import com.ejianc.business.profinance.api.IPaymentApplyApi;
import com.ejianc.business.profinance.vo.ContractPaymentResultVO;
import com.ejianc.business.rent.api.IRentContractApi;
import com.ejianc.business.rent.enums.RentContractSyncTypeEnum;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.business.tender.api.ITenderRentApi;
import com.ejianc.business.tender.common.vo.SignContractVo;
import com.ejianc.business.tender.common.vo.TenderPicketageVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.foundation.support.vo.ParamRegisterSetVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.ComplexParam;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.core.util.Utils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service(value="outRentContractService")
public class OutRentContractServiceImpl
extends BaseServiceImpl<OutRentContractMapper, OutRentContractEntity>
implements IOutRentContractService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private OutRentContractMapper outRentContractMapper;
    @Autowired
    private IOutRentContractChangeService outRentContractChangeService;
    @Autowired
    private IOutRentContractFreezeService outRentContractFreezeService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IParamCheckApi paramCheckApi;
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private ITenderRentApi tenderApi;
    @Autowired
    private IPaymentApplyApi paymentApplyApi;
    @Value(value="${common.env.base-host}")
    private String BaseHost;
    int unOccupyState = 0;
    int occupyState = 1;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IOutRentContractRelieveService outRentContractRelieveService;
    private final String OutRent_CONTRACT = "EJCBT202210000034";
    private static final String GenerateSourceType = "SPZLSPZR10086";
    @Value(value="${contract.generateBillCodeType:common}")
    private String GenerateBillCodeType;
    @Autowired
    private ICommonSNAPI commonSNAPI;
    @Autowired
    private IParamConfigApi paramConfigApi;
    private static final String CHECK_SUP_CODE = "P-oOnHR591";
    private static final String CHECK_PLAN_CODE = "P-i91Xpi92";
    private static final String CONTRACT_FILING_CODE = "P-eg7rBO0134";
    @Autowired
    private IOutRentContractService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOutRentContractChangeService contractChangeService;
    @Autowired
    private ITemplateCategoryApi templateCategoryApi;
    private static final String WATERMARK_CHECK_PARAM_NAME = "P-00a9W886";
    @Autowired
    ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IRentContractApi rentContractApi;
    @Autowired
    private IProxyContractService proxyContractService;

    @Override
    public OutRentContractVO saveOrUpdateSupplement(OutRentContractVO outRentContractVO, String authority) {
        QueryParam param;
        OutRentContractEntity entity;
        CommonResponse orgResponse;
        List entities = null;
        List entitiesc = null;
        Long tenantId = InvocationInfoProxy.getTenantid();
        OutRentContractEntity outRentContractEntity = (OutRentContractEntity)((Object)this.service.selectById(outRentContractVO.getMainContractId()));
        if (null == outRentContractEntity) {
            throw new BusinessException("\u672a\u627e\u5230\u4e3b\u5408\u540c\uff0c\u4e0d\u80fd\u521b\u5efa\u8865\u5145\u534f\u8bae\uff01");
        }
        if (StringUtils.isEmpty((CharSequence)outRentContractVO.getParentOrgCode()) && outRentContractVO.getParentOrgId() != null && (orgResponse = this.iOrgApi.getOneById(outRentContractVO.getParentOrgId())).isSuccess()) {
            OrgVO orgVO = (OrgVO)orgResponse.getData();
            outRentContractVO.setParentOrgCode(orgVO.getCode());
        }
        if ((entity = (OutRentContractEntity)((Object)BeanMapper.map((Object)outRentContractVO, OutRentContractEntity.class))).getId() == null || entity.getId() == 0L) {
            entity.setSignatureState(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
            entity.setSupplementFlag(1);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            param = new QueryParam();
            param.getParams().put("main_contract_id", new Parameter("eq", (Object)outRentContractVO.getMainContractId()));
            ArrayList<Integer> billStateList = new ArrayList<Integer>();
            billStateList.add(BillStateEnum.COMMITED_STATE.getBillStateCode());
            billStateList.add(BillStateEnum.PASSED_STATE.getBillStateCode());
            param.getParams().put("bill_state", new Parameter("in", billStateList));
            List supplementList = this.service.queryList(param, false);
            if (StringUtils.isBlank((CharSequence)entity.getCode())) {
                String supplementNum = "";
                supplementNum = supplementList.size() < 9 ? supplementNum + "0" + (supplementList.size() + 1) : supplementNum + (supplementList.size() + 1);
                entity.setCode(outRentContractEntity.getCode() + "2" + supplementNum);
            }
        }
        if (outRentContractVO.getId() != null && outRentContractVO.getId() > 0L) {
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(OutRentContractEntity::getCode, (Object)outRentContractVO.getCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)outRentContractVO.getId());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("code", new Parameter("eq", (Object)outRentContractVO.getCode()));
            queryParam.getParams().put("contract_id", new Parameter("ne", (Object)outRentContractVO.getId()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
        } else {
            param = new QueryParam();
            param.getParams().put("main_contract_id", new Parameter("eq", (Object)outRentContractVO.getMainContractId()));
            List supplementList = super.queryList(param, false);
            supplementList.stream().forEach(e -> {
                if (!e.getSignatureState().equals(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()) || !e.getBillState().equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) && !e.getBillState().equals(BillStateEnum.PASSED_STATE.getBillStateCode())) {
                    throw new BusinessException("\u8be5\u5408\u540c\u5df2\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae!");
                }
            });
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(OutRentContractEntity::getCode, (Object)outRentContractVO.getCode());
            entities = super.list((Wrapper)lambda);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("code", new Parameter("eq", (Object)outRentContractVO.getCode()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
        }
        if (entities != null && entities.size() > 0 || entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        this.checkContract(outRentContractVO.getMainContractId(), outRentContractVO.getId());
        entity.setBaseMny(outRentContractVO.getContractMny() == null ? BigDecimal.ZERO : outRentContractVO.getContractMny());
        entity.setBaseTaxMny(outRentContractVO.getContractTaxMny() == null ? BigDecimal.ZERO : outRentContractVO.getContractTaxMny());
        entity.setBeforeChangeMny(outRentContractVO.getContractMny() == null ? BigDecimal.ZERO : outRentContractVO.getContractMny());
        entity.setBeforeChangeTaxMny(outRentContractVO.getContractTaxMny() == null ? BigDecimal.ZERO : outRentContractVO.getContractTaxMny());
        if (entity.getContractFileId() != null) {
            if (entity.getId() != null) {
                OutRentContractEntity contract = (OutRentContractEntity)((Object)this.service.getById(entity.getId()));
                if (contract != null && !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(contract.getDraftType()) && DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType())) {
                    this.service.delContractFile(entity.getContractFileId(), authority);
                    entity.setContractFileId(null);
                    entity.setContractFile(null);
                }
            } else if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType())) {
                this.service.delContractFile(entity.getContractFileId(), authority);
                entity.setContractFileId(null);
                entity.setContractFile(null);
            }
        }
        super.saveOrUpdate((Object)entity, false);
        OutRentContractVO vo = (OutRentContractVO)BeanMapper.map((Object)((Object)entity), OutRentContractVO.class);
        return vo;
    }

    @Override
    public boolean checkContract(Long id, Long otherId) {
        List contractChangeEntityList;
        List<Integer> billStateList = Arrays.asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(), BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(), BillStateEnum.UNAPPROVED.getBillStateCode(), BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode());
        OutRentContractEntity contractEntity = (OutRentContractEntity)((Object)super.selectById((Serializable)id));
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter("eq", (Object)id));
        if (otherId != null) {
            supplementQueryParam.getParams().put("id", new Parameter("ne", (Object)otherId));
        }
        supplementQueryParam.getParams().put("signatureState", new Parameter("ne", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        List supplementContractList = super.queryList(supplementQueryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)supplementContractList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u8865\u5145\u534f\u8bae\uff01");
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        queryParam.getParams().put("signatureState", new Parameter("ne", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        if (otherId != null) {
            queryParam.getParams().put("id", new Parameter("ne", (Object)otherId));
        }
        if (CollectionUtils.isNotEmpty((Collection)(contractChangeEntityList = this.contractChangeService.queryList(queryParam, false)))) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u53d8\u66f4\u5408\u540c\uff01");
        }
        QueryParam queryRelParam = new QueryParam();
        queryRelParam.getParams().put("contractId", new Parameter("eq", (Object)id));
        queryRelParam.getParams().put("signature_state", new Parameter("ne", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        List relieveEntityList = this.outRentContractRelieveService.queryList(queryRelParam, false);
        if (CollectionUtils.isNotEmpty((Collection)relieveEntityList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u5408\u540c\u89e3\u9664\u5355\u636e\uff01");
        }
        queryParam.getParams().remove("signatureState");
        queryParam.getParams().put("billState", new Parameter("in", billStateList));
        List freezeEntityList = this.outRentContractFreezeService.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty((Collection)freezeEntityList)) {
            throw new BusinessException("\u5b58\u5728\u672a\u751f\u6548\u7684\u5408\u540c\u51bb\u7ed3\u6216\u5408\u540c\u89e3\u51bb\u5355\u636e\uff01");
        }
        return true;
    }

    @Override
    public OutRentContractVO addConvertByConId(Long contractId) {
        OutRentContractEntity entity = (OutRentContractEntity)((Object)super.selectById((Serializable)contractId));
        OutRentContractVO supplementVO = new OutRentContractVO();
        supplementVO.setTargetResultId(entity.getTargetResultId());
        supplementVO.setTargetResultName(entity.getTargetResultName());
        supplementVO.setPartyHandleUser(entity.getPartyHandleUser());
        supplementVO.setPartyHandleUserName(entity.getPartyHandleUserName());
        supplementVO.setPartyPhone(entity.getPartyPhone());
        supplementVO.setSupplierHandleUser(entity.getSupplierHandleUser());
        supplementVO.setSupplierHandleUserName(entity.getSupplierHandleUserName());
        supplementVO.setSupplierPhone(entity.getSupplierPhone());
        supplementVO.setMainContractCode(entity.getCode());
        supplementVO.setMainContractId(contractId);
        supplementVO.setMainContractName(entity.getContractName());
        supplementVO.setContractType(entity.getContractType());
        supplementVO.setContractTypeName(entity.getContractTypeName());
        supplementVO.setProjectId(entity.getProjectId());
        supplementVO.setProjectName(entity.getProjectName());
        supplementVO.setProjectAddress(entity.getProjectAddress());
        supplementVO.setPartyId(entity.getPartyId());
        supplementVO.setPartyName(entity.getPartyName());
        supplementVO.setSupplierId(entity.getSupplierId());
        supplementVO.setSupplierName(entity.getSupplierName());
        supplementVO.setOrgId(entity.getOrgId());
        supplementVO.setOrgName(entity.getOrgName());
        supplementVO.setParentOrgId(entity.getParentOrgId());
        supplementVO.setParentOrgName(entity.getParentOrgName());
        supplementVO.setParentOrgCode(entity.getParentOrgCode());
        supplementVO.setSignedDate(new Date());
        supplementVO.setSupplementFlag(OutRentContractVO.CONTRACT_TYPE_SUPPLEMENT);
        supplementVO.setSignatureState(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode().toString());
        supplementVO.setContractPerformanceState(PerformanceStatusEnum.\u672a\u7b7e\u8ba2.getCode().toString());
        supplementVO.setDraftType(DraftTypeEnum.\u4e0a\u4f20\u5408\u540c.getCode().toString());
        supplementVO.setName(entity.getContractName() + "\u8865\u5145\u534f\u8bae");
        supplementVO.setMainContractCreateDate(entity.getMainContractCreateDate());
        supplementVO.setContractType(entity.getContractType());
        supplementVO.setMeterRentType(entity.getMeterRentType());
        supplementVO.setMeterRentTypeName(entity.getMeterRentTypeName());
        supplementVO.setContractName(entity.getContractName() + "\u8865\u5145\u534f\u8bae");
        supplementVO.setCompanyId(entity.getCompanyId());
        supplementVO.setCompanyName(entity.getCompanyName());
        supplementVO.setRentType(entity.getRentType());
        supplementVO.setRentTypeName(entity.getRentTypeName());
        supplementVO.setRentHarborType(entity.getRentHarborType());
        supplementVO.setFilingStatus(FilingStatusEnum.\u672a\u5f52\u6863.getTypeCode());
        return supplementVO;
    }

    @Override
    public Boolean addSupplementFlag(Long id) {
        OutRentContractEntity contractEntity = (OutRentContractEntity)((Object)super.selectById((Serializable)id));
        if (!PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode().equals(contractEntity.getContractPerformanceState())) {
            return false;
        }
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(OutRentContractEntity::getMainContractId, (Object)id);
        lambda.eq(OutRentContractEntity::getSupplementFlag, (Object)1);
        lambda.and(l -> (LambdaQueryWrapper)((LambdaQueryWrapper)l.ne(OutRentContractEntity::getSignatureState, (Object)String.valueOf(SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()))).or(c -> (LambdaQueryWrapper)c.notIn(OutRentContractEntity::getBillState, new Object[]{BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode()})));
        List supplementList = super.list((Wrapper)lambda);
        return supplementList.size() == 0;
    }

    @Override
    public ExecutionVO targetCost(OutRentContractVO contractVO, String linkUrl) {
        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(contractVO.getId());
        totalVO.setTenantId(contractVO.getTenantId());
        totalVO.setBillCode(contractVO.getCode());
        totalVO.setBillType("EJCBT202210000058");
        totalVO.setBussinessType(BussinessTypeEnum.\u8bbe\u5907\u79df\u8d41\u5408\u540c.getCode());
        totalVO.setBillCategory(BillCategoryEnum.\u5408\u540c.getCode());
        totalVO.setProjectId(contractVO.getProjectId());
        totalVO.setOrgId(contractVO.getOrgId());
        totalVO.setMoney(contractVO.getContractMny());
        totalVO.setTaxMoney(contractVO.getContractTaxMny());
        totalVO.setLinkUrl(linkUrl);
        executionVO.setTotalVO(totalVO);
        return executionVO;
    }

    @Override
    public Map<String, Object> countContractAmount(QueryParam param) {
        Map<String, Integer> resp = new HashMap();
        QueryWrapper wrapper = OutRentContractServiceImpl.changeToQueryWrapper((QueryParam)param);
        wrapper.select(new String[]{"sum(base_tax_mny) as baseTaxMny, sum(contract_tax_mny) as contractTaxMny"});
        resp = super.getMap((Wrapper)wrapper);
        if (null == resp) {
            resp = new HashMap();
            resp.put("baseTaxMny", 0);
            resp.put("contractTaxMny", 0);
        }
        return resp;
    }

    @Override
    public OutRentContractVO querySupplementRecord(Long id) {
        OutRentContractEntity contractEntity = (OutRentContractEntity)((Object)super.selectById((Serializable)id));
        OutRentContractVO contractVO = new OutRentContractVO();
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        contractVO.setId(id);
        contractVO.setContractTaxMny(contractTaxMny);
        contractVO.setChangeStatus(contractEntity.getChangeStatus());
        contractVO.setContractType(contractEntity.getContractType());
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"main_contract_id", (Object)id);
        query.eq((Object)"contract_performance_state", (Object)PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
        query.orderByDesc((Object)"create_time");
        List supplementEntities = super.list((Wrapper)query);
        contractVO.setSupplementList(BeanMapper.mapList((Iterable)supplementEntities, OutRentContractVO.class));
        contractVO.setSupplementNum(Integer.valueOf(supplementEntities.size()));
        BigDecimal allSupplementAmt = BigDecimal.ZERO;
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)supplementEntities)) {
            for (OutRentContractEntity c : supplementEntities) {
                if (c.getContractTaxMny() == null) continue;
                allSupplementAmt = c.getContractTaxMny().add(allSupplementAmt);
            }
        }
        contractVO.setAllSupplementMny(allSupplementAmt);
        contractVO.setSupplementMnyRate(BigDecimal.ZERO.compareTo(contractTaxMny) != 0 ? allSupplementAmt.divide(contractTaxMny, 8, 4).multiply(new BigDecimal(100)) : BigDecimal.ZERO);
        if (SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode().equals(contractEntity.getSignatureState()) && (BillStateEnum.PASSED_STATE.getBillStateCode().equals(contractEntity.getBillState()) || BillStateEnum.COMMITED_STATE.getBillStateCode().equals(contractEntity.getBillState())) && !PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode().equals(contractEntity.getContractPerformanceState()) && !PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(contractEntity.getContractPerformanceState())) {
            contractVO.setEditFlag(this.addSupplementFlag(id));
        }
        return contractVO;
    }

    @Override
    public void pushContract(OutRentContractVO contractVO) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)contractVO, (Object)data);
            data.setSourceType(ContractTypeEnum.\u8bbe\u5907\u516c\u53f8\u8bbe\u5907\u79df\u8d41\u5408\u540c.getTypeCode());
            data.setContractProperty(ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode());
            data.setPcCardUrl("/ejc-proequipmentcorp-frontend/#/leaseContract/cardList?id=" + contractVO.getId() + "&showTitle=true&supplementFlag=" + contractVO.getSupplementFlag());
            this.logger.info("\u5f00\u59cb\u63a8\u9001\u5408\u540c\u6c60>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.logger.info("\u63a8\u9001\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)data));
            CommonResponse transDataResp = this.contractPoolApi.saveOrUpdateContract(data);
            this.logger.info("\u63a8\u9001\u5408\u540c\u6c60\u7ed3\u675f\uff0c\u63a8\u9001\u7ed3\u679c\uff1a{}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", (Object)transDataResp.isSuccess());
            if (!transDataResp.isSuccess()) {
                this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)contractVO.getId(), (Object)transDataResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)contractVO.getId(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String validateContract(Long contractId, String billType, Long billId, String type) {
        ComplexParam c1 = new ComplexParam();
        c1.setLogic("and");
        c1.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        ComplexParam c2 = new ComplexParam();
        c2.setLogic("or");
        c2.getParams().put("bill_state", new Parameter("in", (Object)"1,3"));
        c2.getParams().put("signature_state", new Parameter("ne", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        c1.getComplexParams().add(c2);
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("main_contract_id", new Parameter("eq", (Object)contractId));
        queryParam.getComplexParams().add(c1);
        QueryParam queryParam2 = new QueryParam();
        queryParam2.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam2.getComplexParams().add(c1);
        QueryParam queryParam3 = new QueryParam();
        queryParam3.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        queryParam3.getParams().put("bill_state", new Parameter("not_in", (Object)"1,3"));
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        QueryParam param = (QueryParam)BeanMapper.map((Object)queryParam, QueryParam.class);
        QueryParam param2 = (QueryParam)BeanMapper.map((Object)queryParam2, QueryParam.class);
        QueryParam param3 = (QueryParam)Utils.deepCopy((Object)queryParam3);
        if (billId != null) {
            param.getParams().put("id", new Parameter("ne", (Object)billId));
            param2.getParams().put("id", new Parameter("ne", (Object)billId));
            param3.getParams().put("id", new Parameter("ne", (Object)billId));
        }
        Future<JSONArray> future1 = ListCallable.excute(threadPool, "\u8865\u5145\u534f\u8bae".equals(billType) ? param : queryParam, this.service);
        Future<JSONArray> future2 = ListCallable.excute(threadPool, "\u53d8\u66f4\u5355".equals(billType) ? param2 : queryParam2, this.contractChangeService);
        Future<JSONArray> future3 = ListCallable.excute(threadPool, "\u89e3\u9664\u5355".equals(billType) ? param2 : queryParam2, this.outRentContractRelieveService);
        Future<JSONArray> future4 = ListCallable.excute(threadPool, "\u51bb\u7ed3\u5355".equals(billType) ? param3 : queryParam3, this.outRentContractFreezeService);
        List supplementList = new ArrayList();
        List changeList = new ArrayList();
        List relieveList = new ArrayList();
        List freezeList = new ArrayList();
        try {
            supplementList = JSONObject.parseArray((String)future1.get().toJSONString(), OutRentContractEntity.class);
            changeList = JSONObject.parseArray((String)future2.get().toJSONString(), OutRentContractChangeEntity.class);
            relieveList = JSONObject.parseArray((String)future3.get().toJSONString(), OutRentContractRelieveEntity.class);
            freezeList = JSONObject.parseArray((String)future4.get().toJSONString(), OutRentContractFreezeEntity.class);
        }
        catch (Exception e) {
            this.logger.error("\u67e5\u8be2\u6570\u636e\u5f02\u5e38", (Throwable)e);
        }
        finally {
            threadPool.shutdown();
        }
        if (ListUtil.isNotEmpty(supplementList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u6216\u672a\u7b7e\u7ae0\u7684\u8865\u5145\u534f\u8bae\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(changeList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u6216\u672a\u7b7e\u7ae0\u7684\u53d8\u66f4\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(freezeList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u7684\u51bb\u7ed3\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        if (CollectionUtils.isNotEmpty(relieveList)) {
            throw new BusinessException("\u5f53\u524d\u5408\u540c\u5b58\u5728\u975e\u5ba1\u6279\u901a\u8fc7\u6001\u6216\u672a\u7b7e\u7ae0\u7684\u89e3\u9664\u5355\uff0c\u4e0d\u5141\u8bb8" + type + "!");
        }
        return "\u6821\u9a8c\u901a\u8fc7\uff01";
    }

    private void clearBaseFields(OutRentContractEntity entity) {
        entity.setId(null);
        entity.setCreateTime(null);
        entity.setCreateUserCode(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
    }

    @Override
    public IPage<OutRentContractEquipmentAllVO> queryEquipmentSubList(Map<String, Object> param) {
        Page page = new Page();
        param.put("tenantId", InvocationInfoProxy.getTenantid());
        Integer count = this.outRentContractMapper.countNumber(param);
        if (count > 0) {
            List<OutRentContractEquipmentAllVO> appEntity = this.outRentContractMapper.queryEquipmentSubList(param);
            page.setRecords(appEntity);
        } else {
            page.setRecords(new ArrayList());
        }
        if (param.get("pageIndex") != null) {
            page.setCurrent((long)Integer.parseInt(param.get("pageIndex").toString()));
            page.setSize((long)Integer.parseInt(param.get("pageSize").toString()));
            page.setTotal((long)count.intValue());
        }
        return page;
    }

    @Override
    public Boolean delContractFile(Long contractFileId, String authority) {
        HashMap<String, String> params = new HashMap<String, String>();
        HashMap<String, String> header = new HashMap<String, String>();
        params.put("ids", contractFileId.toString());
        header.put("authority", authority);
        String delRespStr = null;
        try {
            delRespStr = HttpTookit.get((String)(this.BaseHost + "ejc-file-web/attachment/delete"), params, header, (int)10000, (int)10000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CommonResponse delResp = (CommonResponse)JSONObject.parseObject(delRespStr, CommonResponse.class);
        if (delResp != null) {
            this.logger.info("\u5728\u7ebf\u8d77\u8349\uff0c\u5220\u9664\u4e0a\u4f20\u5408\u540c\u8fd4\u56de\u4fe1\u606f\uff1a" + delResp.getMsg());
        }
        return true;
    }

    @Override
    public CommonResponse<String> deleteByIds(List<OutRentContractVO> vos) {
        vos.forEach(contractVO -> {
            OutRentContractEntity contractEntity = (OutRentContractEntity)((Object)((Object)super.getById((Serializable)contractVO.getId())));
            if (null != contractEntity.getTargetResultId()) {
                CommonResponse tender = this.tenderApi.updateById(contractEntity.getTargetResultId(), Integer.valueOf(0));
                this.logger.info("\u5b9a\u6807\u7ed3\u679c\u5360\u7528\u72b6\u6001\u4fee\u6539\u4e3a\u672a\u5360\u7528\u72b6\u6001\u4fe1\u606f\uff1a" + tender.getMsg());
            }
        });
        this.removeByIds(vos.stream().map(OutRentContractVO::getId).collect(Collectors.toList()), false);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public OutRentContractEntity selectCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"code", (Object)code);
        queryWrapper.eq((Object)"dr", (Object)"0");
        List list = this.outRentContractMapper.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return (OutRentContractEntity)((Object)list.get(0));
        }
        return null;
    }

    @Override
    public void pushDelContract(OutRentContractVO contractVO) {
        ContractPoolVO data = new ContractPoolVO();
        try {
            BeanConvertorUtil.convert((Object)contractVO, (Object)data);
            data.setSourceType(ContractTypeEnum.\u8bbe\u5907\u516c\u53f8\u8bbe\u5907\u79df\u8d41\u5408\u540c.getTypeCode());
            data.setContractProperty(ContractPropertyEnum.\u652f\u51fa\u5408\u540c.getPropertyCode());
            data.setSourceId(contractVO.getId());
            this.logger.info("\u5f00\u59cb\u5220\u9664\u5408\u540c\u6c60\u5408\u540c>>>>>>>>>>>>>>>>>>>>>>>>>>>>");
            this.logger.info("\u63a8\u9001\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)data));
            CommonResponse transDataResp = this.contractPoolApi.deleteContract(data);
            this.logger.info("\u5220\u9664\u5408\u540c\u6c60\u5408\u540c\u7ed3\u675f\uff0c\u5220\u9664\u7ed3\u679c\uff1a{}<<<<<<<<<<<<<<<<<<<<<<<<<<<<<", (Object)transDataResp.isSuccess());
            if (!transDataResp.isSuccess()) {
                this.logger.error("\u5408\u540cid-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c{}", (Object)contractVO.getId(), (Object)transDataResp.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u5408\u540c-{}\u63a8\u9001\u5408\u540c\u6c60\u5931\u8d25\uff0c", (Object)contractVO.getId(), (Object)e);
        }
    }

    @Override
    public CommonResponse<OutRentContractVO> saveOrUpdate(OutRentContractVO outRentContractVO, String authority, Boolean isControl) {
        OutRentContractEntity contract;
        QueryParam queryParam;
        LambdaQueryWrapper lambda;
        Object outRentContractEntity;
        CommonResponse orgResponse;
        List entities = null;
        List entitiesc = null;
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (outRentContractVO.getOrgId() != null && (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)outRentContractVO.getOrgCode()) || com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)outRentContractVO.getParentOrgCode())) && (orgResponse = this.iOrgApi.getOneById(outRentContractVO.getOrgId())).isSuccess()) {
            OrgVO orgVO = (OrgVO)orgResponse.getData();
            outRentContractVO.setOrgCode(orgVO.getCode());
            if (StringUtils.isEmpty((CharSequence)outRentContractVO.getOrgName())) {
                outRentContractVO.setOrgName(orgVO.getName());
            }
            if (5 == orgVO.getOrgType()) {
                CommonResponse parentOrgResponse = this.iOrgApi.getOneById(orgVO.getParentId());
                if (parentOrgResponse.isSuccess()) {
                    OrgVO parentOrgVO = (OrgVO)parentOrgResponse.getData();
                    outRentContractVO.setParentOrgId(parentOrgVO.getId());
                    outRentContractVO.setParentOrgCode(parentOrgVO.getCode());
                    outRentContractVO.setParentOrgName(parentOrgVO.getName());
                }
            } else {
                outRentContractVO.setParentOrgId(outRentContractVO.getOrgId());
                outRentContractVO.setParentOrgCode(outRentContractVO.getOrgCode());
                outRentContractVO.setParentOrgName(outRentContractVO.getOrgName());
            }
        }
        OutRentContractEntity entity = (OutRentContractEntity)((Object)BeanMapper.map((Object)outRentContractVO, OutRentContractEntity.class));
        if (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(entity.getDraftType())) {
            entity.setContractFileSyncFlag(false);
        }
        if (!isControl.booleanValue()) {
            if (entity.getTargetResultId() != null) {
                this.validateTargetMny(entity);
            }
            if (entity.getId() == null && entity.getTargetResultId() != null) {
                this.updateTargetResult(entity, 0);
            }
            if (entity.getId() != null && entity.getTargetResultId() != null) {
                outRentContractEntity = (OutRentContractEntity)((Object)super.selectById((Serializable)entity.getId()));
                this.updateTargetResult((OutRentContractEntity)((Object)outRentContractEntity), 1);
                this.updateTargetResult(entity, 0);
            }
            this.updateProxyContractByContract(outRentContractVO);
            if (entity.getId() == null || entity.getId() == 0L) {
                entity.setSignatureState(SignatureStatusEnum.\u672a\u7b7e\u7ae0.getCode());
                entity.setSupplementFlag(0);
                entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
                entity.setMainContractCreateDate(new Date());
            }
            if (StringUtils.isEmpty((CharSequence)entity.getCode())) {
                switch (this.GenerateBillCodeType) {
                    case "common": {
                        CommonResponse billCode = this.billCodeApi.generateBillCode(BillCodeParam.build((String)"OUT_RENTCORP_CONTRACT", (Long)InvocationInfoProxy.getTenantid(), (BaseVO)outRentContractVO));
                        if (!billCode.isSuccess()) {
                            this.logger.error("\u4fdd\u5b58\u5408\u540c\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u5408\u540c\u5408\u540c\u5931\u8d25: {}", (Object)billCode.getMsg());
                            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                        }
                        entity.setCode((String)billCode.getData());
                        break;
                    }
                    case "ynjt": {
                        CommonResponse billCodeFirstPart = this.billCodeApi.generateBillCode(BillCodeParam.build((String)"OUT_RENTCORP_CONTRACT", (Long)InvocationInfoProxy.getTenantid(), (BaseVO)outRentContractVO));
                        if (!billCodeFirstPart.isSuccess()) {
                            this.logger.error("\u4fdd\u5b58\u5408\u540c\u5931\u8d25\uff0c\u81ea\u52a8\u751f\u6210\u5408\u540c\u5408\u540c\u5931\u8d25: {}", (Object)billCodeFirstPart.getMsg());
                            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                        }
                        CommonSNVO commonSNVO = new CommonSNVO();
                        commonSNVO.setSnLength(Integer.valueOf(4));
                        commonSNVO.setTenantId(InvocationInfoProxy.getTenantid());
                        commonSNVO.setDimension(entity.getParentOrgCode().substring(entity.getParentOrgCode().length() - 3));
                        commonSNVO.setSourceType(GenerateSourceType);
                        CommonResponse snResp = this.commonSNAPI.getNext(commonSNVO);
                        if (!snResp.isSuccess()) {
                            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
                        }
                        entity.setCode((String)billCodeFirstPart.getData() + entity.getParentOrgCode().substring(entity.getParentOrgCode().length() - 3) + (String)snResp.getData());
                        outRentContractVO.setCode(entity.getCode());
                    }
                }
            }
        }
        if (outRentContractVO.getId() != null && outRentContractVO.getId() > 0L) {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(OutRentContractEntity::getCode, (Object)outRentContractVO.getCode());
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.ne(BaseEntity::getId, (Object)outRentContractVO.getId());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
            queryParam.getParams().put("code", new Parameter("eq", (Object)outRentContractVO.getCode()));
            queryParam.getParams().put("contract_id", new Parameter("ne", (Object)outRentContractVO.getId()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
        } else {
            lambda = Wrappers.lambdaQuery();
            lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
            lambda.eq(OutRentContractEntity::getCode, (Object)outRentContractVO.getCode());
            entities = super.list((Wrapper)lambda);
            queryParam = new QueryParam();
            queryParam.getParams().put("tenant_id", new Parameter("eq", (Object)tenantId));
            queryParam.getParams().put("supplement_flag", new Parameter("eq", (Object)0));
            queryParam.getParams().put("code", new Parameter("eq", (Object)outRentContractVO.getCode()));
            entitiesc = this.contractChangeService.queryList(queryParam, false);
            entity.setId(IdWorker.getId());
            entity.setChangeVersion(0);
            entity.setChangeStatus(ChangeStatusEnum.\u672a\u53d8\u66f4.getCode());
            entity.setMainContractCreateDate(new Date());
        }
        if (entities != null && entities.size() > 0 || entitiesc != null && entitiesc.size() > 0) {
            throw new BusinessException("\u5b58\u5728\u76f8\u540c\u7f16\u7801\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58!");
        }
        entity.setBaseMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBaseTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        entity.setBeforeChangeMny(entity.getContractMny() == null ? BigDecimal.ZERO : entity.getContractMny());
        entity.setBeforeChangeTaxMny(entity.getContractTaxMny() == null ? BigDecimal.ZERO : entity.getContractTaxMny());
        if (!(entity.getContractFileId() == null || (contract = (OutRentContractEntity)((Object)this.service.getById(entity.getId()))) == null || contract.getContractType().equals(entity.getContractType()) && (DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(contract.getDraftType()) || DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(contract.getDraftType())) || !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349.getCode().toString().equals(entity.getDraftType()) && !DraftTypeEnum.\u7ebf\u4e0a\u8d77\u8349\u4e0d\u4f7f\u7528\u7535\u5b50\u7b7e\u7ae0.getCode().toString().equals(entity.getDraftType()))) {
            if (Boolean.FALSE.equals(isControl) && null != contract.getContractFileId()) {
                this.delContractFile(contract.getContractFileId(), authority);
            }
            entity.setContractFileId(null);
            entity.setContractFile(null);
        }
        if (!isControl.booleanValue()) {
            if (outRentContractVO.getId() != null && outRentContractVO.getTargetResultId() != null) {
                outRentContractEntity = (OutRentContractEntity)((Object)super.selectById((Serializable)outRentContractVO.getId()));
                CommonResponse stringCommonResponse = this.tenderApi.updateById(((OutRentContractEntity)((Object)outRentContractEntity)).getTargetResultId(), Integer.valueOf(0));
                this.tenderApi.updateById(outRentContractVO.getTargetResultId(), Integer.valueOf(1));
            }
            if (entity.getFilingStatus() == null) {
                entity.setFilingRef(0);
            }
            super.saveOrUpdate((Object)entity, false);
        }
        OutRentContractVO vo = (OutRentContractVO)BeanMapper.map((Object)((Object)entity), OutRentContractVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public ParamsCheckVO targetCostCtrl(OutRentContractVO contractVO, String authority) {
        OutRentContractVO contractVO1 = (OutRentContractVO)this.saveOrUpdate(contractVO, authority, true).getData();
        String linkUrl = this.BaseHost + "ejc-proequipment-frontend/#/leaseContract/card?id=" + contractVO1.getId();
        ExecutionVO executionVO = this.service.targetCost(contractVO1, linkUrl);
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO paramsCheckVO = this.checkParams(contractVO1, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public ParamsCheckVO viewTargetCostCtrlInfo(Long id) {
        OutRentContractVO contractVO = this.queryDetail(id);
        String linkUrl = this.BaseHost + "ejc-proequipment-frontend/#/leaseContract/card?id=" + contractVO.getId();
        ExecutionVO executionVO = this.service.targetCost(contractVO, linkUrl);
        this.logger.error("ss" + JSONObject.toJSONString((Object)executionVO));
        CommonResponse response = this.executionApi.ctrlCheckVO(executionVO);
        ParamsCheckVO paramsCheckVO = this.checkParams(contractVO, (ParamsCheckVO)response.getData());
        return paramsCheckVO;
    }

    @Override
    public OutRentContractVO queryDetail(Long id) {
        OutRentContractEntity entity = (OutRentContractEntity)((Object)this.service.selectById(id));
        OutRentContractVO vo = (OutRentContractVO)BeanMapper.map((Object)((Object)entity), OutRentContractVO.class);
        return vo;
    }

    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        CommonResponse response;
        OutRentContractEntity outRentContractEntity = (OutRentContractEntity)((Object)this.service.selectById(id));
        if (ContractStatusEnum.\u5df2\u4f5c\u5e9f.getCode().toString().equals(outRentContractEntity.getContractPerformanceState())) {
            QueryWrapper relieveQueryWrapper = new QueryWrapper();
            relieveQueryWrapper.eq((Object)"contract_id", (Object)id);
            OutRentContractRelieveEntity outRentContractRelieveEntity = (OutRentContractRelieveEntity)((Object)this.outRentContractRelieveService.getOne((Wrapper)relieveQueryWrapper));
            ExecutionVO executionVO = this.outRentContractRelieveService.targetCost(outRentContractRelieveEntity);
            this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
            response = this.executionApi.aggPush(executionVO);
            if (!response.isSuccess()) {
                throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
            }
        }
        QueryWrapper outRentContractChangeEntityQueryWrapper = new QueryWrapper();
        ((QueryWrapper)outRentContractChangeEntityQueryWrapper.eq((Object)"contract_id", (Object)id)).orderByDesc((Object)"create_time");
        ExecutionVO executionVO = new ExecutionVO();
        List contractChangeEntityList = this.outRentContractChangeService.list((Wrapper)outRentContractChangeEntityQueryWrapper);
        if (contractChangeEntityList.size() > 0) {
            OutRentContractChangeEntity outRentContractChangeEntity = (OutRentContractChangeEntity)((Object)this.outRentContractChangeService.selectById(((OutRentContractChangeEntity)((Object)contractChangeEntityList.get(0))).getId()));
            executionVO = this.outRentContractChangeService.targetCost((OutRentContractChangeVO)BeanMapper.map((Object)((Object)outRentContractChangeEntity), OutRentContractChangeVO.class), null);
        } else {
            OutRentContractVO outRentContractVO = this.service.queryDetail(id);
            String linkUrl = this.BaseHost + "ejc-proequipment-frontend/#/leaseContract/card?id=" + outRentContractVO.getId();
            executionVO = this.service.targetCost(outRentContractVO, linkUrl);
        }
        this.logger.info("\u76ee\u6807\u6210\u672c\u63a8\u9001\u6570\u636e" + JSON.toJSONString((Object)executionVO));
        response = this.executionApi.aggPush(executionVO);
        if (!response.isSuccess()) {
            throw new BusinessException("\u76ee\u6807\u6210\u672c\u63a8\u9001\u5931\u8d25," + response.getMsg());
        }
        return CommonResponse.success((String)"\u76ee\u6807\u6210\u672c\u63a8\u9001\u6210\u529f");
    }

    @Override
    public ParamsCheckVO checkParams(OutRentContractVO vo, ParamsCheckVO paramsCheckVO2) {
        ArrayList<ParamsCheckVO> paramsCheckVOS = new ArrayList<ParamsCheckVO>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        paramsCheckVOS.addAll(this.checkParamsMnyPlan(vo));
        if (vo.getSupplementFlag() != null && Objects.equals(vo.getSupplementFlag(), OutRentContractVO.CONTRACT_TYPE_SUPPLEMENT)) {
            paramsCheckVOS.addAll(this.checkParamsMnySup(vo));
        }
        if (paramsCheckVO2 != null) {
            paramsCheckVOS.add(paramsCheckVO2);
        }
        HashMap<String, List> map = new HashMap<String, List>();
        String[] paramsArray = new String[]{"alert", "warn", "none"};
        if (CollectionUtils.isNotEmpty(paramsCheckVOS)) {
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if (map.containsKey(warnType)) {
                    List checkDsVOS = (List)map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType, checkDsVOS);
                    continue;
                }
                map.put(warnType, checkVO.getDataSource());
            }
        }
        for (String s : paramsArray) {
            if (!map.containsKey(s)) continue;
            paramsCheckVO.setWarnType(s);
            paramsCheckVO.setDataSource((List)map.get(s));
            if (CollectionUtils.isEmpty((Collection)paramsCheckVO.getDataSource())) {
                paramsCheckVO.setWarnType("none");
                continue;
            }
            return paramsCheckVO;
        }
        return paramsCheckVO;
    }

    @Override
    public List<ParamsCheckVO> checkParamsConstruction(OutRentContractVO vo) {
        CommonResponse response = this.paramCheckApi.paramsCheck(vo.getProjectId(), vo.getId(), vo.getContractTaxMny(), vo.getOrgId());
        this.logger.info("\u65bd\u5de5\u5408\u540c\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)response.getData()));
        if (!response.isSuccess()) {
            throw new BusinessException("\u83b7\u53d6\u65bd\u5de5\u53c2\u6570\u63a7\u5236\u4fe1\u606f\u5931\u8d25!" + response.getMsg());
        }
        return (List)response.getData();
    }

    @Override
    public List<ParamsCheckVO> checkParamsMnySup(OutRentContractVO vo) {
        BigDecimal contractTaxMnySup = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
        OutRentContractEntity contractEntity = (OutRentContractEntity)((Object)super.selectById((Serializable)vo.getMainContractId()));
        BigDecimal contractTaxMny = contractEntity.getContractTaxMny() == null ? BigDecimal.ZERO : contractEntity.getContractTaxMny();
        BigDecimal totalSupMoney = contractTaxMnySup;
        QueryParam supplementQueryParam = new QueryParam();
        supplementQueryParam.getParams().put("mainContractId", new Parameter("eq", (Object)vo.getMainContractId()));
        if (vo.getId() != null) {
            supplementQueryParam.getParams().put("id", new Parameter("ne", (Object)vo.getId()));
        }
        supplementQueryParam.getParams().put("mainContractId", new Parameter("eq", (Object)vo.getMainContractId()));
        supplementQueryParam.getParams().put("signatureState", new Parameter("eq", (Object)SignatureStatusEnum.\u5df2\u7b7e\u7ae0.getCode()));
        List supplementContractList = super.queryList(supplementQueryParam, false);
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty((Collection)supplementContractList)) {
            for (OutRentContractEntity entity : supplementContractList) {
                totalSupMoney = ComputeUtil.safeAdd((BigDecimal)entity.getContractTaxMny(), (BigDecimal)totalSupMoney);
            }
        }
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        CommonResponse billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_SUP_CODE, vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u534f\u8bae\u91d1\u989d\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)contractTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    if (totalSupMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u8865\u5145\u534f\u8bae\u8d85\u5408\u540c\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u7d2f\u8ba1\u8865\u5145\u534f\u8bae\u91d1\u989d\u5927\u4e8e\u5408\u540c\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u8865\u5145\u534f\u8bae\u91d1\u989d\uff1a").append(contractTaxMnySup.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u8865\u5145\u534f\u8bae\u91d1\u989d\uff1a").append(totalSupMoney.setScale(2, 4)).append("\u5143\uff0c\u5408\u540c\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalSupMoney, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public List<ParamsCheckVO> checkParamsMnyPlan(OutRentContractVO vo) {
        CommonResponse billParamByCode;
        List list;
        String[] paramsArray = new String[]{"none", "warn", "alert"};
        ArrayList<ParamsCheckVO> paramsCheckVOList = new ArrayList<ParamsCheckVO>();
        BigDecimal contractTaxMny = vo.getContractTaxMny() == null ? BigDecimal.ZERO : vo.getContractTaxMny();
        BigDecimal planTaxMny = BigDecimal.ZERO;
        BigDecimal totalMoney = contractTaxMny;
        LambdaQueryWrapper Lambda = new LambdaQueryWrapper();
        Lambda.eq(OutRentContractEntity::getProjectId, (Object)vo.getProjectId());
        Lambda.orderByDesc(BaseEntity::getCreateTime);
        if (vo.getId() != null) {
            Lambda.ne(BaseEntity::getId, (Object)vo.getId());
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = super.list((Wrapper)Lambda)))) {
            List<Long> collect = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
            List<OutRentContractChangeVO> contractChangeList = ((OutRentContractMapper)this.baseMapper).getRentContractChangeList(collect);
            Map<Long, OutRentContractChangeVO> mapChange = contractChangeList.stream().filter(t -> t.getContractId() != null).collect(Collectors.toMap(OutRentContractChangeVO::getContractId, item -> item, (v1, v2) -> v2));
            for (OutRentContractEntity entity : list) {
                BigDecimal zero = BigDecimal.ZERO;
                if (!PerformanceStatusEnum.\u5df2\u7ec8\u6b62.getCode().equals(entity.getContractPerformanceState()) && !PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode().equals(entity.getContractPerformanceState())) {
                    zero = mapChange.containsKey(entity.getId()) ? mapChange.get(entity.getId()).getContractTaxMny() : entity.getContractTaxMny();
                }
                totalMoney = ComputeUtil.safeAdd((BigDecimal)zero, (BigDecimal)totalMoney);
            }
        }
        if ((billParamByCode = this.paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PLAN_CODE, vo.getOrgId())).isSuccess() && null != billParamByCode.getData()) {
            List data = (List)billParamByCode.getData();
            this.logger.info("\u603b\u8ba1\u5212\u91d1\u989d\u63a7\u5236\u4fe1\u606f\u8fd4\u56de\uff1a" + JSONObject.toJSONString((Object)data));
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    ArrayList<ParamsCheckDsVO> checkDsVOS = new ArrayList<ParamsCheckDsVO>();
                    BigDecimal roleValue = datum.getRoleValue();
                    paramsCheckVO.setWarnType(paramsArray[datum.getControlType()]);
                    BigDecimal comMny = ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeMultiply((BigDecimal)planTaxMny, (BigDecimal)roleValue), (BigDecimal)new BigDecimal("100")).setScale(2, 4);
                    if (totalMoney.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(datum.getOrgName());
                        paramsCheckDsVO.setWarnItem("\u79df\u8d41\u91d1\u989d\u8d85\u603b\u8ba1\u5212\u91d1\u989d");
                        paramsCheckDsVO.setWarnName("\u79df\u8d41\u91d1\u989d\u8d85\u603b\u8ba1\u5212\u91d1\u989d");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("\u672c\u6b21\u5408\u540c\u91d1\u989d\uff1a").append(contractTaxMny.setScale(2, 4)).append("\u5143\uff0c\u542b\u672c\u6b21\u7d2f\u8ba1\u5408\u540c\u91d1\u989d\uff1a").append(totalMoney.setScale(2, 4)).append("\u5143\uff0c\u603b\u8ba1\u5212\u91d1\u989d*").append(roleValue).append("%:").append(comMny.setScale(2, 4)).append("\u5143\u3002\u8d85\u51fa\u91d1\u989d\uff1a").append(ComputeUtil.safeSub((BigDecimal)totalMoney, (BigDecimal)comMny).setScale(2, 4)).append("\u5143");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            this.logger.info(billParamByCode.getMsg());
            throw new BusinessException("\u83b7\u53d6\u63a7\u5236\u53c2\u6570\u5931\u8d25");
        }
        return paramsCheckVOList;
    }

    @Override
    public boolean delWatermarkContractFile(Long watermarkFileId) {
        Assert.notNull((Object)watermarkFileId, (String)"\u6c34\u5370\u5408\u540c\u9644\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        CommonResponse res = this.attachmentApi.delete(String.valueOf(watermarkFileId));
        if (!res.isSuccess()) {
            this.logger.error("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a{}\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a{}", (Object)res.getMsg(), (Object)watermarkFileId);
            throw new BusinessException("\u5220\u9664\u6587\u4ef6\u4e2d\u5fc3\u6c34\u5370\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + res.getMsg() + "\uff0c\u6c34\u5370\u6587\u4ef6id\uff1a" + watermarkFileId);
        }
        return true;
    }

    @Override
    public ContractPaymentResultVO queryPaymentApplyList(Long id) {
        CommonResponse res = this.paymentApplyApi.queryJsonByContractId(id);
        if (!res.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u4ed8\u6b3e\u8be6\u60c5\u5931\u8d25!");
        }
        return (ContractPaymentResultVO)res.getData();
    }

    @Override
    public void updateTargetResult(OutRentContractEntity vo, Integer type) {
        if (vo.getTargetResultId() == null) {
            return;
        }
        TenderPicketageVO picketageVO = new TenderPicketageVO();
        picketageVO.setId(vo.getTargetResultId());
        picketageVO.setContractMoneyTax(vo.getContractTaxMny());
        picketageVO.setContractMoney(vo.getContractMny());
        ArrayList list = new ArrayList();
        picketageVO.setTenderPicketageDetailList(list);
        String typeStr = 0 == type ? "\u5360\u7528" : "\u91ca\u653e";
        this.logger.info("{}\u5b9a\u6807\u7ed3\u679c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)typeStr, (Object)JSONObject.toJSONString((Object)picketageVO));
        CommonResponse response = 0 == type ? this.tenderApi.updateStatus(picketageVO) : this.tenderApi.delUpdateStatus(picketageVO);
        this.logger.info("{}\u5b9a\u6807\u7ed3\u679c\u8bf7\u6c42\u7ed3\u679c\uff1a{}", (Object)typeStr, (Object)JSONObject.toJSONString((Object)response));
        if (!response.isSuccess()) {
            throw new BusinessException(typeStr + "\u5b9a\u6807\u7ed3\u679c\u5931\u8d25\uff01");
        }
    }

    @Override
    public Boolean validateTargetMny(OutRentContractEntity entity) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(OutRentContractEntity::getTargetResultId, (Object)entity.getTargetResultId());
        if (entity.getId() != null) {
            wrapper.ne(BaseEntity::getId, (Object)entity.getId());
        }
        List list = this.list((Wrapper)wrapper);
        BigDecimal sumContractTaxMny = list.stream().map(OutRentContractEntity::getContractTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        if ((sumContractTaxMny = ComputeUtil.safeAdd((BigDecimal)sumContractTaxMny, (BigDecimal)entity.getContractTaxMny())).compareTo(entity.getTargetTaxMny()) > 0) {
            throw new BusinessException("\u5408\u540c\u7d2f\u8ba1\u7b7e\u8ba2\u91d1\u989d\u8d85\u8fc7\u5b9a\u6807\u91d1\u989d\uff0c\u4e0d\u53ef\u4fdd\u5b58\uff01");
        }
        return true;
    }

    @Override
    public List<SignContractVo> queryContractByTargetResultId(List<String> targetResultIdList) {
        ArrayList<SignContractVo> rtnList = new ArrayList<SignContractVo>();
        if (CollectionUtils.isEmpty(targetResultIdList)) {
            return rtnList;
        }
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("targetResultId", new Parameter("in", targetResultIdList));
        queryParam.getOrderMap().put("signedDate", "desc");
        List entityList = super.queryList(queryParam, false);
        if (CollectionUtils.isEmpty((Collection)entityList)) {
            return rtnList;
        }
        for (OutRentContractEntity entity : entityList) {
            SignContractVo vo = new SignContractVo();
            vo.setBillCode(entity.getCode());
            vo.setContractId(entity.getId());
            vo.setContractName(entity.getContractName());
            vo.setSupplierId(entity.getSupplierId());
            vo.setSupplierName(entity.getSupplierName());
            vo.setContractMny(entity.getContractMny());
            vo.setContractTaxMny(entity.getContractTaxMny());
            vo.setSignDate(entity.getSignedDate());
            vo.setBillState(entity.getBillState());
            String url = "/ejc-proequipmentcorp-frontend/#/leaseContract/cardList?id=" + entity.getId() + "&showTitle=true";
            vo.setLinkUrl(url);
            rtnList.add(vo);
        }
        return rtnList;
    }

    @Override
    public String getContractFilingCode() {
        CommonResponse response = this.paramConfigApi.getByCode(CONTRACT_FILING_CODE);
        this.logger.info("\u5408\u540c\u5f52\u6863\u63a7\u5236\u53c2\u6570\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
        if (!response.isSuccess() || response.getData() == null) {
            throw new BusinessException("\u83b7\u53d6\u5408\u540c\u5f52\u6863\u63a7\u5236\u53c2\u6570\u8bf7\u6c42\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + response.getMsg());
        }
        String valueData = ((ParamRegisterSetVO)response.getData()).getValueData();
        return com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotEmpty((CharSequence)valueData) ? valueData : "0";
    }

    @Override
    public boolean checkContractFiling(Long contractId) {
        String valueData = this.getContractFilingCode();
        OutRentContractEntity outRentContractEntity = (OutRentContractEntity)((Object)super.selectById((Serializable)contractId));
        if ("0".equals(valueData)) {
            return true;
        }
        return FilingStatusEnum.\u5df2\u5f52\u6863.getTypeCode().equals(outRentContractEntity.getFilingStatus());
    }

    @Override
    public void updateProxyContract(Long proxyId, Integer signState) {
        ProxyContractEntity proxyEntity = (ProxyContractEntity)((Object)this.proxyContractService.selectById(proxyId));
        if (proxyEntity != null) {
            proxyEntity.setSignStatus(signState);
        }
        this.proxyContractService.saveOrUpdate((Object)proxyEntity);
    }

    @Override
    public void pushContractToRent(String jsonVo, Integer optType, String optBill) {
        Integer rentHarborType;
        Long id;
        String type;
        switch (optBill) {
            case "contract": {
                type = RentContractSyncTypeEnum.\u79df\u8d41\u5408\u540c.getName();
                OutRentContractEntity entity = (OutRentContractEntity)((Object)JSONObject.parseObject((String)jsonVo, OutRentContractEntity.class));
                id = entity.getId();
                rentHarborType = entity.getRentHarborType();
                break;
            }
            case "contractChange": {
                type = RentContractSyncTypeEnum.\u79df\u8d41\u5408\u540c\u53d8\u66f4.getName();
                OutRentContractChangeEntity changeEntity = (OutRentContractChangeEntity)((Object)JSONObject.parseObject((String)jsonVo, OutRentContractChangeEntity.class));
                id = changeEntity.getId();
                rentHarborType = changeEntity.getRentHarborType();
                break;
            }
            case "contractRelieve": {
                type = RentContractSyncTypeEnum.\u79df\u8d41\u5408\u540c\u89e3\u9664.getName();
                OutRentContractRelieveEntity relieveEntity = (OutRentContractRelieveEntity)((Object)JSONObject.parseObject((String)jsonVo, OutRentContractRelieveEntity.class));
                OutRentContractEntity qcer = (OutRentContractEntity)((Object)super.selectById((Serializable)relieveEntity.getContractId()));
                id = relieveEntity.getId();
                rentHarborType = qcer.getRentHarborType();
                break;
            }
            case "contractFreeze": {
                type = RentContractSyncTypeEnum.\u79df\u8d41\u5408\u540c\u51bb\u7ed3.getName();
                OutRentContractFreezeEntity freezeEntity = (OutRentContractFreezeEntity)((Object)JSONObject.parseObject((String)jsonVo, OutRentContractFreezeEntity.class));
                OutRentContractEntity qcef = (OutRentContractEntity)((Object)super.selectById((Serializable)freezeEntity.getContractId()));
                id = freezeEntity.getId();
                rentHarborType = qcef.getRentHarborType();
                break;
            }
            default: {
                throw new BusinessException("\u64cd\u4f5c\u5355\u636e\u7c7b\u578b\u9519\u8bef\uff01");
            }
        }
        if (OutRentConstants.OUT_CONTRACT_RENT_HARBOR_TYPE_OUT.equals(rentHarborType)) {
            return;
        }
        this.logger.info("\u5f00\u59cb\u63a8\u9001\u5408\u540c\u5230\u8bbe\u5907\u79df\u8d41\uff0c\u63a8\u9001\u7c7b\u578b\uff081\u65b0\u589e2\u5220\u9664\uff09\uff1a{}\uff0c\u63a8\u9001\u5355\u636e\uff1a{}\uff0c\u63a8\u9001\u6570\u636e\uff1a{}", new Object[]{optType, optBill, jsonVo});
        CommonResponse response = OutRentConstants.PUSH_RENT_OPT_TYPE_ADD.equals(optType) ? this.rentContractApi.contractSync(JSONObject.parseObject((String)jsonVo), type) : this.rentContractApi.delContract(id, type);
        this.logger.info("\u63a8\u9001\u5408\u540c\u5230\u8bbe\u5907\u79df\u8d41\u7ed3\u675f\uff0c\u63a8\u9001\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
        response.isSuccess();
    }

    private void updateProxyContractByContract(OutRentContractVO outRentContractVO) {
        OutRentContractEntity contractEntity;
        if (OutRentConstants.OUT_CONTRACT_RENT_HARBOR_TYPE_OUT.equals(outRentContractVO.getRentType())) {
            return;
        }
        if (outRentContractVO.getProxyContractId() == null) {
            throw new BusinessException("\u5408\u540c\u6388\u6743\u59d4\u6258\u4e66\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (outRentContractVO.getId() != null && (contractEntity = (OutRentContractEntity)((Object)super.selectById((Serializable)outRentContractVO.getId()))).getProxyContractId() != null) {
            this.logger.info("\u91ca\u653e\u5408\u540c\u6388\u6743\u59d4\u6258\u4e66id\uff1a{}", (Object)contractEntity.getProxyContractId());
            this.updateProxyContract(contractEntity.getProxyContractId(), 1);
        }
        this.logger.info("\u5360\u7528\u5408\u540c\u6388\u6743\u59d4\u6258\u4e66id\uff1a{}", (Object)outRentContractVO.getProxyContractId());
        this.updateProxyContract(outRentContractVO.getProxyContractId(), 2);
    }
}

