/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorpout.outLedger.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorpout.constants.MeterRentTypeEnum;
import com.ejianc.business.proequipmentcorpout.constants.RentOutStatusEnum;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterService;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/outRentParameter/"})
public class OutRentParameterController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOutRentParameterService service;

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OutRentParameterVO> queryDetail(Long id) {
        OutRentParameterEntity entity = (OutRentParameterEntity)((Object)this.service.selectById(id));
        OutRentParameterVO vo = (OutRentParameterVO)BeanMapper.map((Object)((Object)entity), OutRentParameterVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutRentParameterVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OutRentParameterVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("factoryCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("outOrgName");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("spec");
        fuzzyFields.add("unitName");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutRentParameterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("factoryCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("firstPartyName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("outOrgName");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("spec");
        fuzzyFields.add("unitName");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        HashMap<String, List> beans = new HashMap<String, List>();
        List vos = BeanMapper.mapList((Iterable)list, OutRentParameterVO.class);
        if (CollectionUtils.isNotEmpty((Collection)vos)) {
            vos.forEach(vo -> {
                vo.setBillStateName(BillStateEnum.getEnumByStateCode((Integer)vo.getBillState()).getDescription());
                vo.setMeterRentTypeName(null != MeterRentTypeEnum.getEnumByCode((String)vo.getMeterRentType()) ? MeterRentTypeEnum.getEnumByCode((String)vo.getMeterRentType()).getName() : null);
                vo.setRentOutStatusName(null != RentOutStatusEnum.getEnumByCode((Integer)vo.getRentOutStatus()) ? RentOutStatusEnum.getEnumByCode((Integer)vo.getRentOutStatus()).getName() : null);
                vo.setSourceTypeName(Integer.valueOf(1).equals(vo.getSourceType()) ? "\u79df\u8d41" : "\u81ea\u8d2d");
            });
        }
        beans.put("records", vos);
        ExcelExport.getInstance().export("EquipRentOutLedger-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refRentParameterData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutRentParameterVO>> refRentParameterData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        Long contractId = null;
        param.getFuzzyFields().add("categoryName");
        param.getFuzzyFields().add("equipmentName");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            contractId = _con.getLong("contractId");
        }
        if (contractId == null) {
            throw new BusinessException("\u5408\u540cid\u4e0d\u80fd\u5fc5\u987b\u4f20\uff01");
        }
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getParams().put("equipmentState", new Parameter("in", (Object)"1,2"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OutRentParameterVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refOutRentEquipmentStart"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutRentParameterVO>> refOutRentEquipmentStart(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("factoryCode");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("name");
        Long contractId = null;
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            contractId = _con.getLong("contractId");
        }
        if (contractId == null) {
            throw new BusinessException("\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getParams().put("rentOutStatus", new Parameter("in", (Object)"1"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List outRentParameterVOList = BeanMapper.mapList((Iterable)page.getRecords(), OutRentParameterVO.class);
        if (CollectionUtils.isNotEmpty((Collection)outRentParameterVOList)) {
            block10: for (OutRentParameterVO outRentParameterVO : outRentParameterVOList) {
                outRentParameterVO.setRentOutStatusName("\u505c\u7528");
                switch (outRentParameterVO.getMeterRentType()) {
                    case "day": {
                        outRentParameterVO.setMeterRentTypeName("\u65e5\u79df");
                        continue block10;
                    }
                    case "month": {
                        outRentParameterVO.setMeterRentTypeName("\u6708\u79df");
                        continue block10;
                    }
                    case "engineering": {
                        outRentParameterVO.setMeterRentTypeName("\u5de5\u7a0b\u91cf");
                        continue block10;
                    }
                }
                outRentParameterVO.setMeterRentTypeName("\u5176\u5b83\u8d39\u7528");
            }
        }
        pageData.setRecords(outRentParameterVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/refOutRentEquipmentStop"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OutRentParameterVO>> refOutRentEquipmentStop(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("factoryCode");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("name");
        Long contractId = null;
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject _con = JSONObject.parseObject((String)condition);
            contractId = _con.getLong("contractId");
        }
        if (contractId == null) {
            throw new BusinessException("\u5408\u540cid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        param.getParams().put("contractId", new Parameter("eq", (Object)contractId));
        param.getParams().put("rentOutStatus", new Parameter("eq", (Object)"0"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List outRentParameterVOList = BeanMapper.mapList((Iterable)page.getRecords(), OutRentParameterVO.class);
        if (CollectionUtils.isNotEmpty((Collection)outRentParameterVOList)) {
            block10: for (OutRentParameterVO outRentParameterVO : outRentParameterVOList) {
                outRentParameterVO.setRentOutStatusName("\u542f\u7528");
                switch (outRentParameterVO.getMeterRentType()) {
                    case "day": {
                        outRentParameterVO.setMeterRentTypeName("\u65e5\u79df");
                        continue block10;
                    }
                    case "month": {
                        outRentParameterVO.setMeterRentTypeName("\u6708\u79df");
                        continue block10;
                    }
                    case "engineering": {
                        outRentParameterVO.setMeterRentTypeName("\u5de5\u7a0b\u91cf");
                        continue block10;
                    }
                }
                outRentParameterVO.setMeterRentTypeName("\u5176\u5b83\u8d39\u7528");
            }
        }
        pageData.setRecords(outRentParameterVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

