package com.ejianc.business.proequipmentcorpout.outrent.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorpout.outrent.bean.OutRentEquipmentStopEntity;
import com.ejianc.business.proequipmentcorpout.outrent.bean.OutRentEquipmentStopSubEntity;
import com.ejianc.business.proequipmentcorpout.outrent.service.IOutRentEquipmentStopService;
import com.ejianc.business.proequipmentcorpout.outrent.vo.OutRentEquipmentStopVO;
import com.ejianc.business.proequipmentcorprent.ac.enums.BillPushStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentEquipmentStopEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentEquipmentStopSubEntity;
import com.ejianc.business.proequipmentcorprent.rent.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentEquipmentStopService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterService;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentEquipmentStopVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 租赁设备停用
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("outRentEquipmentStop")
public class OutRentEquipmentStopController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String billTypeCode = "BT220221000000004";
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "OUT_RENT_EQUIPMENT_STOP";//此处需要根据实际修改
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proEquipment/card";
    @Autowired
    private IOutRentEquipmentStopService service;
    @Autowired
    private IShareCooperateApi shareCooperateApi;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IRentParameterService parameterService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<OutRentEquipmentStopVO> saveOrUpdate(@RequestBody OutRentEquipmentStopVO saveOrUpdateVO) {
    	OutRentEquipmentStopEntity entity = BeanMapper.map(saveOrUpdateVO, OutRentEquipmentStopEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
//        List<Long> parameterIdList = entity.getOutRentEquipmentStopSubList().stream().map(OutRentEquipmentStopSubEntity::getSourceId)
//                .collect(Collectors.toList());
//        // 校验停用日期
//        parameterService.checkValidation(parameterIdList, RentParameterTypeEnum.停用单.getCode(), entity.getId(),
//                entity.getContractId(), entity.getTypeDate());
//        entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
        entity.setSignStatus(0);
        service.saveOrUpdates(entity);
    	OutRentEquipmentStopVO vo = BeanMapper.map(entity, OutRentEquipmentStopVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/supSignSync")
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<OutRentEquipmentStopVO> queryDetail(Long id) {
    	OutRentEquipmentStopEntity entity = service.selectById(id);
    	OutRentEquipmentStopVO vo = BeanMapper.map(entity, OutRentEquipmentStopVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OutRentEquipmentStopVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (OutRentEquipmentStopVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(OutRentEquipmentStopVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<OutRentEquipmentStopVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        param.getFuzzyFields().add("projectName");
        param.getFuzzyFields().add("contractName");
        param.getFuzzyFields().add("employeeName");
        param.getFuzzyFields().add("supplierName");
        param.getFuzzyFields().add("code");
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        if(!param.getParams().containsKey("orgId")){// 非移动端默认项目，走PC端
            /** 数据隔离，如果当前登录组织为项目部，查询orgId，否则查询parentOrgId本下 */
            if(OrgVO.ORG_TYPE_DEPARTMENT.toString().equals(InvocationInfoProxy.getOrgType())){
                param.getParams().put("orgId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getOrgId()));
            } else {
                param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(
                        InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
            }
        } else if (param.getParams().get("orgId").getValue() != null){ // 移动端默认项目、默认组织
            Long orgId = Long.valueOf(param.getParams().get("orgId").getValue().toString());
            param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentId(orgId).
                    getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<OutRentEquipmentStopEntity> page = service.queryPage(param,false);
        IPage<OutRentEquipmentStopVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutRentEquipmentStopVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    @ApiOperation("获取协同链接")
    @RequestMapping(value = "/getBillShareLink", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam Long id) {
        return service.getBillShareLink(id);
    }
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("employeeName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("code");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId", new Parameter(QueryParam.IN, iOrgApi.findChildrenByParentIdWithoutProjectDept(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<OutRentEquipmentStopEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<OutRentEquipmentStopVO> outRentEquipmentStopVOS = BeanMapper.mapList(list, OutRentEquipmentStopVO.class);
        for (OutRentEquipmentStopVO outRentEquipmentStopVO : outRentEquipmentStopVOS) {
            outRentEquipmentStopVO.setBillStateName(BillStateEnum.getEnumByStateCode(outRentEquipmentStopVO.getBillState()).getDescription());
            outRentEquipmentStopVO.setSignStatusName(outRentEquipmentStopVO.getSignStatus() == 1 ? "已签字" : "未签字");
            outRentEquipmentStopVO.setRentHarborTypeName(outRentEquipmentStopVO.getRentHarborType() == 1 ? "内租" : "外租");
        }
        beans.put("records", outRentEquipmentStopVOS);
        ExcelExport.getInstance().export("OutRentEquipmentStop-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refOutRentEquipmentStopData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<OutRentEquipmentStopVO>> refOutRentEquipmentStopData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */

        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<OutRentEquipmentStopEntity> page = service.queryPage(param,false);
        IPage<OutRentEquipmentStopVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), OutRentEquipmentStopVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
