package com.ejianc.business.proequipmentcorpout.outrent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.order.api.IRentReceiptsApi;
import com.ejianc.business.order.enums.RentReceiptsEnum;
import com.ejianc.business.proequipmentcorpout.constants.RentOutStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterDetailEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterDetailService;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterService;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterDetailVO;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterVO;
import com.ejianc.business.proequipmentcorpout.outrent.Enums.OutRentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorpout.outrent.bean.OutRentEquipmentStopEntity;
import com.ejianc.business.proequipmentcorpout.outrent.bean.OutRentEquipmentStopSubEntity;
import com.ejianc.business.proequipmentcorpout.outrent.service.IOutRentEquipmentStopService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentAcceptanceService;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;

import java.util.*;
import java.util.stream.Collectors;

@Service("outRentEquipmentStop")
public class OutRentEquipmentStopBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IOutRentParameterService outRentParameterService;
	@Autowired
	private IOutRentEquipmentStopService stopService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IOutRentEquipmentStopService outRentEquipmentStopService;
	@Autowired
	private IShareCooperateApi shareCooperateApi;
	@Autowired
	private IOutRentParameterDetailService outRentParameterDetailService;
	@Autowired
	private IProSupplierApi proSupplierApi;
	private final String PUSH_DELETE_URL = "/ejc-supbusiness-web/openapi/equipmentStop/deleteStop";
	private final String OPERATE = "RENT-PROEQUIPMENT-ASTOP";
	@Autowired
	private IRentAcceptanceService rentAcceptanceService;
	private static final String BILL_TYPE = "BT220221000000004";//停用单 单据类型
	private static final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/equipmentStop/saveStop";

	@Autowired
	private IRentReceiptsApi receiptsApi;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//更新台账租出状态
		OutRentEquipmentStopEntity entity = outRentEquipmentStopService.selectById(billId);
		logger.info("获取启用单id：{}的子表数据：{}", entity.getId(), JSONObject.toJSONString(entity.getOutRentEquipmentStopSubList()));
		List<Long> outRentParameterIds = entity.getOutRentEquipmentStopSubList().stream().map(OutRentEquipmentStopSubEntity::getSourceId).collect(Collectors.toList());

		Map<Long, OutRentEquipmentStopSubEntity> stopSubMap = entity.getOutRentEquipmentStopSubList().stream().collect(Collectors.toMap(OutRentEquipmentStopSubEntity::getSourceId, vo -> vo, (v1, v2) -> v2));

		logger.info("获取台账单id数据集：{}", outRentParameterIds);
		QueryParam outRentParameterQuery = new QueryParam();
		outRentParameterQuery.getParams().put("id", new Parameter(QueryParam.IN, outRentParameterIds));
		List<OutRentParameterVO> updateList = BeanMapper.mapList(outRentParameterService.queryList(outRentParameterQuery), OutRentParameterVO.class);

		QueryParam outRentParameterDetailQuery = new QueryParam();
		outRentParameterDetailQuery.getParams().put("parameterId", new Parameter(QueryParam.IN, outRentParameterIds));
		List<OutRentParameterDetailVO> outRentParameterDetailVOList = BeanMapper.mapList(outRentParameterDetailService.queryList(outRentParameterDetailQuery), OutRentParameterDetailVO.class);

		//设置原台账子表
		if (CollectionUtils.isNotEmpty(updateList) && CollectionUtils.isNotEmpty(outRentParameterDetailVOList)){
			Map<Long, OutRentParameterDetailVO> outRentParameterDetailVOMap = outRentParameterDetailVOList.stream().collect(Collectors.toMap(OutRentParameterDetailVO::getParameterId, vo -> vo, (v1, v2) -> v2));
			for (OutRentParameterVO outRentParameterVO : updateList) {
				if (outRentParameterDetailVOMap.containsKey(outRentParameterVO.getId())){
					outRentParameterVO.getRentParameterDetailList().add(outRentParameterDetailVOMap.get(outRentParameterVO.getId()));
				}
			}
		}

		List<OutRentParameterDetailEntity> outRentParameterDetailEntityList = new ArrayList<>();
		if (CollectionUtils.isNotEmpty(updateList)){
			for (OutRentParameterVO outRentParameterVO : updateList) {
				outRentParameterVO.setRentOutStatus(RentOutStatusEnum.停用.getCode());

				//添加台账设备新子表数据
				OutRentParameterDetailVO paramDetailVO = new OutRentParameterDetailVO();
				paramDetailVO.setEquipmentState(OutRentEquipmentStateEnum.停用.getCode());
				if (stopSubMap.containsKey(outRentParameterVO.getId())){
					paramDetailVO.setOperationDate(stopSubMap.get(outRentParameterVO.getId()).getTypeDate());
					paramDetailVO.setSourceId(stopSubMap.get(outRentParameterVO.getId()).getId());
				}
				paramDetailVO.setParameterId(outRentParameterVO.getId());
				paramDetailVO.setSourceType(OutRentParameterDetailVO.SOURCE_TYPE_STOP); //停用
				outRentParameterVO.getRentParameterDetailList().add(paramDetailVO);
				outRentParameterDetailEntityList.add(BeanMapper.map(paramDetailVO, OutRentParameterDetailEntity.class));
			}
		}
		logger.info("通过停用单子表sourceId获取台账数据updateList：{}", JSONObject.toJSONString(updateList));
		outRentParameterService.saveOrUpdateBatch(BeanMapper.mapList(updateList, OutRentParameterEntity.class), updateList.size(), false);
		outRentParameterDetailService.saveOrUpdateBatch(outRentParameterDetailEntityList, outRentParameterDetailEntityList.size(), false);

		logger.info("推送项目方数据entity：{}", JSONObject.toJSONString(entity));

		if(entity.getRentHarborType() == 1) { //内租 推项目验收
			CommonResponse<String> response = receiptsApi.receiptsSync((JSONObject) JSONObject.toJSON(entity), RentReceiptsEnum.停用单.getName());
			if(!response.isSuccess()){
				throw new BusinessException(response.getMsg());
			}
		}
		return CommonResponse.success("审批回调成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//更新台账租出状态
		OutRentEquipmentStopEntity entity = outRentEquipmentStopService.selectById(billId);
		if(entity.getSignStatus()==1){
			throw new BusinessException("已签字不能撤回！");
		}

		logger.info("获取启用单id：{}的子表数据：{}", entity.getId(), JSONObject.toJSONString(entity.getOutRentEquipmentStopSubList()));
		List<Long> outRentParameterIds = entity.getOutRentEquipmentStopSubList().stream().map(OutRentEquipmentStopSubEntity::getSourceId).collect(Collectors.toList());
		//停用单子表id集合
		List<Long> outRentEquipmentStopSubIds = entity.getOutRentEquipmentStopSubList().stream().map(OutRentEquipmentStopSubEntity::getId).collect(Collectors.toList());
		//修改合同台账租出状态
		QueryParam outRentParameterQuery = new QueryParam();
		outRentParameterQuery.getParams().put("id", new Parameter(QueryParam.IN, outRentParameterIds));
		List<OutRentParameterVO> updateList = BeanMapper.mapList(outRentParameterService.queryList(outRentParameterQuery), OutRentParameterVO.class);
		logger.info("通过启用单子表sourceId获取台账数据：{}", JSONObject.toJSONString(updateList));
		if (CollectionUtils.isNotEmpty(updateList)){
			for (OutRentParameterVO outRentParameterVO : updateList) {
				if (outRentParameterVO.getRentOutStatus().equals(RentOutStatusEnum.停用.getCode())){
					outRentParameterVO.setRentOutStatus(RentOutStatusEnum.启用.getCode());
				}else {
					throw new BusinessException("当前设备"+ outRentParameterVO.getName() +"在台账中的租出状态已经不是停用状态，不能撤回！");
				}
			}
		}
		outRentParameterService.saveOrUpdateBatch(BeanMapper.mapList(updateList, OutRentParameterEntity.class), updateList.size(), false);
		//删除合同台账子表记录信息
		outRentParameterDetailService.delParameterDetailList(outRentEquipmentStopSubIds, RentParameterTypeEnum.停用单.getCode());

		if(entity.getRentHarborType() == 1) { //内租 推项目验收
			//将租出单位信息赋值给组织
			entity.setOrgId(entity.getOutOrgId());
			entity.setOrgName(entity.getOutOrgName());
			entity.setOrgCode(entity.getOutOrgCode());
			CommonResponse<String> response = receiptsApi.delReceipts(entity.getId(), RentReceiptsEnum.停用单.getName());
			if(!response.isSuccess()){
				throw new BusinessException(response.getMsg());
			}
		}

		return CommonResponse.success("审批回调成功！");
	}

}
