package com.ejianc.business.proequipmentcorprent.rent.enums;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 租金计算单据结算标志
 */
public enum RentalSettlementStateEnum {

    /**
     * 已结算: 0-已结算
     */
    已结算(0, "已结算"),

    /**
     * 未结算: 1-未结算
     */
    未结算(1, "未结算");


    private Integer code;
    private String description;
    private static Map<Integer, RentalSettlementStateEnum> enumMap = new HashMap<>();

    RentalSettlementStateEnum(Integer code, String description){
        this.code = code;
        this.description = description;
    }
    public Integer getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

    static {
        enumMap = EnumSet.allOf(RentalSettlementStateEnum.class).stream().collect(Collectors
                .toMap(RentalSettlementStateEnum::getCode, Function.identity(), (k1, k2) -> k2));
    }

    public static RentalSettlementStateEnum getEnumByCode(Integer billStateCode) {
        return enumMap.get(billStateCode);
    }
}
