/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorprent.rent.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractChangeEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractEntity;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentContractChangeService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentContractService;
import com.ejianc.business.signaturemanage.api.ISignatureCommonApi;
import com.ejianc.business.signaturemanage.api.ISignatureManageApi;
import com.ejianc.business.signaturemanage.vo.ContractVO;
import com.ejianc.business.signaturemanage.vo.SignMgrPreviewVO;
import com.ejianc.framework.core.response.CommonResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rentContractFileUpdate/"})
public class RentContractFileController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IRentContractService contractService;
    @Autowired
    private ISignatureManageApi signatureManageApi;
    @Autowired
    private ISignatureCommonApi signatureCommonApi;
    @Autowired
    private IRentContractChangeService changeService;

    @PostMapping(value={"updateFileInfo"})
    public CommonResponse<JSONObject> updateFileInfo(@RequestBody JSONObject updateData) {
        JSONObject resp = new JSONObject();
        this.logger.info("@@@@@@@@@@@@@", (Object)updateData.getLong("billId"));
        RentContractEntity contract = (RentContractEntity)((Object)this.contractService.selectById(updateData.getLong("billId")));
        contract.setContractFileId(updateData.getLong("fileId"));
        contract.setContractFile(updateData.getString("fileOnlinePath"));
        contract.setContractFileSyncFlag(true);
        this.contractService.saveOrUpdate((Object)contract, false);
        resp.put("message", (Object)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f");
        resp.put("billData", (Object)contract);
        return CommonResponse.success((String)"\u5408\u540c\u6587\u4ef6\u4fe1\u606f\u66f4\u65b0\u6210\u529f\uff01", (Object)resp);
    }

    @GetMapping(value={"getSignedFileInfo"})
    public CommonResponse<JSONObject> getSignedFileInfo(@RequestParam(value="billId") Long billId, @RequestParam(value="billType") String billType) {
        JSONObject resp = new JSONObject();
        String contractBillTypeStr = "contract";
        ArrayList<ContractVO> cvs = new ArrayList<ContractVO>();
        ContractVO cv = new ContractVO();
        if (contractBillTypeStr.equals(billType)) {
            RentContractEntity contract = (RentContractEntity)((Object)this.contractService.selectById(billId));
            Assert.notNull((Object)((Object)contract), (String)"\u67e5\u8be2\u4e0d\u5230\u4e3b\u5408\u540c\u8be6\u60c5");
            cv.setContractId(contract.getId());
            cv.setContractName(contract.getContractName());
            cv.setSourceType(billType);
            cv.setBillType("EJCBT202210000034");
        } else {
            RentContractChangeEntity contractChange = (RentContractChangeEntity)((Object)this.changeService.selectById(billId));
            cv.setContractId(contractChange.getId());
            cv.setContractName(contractChange.getContractName());
            cv.setSourceType(billType);
            cv.setBillType("EJCBT202210000035");
        }
        cvs.add(cv);
        CommonResponse signResp = this.signatureCommonApi.fetchSignedContract(cvs);
        if (!signResp.isSuccess()) {
            this.logger.error("\u83b7\u53d6\u5355\u636eid-{}\uff0cbillType-{}\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\u5931\u8d25: {}", new Object[]{billId, billType, signResp.getMsg()});
            return CommonResponse.error((String)"\u83b7\u53d6\u5408\u540c\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\u5931\u8d25!");
        }
        List fileList = (List)signResp.getData();
        if (CollectionUtils.isEmpty((Collection)fileList)) {
            return CommonResponse.error((String)"\u4e3a\u83b7\u53d6\u5230\u5408\u540c\u7b7e\u7ae0\u6587\u4ef6\u4fe1\u606f\uff01");
        }
        SignMgrPreviewVO signedFileInfo = (SignMgrPreviewVO)((List)signResp.getData()).get(0);
        if (contractBillTypeStr.equals(billType)) {
            RentContractEntity contract = (RentContractEntity)((Object)this.contractService.selectById(billId));
            contract.setSignedFileId(signedFileInfo.getFileId());
            this.contractService.saveOrUpdate((Object)contract, false);
        } else {
            RentContractChangeEntity contractChange = (RentContractChangeEntity)((Object)this.changeService.selectById(billId));
            contractChange.setSignedFileId(signedFileInfo.getFileId());
            this.changeService.saveOrUpdate((Object)contractChange, false);
        }
        resp.put("fileId", (Object)signedFileInfo.getFileId());
        resp.put("filePath", (Object)signedFileInfo.getFilePath());
        resp.put("fileTruePath", (Object)signedFileInfo.getTruePath());
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", (Object)resp);
    }
}

