/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorpout.appearance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.proequipmentcorpout.appearance.bean.OutAppearanceEntity;
import com.ejianc.business.proequipmentcorpout.appearance.bean.OutAppearanceSubEntity;
import com.ejianc.business.proequipmentcorpout.appearance.service.IOutAppearanceService;
import com.ejianc.business.proequipmentcorpout.contract.enums.RentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterDetailEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterService;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetEntity;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetService;
import com.ejianc.business.proequipmentcorprent.ac.enums.BillPushStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterEntity;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentParameterService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outAppearance")
public class OutAppearanceBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOutAppearanceService service;
    @Autowired
    private IOutRentParameterService rentParameterService;
    @Autowired
    private IRentParameterService parameterService;
    @Autowired
    private IAssetService assetService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        OutAppearanceEntity e = (OutAppearanceEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        e.setCommitDate(new Date());
        e.setCommitUserCode(userContext.getUserCode());
        e.setCommitUserName(userContext.getUserName());
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u4f7f\u7528\u8bb0\u5f55\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OutAppearanceEntity e = (OutAppearanceEntity)((Object)this.service.selectById(billId));
        UserContext userContext = this.sessionManager.getUserContext();
        if (state.equals(BillStateEnum.COMMITED_STATE.getBillStateCode()) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(state)) {
            e.setCommitDate(new Date());
            e.setCommitUserCode(userContext.getUserCode());
            e.setCommitUserName(userContext.getUserName());
        }
        ArrayList<OutRentParameterEntity> parameterList = new ArrayList<OutRentParameterEntity>();
        List<OutAppearanceSubEntity> appearanceSubList = e.getAppearanceSubList();
        for (OutAppearanceSubEntity subEntity : appearanceSubList) {
            OutRentParameterEntity parameterEntity = new OutRentParameterEntity();
            parameterEntity.setId(subEntity.getSourceId());
            parameterEntity.setOutDate(e.getAppearanceDate());
            parameterEntity.setOperationDate(new Date());
            parameterEntity.setEquipmentState(RentEquipmentStateEnum.\u9000\u573a.getCode());
            parameterEntity.setEquipmentStateName(RentEquipmentStateEnum.\u9000\u573a.getDescription());
            ArrayList<OutRentParameterDetailEntity> parameterDetailList = new ArrayList<OutRentParameterDetailEntity>();
            OutRentParameterDetailEntity detailEntity = new OutRentParameterDetailEntity();
            detailEntity.setSourceType(RentParameterTypeEnum.\u9000\u573a\u5355.getCode());
            detailEntity.setSourceId(e.getId());
            detailEntity.setOperationDate(subEntity.getRentEndDate());
            detailEntity.setEquipmentState(RentEquipmentStateEnum.\u9000\u573a.getCode());
            detailEntity.setParameterId(subEntity.getSourceId());
            parameterDetailList.add(detailEntity);
            parameterEntity.setRentParameterDetailList(parameterDetailList);
            parameterList.add(parameterEntity);
            OutRentParameterEntity outRentParameterEntity = (OutRentParameterEntity)((Object)this.rentParameterService.getById(subEntity.getSourceId()));
            int type = outRentParameterEntity.getSourceType();
            if (0 == type) {
                AssetEntity assetEntity = (AssetEntity)((Object)this.assetService.selectById(outRentParameterEntity.getEquipLedgerId()));
                assetEntity.setEquipmentStatus(3);
                this.assetService.updateById((Object)assetEntity);
                continue;
            }
            RentParameterEntity rentParameterEntity = (RentParameterEntity)((Object)this.parameterService.selectById(outRentParameterEntity.getEquipLedgerId()));
            rentParameterEntity.setUseType(1);
            this.parameterService.updateById((Object)rentParameterEntity);
        }
        this.rentParameterService.changeParameter(parameterList, RentParameterTypeEnum.\u9000\u573a\u5355.getCode());
        boolean pushFlag = false;
        if (!pushFlag) {
            e.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        } else {
            e.setBillPushFlag(BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus());
        }
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success((String)"\u4f7f\u7528\u8bb0\u5f55\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OutAppearanceEntity entity = (OutAppearanceEntity)((Object)this.service.selectById(billId));
        if (entity.getNotSignature().booleanValue()) {
            throw new BusinessException("\u5df2\u7b7e\u5b57\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OutAppearanceEntity e = (OutAppearanceEntity)((Object)this.service.selectById(billId));
        List<OutAppearanceSubEntity> appearanceSubList = e.getAppearanceSubList();
        List<Long> parameterIdList = appearanceSubList.stream().map(OutAppearanceSubEntity::getSourceId).collect(Collectors.toList());
        this.rentParameterService.cancelParameter(parameterIdList, RentParameterTypeEnum.\u9000\u573a\u5355.getCode(), e.getId());
        for (OutAppearanceSubEntity subEntity : appearanceSubList) {
            OutRentParameterEntity outRentParameterEntity = (OutRentParameterEntity)((Object)this.rentParameterService.getById(subEntity.getSourceId()));
            int type = outRentParameterEntity.getSourceType();
            if (0 == type) {
                AssetEntity assetEntity = (AssetEntity)((Object)this.assetService.selectById(outRentParameterEntity.getEquipLedgerId()));
                assetEntity.setEquipmentStatus(1);
                this.assetService.updateById((Object)assetEntity);
                continue;
            }
            RentParameterEntity rentParameterEntity = (RentParameterEntity)((Object)this.parameterService.selectById(outRentParameterEntity.getEquipLedgerId()));
            rentParameterEntity.setUseType(2);
            this.parameterService.updateById((Object)rentParameterEntity);
        }
        if (BillPushStatusEnum.\u63a8\u9001\u6210\u529f.getStatus().equals(e.getBillPushFlag())) {
            CommonResponse<String> commonResponse = this.service.updatePushBill(e, billTypeCode);
            this.logger.info("\u4f9b\u65b9\u7ed3\u679c" + JSONObject.toJSONString(commonResponse));
            if (!commonResponse.isSuccess()) {
                throw new BusinessException(commonResponse.getMsg());
            }
        }
        e.setBillPushFlag(BillPushStatusEnum.\u672a\u6210\u529f\u63a8\u9001.getStatus());
        this.service.saveOrUpdate((Object)e, false);
        return CommonResponse.success();
    }
}

