/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorpout.outStore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.order.api.IRentReceiptsApi;
import com.ejianc.business.order.enums.RentReceiptsEnum;
import com.ejianc.business.proequipmentcorpout.constants.RentOutParamSourceBillTypeEnum;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterDetailService;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterService;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterDetailVO;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterVO;
import com.ejianc.business.proequipmentcorpout.outStore.bean.OutStoreDetailEntity;
import com.ejianc.business.proequipmentcorpout.outStore.bean.OutStoreEntity;
import com.ejianc.business.proequipmentcorpout.outStore.enums.RequireFlagEnum;
import com.ejianc.business.proequipmentcorpout.outStore.enums.WeighFlagEnum;
import com.ejianc.business.proequipmentcorpout.outStore.service.IOutStoreService;
import com.ejianc.business.proequipmentcorpout.outStore.vo.OutStoreDetailVO;
import com.ejianc.business.proequipmentcorpout.outStore.vo.OutStoreVO;
import com.ejianc.business.proequipmentcorpout.outrent.Enums.OutRentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetEntity;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetService;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentAcceptanceVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="outStore")
public class OutStoreBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOutStoreService service;
    @Autowired
    private IOutRentParameterService outRentParameterService;
    @Autowired
    private IOutRentParameterDetailService outRentParameterDetailService;
    @Autowired
    private IOutRentContractService outRentContractService;
    @Autowired
    private IRentReceiptsApi rentReceiptsApi;
    @Autowired
    private IAssetService assetService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        OutStoreEntity outStoreEntity = (OutStoreEntity)((Object)this.service.selectById(billId));
        if (outStoreEntity.getWeighFlag().equals(WeighFlagEnum.\u662f.getCode()) && outStoreEntity.getRequireFlag().equals(RequireFlagEnum.\u5426.getCode())) {
            return CommonResponse.error((String)"\u5730\u78c5\u79f0\u91cd\u4e0d\u7b26\u5408\u8981\u6c42,\u65e0\u6cd5\u63d0\u4ea4");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OutStoreEntity outStoreEntity;
        if (state == 0 && (outStoreEntity = (OutStoreEntity)((Object)this.service.selectById(billId))).getWeighFlag().equals(WeighFlagEnum.\u662f.getCode()) && outStoreEntity.getRequireFlag().equals(RequireFlagEnum.\u5426.getCode())) {
            return CommonResponse.error((String)"\u5730\u78c5\u79f0\u91cd\u4e0d\u7b26\u5408\u8981\u6c42,\u65e0\u6cd5\u63d0\u4ea4");
        }
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OutStoreEntity entity = (OutStoreEntity)((Object)this.service.selectById(billId));
        OutStoreVO outStoreVO = (OutStoreVO)BeanMapper.map((Object)((Object)entity), OutStoreVO.class);
        OutRentParameterVO pushParamVO = null;
        OutRentContractEntity contract = (OutRentContractEntity)((Object)this.outRentContractService.selectById(entity.getContractId()));
        ArrayList<OutRentParameterVO> saveList = new ArrayList<OutRentParameterVO>();
        for (OutStoreDetailVO outStoreDetailVO : outStoreVO.getOutStoreDetailList()) {
            try {
                pushParamVO = (OutRentParameterVO)BeanConvertorUtil.convert((Object)outStoreVO, OutRentParameterVO.class);
                this.logger.info("pushParamVO: {}", (Object)JSONObject.toJSONString((Object)pushParamVO));
            }
            catch (Exception e) {
                this.logger.error("\u51fa\u5e93\u5355\u63a8\u9001\u79df\u51fa\u8bbe\u5907\u53f0\u8d26\u5931\u8d25, \u51fa\u5e93\u8f6c\u6362\u53f0\u8d26\u5355\u5f02\u5e38: ", (Throwable)e);
                return CommonResponse.error((String)"\u51fa\u5e93\u5355\u63a8\u9001\u79df\u51fa\u8bbe\u5907\u53f0\u8d26\u5931\u8d25\uff01");
            }
            pushParamVO.setFactoryCode(outStoreDetailVO.getEquipLeaveFactoryCode());
            pushParamVO.setBillState(Integer.valueOf(1));
            pushParamVO.setCategoryId(outStoreDetailVO.getMaterialTypeId());
            pushParamVO.setCategoryName(outStoreDetailVO.getMaterialTypeName());
            pushParamVO.setEquipmentId(outStoreDetailVO.getMaterialId());
            pushParamVO.setEquipmentCode(outStoreDetailVO.getMaterialCode());
            pushParamVO.setEquipmentName(outStoreDetailVO.getMaterialName());
            pushParamVO.setUnitId(outStoreDetailVO.getRentUnitId());
            pushParamVO.setUnitName(outStoreDetailVO.getRentUnitName());
            pushParamVO.setMeterRentDate(outStoreDetailVO.getRentDetailDate());
            pushParamVO.setMeterRentType(outStoreDetailVO.getRentCalculationType());
            pushParamVO.setEquipmentState(OutRentEquipmentStateEnum.\u542f\u7528.getCode());
            pushParamVO.setEquipmentStateName(OutRentEquipmentStateEnum.\u542f\u7528.getDescription());
            pushParamVO.setUseType(Integer.valueOf(2));
            pushParamVO.setEquipLedgerId(outStoreDetailVO.getStoreEquipId());
            pushParamVO.setEquipLedgerFactoryCode(outStoreDetailVO.getStoreEquipCode());
            pushParamVO.setUseProjectCode(pushParamVO.getProjectCode());
            pushParamVO.setUseProjectId(pushParamVO.getProjectId());
            pushParamVO.setUseProjectName(pushParamVO.getProjectName());
            pushParamVO.setUseOrgCode(pushParamVO.getUseOrgCode());
            pushParamVO.setUseOrgName(pushParamVO.getUseOrgName());
            pushParamVO.setUseOrgId(pushParamVO.getUseOrgId());
            pushParamVO.setSupplierId(contract.getSupplierId());
            pushParamVO.setSupplierName(contract.getSupplierName());
            pushParamVO.setSourceId(outStoreVO.getId());
            pushParamVO.setSourceBillType(entity.getRentHarborType() == 0 ? RentOutParamSourceBillTypeEnum.\u8bbe\u5907\u79df\u51fa\u81ea\u8d2d.getCode() : RentOutParamSourceBillTypeEnum.\u8bbe\u5907\u79df\u51fa\u79df\u8d41.getCode());
            pushParamVO.setMemo(outStoreDetailVO.getMemo());
            pushParamVO.setContractTaxRate(contract.getContractTax());
            pushParamVO.setContractCode(contract.getContractCode());
            OutRentParameterDetailVO paramDetailVO = new OutRentParameterDetailVO();
            paramDetailVO.setEquipmentState(OutRentEquipmentStateEnum.\u542f\u7528.getCode());
            paramDetailVO.setOperationDate(outStoreDetailVO.getRentDetailDate());
            paramDetailVO.setSourceId(outStoreDetailVO.getId());
            paramDetailVO.setSourceType("4");
            ArrayList<OutRentParameterDetailVO> paramSubList = new ArrayList<OutRentParameterDetailVO>();
            paramSubList.add(paramDetailVO);
            pushParamVO.setRentParameterDetailList(paramSubList);
            this.logger.info("pushParamVO: {}", (Object)JSONObject.toJSONString((Object)pushParamVO));
            saveList.add(pushParamVO);
        }
        QueryWrapper assetQuery = new QueryWrapper();
        assetQuery.in((Object)"id", (Collection)entity.getOutStoreDetailList().stream().map(OutStoreDetailEntity::getStoreEquipId).collect(Collectors.toList()));
        List assetEntities = this.assetService.list((Wrapper)assetQuery);
        for (AssetEntity asset : assetEntities) {
            asset.setRentState(1);
            asset.setEquipmentStatus(1);
            if (!StringUtils.isBlank((CharSequence)asset.getProjectName())) continue;
            asset.setProjectId(entity.getProjectId());
            asset.setProjectName(entity.getProjectName());
        }
        this.outRentParameterService.saveOrUpdateOutRentParams(saveList);
        if (entity.getRentHarborType() == 1) {
            JSONObject data = JSONObject.parseObject((String)JSONObject.toJSONString((Object)BeanMapper.map((Object)((Object)entity), RentAcceptanceVO.class)));
            data.put("orgId", (Object)outStoreVO.getOutOrgId());
            data.put("orgCode", (Object)outStoreVO.getOutOrgCode());
            data.put("orgName", (Object)outStoreVO.getOutOrgName());
            data.put("outOrgId", (Object)outStoreVO.getOrgId());
            data.put("outOrgCode", (Object)outStoreVO.getOrgCode());
            data.put("outOrgName", (Object)outStoreVO.getOrgName());
            data.put("supplierId", (Object)contract.getSupplierId());
            data.put("supplierName", (Object)contract.getSupplierName());
            data.put("acceptanceDate", (Object)entity.getOutstoreDate());
            data.put("acceptanceUserName", (Object)entity.getEmployeeName());
            data.put("acceptanceUserId", (Object)entity.getEmployeeId());
            data.put("rentDate", (Object)entity.getRentDate());
            data.put("acceptanceSource", (Object)("\u51fa\u5e93\u5355[" + entity.getId().toString() + "]"));
            data.put("acceptanceSourceId", (Object)1);
            data.put("sourceType", (Object)0);
            data.put("signStatus", (Object)0);
            data.put("carCode", (Object)entity.getLicensePlate());
            data.put("companyId", (Object)entity.getParentOrgId());
            data.put("companyName", (Object)entity.getParentOrgName());
            data.put("rentType", (Object)1);
            CommonResponse response = this.rentReceiptsApi.receiptsSync(data, RentReceiptsEnum.\u9a8c\u6536\u5355.getName());
            if (!response.isSuccess()) {
                this.logger.error("\u5185\u79df\u51fa\u5e93\u5355\u63a8\u9879\u76ee\u9a8c\u6536\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
                throw new BusinessException(response.getMsg());
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        OutStoreEntity entity = (OutStoreEntity)((Object)this.service.selectById(billId));
        List subIds = entity.getOutStoreDetailList().stream().map(BaseEntity::getId).collect(Collectors.toList());
        QueryWrapper detailQuery = new QueryWrapper();
        detailQuery.in((Object)"source_id", subIds);
        detailQuery.ne((Object)"source_type", (Object)"4");
        List list = this.outRentParameterDetailService.list((Wrapper)detailQuery);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return CommonResponse.error((String)"\u5f03\u5ba1\u5931\u8d25\uff0c\u8bbe\u5907\u5df2\u8fdb\u884c\u4e0b\u6e38\u4e1a\u52a1\uff01");
        }
        String result = this.outRentParameterService.removeBySourceId(entity.getId(), entity.getRentHarborType() == 0 ? RentOutParamSourceBillTypeEnum.\u8bbe\u5907\u79df\u51fa\u81ea\u8d2d.getCode() : RentOutParamSourceBillTypeEnum.\u8bbe\u5907\u79df\u51fa\u79df\u8d41.getCode());
        if (StringUtils.isNotBlank((CharSequence)result)) {
            return CommonResponse.error((String)("\u5f03\u5ba1\u5931\u8d25\uff0c\u5220\u9664\u79df\u51fa\u53f0\u8d26\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + result));
        }
        if (entity.getRentHarborType() == 1) {
            this.assetService.updateEquipState(entity.getOutStoreDetailList().stream().map(OutStoreDetailEntity::getStoreEquipId).collect(Collectors.toList()), 3, 2);
            CommonResponse response = this.rentReceiptsApi.delReceipts(entity.getId(), RentReceiptsEnum.\u9a8c\u6536\u5355.getName());
            if (!response.isSuccess()) {
                this.logger.error("\u51fa\u5e93\u5355\u5f03\u5ba1\u5f02\u5e38\uff0c\u5220\u9664\u5185\u79df\u9a8c\u6536\u5355\u5931\u8d25\uff1a{}", (Object)JSONObject.toJSONString((Object)response));
                throw new BusinessException(response.getMsg());
            }
        }
        return CommonResponse.success((String)"\u64cd\u4f5c\u6210\u529f\uff01");
    }
}

