/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorpout.outrent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.order.api.IRentReceiptsApi;
import com.ejianc.business.order.enums.RentReceiptsEnum;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.contract.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.RentalSettlementStateEnum;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.business.proequipmentcorpout.outrent.bean.OutRentSettlementEntity;
import com.ejianc.business.proequipmentcorpout.outrent.bean.OutRentSettlementRentalEntity;
import com.ejianc.business.proequipmentcorpout.outrent.service.IOutRentSettlementService;
import com.ejianc.business.proequipmentcorpout.outrent.vo.OutRentSettlementVO;
import com.ejianc.business.proequipmentcorpout.rental.service.IOutRentRentalService;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outRentSettlement")
public class OutRentSettlementBpmServiceImpl
implements ICommonBusinessService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IOutRentSettlementService service;
    @Autowired
    private IOutRentContractService contractService;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IExecutionApi executionApi;
    @Autowired
    private IOutRentRentalService rentRentalService;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private IRentReceiptsApi receiptsApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        OutRentSettlementEntity entity = (OutRentSettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getContractId() != null) {
            OutRentContractEntity contractEntity = (OutRentContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            if (PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(contractEntity.getContractPerformanceState()) || PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode().equals(contractEntity.getContractPerformanceState())) {
                throw new BusinessException("\u5408\u540c{" + contractEntity.getContractName() + "},\u72b6\u6001\u4e3a\uff1a" + PerformanceStatusEnum.getEnumByCode(contractEntity.getContractPerformanceState()).getDescription() + "\u4e0d\u53ef\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        OutRentSettlementEntity entity = (OutRentSettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getContractId() != null) {
            OutRentContractEntity contractEntity = (OutRentContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            if (PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(contractEntity.getContractPerformanceState()) || PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode().equals(contractEntity.getContractPerformanceState())) {
                throw new BusinessException("\u5408\u540c{" + contractEntity.getContractName() + "},\u72b6\u6001\u4e3a\uff1a" + PerformanceStatusEnum.getEnumByCode(contractEntity.getContractPerformanceState()).getDescription() + "\u4e0d\u53ef\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        OutRentSettlementEntity entity = (OutRentSettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getContractId() != null) {
            OutRentContractEntity contractEntity = (OutRentContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            if (PerformanceStatusEnum.\u5df2\u51bb\u7ed3.getCode().equals(contractEntity.getContractPerformanceState()) || PerformanceStatusEnum.\u5df2\u4f5c\u5e9f.getCode().equals(contractEntity.getContractPerformanceState())) {
                throw new BusinessException("\u5408\u540c{" + contractEntity.getContractName() + "},\u72b6\u6001\u4e3a\uff1a" + PerformanceStatusEnum.getEnumByCode(contractEntity.getContractPerformanceState()).getDescription() + "\u4e0d\u53ef\u8fdb\u884c\u6b64\u64cd\u4f5c\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        if (BillStateEnum.COMMITED_STATE.getBillStateCode().equals(state) || BillStateEnum.PASSED_STATE.getBillStateCode().equals(state)) {
            this.logger.info("\u5ba1\u6279\u901a\u8fc7\u4e1a\u52a1\u5f00\u59cb\uff01");
            OutRentSettlementEntity entity = (OutRentSettlementEntity)((Object)this.service.selectById(billId));
            OutRentSettlementVO settlementVO = (OutRentSettlementVO)BeanMapper.map((Object)((Object)entity), OutRentSettlementVO.class);
            if (entity.getContractId() != null && entity.getSettlementType() == 1) {
                OutRentContractEntity rentContractEntity = (OutRentContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
                rentContractEntity.setContractPerformanceState(PerformanceStatusEnum.\u5df2\u7ec8\u6b62.getCode());
                this.contractService.saveOrUpdate((Object)rentContractEntity);
                this.logger.info("\u4fee\u6539\u5408\u540c\u72b6\u6001\uff01" + JSONObject.toJSONString((Object)((Object)rentContractEntity)));
            }
            this.service.updateContractPoolSettle(settlementVO, true);
            if (CollectionUtils.isNotEmpty(entity.getRentSettlementRentalList())) {
                List<OutRentSettlementRentalEntity> rentalList = entity.getRentSettlementRentalList();
                List<Long> ids = rentalList.stream().filter(t -> t.getSourceId() != null).map(OutRentSettlementRentalEntity::getSourceId).collect(Collectors.toList());
                this.rentRentalService.updateRentalSettlementState(ids, RentalSettlementStateEnum.\u5df2\u7ed3\u7b97.getCode());
            }
            this.logger.info("\u63a8\u9001\u9879\u76ee\u65b9\u6570\u636eentity\uff1a{}", (Object)JSONObject.toJSONString((Object)((Object)entity)));
            if (entity.getRentHarborType() == 1) {
                entity.setOrgId(entity.getOutOrgId());
                entity.setOrgName(entity.getOutOrgName());
                entity.setOrgCode(entity.getOutOrgCode());
                CommonResponse response = this.receiptsApi.receiptsSync((JSONObject)JSONObject.toJSON((Object)((Object)entity)), RentReceiptsEnum.\u79df\u8d41\u5408\u540c\u7ed3\u7b97\u5355.getName());
                if (!response.isSuccess()) {
                    throw new BusinessException(response.getMsg());
                }
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse res = this.billTypeApi.checkQuote(billTypeCode, billId);
        this.logger.info("\u5e73\u53f0\u8fd4\u56de\u67e5\u8be2\u88ab\u5f15\u7528\u60c5\u51b5" + res.isSuccess() + "----" + res.getMsg());
        if (!res.isSuccess()) {
            return CommonResponse.error((String)"\u5f53\u524d\u5355\u636e\u5df2\u88ab\u4e0b\u6e38\u4e1a\u52a1\u5f15\u7528\uff0c\u4e0d\u80fd\u5f03\u5ba1\uff01");
        }
        OutRentSettlementEntity entity = (OutRentSettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getSignStatus() == 1) {
            throw new BusinessException("\u5df2\u7b7e\u5b57\u4e0d\u80fd\u64a4\u56de\uff01");
        }
        if (entity.getContractId() != null) {
            LambdaQueryWrapper lambda = new LambdaQueryWrapper();
            lambda.eq(OutRentSettlementEntity::getContractId, (Object)entity.getContractId());
            lambda.orderByDesc(BaseEntity::getCreateTime);
            List list = this.service.list((Wrapper)lambda);
            OutRentSettlementEntity settlementEntity = (OutRentSettlementEntity)((Object)list.get(0));
            if (!entity.getId().equals(settlementEntity.getId())) {
                throw new BusinessException("\u53ea\u80fd\u64a4\u56de\u6700\u65b0\u7684\u7ed3\u7b97\u5355\uff01");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse response;
        OutRentSettlementEntity entity = (OutRentSettlementEntity)((Object)this.service.selectById(billId));
        if (entity.getContractId() != null && entity.getSettlementType() == 1) {
            OutRentContractEntity contractEntity = (OutRentContractEntity)((Object)this.contractService.selectById(entity.getContractId()));
            contractEntity.setContractPerformanceState(PerformanceStatusEnum.\u5c65\u7ea6\u4e2d.getCode());
            this.contractService.saveOrUpdate((Object)contractEntity);
            this.logger.info("\u4fee\u6539\u5408\u540c\u72b6\u6001\uff01" + JSONObject.toJSONString((Object)((Object)contractEntity)));
        }
        if (CollectionUtils.isNotEmpty(entity.getRentSettlementRentalList())) {
            List<OutRentSettlementRentalEntity> rentalList = entity.getRentSettlementRentalList();
            List<Long> ids = rentalList.stream().filter(t -> t.getSourceId() != null).map(OutRentSettlementRentalEntity::getSourceId).collect(Collectors.toList());
            this.rentRentalService.updateRentalSettlementState(ids, RentalSettlementStateEnum.\u672a\u7ed3\u7b97.getCode());
        }
        if (entity.getRentHarborType() == 1 && !(response = this.receiptsApi.delReceipts(entity.getId(), RentReceiptsEnum.\u79df\u8d41\u5408\u540c\u7ed3\u7b97\u5355.getName())).isSuccess()) {
            throw new BusinessException(response.getMsg());
        }
        return CommonResponse.success();
    }
}

