/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorppur.acceptance.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.proequipmentcorpout.constants.RentOutParamSourceBillTypeEnum;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterDetailService;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterService;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterDetailVO;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterVO;
import com.ejianc.business.proequipmentcorpout.outrent.Enums.OutRentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorppur.acceptance.bean.PurchaseAcceptanceEntity;
import com.ejianc.business.proequipmentcorppur.acceptance.bean.PurchaseAcceptanceSubEntity;
import com.ejianc.business.proequipmentcorppur.acceptance.service.IPurchaseAcceptanceService;
import com.ejianc.business.proequipmentcorppur.acceptance.service.IPurchaseAcceptanceSubService;
import com.ejianc.business.proequipmentcorppur.acceptance.vo.PurchaseAcceptanceSubVO;
import com.ejianc.business.proequipmentcorppur.acceptance.vo.PurchaseAcceptanceVO;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetEntity;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetService;
import com.ejianc.business.proequipmentcorppur.asset.vo.AssetVO;
import com.ejianc.business.proequipmentcorppur.purchase.bean.PurchaseContractDetailedEntity;
import com.ejianc.business.proequipmentcorppur.purchase.bean.PurchaseContractEntity;
import com.ejianc.business.proequipmentcorppur.purchase.service.IPurchaseContractDetailedService;
import com.ejianc.business.proequipmentcorppur.purchase.service.IPurchaseContractService;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="purchaseAcceptance")
public class PurchaseAcceptanceBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPurchaseAcceptanceService service;
    @Autowired
    private IPurchaseContractService contractService;
    @Autowired
    private IPurchaseContractDetailedService equipmentDetailedService;
    @Autowired
    private IPurchaseAcceptanceSubService subService;
    @Autowired
    private IAssetService assetService;
    @Autowired
    private IOutRentParameterService outRentParameterService;
    @Autowired
    private IOutRentParameterDetailService outRentParameterDetailService;
    @Autowired
    private IOutRentContractService outRentContractService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    @Transactional(rollbackFor={Exception.class})
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PurchaseAcceptanceEntity acc = (PurchaseAcceptanceEntity)((Object)this.service.selectById(billId));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"purchase_acceptance_id", (Object)billId);
        List list = this.assetService.list((Wrapper)queryWrapper);
        AssetVO pushAssetVO = null;
        if (CollectionUtils.isEmpty((Collection)list)) {
            pushAssetVO = this.assetService.pushAsset(billId);
        }
        PurchaseAcceptanceVO assetVO = (PurchaseAcceptanceVO)BeanMapper.map((Object)((Object)acc), PurchaseAcceptanceVO.class);
        PurchaseAcceptanceSubVO subVo = (PurchaseAcceptanceSubVO)assetVO.getPurchaseAcceptanceSubList().get(0);
        if (acc.getAcceptanceStandardSectionFlag() == 0 && acc.getAcceptanceType() == 0) {
            OutRentParameterVO pushParamVO = null;
            OutRentContractEntity contract = (OutRentContractEntity)((Object)this.outRentContractService.selectById(subVo.getContractId()));
            if (null == contract) {
                throw new BusinessException("\u672a\u67e5\u8be2\u5230id-[" + subVo.getContractId() + "]\u5339\u914d\u7684\u79df\u51fa\u5408\u540c\u4fe1\u606f\uff01");
            }
            try {
                pushParamVO = (OutRentParameterVO)BeanConvertorUtil.convert((Object)assetVO, OutRentParameterVO.class);
                this.logger.info("pushParamVO: {}", (Object)JSONObject.toJSONString((Object)pushParamVO));
            }
            catch (Exception e) {
                this.logger.error("\u51fa\u5e93\u5355\u63a8\u9001\u79df\u51fa\u8bbe\u5907\u53f0\u8d26\u5931\u8d25, \u51fa\u5e93\u8f6c\u6362\u53f0\u8d26\u5355\u5f02\u5e38: ", (Throwable)e);
                return CommonResponse.error((String)"\u51fa\u5e93\u5355\u63a8\u9001\u79df\u51fa\u8bbe\u5907\u53f0\u8d26\u5931\u8d25\uff01");
            }
            pushParamVO.setCategoryId(subVo.getEquipmentTypeId());
            pushParamVO.setCategoryName(subVo.getEquipmentType());
            pushParamVO.setEquipmentId(subVo.getEquipmentId());
            pushParamVO.setEquipmentCode(subVo.getEquipmentCode());
            pushParamVO.setEquipmentName(subVo.getEquipmentName());
            pushParamVO.setUnitName(subVo.getCompany());
            pushParamVO.setProductionManufactor(subVo.getManufacturer());
            pushParamVO.setProjectId(contract.getProjectId());
            pushParamVO.setProjectCode(contract.getProjectCode());
            pushParamVO.setProjectName(contract.getProjectName());
            pushParamVO.setOutOrgId(contract.getOutOrgId());
            pushParamVO.setOutOrgCode(contract.getOutOrgCode());
            pushParamVO.setOutOrgName(contract.getOutOrgName());
            pushParamVO.setParentOrgId(contract.getParentOrgId());
            pushParamVO.setParentOrgName(contract.getParentOrgName());
            pushParamVO.setParentOrgCode(contract.getParentOrgCode());
            pushParamVO.setFirstPartyId(contract.getPartyId());
            pushParamVO.setFirstPartyName(contract.getPartyName());
            pushParamVO.setBillState(Integer.valueOf(1));
            pushParamVO.setMeterRentDate(assetVO.getAcceptanceDate());
            pushParamVO.setMeterRentType(contract.getMeterRentType());
            pushParamVO.setRentHarborType(contract.getRentHarborType());
            pushParamVO.setEquipmentState(OutRentEquipmentStateEnum.\u542f\u7528.getCode());
            pushParamVO.setEquipmentStateName(OutRentEquipmentStateEnum.\u542f\u7528.getDescription());
            pushParamVO.setUseType(Integer.valueOf(2));
            pushParamVO.setUseProjectCode(pushParamVO.getProjectCode());
            pushParamVO.setUseProjectId(pushParamVO.getProjectId());
            pushParamVO.setUseProjectName(pushParamVO.getProjectName());
            pushParamVO.setUseOrgCode(pushParamVO.getUseOrgCode());
            pushParamVO.setUseOrgName(pushParamVO.getUseOrgName());
            pushParamVO.setUseOrgId(pushParamVO.getUseOrgId());
            pushParamVO.setOrgId(contract.getOrgId());
            pushParamVO.setOrgName(contract.getOrgName());
            pushParamVO.setOrgCode(contract.getOrgCode());
            pushParamVO.setContractId(contract.getId());
            pushParamVO.setContractName(contract.getContractName());
            pushParamVO.setContractCode(contract.getContractCode());
            pushParamVO.setContractTaxRate(contract.getContractTax());
            pushParamVO.setSupplierId(contract.getSupplierId());
            pushParamVO.setSupplierName(contract.getSupplierName());
            pushParamVO.setSourceId(acc.getId());
            pushParamVO.setSourceBillType(RentOutParamSourceBillTypeEnum.\u8bbe\u5907\u9a8c\u6536\u76f4\u5165\u76f4\u51fa.getCode());
            pushParamVO.setFactoryCode(acc.getLeaveFactoryCode());
            pushParamVO.setEquipLedgerId(pushAssetVO.getId());
            pushParamVO.setEquipLedgerFactoryCode(acc.getLeaveFactoryCode());
            pushParamVO.setAcceptanceId(acc.getId());
            pushParamVO.setAcceptanceDetailId(subVo.getId());
            pushParamVO.setAcceptanceDate(acc.getAcceptanceDate());
            pushParamVO.setOutstoreDate(acc.getAcceptanceDate());
            OutRentParameterDetailVO paramDetailVO = new OutRentParameterDetailVO();
            paramDetailVO.setEquipmentState(OutRentEquipmentStateEnum.\u542f\u7528.getCode());
            paramDetailVO.setOperationDate(assetVO.getAcceptanceDate());
            paramDetailVO.setSourceId(subVo.getId());
            paramDetailVO.setSourceType("4");
            ArrayList<OutRentParameterDetailVO> paramSubList = new ArrayList<OutRentParameterDetailVO>();
            paramSubList.add(paramDetailVO);
            pushParamVO.setRentParameterDetailList(paramSubList);
            this.logger.info("pushParamVO: {}", (Object)JSONObject.toJSONString((Object)pushParamVO));
            this.outRentParameterService.saveOrUpdateOutRentParams(pushParamVO);
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        PurchaseAcceptanceEntity e = (PurchaseAcceptanceEntity)((Object)this.service.selectById(billId));
        QueryParam params = new QueryParam();
        params.getParams().put("pid", new Parameter("eq", (Object)billId));
        List subEntityList = this.subService.queryList(params);
        this.logger.info("11111111111111---------->: {}", (Object)JSONObject.toJSONString((Object)subEntityList));
        PurchaseAcceptanceSubEntity subEntity = (PurchaseAcceptanceSubEntity)((Object)subEntityList.get(0));
        this.logger.info("22222222222222---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)subEntity)));
        if (e.getAcceptanceStandardSectionFlag() == 0) {
            PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.contractService.selectById(e.getContractId()));
            this.logger.info("\u5f53\u524d\u4e3a\u8bbe\u5907\u9a8c\u6536\u5355\uff0c\u66f4\u65b0\u5408\u540c\u3010{}\u3011\u4e0b\u8bbe\u5907\u7684\u9a8c\u6570\u91cf", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
            QueryParam param = new QueryParam();
            param.getParams().put("contractId", new Parameter("eq", (Object)contractEntity.getId()));
            param.getParams().put("docCategoryId", new Parameter("eq", (Object)subEntity.getEquipmentTypeId()));
            param.getParams().put("docId", new Parameter("eq", (Object)subEntity.getEquipmentId()));
            List equipmentList = this.equipmentDetailedService.queryList(param);
            PurchaseContractDetailedEntity equipmentDetailedEntity = (PurchaseContractDetailedEntity)((Object)equipmentList.get(0));
            this.logger.info("\u5408\u540c\u4e0b\u8981\u66f4\u65b0\u7684\u8bbe\u5907---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)equipmentDetailedEntity)));
            if (equipmentDetailedEntity.getAcceptanceQuantity() == null) {
                equipmentDetailedEntity.setAcceptanceQuantity(1);
            } else {
                equipmentDetailedEntity.setAcceptanceQuantity(equipmentDetailedEntity.getAcceptanceQuantity() + 1);
            }
            this.equipmentDetailedService.saveOrUpdate((Object)equipmentDetailedEntity);
        }
        return CommonResponse.success((String)"\u4f7f\u7528\u8bb0\u5f55\u5ba1\u6279\u56de\u8c03\u5904\u7406\u6210\u529f\uff01");
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        CommonResponse resp = this.billTypeApi.checkQuote(billTypeCode, billId);
        if (!resp.isSuccess()) {
            return CommonResponse.error((String)("\u65e0\u6cd5\u64a4\u56de\uff01" + resp.getMsg()));
        }
        PurchaseAcceptanceEntity e = (PurchaseAcceptanceEntity)((Object)this.service.selectById(billId));
        QueryParam params = new QueryParam();
        params.getParams().put("pid", new Parameter("eq", (Object)billId));
        List subEntityList = this.subService.queryList(params);
        this.logger.info("11111111111111---------->: {}", (Object)JSONObject.toJSONString((Object)subEntityList));
        PurchaseAcceptanceSubEntity subEntity = (PurchaseAcceptanceSubEntity)((Object)subEntityList.get(0));
        this.logger.info("22222222222222---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)subEntity)));
        UserContext userContext = this.sessionManager.getUserContext();
        PurchaseContractEntity contractEntity = (PurchaseContractEntity)((Object)this.contractService.selectById(e.getContractId()));
        this.logger.info("333333333333333---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)contractEntity)));
        QueryParam param = new QueryParam();
        param.getParams().put("contractId", new Parameter("eq", (Object)contractEntity.getId()));
        param.getParams().put("docCategoryId", new Parameter("eq", (Object)subEntity.getEquipmentTypeId()));
        param.getParams().put("docId", new Parameter("eq", (Object)subEntity.getEquipmentId()));
        List equipmentList = this.equipmentDetailedService.queryList(param);
        this.logger.info("4444444444444444---------->: {}", (Object)JSONObject.toJSONString((Object)equipmentList));
        PurchaseContractDetailedEntity equipmentDetailedEntity = (PurchaseContractDetailedEntity)((Object)equipmentList.get(0));
        this.logger.info("555555555555555555---------->: {}", (Object)JSONObject.toJSONString((Object)((Object)equipmentDetailedEntity)));
        if (equipmentDetailedEntity.getAcceptanceQuantity() == null) {
            equipmentDetailedEntity.setAcceptanceQuantity(0);
        } else {
            equipmentDetailedEntity.setAcceptanceQuantity(equipmentDetailedEntity.getAcceptanceQuantity() - 1);
        }
        this.equipmentDetailedService.saveOrUpdate((Object)equipmentDetailedEntity);
        if (e.getAcceptanceStandardSectionFlag() == 0) {
            if (e.getAcceptanceType() == 0) {
                List subIds = e.getPurchaseAcceptanceSubList().stream().map(BaseEntity::getId).collect(Collectors.toList());
                QueryWrapper detailQuery = new QueryWrapper();
                detailQuery.in((Object)"source_id", subIds);
                detailQuery.ne((Object)"source_type", (Object)"4");
                List list = this.outRentParameterDetailService.list((Wrapper)detailQuery);
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    return CommonResponse.error((String)"\u5f03\u5ba1\u5931\u8d25\uff0c\u8bbe\u5907\u5df2\u8fdb\u884c\u4e0b\u6e38\u4e1a\u52a1\uff01");
                }
                String result = this.outRentParameterService.removeBySourceId(e.getId(), RentOutParamSourceBillTypeEnum.\u8bbe\u5907\u9a8c\u6536\u76f4\u5165\u76f4\u51fa.getCode());
                if (StringUtils.isNotBlank((CharSequence)result)) {
                    return CommonResponse.error((String)("\u5f03\u5ba1\u5931\u8d25\uff0c\u5220\u9664\u79df\u51fa\u53f0\u8d26\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + result));
                }
            }
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"purchase_acceptance_id", (Object)billId);
            List list = this.assetService.list((Wrapper)queryWrapper);
            AssetEntity assetEntity = (AssetEntity)((Object)list.get(0));
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                CommonResponse response = this.billTypeApi.checkQuote("EJCBT202206000070", assetEntity.getId());
                if (!response.isSuccess()) {
                    return CommonResponse.error((String)("\u9a8c\u6536\u751f\u6210\u7684\u56fa\u5b9a\u8d44\u4ea7\u5361\u7247\u88ab\u4e0b\u6e38\u5f15\u7528\u65e0\u6cd5\u64a4\u56de\uff01" + resp.getMsg()));
                }
                this.assetService.removeById(assetEntity.getId());
            }
        } else {
            QueryWrapper dbQuery = new QueryWrapper();
            dbQuery.eq((Object)"leave_factory_code", (Object)e.getLeaveFactoryCode());
            AssetEntity dbEntity = (AssetEntity)((Object)this.assetService.getOne((Wrapper)dbQuery));
            if (null == dbEntity) {
                throw new BusinessException("\u6ca1\u627e\u5230\u51fa\u5382\u7f16\u7801\u5339\u914d\u7684\u8bbe\u5907\uff0c\u64cd\u4f5c\u5931\u8d25\uff01");
            }
            dbEntity.setEquipmentStandardNum((null != dbEntity.getEquipmentStandardNum() ? dbEntity.getEquipmentStandardNum() : 0) - (null != subEntity.getCurAcceptStandardSectionNum() ? subEntity.getCurAcceptStandardSectionNum() : 0));
            if (e.getAcceptanceType() == 0) {
                dbEntity.setUseEquipmentStandardNum((null != dbEntity.getUseEquipmentStandardNum() ? dbEntity.getUseEquipmentStandardNum() : 0) - (null != subEntity.getCurAcceptStandardSectionNum() ? subEntity.getCurAcceptStandardSectionNum() : 0));
            }
            this.assetService.saveOrUpdate((Object)dbEntity, false);
        }
        return CommonResponse.success((String)"\u91c7\u8d2d\u9a8c\u6536\u5904\u7406\u6210\u529f\uff01");
    }
}

