package com.ejianc.business.proequipmentcorpout.contract.service;

import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractChangeEntity;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentContractChangeVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;

import java.util.List;
import java.util.Map;

/**
 * 租赁合同变更
 * 
 * @author generator
 * 
 */
public interface IOutRentContractChangeService extends IBaseService<OutRentContractChangeEntity> {
    /**
     * 保存或者修改
     * @param OutRentContractChangeVO
     */
    public OutRentContractChangeVO saveOrUpdates(OutRentContractChangeVO OutRentContractChangeVO);

    public OutRentContractChangeVO addConvertByConId(Long contractId, Long changeId);

    /**
     * 查询详情
     * @param id
     * @return
     */
    public OutRentContractChangeVO queryDetailRecord(Long id);

    /**
     * 根据合同id查询是否可以变更
     * @param contractId
     * @return
     */
    public Boolean editChangeFlag(Long contractId);

    ExecutionVO targetCost(OutRentContractChangeVO changeVO, Long lastSourceId);

    public void queryBpm(Long contractId);
    public CommonResponse<String> effectiveSaveWriteContract(Long billId, String billTypeCode, Boolean commitState);
    public CommonResponse<String> deleteById(Long changeBillId);

    OutRentContractChangeVO saveOrUpdate(OutRentContractChangeVO saveOrUpdateVO, Boolean isControl);

    ParamsCheckVO targetCostCtrl(OutRentContractChangeVO changeVO);

    ParamsCheckVO viewTargetCostCtrlInfo(Long id);

    OutRentContractChangeVO queryDetail(Long id);
    Boolean changeSignStatus(Long billId, int status, String refCode);
    ParamsCheckVO checkParams(OutRentContractChangeVO vo, ParamsCheckVO paramsCheckVO2);
    List<ParamsCheckVO> checkParamsMny(OutRentContractChangeVO vo);
    List<ParamsCheckVO> checkParamsMnyPlan(OutRentContractChangeVO vo);
    /*施工合同 控  变更
     *        @param 变更合同vo

     * */
    List<ParamsCheckVO> checkParamsConstruction(OutRentContractChangeVO vo);

    Map queryChangeCompare(Long id);
}
