package com.ejianc.business.proequipmentcorpout.order.service;

import com.ejianc.business.proequipmentcorpout.order.bean.OutOrderEntity;
import com.ejianc.business.proequipmentcorpout.order.vo.OutOrderVO;
import com.ejianc.framework.skeleton.template.IBaseService;

/**
 * 租赁订单
 * 
 * @author generator
 * 
 */
public interface IOutOrderService extends IBaseService<OutOrderEntity> {

    /**
     * 接收项目方订单接口
     *
     * @param saveOrUpdateVO 接收数据
     * @return
     */

    void saveOrder(OutOrderVO saveOrUpdateVO);
    /**
     * 项目方撤回时删除订单
     *
     * @param vo 需要删除的订单
     * @return 删除结果
     */
    void deleteOrder(OutOrderVO vo);
    /**
     * 施工方关闭订单
     *
     * @param vo 需要关闭订单
     * @return 关闭订单
     */
    String updateOrderCloseFlag(OutOrderVO vo);
    /**
     * 接收、拒收订单
     *
     * @param saveOrUpdateVO 订单详情
     * @return 保存结果
     */
    OutOrderVO saveOrUpdate(OutOrderVO saveOrUpdateVO);

}
