package com.ejianc.business.proequipmentcorpout.outStore.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 设备租出-设备出库主实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_outequipmentcorp_outstore")
public class OutStoreEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="deliver_id")
    private Long deliverId; // 送货人主键
    @TableField(value="deliver_name")
    private String deliverName; // 送货人名称
    @TableField(value="deliver_phone")
    private String deliverPhone; // 送货人电话
    @TableField(value="rent_id")
    private Long rentId; // 租赁方主键
    @TableField(value="rent_name")
    private String rentName; // 租赁方名称
    @TableField(value="rent_code")
    private String rentCode; // 租赁方code
    @TableField(value="contract_id")
    private Long contractId; // 合同主键
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="contract_code")
    private String contractCode; // 合同code

    @TableField(value="out_store_org_id")
    private Long outStoreOrgId; // 出库单位主键
    @TableField(value="out_store_org_name")
    private String outStoreOrgName; // 出库单位名称
    @TableField(value="source_type")
    private Integer sourceType; // 材料来源,0-自购,1-租赁
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="department_id")
    private Long departmentId; // 经办部门
    @TableField(value="department_name")
    private String departmentName; // 经办部门名称
    @TableField(value="arrive_date")
    private Date arriveDate; // 预计到货日期
    @TableField(value="license_plate")
    private String licensePlate; // 车牌号
    @TableField(value="record_flag")
    private Integer recordFlag; // 是否补录，0-否，1-是
    @TableField(value="record_reason")
    private String recordReason; // 补录原因
    /**
     * 租出组织id
     */
    @TableField(value="org_id")
    private Long orgId;
    /**
     * 租出组织名称
     */
    @TableField(value="org_name")
    private String orgName;
    /**
     * 租出组织编码
     */
    @TableField(value="org_code")
    private String orgCode;
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="store_id")
    private Long storeId; // 仓库主键
    @TableField(value="store_name")
    private String storeName; // 仓库名称
    @TableField(value="outstore_date")
    private Date outstoreDate; // 出库日期
    @TableField(value="rent_date")
    private Date rentDate; // 计租日期
    @TableField(value="weigh_flag")
    private Integer weighFlag; // 是否地磅称重 0-否，1-是
    @TableField(value="require_flag")
    private Integer requireFlag; // 是否符合要求 0-否，1-是

    @TableField(value="bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value="supplier_sign_status")
    private Integer supplierSignStatus; // 签字状态(已签字-1,未签字-0)
    @TableField(value="relation_flag")
    private String relationFlag; // 关联状态(1:是，0：否)
    @TableField(value="proportion_flag")
    private String proportionFlag; // 分摊状态(1:是，0：否)
    @TableField(value="rent_harbor_type")
    private Integer rentHarborType; // 租赁方式：0-外租，1-内租
    @TableField(value = "rent_harbor_type_name")
    private String rentHarborTypeName;
    @TableField(value = "sup_operator_name")
    private String supOperatorName; // 供方经办人名称
    @TableField(value = "sup_operator_phone")
    private String supOperatorPhone; // 供方经办人手机号
    @TableField(value = "sup_operator_user_code")
    private String supOperatorUserCode; // 供方经办人账号
    @TableField(value="sup_operate_time")
    private Date supOperateTime; // 供方经办人签字时间
    @TableField(value="proxy_employee_id")
    private Long proxyEmployeeId; // 委托代理人id
    @TableField(value="proxy_employee_name")
    private String proxyEmployeeName; // 委托代理人名称
    @TableField(value="proxy_contract_id")
    private Long proxyContractId; // 合同委托书ID
    @TableField(exist=false)
    @SubEntity(serviceName="outStoreDetailService",pidName = "deliveryId")
    private List<OutStoreDetailEntity> outStoreDetailList = new ArrayList<>(); // out-出库单子表

    /**
     * 项目id
     */
    @TableField(value="project_id")
    private Long projectId;
    /**
     * 项目名称
     */
    @TableField(value="project_name")
    private String projectName;
    /**
     * 项目编码
     */
    @TableField(value="project_code")
    private String projectCode;
    /**
     * 项目部id
     */
    @TableField(value="out_org_id")
    private Long outOrgId;
    /**
     * 项目部名称
     */
    @TableField(value="out_org_name")
    private String outOrgName;
    /**
     * 项目部编码
     */
    @TableField(value="out_org_code")
    private String outOrgCode;
    /**
     * 项目部父级组织名称
     */
    @TableField(value="parent_org_name")
    private String parentOrgName;
    /**
     * 项目部父级组织编码
     */
    @TableField(value="parent_org_code")
    private String parentOrgCode;
    /**
     * 项目部父级组织id
     */
    @TableField(value="parent_org_id")
    private Long parentOrgId;

    public Long getOutOrgId() {
        return outOrgId;
    }

    public void setOutOrgId(Long outOrgId) {
        this.outOrgId = outOrgId;
    }

    public String getOutOrgName() {
        return outOrgName;
    }

    public void setOutOrgName(String outOrgName) {
        this.outOrgName = outOrgName;
    }

    public String getOutOrgCode() {
        return outOrgCode;
    }

    public void setOutOrgCode(String outOrgCode) {
        this.outOrgCode = outOrgCode;
    }

    public Integer getSupplierSignStatus() {
        return supplierSignStatus;
    }

    public void setSupplierSignStatus(Integer supplierSignStatus) {
        this.supplierSignStatus = supplierSignStatus;
    }

    public Long getProxyContractId() {
        return proxyContractId;
    }

    public void setProxyContractId(Long proxyContractId) {
        this.proxyContractId = proxyContractId;
    }

    public Long getProxyEmployeeId() {
        return proxyEmployeeId;
    }

    public void setProxyEmployeeId(Long proxyEmployeeId) {
        this.proxyEmployeeId = proxyEmployeeId;
    }

    public String getProxyEmployeeName() {
        return proxyEmployeeName;
    }

    public void setProxyEmployeeName(String proxyEmployeeName) {
        this.proxyEmployeeName = proxyEmployeeName;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getDeliverId() {
        return deliverId;
    }

    public void setDeliverId(Long deliverId) {
        this.deliverId = deliverId;
    }
    public String getDeliverName() {
        return deliverName;
    }

    public void setDeliverName(String deliverName) {
        this.deliverName = deliverName;
    }
    public String getDeliverPhone() {
        return deliverPhone;
    }

    public void setDeliverPhone(String deliverPhone) {
        this.deliverPhone = deliverPhone;
    }
    public Long getRentId() {
        return rentId;
    }

    public void setRentId(Long rentId) {
        this.rentId = rentId;
    }
    public String getRentName() {
        return rentName;
    }

    public void setRentName(String rentName) {
        this.rentName = rentName;
    }
    public String getRentCode() {
        return rentCode;
    }

    public void setRentCode(String rentCode) {
        this.rentCode = rentCode;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getOutStoreOrgId() {
        return outStoreOrgId;
    }

    public void setOutStoreOrgId(Long outStoreOrgId) {
        this.outStoreOrgId = outStoreOrgId;
    }

    public String getOutStoreOrgName() {
        return outStoreOrgName;
    }

    public void setOutStoreOrgName(String outStoreOrgName) {
        this.outStoreOrgName = outStoreOrgName;
    }

    public Integer getSourceType() {
        return sourceType;
    }

    public void setSourceType(Integer sourceType) {
        this.sourceType = sourceType;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Date getArriveDate() {
        return arriveDate;
    }

    public void setArriveDate(Date arriveDate) {
        this.arriveDate = arriveDate;
    }
    public String getLicensePlate() {
        return licensePlate;
    }

    public void setLicensePlate(String licensePlate) {
        this.licensePlate = licensePlate;
    }
    public Integer getRecordFlag() {
        return recordFlag;
    }

    public void setRecordFlag(Integer recordFlag) {
        this.recordFlag = recordFlag;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public Date getOutstoreDate() {
        return outstoreDate;
    }

    public void setOutstoreDate(Date outstoreDate) {
        this.outstoreDate = outstoreDate;
    }
    public Date getRentDate() {
        return rentDate;
    }

    public void setRentDate(Date rentDate) {
        this.rentDate = rentDate;
    }
    public Integer getWeighFlag() {
        return weighFlag;
    }

    public void setWeighFlag(Integer weighFlag) {
        this.weighFlag = weighFlag;
    }
    public Integer getRequireFlag() {
        return requireFlag;
    }

    public void setRequireFlag(Integer requireFlag) {
        this.requireFlag = requireFlag;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }
    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }


    public List<OutStoreDetailEntity> getOutStoreDetailList() {
        return outStoreDetailList;
    }

    public void setOutStoreDetailList(List<OutStoreDetailEntity> outStoreDetailList) {
        this.outStoreDetailList = outStoreDetailList;
    }

    public String getRecordReason() {
        return recordReason;
    }

    public void setRecordReason(String recordReason) {
        this.recordReason = recordReason;
    }

    public Integer getRentHarborType() {
        return rentHarborType;
    }

    public void setRentHarborType(Integer rentHarborType) {
        this.rentHarborType = rentHarborType;
    }

    public String getRentHarborTypeName() {
        return rentHarborTypeName;
    }

    public void setRentHarborTypeName(String rentHarborTypeName) {
        this.rentHarborTypeName = rentHarborTypeName;
    }


}
