package com.ejianc.business.proequipmentcorpout.outrent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.contractbase.pool.contractpool.api.IContractPoolApi;
import com.ejianc.business.contractbase.pool.contractpool.vo.ContractPoolVO;
import com.ejianc.business.contractbase.pool.enums.ContractTypeEnum;
import com.ejianc.business.contractbase.pool.enums.SettleSourceTypeEnum;
import com.ejianc.business.contractbase.pool.settlepool.api.ISettlePoolApi;
import com.ejianc.business.contractbase.pool.settlepool.vo.SettlePoolVO;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.business.proequipmentcorpout.outrent.bean.*;
import com.ejianc.business.proequipmentcorpout.outrent.mapper.OutRentSettlementMapper;
import com.ejianc.business.proequipmentcorpout.outrent.service.IOutRentSettlementFragmentaryService;
import com.ejianc.business.proequipmentcorpout.outrent.service.IOutRentSettlementService;
import com.ejianc.business.proequipmentcorpout.outrent.vo.OutRentSettleRecordVO;
import com.ejianc.business.proequipmentcorpout.outrent.vo.OutRentSettlementVO;
import com.ejianc.business.proequipmentcorprent.ac.enums.BillPushStatusEnum;
import com.ejianc.business.proequipmentcorprent.ac.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentRentalEntity;
import com.ejianc.business.proequipmentcorprent.temporary.userecord.bean.TemporaryUseRecordSubEntity;
import com.ejianc.business.proequipmentcorprent.temporary.userecord.service.ITemporaryUseRecordSubService;
import com.ejianc.business.targetcost.api.IExecutionApi;
import com.ejianc.business.targetcost.enums.BillCategoryEnum;
import com.ejianc.business.targetcost.enums.BussinessTypeEnum;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckDsVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.business.targetcost.vo.TotalExecutionVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.utils.FileUtil;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IParamConfigApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.BillParamVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.utils.RedisTool;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.dataPush.ISystemDataPushService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

import javax.servlet.http.HttpServletRequest;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 设备租赁结算主表
 * 
 * @author generator
 * 
 */
@Service("outRentSettlementService")
public class OutRentSettlementServiceImpl extends BaseServiceImpl<OutRentSettlementMapper, OutRentSettlementEntity> implements IOutRentSettlementService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IParamConfigApi paramConfigApi;
    //参数控制
    private static final String CHECK_PARAM_CODE_GC = "P-5kO0W220";//合同金额控结算金额-过程
    private static final String CHECK_PARAM_CODE_ZZ = "P-Zez9060156";//合同金额控结算金额-最终
    @Autowired
    private IOrgApi iOrgApi;


    private static final String BILL_CODE = "OUT_RENT_SETTLEMENT";//此处需要根据实际修改

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOutRentContractService rentContractService;//租赁合同
    @Autowired
    private IProSupplierApi proSupplierApi;
    @Autowired
    private ITemporaryUseRecordSubService temporaryUseRecordSubService;//临时使用记录明细
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IOutRentSettlementFragmentaryService rentSettlementFragmentaryService;
    @Autowired
    private JedisPool jedisPool;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ISystemDataPushService systemDataPushService;
    @Autowired
    private ISettlePoolApi settlePoolApi;
    @Autowired
    private IContractPoolApi contractPoolApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private IShareMaterialApi materialApi;
    @Autowired
    private IExecutionApi executionApi;


    private final String  OPERATE= "RENT_SETTLE_JS";

    private final String PUSH_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/rentSettlement/saveRentSettlement";
    private final String DEL_BILL_SERVER_URL = "/ejc-supbusiness-web/openapi/rentSettlement/deleteRentSettlement";
    private static final String BILL_TYPE = "EJCBT202204000006";

    @Override
    public OutRentSettlementVO saveOrUpdate(OutRentSettlementVO saveOrUpdateVO) {
        OutRentSettlementEntity entity = BeanMapper.map(saveOrUpdateVO, OutRentSettlementEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
            entity.setRelationFlag("0");//关联状态初始化
            entity.setProportionFlag("0");//分摊状态初始化
            //保存初始化签章，签字状态
            entity.setSignStatus(0);
            entity.setSignatureStatus(0);
            entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
        }
        if (null!=entity.getContractId() && this.queryExist(entity.getContractId(),entity.getId())){
            throw new BusinessException("该合同下有未生效的结算单！");
        }
        List<OutRentSettlementFragmentaryEntity> rentSettlementFragmentaryList = entity.getRentSettlementFragmentaryList();
        if(CollectionUtils.isNotEmpty(rentSettlementFragmentaryList)){
            List<Long> addLong = new ArrayList<>();//引用id
            List<Long> delLong = new ArrayList<>();//释放id
            for (OutRentSettlementFragmentaryEntity fragmentaryEntity : rentSettlementFragmentaryList) {
                if("del".equals(fragmentaryEntity.getRowState())){
                    delLong.add(fragmentaryEntity.getSourceId());
                }else {
                    addLong.add(fragmentaryEntity.getSourceId());
                }
            }
            updateSettleFlag(addLong,true);
            updateSettleFlag(delLong,false);
        }
        super.saveOrUpdate(entity, false);
        OutRentSettlementVO vo = BeanMapper.map(entity, OutRentSettlementVO.class);
        return vo;
    }
    public void updateSettleFlag( List<Long> ids,Boolean flag){
        if(CollectionUtils.isEmpty(ids)){
            return;
        }
        LambdaQueryWrapper<TemporaryUseRecordSubEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(TemporaryUseRecordSubEntity::getPid,ids);
        List<TemporaryUseRecordSubEntity> list = temporaryUseRecordSubService.list(wrapper);
        List<Long> collect = list.stream().map(item -> item.getId()).collect(Collectors.toList());
        if(flag){
            logger.info("结算--临时记录id--{}",JSONObject.toJSONString(ids));
            temporaryUseRecordSubService.updateSettleFlag(collect,1); //是否被结算(0-否，1-是)
        }else {
            logger.info("释放--临时记录id--{}",JSONObject.toJSONString(ids));
            temporaryUseRecordSubService.updateSettleFlag(collect,0); //是否被结算(0-否，1-是)
        }

    }
//删除
    @Override
    public void delete(List<Long> settleIds) {
        LambdaQueryWrapper<OutRentSettlementFragmentaryEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.in(OutRentSettlementFragmentaryEntity::getSettlementId,settleIds);
        List<OutRentSettlementFragmentaryEntity> list = rentSettlementFragmentaryService.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)){
            List<Long> delIds = list.stream().map(OutRentSettlementFragmentaryEntity::getSourceId).collect(Collectors.toList());
            updateSettleFlag(delIds,false);
        }
        super.removeByIds(settleIds,false);
    }

    /*是否有为生效的结算单*/
    @Override
    public boolean queryExist(Long contractId,Long id){
        LambdaQueryWrapper<OutRentSettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(OutRentSettlementEntity::getContractId, contractId);
        wrapper.notIn(OutRentSettlementEntity::getBillState, 1,3);//未生效条件
        if(id!=null){
            wrapper.ne(OutRentSettlementEntity::getId, id);
        }
        List<OutRentSettlementEntity> list = super.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)){//有数据表示有未生效的结算单
            return true;
        }
        return false;
    }

    /*获取最近一次含本期结算金额和结算日期 结算次数*/
    @Override
    public CommonResponse<Map> getDateMny(Long contractId) {
        Map<String, Object> map = new HashMap<>();
        BigDecimal currentTaxMny = BigDecimal.ZERO; // 结算金额
        BigDecimal currentMny = BigDecimal.ZERO; // 结算金额(无税)
        String sTDate  = null;
        LambdaQueryWrapper<OutRentSettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.orderByDesc(OutRentSettlementEntity::getCreateTime);
        wrapper.in(OutRentSettlementEntity::getBillState, 1,3);//防止修改时获取本单据的数据
        wrapper.eq(OutRentSettlementEntity::getDr, 0);
        wrapper.eq(OutRentSettlementEntity::getContractId, contractId);
        List<OutRentSettlementEntity> list = super.list(wrapper);
        if(CollectionUtils.isNotEmpty(list)){
            OutRentSettlementEntity settlementEntity = list.get(0);
            currentTaxMny = settlementEntity.getCurrentSettlementTaxMny()==null?BigDecimal.ZERO:settlementEntity.getCurrentSettlementTaxMny();
            currentMny = settlementEntity.getCurrentSettlementMny()==null?BigDecimal.ZERO:settlementEntity.getCurrentSettlementMny();
            sTDate = DateFormatUtil.formatDate("yyyy-MM-dd", settlementEntity.getSettlementDate());
        }
        map.put("currentTaxMny",currentTaxMny);
        map.put("currentMny",currentMny);
        map.put("sTDate",sTDate);
        map.put("settlementNum",list.size());
        return CommonResponse.success("获取金额和时间成功！",map);
    }

    /*推送供方*/
    @Override
    public boolean pushBillToSupCenter(OutRentSettlementEntity entity) {
        boolean locked = false, syncFlag = false;
        Jedis jedis = jedisPool.getResource();
        String key = BILL_TYPE + "::" + entity.getId().toString();

        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送计量单据-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
            return false;
        }
        //设置当前系统ID
        entity.setSystemId(ejcCloudSystemCode.getData());

        try {
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据推送失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return false;
            }

            Map<String, String> paramMap = new HashMap<>();
//            SupRentSettlementVO supRentSettlementVO = BeanMapper.map(entity, SupRentSettlementVO.class);
//            List<SupRentSettlementDayVO> supRentSettlementDayVOS = BeanMapper.mapList(entity.getRentSettlementDayList(), SupRentSettlementDayVO.class);
//            List<SupRentSettlementMonthVO> supRentSettlementMonthVOS = BeanMapper.mapList(entity.getRentSettlementMonthList(), SupRentSettlementMonthVO.class);
//            List<SupRentSettlementQuantitiesVO> supRentSettlementQuantitiesVOS = BeanMapper.mapList(entity.getRentSettlementQuantitiesList(), SupRentSettlementQuantitiesVO.class);
//            List<SupRentSettlementRentalVO> supRentSettlementRentalVOS = BeanMapper.mapList(entity.getRentSettlementRentalList(), SupRentSettlementRentalVO.class);
//            List<SupRentSettlementFeeVO> supSettlementFeeVOS = BeanMapper.mapList(entity.getRentSettlementFeeList(), SupRentSettlementFeeVO.class);
//            supRentSettlementVO.setRentSettlementDayList(supRentSettlementDayVOS);
//            supRentSettlementVO.setRentSettlementMonthList(supRentSettlementMonthVOS);
//            supRentSettlementVO.setRentSettlementRentalList(supRentSettlementRentalVOS);
//            supRentSettlementVO.setRentSettlementQuantitiesList(supRentSettlementQuantitiesVOS);
//            supRentSettlementVO.setRentSettlementFeeList(supSettlementFeeVOS);
//            paramMap.put("transData", JSONObject.toJSONString(supRentSettlementVO));

            //查询单据附件信息并下载
            CommonResponse<List<AttachmentVO>> fileResp = attachmentApi.queryListBySourceId(entity.getId(), BILL_TYPE, "projectMangerSign", null);
            if (fileResp.isSuccess()) {
                Map<String, Map<String, InputStream>> files = new HashMap<>();
                List<AttachmentVO> fileList = fileResp.getData();
                List<Long> fileIds = new ArrayList<>();
                //从附件信息列表获取到： 1、附件名对应附件业务类型Map,2、获取到附件Id列表
                for (AttachmentVO attach : fileList) {
                    fileIds.add(attach.getId());
                }
                //当前单据携带有附件信息
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(fileList)) {
                    Map<String, InputStream> fileMap = FileUtil.getInstance().batchDownFileFlow(fileIds, true);
                    fileMap.keySet().stream().forEach(fileKey -> {
                        Map<String, InputStream> file = new HashMap<>(1);
                        file.put(fileKey, fileMap.get(fileKey));
                        files.put("file", file);
                    });
                }
                logger.info("向供应商-{}推送附件参数-{}", entity.getSupplierId(), JSONObject.toJSONString(files));
                logger.info("向供应商-{}推送计量单据参数-{}", entity.getSupplierId(), JSONObject.toJSONString(paramMap));

                //推送单据到指定的供方
                CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataAndFilesWithEachLinkSystem(PUSH_BILL_SERVER_URL,
                        paramMap,
                        entity.getSupplierId().toString(),
                        files);
//                syncFlag = CommonUtils.checkCommonResponse(syncReqResp, logger);
                if (syncReqResp.isSuccess()) {
                    CommonResponse<String> billPushResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                    if (billPushResp.isSuccess()) {
                        syncFlag = true;
                    } else {
                        logger.error("供方id-{}处理推送订单单据id-{}失败, {}", entity.getSupplierId(), entity.getId(), billPushResp.getMsg());
                    }
                } else {
                    logger.error("发送请求推送订单单据id-{}给供方id-{}失败, {}", entity.getId(), entity.getSupplierId(), syncReqResp.getMsg());
                }
            } else {
                logger.error("获取订单单据id-{}对应附件信息失败, {}", entity.getId(), fileResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("推送订单单据id-{}给供方id-{} 异常，", entity.getId(), entity.getSupplierId(), e);
//            throw e;
        } finally {
            //释放单据锁
            releaseLock(jedis, locked, key, OPERATE);
        }

        return syncFlag;
    }

    /*
     * 撤回推送供方
     *  */
    @Override
    public CommonResponse<String> updatePushBill(OutRentSettlementEntity entity) {
        boolean locked = false;
        Jedis jedis = jedisPool.getResource();
        String key = BILL_TYPE + "::" + entity.getId().toString();
        //设置单据当前系统信息
        CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
        if (!ejcCloudSystemCode.isSuccess()) {
            logger.error("推送单据-{}失败，获取当前系统编码失败,{}", entity.getId(), ejcCloudSystemCode.getMsg());
            return CommonResponse.error("推送供方异常!");
        }
        //设置当前系统ID
        entity.setSystemId(ejcCloudSystemCode.getData());
        entity.setSignStatus(0);
        baseMapper.updateById(entity);
        logger.info("修改签字信息：{}", JSONObject.toJSONString(entity));
        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据作废失败，单据锁获取失败！");
                releaseLock(jedis, false, key, OPERATE);
                return CommonResponse.error("单据作废失败，单据锁获取失败!");
            }

            Map<String, String> paramMap = new HashMap<>();
            paramMap.put("id", entity.getId().toString());
            paramMap.put("systemId", entity.getSystemId());
            logger.info("单据id-{}弃审，通知供方-{}单据作废!", entity.getSupplierId(), entity.getId());
            //推送单据到指定的供方
            CommonResponse<String> syncReqResp = systemDataPushService.exchangeDataWithEachLinkSystem(DEL_BILL_SERVER_URL,
                    RequestMethod.POST,
                    JSONObject.toJSONString(paramMap),
                    entity.getSupplierId().toString());

            if (syncReqResp.isSuccess()) {
                CommonResponse<String> supHandleResp = JSONObject.parseObject(syncReqResp.getData(), CommonResponse.class);
                if (supHandleResp.isSuccess()) {
                    return supHandleResp;
                } else {
                    logger.error("供方-{}处理作废单据id-{}作废失败, {}", entity.getSupplierId(), entity.getId(), supHandleResp.getMsg());
                    throw new BusinessException(supHandleResp.getMsg());
                }
            } else {
                logger.error("发送请求通知供方-{} 单据id-{}作废失败, {}", entity.getSupplierId(), entity.getId(), syncReqResp.getMsg());
                throw new BusinessException(syncReqResp.getMsg());
            }

        } catch (Exception e) {
            logger.error("通知供方单据id-{}作废异常，", entity.getId(), e);
            throw new BusinessException("推送供方异常!");
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }
    }
    /*供方签字确认*/
    @Override
    public String updateBillSupSignSyncInfo(HttpServletRequest request) {
        String authority = request.getHeader("authority");
        String msg = null;

        Jedis jedis = null;
        boolean locked = false;

        String billId = request.getParameter("billId");
        String supOperatorName = request.getParameter("supOperatorName");
        String supOperatorPhone = request.getParameter("supOperatorPhone");
        String supOperatorUserCode = request.getParameter("supOperatorUserCode");
        Date supOperateTime = new Date(Long.parseLong(request.getParameter("supOperateTime")));
        String nameSourceTypeMapping = request.getParameter("nameSourceTypeMapping");
        Map<String, String> mp = JSONObject.parseObject(nameSourceTypeMapping, Map.class);

        OutRentSettlementEntity settlementEntity = super.selectById(billId);
        //设置供方签字信息
        settlementEntity.setSupOperateTime(supOperateTime);
        settlementEntity.setSupOperatorName(supOperatorName);
        settlementEntity.setSupOperatorPhone(supOperatorPhone);
        settlementEntity.setSupOperatorUserCode(supOperatorUserCode);

        String key = BILL_TYPE + "::" + settlementEntity.getId().toString();

        try {
            jedis = jedisPool.getResource();
            //对单据进行加锁
            locked = RedisTool.tryLock(jedis, key, OPERATE, 600);

            if(!locked) {
                logger.error("单据id-{}签字信息回写加锁失败！", settlementEntity.getId());
                releaseLock(jedis, false, key, OPERATE);
                return "单据签字信息回写加锁失败";
            }

            //保存单据中附件并获取到上传后附件的Id
            Map<String, List<Long>> attachIdsMap = FileUtil.getInstance().handleReqFile((MultipartHttpServletRequest) request,
                    mp, BILL_TYPE, authority, settlementEntity.getId().toString());

            List<Long> attchIdsList = new ArrayList<>();
            for (List<Long> attachIds : attachIdsMap.values()) {
                if (CollectionUtils.isNotEmpty(attachIds)) {
                    attchIdsList.addAll(attachIds);
                }
            }
            //将附件关联在单据中
            settlementEntity.setAttachIds(attchIdsList);
            //将单据设置为乙方已签字状态 签字状态：0-未签字 1-已签字
            // 乙方已签字状态即待甲方签字
            settlementEntity.setSignStatus(1);
            //更新单据
            super.saveOrUpdate(settlementEntity, false);

//            //向单据制单人和经办人推送该消息
//            String msgSendResult = sendMsg(checkEntity, "供方已签字提醒", "结算单据[" + settleEntity.getBillCode() + "]供方已签字完成");
//            if (null != msgSendResult) {
//                logger.error("向用户-{}发送单据id-{}签字提醒失败，原因：{}", StringUtils.join(settleEntity.getCreateUserId(), settleEntity.getEmployeeId()),
//                        settleEntity.getId(), msgSendResult);
//            }

        } catch (Exception e) {
            logger.error("单据id-{}签字信息回写异常，", settlementEntity.getId(), e);
            msg = "单据签字信息回写失败！";
            throw e;
        } finally {
            releaseLock(jedis, locked, key, OPERATE);
        }

        return msg;
    }
    public void releaseLock(Jedis jedis, boolean locked, String key, String OPERATE) {
        try {
            if(locked) {
                RedisTool.releaseLock(jedis, key, OPERATE);
            }
        } finally {
            if(null != jedis) {
                jedis.close();
            }
        }
    }

    /*提交推送结算池*/
    @Override
    public boolean pushSettleToPool(OutRentSettlementVO vo) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        try {
            logger.info("结算单对象 -> 结算池对象自动转换开始-----"+JSONObject.toJSONString(vo));
            // 对象自动转换
            BeanConvertorUtil.convert(vo, spv);
            logger.info("结算单对象 -> 结算池对象自动转换结束，下面开始手动转换");

            // 个别字段需要手动封装
            convertSettleVOToSettlePoolVO(vo, spv);
            spv.setBillCodeUrl("/ejc-proequipmentcorp-frontend/#/rentSettleList/rentSettleCard?id=" + vo.getId());
            logger.info("推送参数----"+JSONObject.toJSONString(spv));
            CommonResponse<SettlePoolVO> res = settlePoolApi.saveOrUpdateSettle(spv);
            logger.info("结算单推送结算池结束---"+JSONObject.toJSONString(res));
            if(res.isSuccess()){
                flag = true;
                logger.info("结算单推送结算池成功---{}", res.getMsg());
            }else {
                logger.error("结算单推送结算池失败！结算单id-{}，{}",vo.getId(), res.getMsg());
                throw new BusinessException("结算单弃审推送结算池失败!");
            }
        } catch (Exception e) {
            logger.error("结算单推送结算池失败！结算单id-{}", vo.getId(), e);
            throw new BusinessException("结算单推送结算池异常!");
        }
        return flag;
    }

    /*弃审删除结算池*/
// 从结算池中删除数据
    @Override
    public boolean delSettleFromPool(Long id) {
        SettlePoolVO spv = new SettlePoolVO();
        boolean flag = false;
        spv.setSourceId(id);
        try {
            logger.info("结算单弃审推送结算池开始,结算单id-{}",id);
            CommonResponse<SettlePoolVO> res = settlePoolApi.deleteSettle(spv);
            logger.info("结算单推送结算池结束---"+JSONObject.toJSONString(res));
            if(res.isSuccess()){
                flag = true;
                logger.info("结算单弃审推送结算池成功---{}", res.getMsg());
            }else {
                logger.error("结算单推送结算池失败！结算单id-{}，{}",id, res.getMsg());
                throw new BusinessException("结算单弃审推送结算池失败!");
            }
        }catch (Exception e){
            logger.error("结算单弃审推送结算池失败！结算单id-{}", id, e);
            throw new BusinessException("结算单弃审推送结算池异常!");
        }
        return flag;
    }


    // 将SettlementVO转换成settlePoolVO
    private void convertSettleVOToSettlePoolVO(OutRentSettlementVO vo, SettlePoolVO spv) {
        if (null == vo || null == spv) {
            logger.error("将结算单推送至结算池失败！原因：结算单对象为空或结算池对象为空，结算单对象 -> 结算池对象无法转换！");
            return;
        }
        logger.info("结算单对象 -> 结算池对象手动转换开始");
        //单据类似  单据状态
        spv.setBillStateName(BillStateEnum.getEnumByStateCode(vo.getBillState()).getDescription());
        spv.setId(vo.getId());
        if(vo.getSettlementType()==1){
            spv.setSourceType(SettleSourceTypeEnum.设备公司设备租赁最终结算.getCode());
        }else{
            spv.setSourceType(SettleSourceTypeEnum.设备公司设备租赁过程结算.getCode());
        }

        spv.setSettlePropertyName("支出");
        spv.setSettleProperty(0);//属性类别，0支出，1收入
        spv.setSourceId(vo.getId());//结算单id
        spv.setCreateUserCode(vo.getCreateUserCode());//结算创建者账号
        spv.setCreateTime(vo.getCreateTime());//结算创建时间
        spv.setUpdateUserCode(vo.getUpdateUserCode());//结算修改者账号
        spv.setUpdateTime(vo.getUpdateTime());//结算修改时间
        spv.setContractFlag(0);// 是否有合同：1-是，0-否
        spv.setHandleType(0);
        if(vo.getContractId()!=null){//有合同需要推送的字段
            spv.setContractFlag(1);// 是否有合同：1-是，0-否
            //查询合同
            OutRentContractEntity contractEntity = rentContractService.selectById(vo.getContractId());
            spv.setContractType(ContractTypeEnum.设备租赁.getTypeCode());
            spv.setSupplementFlag(contractEntity.getSupplementFlag());//是否补充写协议
            spv.setMaiContractId(contractEntity.getMainContractId());//原合同id
            spv.setMaiContractName(contractEntity.getMainContractName());//原合同name
            spv.setMaiContractCode(contractEntity.getMainContractCode());//原合同code
//            spv.setContractCode(contractEntity.getContractCode());//合同编码
            spv.setPartyaId(contractEntity.getPartyId());//甲方id
            spv.setPartyaName(contractEntity.getPartyName());//甲方name
            spv.setSignDate(contractEntity.getSignedDate());//签订日期
            spv.setLastTaxMny(ComputeUtil.safeSub(vo.getCurrentSettlementTaxMny(),vo.getSettlementTaxMny()));//截止本期已结算金额（含税，不含本期）
            spv.setLastMny(ComputeUtil.safeSub(vo.getCurrentSettlementMny(),vo.getSettlementMny()));//截止本期已结算金额(无税，不含本期)
            spv.setLastTax(ComputeUtil.safeSub(spv.getLastTaxMny(),spv.getLastMny()));//截止本期税额（不含本期）
        }
        logger.info("结算单对象 -> 结算池对象手动转换完成，下面开始推送至结算池");
    }
    /**
     * 计算差值
     * @param a 变量a
     * @param b 变量b
     * @return 差值的绝对值，当其中一个变量为null时 或 计算出来的差值为null时 返回null
     */
    private BigDecimal getSubStractAbs(BigDecimal a, BigDecimal b) {
        if (a == null || b == null) {
            return null;
        }
        BigDecimal subtract = a.subtract(b);
        if (subtract == null) {
            return null;
        }
        return subtract.abs();
    }

    /**
     * 转换目标成本VO
     * @param entity
     * @return
     */
    @Override
    public ExecutionVO targetCost(OutRentSettlementEntity entity) {
        // 查询结算单
        LambdaQueryWrapper<OutRentSettlementEntity> wrapper = new LambdaQueryWrapper<>();
        wrapper.eq(OutRentSettlementEntity::getContractId, entity.getContractId());
        wrapper.in(OutRentSettlementEntity::getBillState, Arrays.asList(1,3));
        List<OutRentSettlementEntity> list = this.list(wrapper);
        // 计算所有结算累计结算金额
        BigDecimal totalSettleTaxMny = list.stream().filter(e -> e.getSettlementTaxMny() != null).map(OutRentSettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal totalSettleMny = list.stream().filter(e -> e.getSettlementMny() != null).map(OutRentSettlementEntity::getSettlementMny).reduce(BigDecimal.ZERO, BigDecimal::add);

        // 查询合同
        OutRentContractEntity contractEntity = rentContractService.getById(entity.getContractId());

        ExecutionVO executionVO = new ExecutionVO();
        TotalExecutionVO totalVO = new TotalExecutionVO();
        totalVO.setSourceId(entity.getId());
        totalVO.setTenantId(entity.getTenantId());
        totalVO.setBillCode(entity.getBillCode());
        totalVO.setBillType(BILL_TYPE);
        totalVO.setBillCategory(BillCategoryEnum.合同.getCode());
        totalVO.setBussinessType(BussinessTypeEnum.设备租赁合同.getCode());
        totalVO.setProjectId(entity.getProjectId());
        totalVO.setOrgId(entity.getOrgId());
        totalVO.setMoney(ComputeUtil.safeSub(totalSettleMny, contractEntity.getContractMny()));
        totalVO.setTaxMoney(ComputeUtil.safeSub(totalSettleTaxMny, contractEntity.getContractTaxMny()));
        totalVO.setLinkUrl(baseHost + "ejc-proequipment-frontend/#/rentSettleList/rentSettleCard?id=" + entity.getId());

        executionVO.setTotalVO(totalVO);

        return executionVO;

    }
    //关联保存
    @Override
    public CommonResponse<OutRentSettlementVO> pushCost(OutRentSettlementVO vo) {
        OutRentSettlementEntity entity = baseMapper.selectById(vo.getId());
        if (CollectionUtils.isNotEmpty(vo.getRentSettlementRentalList())) {
            List<OutRentSettlementRentalEntity> rentalEntities = BeanMapper.mapList(vo.getRentSettlementRentalList(), OutRentSettlementRentalEntity.class);
            entity.setRentSettlementRentalList(rentalEntities);
        }
        if (CollectionUtils.isNotEmpty(vo.getRentSettlementDayList())) {
            List<OutRentSettlementDayEntity> dayEntities = BeanMapper.mapList(vo.getRentSettlementDayList(), OutRentSettlementDayEntity.class);
            entity.setRentSettlementDayList(dayEntities);
        }
        if (CollectionUtils.isNotEmpty(vo.getRentSettlementMonthList())) {
            List<OutRentSettlementMonthEntity> monthEntities = BeanMapper.mapList(vo.getRentSettlementMonthList(), OutRentSettlementMonthEntity.class);
            entity.setRentSettlementMonthList(monthEntities);
        }
        if (CollectionUtils.isNotEmpty(vo.getRentSettlementQuantitiesList())) {
            List<OutRentSettlementQuantitiesEntity> quantitiesEntities = BeanMapper.mapList(vo.getRentSettlementQuantitiesList(), OutRentSettlementQuantitiesEntity.class);
            entity.setRentSettlementQuantitiesList(quantitiesEntities);
        }
        if (CollectionUtils.isNotEmpty(vo.getRentSettlementFeeList())) {
            List<OutRentSettlementFeeEntity> feeEntities = BeanMapper.mapList(vo.getRentSettlementFeeList(), OutRentSettlementFeeEntity.class);
            entity.setRentSettlementFeeList(feeEntities);
        }
        if (CollectionUtils.isNotEmpty(vo.getRentSettlementFragmentaryList())) {
            List<OutRentSettlementFragmentaryEntity> fragmentaryEntities = BeanMapper.mapList(vo.getRentSettlementFragmentaryList(), OutRentSettlementFragmentaryEntity.class);
            entity.setRentSettlementFragmentaryList(fragmentaryEntities);
        }
        super.saveOrUpdate(entity, false);
        //推送数据
        this.costPush(entity);
        return CommonResponse.success(BeanMapper.map(entity, OutRentSettlementVO.class));
    }
    @Override
    public void costPush(OutRentSettlementEntity entity) {
        logger.info("开始costPush");
        List<OutRentSettlementFragmentaryEntity> fragmentaryList = entity.getRentSettlementFragmentaryList();
        List<OutRentSettlementDayEntity> dayList = entity.getRentSettlementDayList();
        List<OutRentSettlementMonthEntity> monthList = entity.getRentSettlementMonthList();
        List<OutRentSettlementQuantitiesEntity> quantitiesList = entity.getRentSettlementQuantitiesList();
        List<OutRentSettlementFeeEntity> feeList = entity.getRentSettlementFeeList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(fragmentaryList)) {
            for (OutRentSettlementFragmentaryEntity detailEntity : fragmentaryList) {
                if (null == detailEntity.getSubjectIdFragmentary() || null == detailEntity.getWbsIdFragmentary()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(dayList)) {
            for (OutRentSettlementDayEntity detailEntity : dayList) {
                if (null == detailEntity.getSubjectId() || null == detailEntity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(monthList)) {
            for (OutRentSettlementMonthEntity detailEntity : monthList) {
                if (null == detailEntity.getSubjectId() || null == detailEntity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(quantitiesList)) {
            for (OutRentSettlementQuantitiesEntity detailEntity : quantitiesList) {
                if (null == detailEntity.getSubjectId() || null == detailEntity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(feeList)) {
            for (OutRentSettlementFeeEntity detailEntity : feeList) {
                if (null == detailEntity.getSubjectId() || null == detailEntity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }

        if (ListUtil.isEmpty(feeList) && ListUtil.isEmpty(dayList) && ListUtil.isEmpty(monthList) && ListUtil.isEmpty(quantitiesList) && ListUtil.isEmpty(fragmentaryList)) {
            newRelationFlag = "0";
        }

        //判断之前的单据是否关联
        String oldRelationFlag = entity.getRelationFlag();
        //之前已关联
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                saveCost(entity);
            }
            if (!"1".equals(newRelationFlag)) {
                //删除成本中心之前的数据
                logger.info("删除成本中心之前的数据-领料出库Id---{}",entity.getId());
                CommonResponse<String> commonResponse = costDetailApi.deleteSubject(entity.getId());
                logger.info("结果"+JSONObject.toJSONString(commonResponse));
                if(!commonResponse.isSuccess()){
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        //之前未关联
        if ("0".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                saveCost(entity);
            }
        }
        //更新是否关联
        entity.setRelationFlag(newRelationFlag);
        LambdaUpdateWrapper<OutRentSettlementEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(OutRentSettlementEntity::getId, entity.getId());
        updateWrapper.set(OutRentSettlementEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);
    }

    @Override
    public List<RentRentalEntity> queryRental(Long contractId, String settleDate) {
        return baseMapper.queryRental(contractId,settleDate);
    }
    /*
    * 合同金额控结算金额*/
    @Override
    public List<ParamsCheckVO> checkParamsMnyList(OutRentContractEntity rentContractEntity, OutRentSettlementVO vo) {
        // 三种控制方式：不控制，提醒，无法保存 (默认为提醒)
        String[] paramsArray = {"none", "warn", "alert"};
        List<ParamsCheckVO> paramsCheckVOList = new ArrayList<>();
        if (null!=rentContractEntity.getPurchaseType() && 2 == rentContractEntity.getPurchaseType()) {
            // 集采合同直接赋值为不控制
            return paramsCheckVOList;
        }
        String CHECK_PARAM_CODE = "";
        switch (vo.getSettlementType()){//结算类型，0-过程,1-最终
            case 0:CHECK_PARAM_CODE= CHECK_PARAM_CODE_GC;break;
            case 1:CHECK_PARAM_CODE= CHECK_PARAM_CODE_ZZ;break;
        }
        CommonResponse<List<BillParamVO>> billParamByCode = paramConfigApi.getBillParamByCodeAndOrgId(CHECK_PARAM_CODE,vo.getOrgId());
        if (billParamByCode.isSuccess() && null != billParamByCode.getData()) {
            List<BillParamVO> data = billParamByCode.getData();
            logger.info("结算金额控制信息返回："+JSONObject.toJSONString(data));
            if(CollectionUtils.isNotEmpty(data)){
                for (BillParamVO datum : data) {
                    ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
                    String orgName = datum.getOrgName();
                    List<ParamsCheckDsVO> checkDsVOS = new ArrayList<>();
                    BillParamVO billParamVO = datum;
                    BigDecimal totalSettleTaxMny = null==vo.getCurrentSettlementTaxMny()?BigDecimal.ZERO:vo.getCurrentSettlementTaxMny();
                    BigDecimal settleTaxMny = null==vo.getSettlementTaxMny()?BigDecimal.ZERO:vo.getSettlementTaxMny();
                    BigDecimal roleValue = billParamVO.getRoleValue();
                    BigDecimal comMny = ComputeUtil.safeDiv(ComputeUtil.safeMultiply(rentContractEntity.getContractTaxMny(), roleValue), new BigDecimal("100")).setScale(2, BigDecimal.ROUND_HALF_UP);
                    paramsCheckVO.setWarnType(paramsArray[billParamVO.getControlType()]);
                    if (totalSettleTaxMny.compareTo(comMny) > 0) {
                        ParamsCheckDsVO paramsCheckDsVO = new ParamsCheckDsVO();
                        paramsCheckDsVO.setOrgName(orgName);
                        paramsCheckDsVO.setWarnItem("合同超结");
                        paramsCheckDsVO.setWarnName("累计结算金额大于合同金额");
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("本次结算金额：").append(settleTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，含本次累计结算金额：").append(totalSettleTaxMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元，合同金额*").append(roleValue).append("%:").append(comMny.setScale(2, BigDecimal.ROUND_HALF_UP))
                                .append("元。超出金额：").append(ComputeUtil.safeSub(totalSettleTaxMny, comMny).setScale(2, BigDecimal.ROUND_HALF_UP)).append("元");
                        paramsCheckDsVO.setContent(stringBuffer.toString());
                        checkDsVOS.add(paramsCheckDsVO);
                    }
                    paramsCheckVO.setDataSource(checkDsVOS);
                    paramsCheckVOList.add(paramsCheckVO);
                }
            }
        } else {
            logger.info(billParamByCode.getMsg());
            throw new BusinessException("获取控制参数失败");
        }
        return paramsCheckVOList;
    }
/*
* 单据参数管控*/
    @Override
    public ParamsCheckVO checkParams(OutRentSettlementVO vo) {
        List<ParamsCheckVO> paramsCheckVOS = new ArrayList<>();
        ParamsCheckVO paramsCheckVO = new ParamsCheckVO();
        paramsCheckVO.setWarnType("none");
        /*参数控制区域*/
        //----start有合同预警域
        if(vo.getContractId()!=null) {
            OutRentContractEntity rentContractEntity = rentContractService.selectById(vo.getContractId());
            paramsCheckVOS.addAll(this.checkParamsMnyList(rentContractEntity,vo));//金额 --组织分别控制
        }
        //------end有合同预警域
        /*--end---参数控制区域*/
        Map<String, List<ParamsCheckDsVO>> map = new HashMap<>();
        String[] paramsArray = {"alert", "warn", "none"};
        if(CollectionUtils.isNotEmpty(paramsCheckVOS)){
            for (ParamsCheckVO checkVO : paramsCheckVOS) {
                String warnType = checkVO.getWarnType();
                if(map.containsKey(warnType)){
                    List<ParamsCheckDsVO> checkDsVOS = map.get(warnType);
                    checkDsVOS.addAll(checkVO.getDataSource());
                    map.put(warnType,checkDsVOS);
                }else {
                    map.put(warnType,checkVO.getDataSource());
                }
            }
        }
        for (String s : paramsArray) {
            if(map.containsKey(s)){
                paramsCheckVO.setWarnType(s);
                paramsCheckVO.setDataSource(map.get(s));
                if(CollectionUtils.isEmpty(paramsCheckVO.getDataSource())){
                    paramsCheckVO.setWarnType("none");
                }else {
                    return paramsCheckVO;
                }
            }
        }
        return paramsCheckVO;
    }

    private void saveCost(OutRentSettlementEntity entity) {
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<OutRentSettlementFragmentaryEntity> fragmentaryList = entity.getRentSettlementFragmentaryList();
        List<OutRentSettlementDayEntity> dayList = entity.getRentSettlementDayList();
        List<OutRentSettlementMonthEntity> monthList = entity.getRentSettlementMonthList();
        List<OutRentSettlementQuantitiesEntity> quantitiesList = entity.getRentSettlementQuantitiesList();
        List<OutRentSettlementFeeEntity> feeList = entity.getRentSettlementFeeList();

        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(fragmentaryList)) {
            for (OutRentSettlementFragmentaryEntity detailEntity : fragmentaryList) {
                CostDetailVO costDetailVO = BeanMapper.map(detailEntity, CostDetailVO.class);
                costDetailVO.setSourceDetailId(detailEntity.getId());
                costDetailVO.setHappenTaxMny(detailEntity.getFragmentaryTaxMny());
                costDetailVO.setHappenMny(detailEntity.getFragmentaryMny());
                costDetailVO.setSourceTabType("RE_EQ_JS_FRAGMENTARY");
                costDetailVO.setWbsId(detailEntity.getWbsIdFragmentary());
                costDetailVO.setWbsCode(detailEntity.getWbsCodeFragmentary());
                costDetailVO.setWbsName(detailEntity.getWbsNameFragmentary());
                costDetailVO.setSubjectId(detailEntity.getSubjectIdFragmentary());
                costDetailVO.setSubjectCode(detailEntity.getSubjectCodeFragmentary());
                costDetailVO.setSubjectName(detailEntity.getSubjectNameFragmentary());
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(dayList)) {
            for (OutRentSettlementDayEntity detailEntity : dayList) {
                CostDetailVO costDetailVO = BeanMapper.map(detailEntity, CostDetailVO.class);
                costDetailVO.setSourceDetailId(detailEntity.getId());
                costDetailVO.setHappenTaxMny(detailEntity.getDayTaxMny());
                costDetailVO.setHappenMny(detailEntity.getDayMny());
                costDetailVO.setSourceTabType("RE_EQ_JS_DAY");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(monthList)) {
            for (OutRentSettlementMonthEntity detailEntity : monthList) {
                CostDetailVO costDetailVO = BeanMapper.map(detailEntity, CostDetailVO.class);
                costDetailVO.setSourceDetailId(detailEntity.getId());
                costDetailVO.setHappenTaxMny(detailEntity.getMonthTaxMny());
                costDetailVO.setHappenMny(detailEntity.getMonthMny());
                costDetailVO.setSourceTabType("RE_EQ_JS_MONTH");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(quantitiesList)) {
            for (OutRentSettlementQuantitiesEntity detailEntity : quantitiesList) {
                CostDetailVO costDetailVO = BeanMapper.map(detailEntity, CostDetailVO.class);
                costDetailVO.setSourceDetailId(detailEntity.getId());
                costDetailVO.setHappenTaxMny(detailEntity.getQuantitiesTaxMny());
                costDetailVO.setHappenMny(detailEntity.getQuantitiesMny());
                costDetailVO.setSourceTabType("RE_EQ_JS_QUANTITIES");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(feeList)) {
            for (OutRentSettlementFeeEntity detailEntity : feeList) {
                CostDetailVO costDetailVO = BeanMapper.map(detailEntity, CostDetailVO.class);
                costDetailVO.setSourceDetailId(detailEntity.getId());
                costDetailVO.setHappenTaxMny(detailEntity.getFeeTaxMny());
                costDetailVO.setHappenMny(detailEntity.getFeeMny());
                costDetailVO.setSourceTabType("RE_EQ_JS_FEE");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(costDetailVOList)) {
            for (CostDetailVO costDetailVO : costDetailVOList) {
                costDetailVO.setSourceBillCode(entity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.设备租赁结算.getTypeName());
                costDetailVO.setSourceBillUrl("/ejc-proequipment-frontend/#/rentSettleList/rentSettleCard?id=" + entity.getId());
                costDetailVO.setSourceId(entity.getId());
                costDetailVO.setHappenDate(entity.getSettlementDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setId(null);
                costDetailVO.setSourceType("TEMP_EQ_JS");
                costDetailVO.setProjectId(entity.getProjectId());
            }
        }

        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            logger.info("推送数据--------"+JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------"+JSONObject.toJSONString(stringCommonResponse));
            if (stringCommonResponse.isSuccess()) {
            } else {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }
    
    @Override
    public CommonResponse<String> pushTargetCost(Long id) {
        OutRentSettlementEntity entity = selectById(id);
        // 最终结算推送目标成本
        if (entity.getSettlementType()!=null&&entity.getSettlementType()==1){
            logger.info("推送目标成本开始");
            CommonResponse<String> response = executionApi.aggPush(targetCost(entity));
            logger.info("推送目标成本入参：" + JSONObject.toJSONString(targetCost(entity)));
            if (!response.isSuccess()){
                logger.error("推送目标成本失败: , {}", response.getMsg());
                throw new BusinessException(response.getMsg());
            }
        }
        return CommonResponse.success("目标成本推送成功");
    }

    @Override
    public OutRentSettleRecordVO queryDetailRecord(Long contractId) {
        OutRentSettleRecordVO settleRecordVO = new OutRentSettleRecordVO();

        OutRentContractEntity contract = rentContractService.selectById(contractId);
        settleRecordVO.setContractId(contract.getId());
        settleRecordVO.setContractTaxMny(contract.getContractTaxMny());
        settleRecordVO.setPerformanceStatus(contract.getContractPerformanceState());

        QueryWrapper<OutRentSettlementEntity> listQuery = new QueryWrapper<>();
        listQuery.eq("contract_id", contractId);
        listQuery.in("bill_state", BillStateEnum.PASSED_STATE.getBillStateCode(), BillStateEnum.COMMITED_STATE.getBillStateCode());
        listQuery.orderByDesc("settlement_date");
        List<OutRentSettlementEntity> list = super.list(listQuery);
        List<OutRentSettlementVO>  rentSettlementVOS = BeanMapper.mapList(list, OutRentSettlementVO.class);
        settleRecordVO.setSettleList(rentSettlementVOS);

            //累计结算金额
        BigDecimal contractSettleMny = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(list)){
            contractSettleMny = list.stream().map(OutRentSettlementEntity::getSettlementTaxMny).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        settleRecordVO.setContractSettleMny(contractSettleMny);

        if (BigDecimal.ZERO.compareTo(settleRecordVO.getContractTaxMny()) == 0) {
            settleRecordVO.setSettleRate(BigDecimal.ZERO);
        } else {
            settleRecordVO.setSettleRate((settleRecordVO.getContractSettleMny().multiply(BigDecimal.valueOf(100))).divide(settleRecordVO.getContractTaxMny(), 8, RoundingMode.HALF_UP));
        }
        return settleRecordVO;
    }

    // 结算审批通过后/撤回后更新合同池累计结算金额（含税、无税、税额），type：是审批通过还是撤回标识，"true"审批通过后，"false"撤回后
    @Override
    public void updateContractPoolSettle(OutRentSettlementVO vo, Boolean type) {
        if(null!=vo.getContractId()) {//有合同推送
            logger.info("ID为【" + vo.getContractId() + "】的合同 " + vo.getBillCode() + "结算" + (type ? "撤回" : "审批通过") + "后更新合同池累计结算金额（含税、无税、税额），settleEntity={}, 过程（0）/最终（1）={}, type={}", vo, vo.getSettlementType(), type);
            //计算累计计算金额
            BigDecimal totalSettleTaxMny = BigDecimal.ZERO;         // 累计结算金额含税初始化
            BigDecimal totalSettleMny = BigDecimal.ZERO;            // 累计结算金额无税初始化
            BigDecimal totalSettleTax = BigDecimal.ZERO;            // 累计结算税额初始化
            if (type) {
                totalSettleTaxMny = vo.getCurrentSettlementTaxMny() == null ? BigDecimal.ZERO : vo.getCurrentSettlementTaxMny();
                totalSettleMny = vo.getCurrentSettlementMny() == null ? BigDecimal.ZERO : vo.getCurrentSettlementMny();
                totalSettleTax = ComputeUtil.safeSub(totalSettleTaxMny, totalSettleMny);
            } else {//撤回删除本次结算金额
                totalSettleTaxMny = ComputeUtil.safeSub(vo.getCurrentSettlementTaxMny(), vo.getSettlementTaxMny());
                totalSettleMny = ComputeUtil.safeSub(vo.getCurrentSettlementMny(), vo.getSettlementMny());
                totalSettleTax = ComputeUtil.safeSub(totalSettleTaxMny, totalSettleMny);
            }
            // 封装
            ContractPoolVO contractPoolVO = new ContractPoolVO();
            contractPoolVO.setSourceId(vo.getContractId());
            contractPoolVO.setTotalSettleTaxMny(totalSettleTaxMny);        // 含税
            contractPoolVO.setTotalSettleMny(totalSettleMny);                 // 无税
            contractPoolVO.setTotalSettleTax(totalSettleTax);     // 税额
            if (1 == vo.getSettlementType()) { // 结算类型，0-过程,1-最终
                if (type) {//通过
                    contractPoolVO.setFinishSettleDate(new Date());
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.已终止.getCode());//performanceStatus
                } else {
                    contractPoolVO.setFinishSettleDate(null);
                    contractPoolVO.setPerformanceStatus(PerformanceStatusEnum.履约中.getCode());//performanceStatus
                }
            }
            logger.info("ID为【" + vo.getContractId() + "】的合同 " + vo.getBillCode() + "结算" + ("back".equals(type) ? "撤回" : "审批通过") + "后更新合同池累计结算金额（含税、无税、税额），结束，更新合同池接口入参：{}", JSONObject.toJSONString(contractPoolVO));
            CommonResponse<ContractPoolVO> updateConPoolRes = contractPoolApi.saveOrUpdateContract(contractPoolVO);
            logger.info("ID为【" + vo.getContractId() + "】的合同 " + vo.getBillCode() + "结算" + ("back".equals(type) ? "撤回" : "审批通过") + "后更新合同池累计结算金额（含税、无税、税额），结束，更新合同池接口返回结果：{}", JSONObject.toJSONString(updateConPoolRes));
        }
    }



}
