package com.ejianc.business.proequipmentcorpout.rental.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import io.swagger.annotations.ApiModelProperty;


/**
 * 租金计算主表
 *
 * @author generator
 */
@TableName("ejc_outequipmentcorp_rent_rental")
public class OutRentRentalEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "bill_code")
    private String billCode; // 单据编号
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态（审批必须字段）
    @TableField(value = "project_id")
    private Long projectId; // 项目
    @TableField(value = "project_code")
    private String projectCode; // 项目编码
    @TableField(value = "project_name")
    private String projectName; // 项目名称
    @TableField(value = "org_id")
    private Long orgId; // 组织
    @TableField(value = "org_name")
    private String orgName; // 组织名称
    @TableField(value = "parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value = "parent_org_code")
    private String parentOrgCode; // 项目编码
    @TableField(value = "parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value = "contract_id")
    private Long contractId; // 合同主键
    @TableField(value = "contract_name")
    private String contractName; // 合同名称
    @TableField(value = "contract_code")
    private String contractCode; // 合同编号
    @TableField(value = "supplier_id")
    private Long supplierId; // 供应商
    @TableField(value = "supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value = "employee_id")
    private Long employeeId; // 经办人
    @TableField(value = "employee_name")
    private String employeeName; // 经办人名称
    @TableField(value = "rental_date")
    private Date rentalDate; // 租金计算日期
    @TableField(value = "department_id")
    private Long departmentId; // 经办部门
    @TableField(value = "department_name")
    private String departmentName; // 经办部门名称
    @TableField(value = "meter_rent_type")
    private String meterRentType; // 计租方式
    @TableField(value = "meter_rent_type_name")
    private String meterRentTypeName; // 计租方式名称
    @TableField(value = "memo")
    private String memo; // 备注
    @TableField(value = "rent_total_mny")
    private BigDecimal rentTotalMny; // 租赁金额(无税)
    @TableField(value = "rent_total_tax_mny")
    private BigDecimal rentTotalTaxMny; // 租赁金额
    @TableField(value = "rent_total_tax")
    private BigDecimal rentTotalTax; // 租赁税额
    @TableField(value = "settlement_state")
    private Integer settlementState; // 结算状态（0-已结算，1-未结算）

    @TableField(value="relation_flag")
    private String relationFlag; // 关联状态(1:是，0：否)
    @TableField(value="proportion_flag")
    private String proportionFlag; // 分摊状态(1:是，0：否)
    @TableField(value="rental_type")
    private String rentalType; // 租金计算类型（0：手动计算，1：自动计算）
    @TableField(value="org_code")
    private String orgCode; // 项目部编码

    @TableField(value="rent_project_id")
    private Long rentProjectId; // 租赁项目id
    @TableField(value="rent_project_code")
    private String rentProjectCode; // 租赁项目编号
    @TableField(value="rent_project_name")
    private String rentProjectName; // 租赁项目名称
    @TableField(value="rent_project_addr")
    private String rentProjectAddr; // 租赁项目地址
    @TableField(value="rent_org_id")
    private Long rentOrgId; // 租赁项目所属组织id
    @TableField(value="rent_org_code")
    private String rentOrgCode; // 租赁项目所属组织编码
    @TableField(value="rent_org_name")
    private String rentOrgName; // 租赁项目所属组织名称
    @TableField(value="rent_project_type")
    private Integer rentProjectType; // 项目类别，0-内部项目,1-外部项目

    @TableField(value="rent_harbor_type")
    private Integer rentHarborType;//租赁港式
    @TableField(value="out_org_id")
    private Long outOrgId; // 租出单位id
    @TableField(value="out_org_code")
    private String outOrgCode; // 租出单位code
    @TableField(value="out_org_name")
    private String outOrgName; // 租出单位name

    @TableField(value="first_party_id")
    private Long firstPartyId;
    @TableField(value="first_party_name")
    private String firstPartyName;

    @TableField(exist = false)
    @SubEntity(serviceName = "outRentRentalDayService", pidName = "rentalId")//此处有pid="xxx"，默认值pid="pid"
    private List<OutRentRentalDayEntity> rentRentalDayList = new ArrayList<>(); // 租金计算日租明细
    @TableField(exist = false)
    @SubEntity(serviceName = "outRentRentalMonthService", pidName = "rentalId")//此处有pid="xxx"，默认值pid="pid"
    private List<OutRentRentalMonthEntity> rentRentalMonthList = new ArrayList<>(); // 租金计算月租明细
    @TableField(exist = false)
    @SubEntity(serviceName = "outRentRentalQuantitiesService", pidName = "rentalId")//此处有pid="xxx"，默认值pid="pid"
    private List<OutRentRentalQuantitiesEntity> rentRentalQuantitiesList = new ArrayList<>(); // 租金计算工程量租明细

    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    public Long getRentProjectId() {
        return rentProjectId;
    }

    public void setRentProjectId(Long rentProjectId) {
        this.rentProjectId = rentProjectId;
    }

    public String getRentProjectCode() {
        return rentProjectCode;
    }

    public void setRentProjectCode(String rentProjectCode) {
        this.rentProjectCode = rentProjectCode;
    }

    public String getRentProjectName() {
        return rentProjectName;
    }

    public void setRentProjectName(String rentProjectName) {
        this.rentProjectName = rentProjectName;
    }

    public String getRentProjectAddr() {
        return rentProjectAddr;
    }

    public void setRentProjectAddr(String rentProjectAddr) {
        this.rentProjectAddr = rentProjectAddr;
    }

    public Long getRentOrgId() {
        return rentOrgId;
    }

    public void setRentOrgId(Long rentOrgId) {
        this.rentOrgId = rentOrgId;
    }

    public String getRentOrgCode() {
        return rentOrgCode;
    }

    public void setRentOrgCode(String rentOrgCode) {
        this.rentOrgCode = rentOrgCode;
    }

    public String getRentOrgName() {
        return rentOrgName;
    }

    public void setRentOrgName(String rentOrgName) {
        this.rentOrgName = rentOrgName;
    }

    public Integer getRentProjectType() {
        return rentProjectType;
    }

    public void setRentProjectType(Integer rentProjectType) {
        this.rentProjectType = rentProjectType;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getRentalType() {
        return rentalType;
    }

    public void setRentalType(String rentalType) {
        this.rentalType = rentalType;
    }

    public String getRelationFlag() {
        return relationFlag;
    }

    public void setRelationFlag(String relationFlag) {
        this.relationFlag = relationFlag;
    }

    public String getProportionFlag() {
        return proportionFlag;
    }

    public void setProportionFlag(String proportionFlag) {
        this.proportionFlag = proportionFlag;
    }

    public Integer getSettlementState() {
        return settlementState;
    }

    public void setSettlementState(Integer settlementState) {
        this.settlementState = settlementState;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }

    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    public String getContractCode() {
        return contractCode;
    }

    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }

    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getRentalDate() {
        return rentalDate;
    }

    public void setRentalDate(Date rentalDate) {
        this.rentalDate = rentalDate;
    }

    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public String getMeterRentType() {
        return meterRentType;
    }

    public void setMeterRentType(String meterRentType) {
        this.meterRentType = meterRentType;
    }

    public String getMeterRentTypeName() {
        return meterRentTypeName;
    }

    public void setMeterRentTypeName(String meterRentTypeName) {
        this.meterRentTypeName = meterRentTypeName;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public BigDecimal getRentTotalMny() {
        return rentTotalMny;
    }

    public void setRentTotalMny(BigDecimal rentTotalMny) {
        this.rentTotalMny = rentTotalMny;
    }

    public BigDecimal getRentTotalTaxMny() {
        return rentTotalTaxMny;
    }

    public void setRentTotalTaxMny(BigDecimal rentTotalTaxMny) {
        this.rentTotalTaxMny = rentTotalTaxMny;
    }

    public BigDecimal getRentTotalTax() {
        return rentTotalTax;
    }

    public void setRentTotalTax(BigDecimal rentTotalTax) {
        this.rentTotalTax = rentTotalTax;
    }

    public Integer getRentHarborType() {
        return rentHarborType;
    }

    public void setRentHarborType(Integer rentHarborType) {
        this.rentHarborType = rentHarborType;
    }

    public Long getOutOrgId() {
        return outOrgId;
    }

    public void setOutOrgId(Long outOrgId) {
        this.outOrgId = outOrgId;
    }

    public String getOutOrgCode() {
        return outOrgCode;
    }

    public void setOutOrgCode(String outOrgCode) {
        this.outOrgCode = outOrgCode;
    }

    public String getOutOrgName() {
        return outOrgName;
    }

    public void setOutOrgName(String outOrgName) {
        this.outOrgName = outOrgName;
    }

    public List<OutRentRentalDayEntity> getRentRentalDayList() {
        return rentRentalDayList;
    }

    public void setRentRentalDayList(List<OutRentRentalDayEntity> rentRentalDayList) {
        this.rentRentalDayList = rentRentalDayList;
    }

    public List<OutRentRentalMonthEntity> getRentRentalMonthList() {
        return rentRentalMonthList;
    }

    public void setRentRentalMonthList(List<OutRentRentalMonthEntity> rentRentalMonthList) {
        this.rentRentalMonthList = rentRentalMonthList;
    }

    public List<OutRentRentalQuantitiesEntity> getRentRentalQuantitiesList() {
        return rentRentalQuantitiesList;
    }

    public void setRentRentalQuantitiesList(List<OutRentRentalQuantitiesEntity> rentRentalQuantitiesList) {
        this.rentRentalQuantitiesList = rentRentalQuantitiesList;
    }
}
