package com.ejianc.business.proequipmentcorpout.rental.service.impl;


import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.ejianc.business.proequipmentcorpout.constants.OutRentConstants;
import com.ejianc.business.proequipmentcorpout.contract.bean.*;
import com.ejianc.business.proequipmentcorpout.contract.enums.RentalSettlementStateEnum;
import com.ejianc.business.proequipmentcorpout.contract.service.*;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentDayRecordVO;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentMonthRecordVO;
import com.ejianc.business.proequipmentcorpout.contract.vo.OutRentQuantitiesRecordVO;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterService;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterDetailVO;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterVO;
import com.ejianc.business.proequipmentcorpout.outrent.Enums.OutRentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorpout.rental.bean.OutRentRentalDayEntity;
import com.ejianc.business.proequipmentcorpout.rental.bean.OutRentRentalEntity;
import com.ejianc.business.proequipmentcorpout.rental.bean.OutRentRentalMonthEntity;
import com.ejianc.business.proequipmentcorpout.rental.bean.OutRentRentalQuantitiesEntity;
import com.ejianc.business.proequipmentcorpout.rental.mapper.OutRentRentalMapper;
import com.ejianc.business.proequipmentcorpout.rental.service.IOutRentRentalDayService;
import com.ejianc.business.proequipmentcorpout.rental.service.IOutRentRentalMonthService;
import com.ejianc.business.proequipmentcorpout.rental.service.IOutRentRentalQuantitiesService;
import com.ejianc.business.proequipmentcorpout.rental.service.IOutRentRentalService;
import com.ejianc.business.proequipmentcorpout.rental.vo.OutRentRentalCacheVO;
import com.ejianc.business.proequipmentcorpout.rental.vo.OutRentRentalVO;
import com.ejianc.business.proequipmentcorpout.rental.vo.OutRentalSumVo;
import com.ejianc.business.procost.api.ICostDetailApi;
import com.ejianc.business.procost.enums.SourceTypeEnum;
import com.ejianc.business.procost.vo.CostDetailVO;
import com.ejianc.business.proequipmentcorprent.userecord.bean.UseRecordEntity;
import com.ejianc.business.proequipmentcorprent.userecord.bean.UseRecordSubEntity;
import com.ejianc.business.proequipmentcorprent.userecord.service.IUseRecordService;
import com.ejianc.business.proequipmentcorprent.userecord.service.IUseRecordSubService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 租金计算主表
 *
 * @author generator
 */
@Service("outRentRentalService")
public class OutRentRentalServiceImpl extends BaseServiceImpl<OutRentRentalMapper, OutRentRentalEntity> implements IOutRentRentalService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String RENT_TYPE_DAY = "day";
    private static final String RENT_TYPE_MONTH = "month";
    private static final String RENT_TYPE_QUANTITIES = "engineering";

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private ICostDetailApi costDetailApi;
    @Autowired
    private SessionManager sessionManager;
    @Value("${common.env.base-host}")
    private String baseHost;

    /** 设备台账 */
    @Autowired
    private IOutRentParameterService parameterService;
    /** 设备租赁合同 */
    @Autowired
    private IOutRentContractService contractService;
    /** 设备租赁合同记录 */
    @Autowired
    private IOutRentContractRecordService contractRecordService;
    /** 设备合同记录日租明细 */
    @Autowired
    private IOutRentDayRecordService dayRecordService;
    /** 设备合同记录月租明细 */
    @Autowired
    private IOutRentMonthRecordService monthRecordService;
    /** 设备合同记录工程量租明细 */
    @Autowired
    private IOutRentQuantitiesRecordService quantitiesRecordService;
    /** 设备使用记录 */
    @Autowired
    private IUseRecordService useRecordService;
    /** 设备使用记录明细 */
    @Autowired
    private IUseRecordSubService useRecordSubService;

    @Autowired
    private IOutRentRentalDayService outRentRentalDayService;
    @Autowired
    private IOutRentRentalMonthService outRentRentalMonthService;
    @Autowired
    private IOutRentRentalQuantitiesService outRentRentalQuantitiesService;


    /**
     * 保存租金计算单据
     *
     * @param vo 租金机选
     * @return 保存结果
     */
    @Override
    public OutRentRentalVO saveRental(OutRentRentalVO vo) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, vo.getContractId()));
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays
                .asList(BillStateEnum.UNCOMMITED_STATE.getBillStateCode(),
                        BillStateEnum.APPROVING_HAS_STATE.getBillStateCode(),
                        BillStateEnum.UNAPPROVED.getBillStateCode(),
                        BillStateEnum.APPROVING_UNEXAM_STATE.getBillStateCode())));
        if (null != vo.getId()) {
            queryParam.getParams().put("id", new Parameter(QueryParam.NE, vo.getId()));
        }
        List<OutRentRentalEntity> checkList = super.queryList(queryParam, false);
        if (CollectionUtils.isNotEmpty(checkList)) {
            throw new BusinessException("存在未生效的租金计算单，无法新增！");
        }
        if (StringUtils.isEmpty(vo.getParentOrgCode()) && vo.getParentOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(vo.getParentOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                vo.setParentOrgCode(orgVO.getCode());
            }
        }
        OutRentRentalEntity entity = BeanMapper.map(vo, OutRentRentalEntity.class);
        if (entity.getId() == null || entity.getId() == 0) {
            BillCodeParam billCodeParam = BillCodeParam.build(OutRentConstants.BILL_CODE_OUT_RENTAL, InvocationInfoProxy.getTenantid(), vo);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }
            else {
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        entity.setSettlementState(RentalSettlementStateEnum.未结算.getCode());
//        entity.setRentalType("0");
        super.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, OutRentRentalVO.class);
    }

    /**
     * 修改租金计算结算标志
     *
     * @param ids   租金计算单据id
     * @param state 标志
     * @return 修改结果
     */
    @Override
    public boolean updateRentalSettlementState(List<Long> ids, Integer state) {
        logger.info("修改租金计算单据状态，单据id：{}，修改状态：{}", JSONObject.toJSONString(ids), state);
        if (CollectionUtils.isNotEmpty(ids)) {
            if (null == RentalSettlementStateEnum.getEnumByCode(state)) {
                throw new BusinessException("结算标志不正确，请检查结算标志");
            }
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("id", new Parameter(QueryParam.IN, ids));
            List<OutRentRentalEntity> saveEntityList = super.queryList(queryParam, false);
            if (CollectionUtils.isEmpty(saveEntityList)) {
                return false;
            }
            for (OutRentRentalEntity entity : saveEntityList) {
                entity.setSettlementState(state);
            }
            return super.saveOrUpdateBatch(saveEntityList);
        }
        return false;
    }

    /**
     * 实际成本关联保存
     *
     * @param outRentRentalVO 租金计算VO
     * @return 保存结果
     */
    @Override
    public CommonResponse<OutRentRentalVO> pushCost(OutRentRentalVO outRentRentalVO) {
        OutRentRentalEntity entity = super.selectById(outRentRentalVO.getId());
        if (CollectionUtils.isNotEmpty(outRentRentalVO.getRentRentalDayList())) {
            List<OutRentRentalDayEntity> dayEntities = BeanMapper
                    .mapList(outRentRentalVO.getRentRentalDayList(), OutRentRentalDayEntity.class);
            entity.setRentRentalDayList(dayEntities);
        }
        if (CollectionUtils.isNotEmpty(outRentRentalVO.getRentRentalMonthList())) {
            List<OutRentRentalMonthEntity> monthEntities = BeanMapper
                    .mapList(outRentRentalVO.getRentRentalMonthList(), OutRentRentalMonthEntity.class);
            entity.setRentRentalMonthList(monthEntities);
        }
        if (CollectionUtils.isNotEmpty(outRentRentalVO.getRentRentalQuantitiesList())) {
            List<OutRentRentalQuantitiesEntity> quantitiesEntities = BeanMapper
                    .mapList(outRentRentalVO.getRentRentalQuantitiesList(), OutRentRentalQuantitiesEntity.class);
            entity.setRentRentalQuantitiesList(quantitiesEntities);
        }
        super.saveOrUpdate(entity, false);
        //推送数据
        this.costPush(entity);
        return CommonResponse.success(BeanMapper.map(entity, OutRentRentalVO.class));
    }

    /**
     * 租金计算推送实际成本
     *
     * @param entity 租金计算实体
     */
    @Override
    public void costPush(OutRentRentalEntity entity) {
        logger.info("租金计算开始推送实际成本costPush");
        List<OutRentRentalDayEntity> dayList = entity.getRentRentalDayList();
        List<OutRentRentalMonthEntity> monthList = entity.getRentRentalMonthList();
        List<OutRentRentalQuantitiesEntity> quantitiesList = entity.getRentRentalQuantitiesList();
        String newRelationFlag = "1";
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(dayList)) {
            for (OutRentRentalDayEntity detailEntity : dayList) {
                if (null == detailEntity.getSubjectId() || null == detailEntity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(monthList)) {
            for (OutRentRentalMonthEntity detailEntity : monthList) {
                if (null == detailEntity.getSubjectId() || null == detailEntity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(quantitiesList)) {
            for (OutRentRentalQuantitiesEntity detailEntity : quantitiesList) {
                if (null == detailEntity.getSubjectId() || null == detailEntity.getWbsId()) {
                    newRelationFlag = "0";
                    break;
                }
            }
        }
        if (ListUtil.isEmpty(dayList) && ListUtil.isEmpty(monthList) && ListUtil.isEmpty(quantitiesList)) {
            newRelationFlag = "0";
        }
        //判断之前的单据是否关联
        String oldRelationFlag = entity.getRelationFlag();
        //之前已关联
        if ("1".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                saveCost(entity);
            }
            if (!"1".equals(newRelationFlag)) {
                //删除成本中心之前的数据
                logger.info("删除成本中心之前的数据-租金计算Id---{}", entity.getId());
                CommonResponse<String> commonResponse = costDetailApi.deleteSubject(entity.getId());
                logger.info("结果" + JSONObject.toJSONString(commonResponse));
                if (!commonResponse.isSuccess()) {
                    throw new BusinessException(commonResponse.getMsg());
                }
            }
        }
        //之前未关联
        if ("0".equals(oldRelationFlag)) {
            if ("1".equals(newRelationFlag)) {
                saveCost(entity);
            }
        }
        //更新是否关联
        entity.setRelationFlag(newRelationFlag);
        LambdaUpdateWrapper<OutRentRentalEntity> updateWrapper = new LambdaUpdateWrapper<>();
        updateWrapper.in(OutRentRentalEntity::getId, entity.getId());
        updateWrapper.set(OutRentRentalEntity::getRelationFlag, newRelationFlag);//(1:是，0：否)
        super.update(updateWrapper);
    }

    /**
     * 推送实际成本
     *
     * @param entity 推送实体
     */
    private void saveCost(OutRentRentalEntity entity) {
        //明细
        List<CostDetailVO> costDetailVOList = new ArrayList<>();
        List<OutRentRentalDayEntity> dayList = entity.getRentRentalDayList();
        List<OutRentRentalMonthEntity> monthList = entity.getRentRentalMonthList();
        List<OutRentRentalQuantitiesEntity> quantitiesList = entity.getRentRentalQuantitiesList();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(dayList)) {
            for (OutRentRentalDayEntity detailEntity : dayList) {
                CostDetailVO costDetailVO = BeanMapper.map(detailEntity, CostDetailVO.class);
                costDetailVO.setSourceDetailId(detailEntity.getId());
                costDetailVO.setHappenTaxMny(detailEntity.getRentDayTaxMny());
                costDetailVO.setHappenMny(detailEntity.getRentDayMny());
                costDetailVO.setSourceTabType("RE_EQ_ZJ_DAY");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(monthList)) {
            for (OutRentRentalMonthEntity detailEntity : monthList) {
                CostDetailVO costDetailVO = BeanMapper.map(detailEntity, CostDetailVO.class);
                costDetailVO.setSourceDetailId(detailEntity.getId());
                costDetailVO.setHappenTaxMny(detailEntity.getRentMonthTaxMny());
                costDetailVO.setHappenMny(detailEntity.getRentMonthMny());
                costDetailVO.setSourceTabType("RE_EQ_ZJ_MONTH");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(quantitiesList)) {
            for (OutRentRentalQuantitiesEntity detailEntity : quantitiesList) {
                CostDetailVO costDetailVO = BeanMapper.map(detailEntity, CostDetailVO.class);
                costDetailVO.setSourceDetailId(detailEntity.getId());
                costDetailVO.setHappenTaxMny(detailEntity.getRentQuantitiesTaxMny());
                costDetailVO.setHappenMny(detailEntity.getRentQuantitiesMny());
                costDetailVO.setSourceTabType("RE_EQ_ZJ_QUANTITIES");
                costDetailVO.setProjectId(entity.getProjectId());
                costDetailVOList.add(costDetailVO);
            }
        }
        if (CollectionUtils.isNotEmpty(costDetailVOList)) {
            String url = "/ejc-proequipmentcorp-frontend/#/rentalList/card?id=" + entity.getId();
            if ("1".equals(entity.getRentalType())) {
                url = "/ejc-proequipmentcorp-frontend/#/rentalList/automaticCard?id=" + entity.getId();
            }
            for (CostDetailVO costDetailVO : costDetailVOList) {
                costDetailVO.setSourceBillCode(entity.getBillCode());
                costDetailVO.setSourceBillName(SourceTypeEnum.设备租金计算.getTypeName());
                costDetailVO.setSourceBillUrl(url);
                costDetailVO.setSourceId(entity.getId());
                costDetailVO.setHappenDate(entity.getRentalDate());
                costDetailVO.setCreateUserName(sessionManager.getUserContext().getUserName());
                costDetailVO.setId(null);
                costDetailVO.setSourceType("TEMP_EQ_ZJ");
                costDetailVO.setProjectId(entity.getProjectId());
            }
        }
        //成本中心
        if (ListUtil.isNotEmpty(costDetailVOList)) {
            logger.info("推送数据--------" + JSONObject.toJSONString(costDetailVOList));
            CommonResponse<String> stringCommonResponse = costDetailApi.saveSubject(costDetailVOList);
            logger.info("推送结果--------" + JSONObject.toJSONString(stringCommonResponse));
            if (!stringCommonResponse.isSuccess()) {
                throw new BusinessException(stringCommonResponse.getMsg());
            }
        }
    }

    /**
     * 批量删除单据
     *
     * @param vos 需要删除的单据信息
     */
    @Override
    public void delRental(List<OutRentRentalVO> vos) {
        if (CollectionUtils.isEmpty(vos)) return;
        super.removeByIds(vos.stream().map(OutRentRentalVO::getId).collect(Collectors.toList()), true);
    }

    /**
     * 根据合同id查询审批通过的租金计算金额
     *
     * @param contractId 合同id
     * @return 租金计算金额
     */
    @Override
    public OutRentalSumVo queryRentalMnyByContractId(Long contractId) {
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        // UNCOMMITED_STATE(0, "自由态"),
        //    COMMITED_STATE(1, "已提交"),
        //    APPROVING_HAS_STATE(2, "审核中（有人审核）"),
        //    PASSED_STATE(3, "已通过"),
        //    UNAPPROVED(4, "审批驳回"),
        //    APPROVING_UNEXAM_STATE(5, "审核中(有审批流的提交态)");
        queryParam.getParams().put("billState", new Parameter(QueryParam.IN, Arrays
                .asList(BillStateEnum.COMMITED_STATE.getBillStateCode(),
                        BillStateEnum.PASSED_STATE.getBillStateCode())));
        List<OutRentRentalEntity> list = super.queryList(queryParam, false);
        BigDecimal sumRentalTaxMny = BigDecimal.ZERO;
        BigDecimal sumRentalMny = BigDecimal.ZERO;
        OutRentalSumVo vo = new OutRentalSumVo();
        if (CollectionUtils.isEmpty(list)) return vo;
        for (OutRentRentalEntity entity : list) {
            sumRentalTaxMny = sumRentalTaxMny.add(entity.getRentTotalTaxMny());
            sumRentalMny = sumRentalMny.add(entity.getRentTotalMny());
        }
        vo.setTotalMny(sumRentalMny);
        vo.setTotalTaxMny(sumRentalTaxMny);
        return vo;
    }


    /**
     * 租金自动计算
     *
     * @param vo 需要合同id，租金计算日期
     * @return 计算后结果
     */
    @Override
    public OutRentRentalVO automaticRental(OutRentRentalVO vo) {
        if (vo == null || vo.getContractId() == null) {
            throw new BusinessException("合同信息不能为空");
        }
        if (vo.getRentalDate() == null) {
            throw new BusinessException("租金计算日期不能为空");
        }
        Long contractId = vo.getContractId(); // 合同id
        Date endDate = vo.getRentalDate(); // 本次租金计算日期
        logger.info("开始租金自动计算，合同id：{}，租金计算日期：{}。>>>>>>>>>>>>>>>>>>>>>>>>>>", contractId, endDate);
        /*
         * 1. 查询当前合同下设备台账信息
         */
        logger.info(">>>>查询已入场设备台账信息start");
        List<OutRentParameterVO> rentParameterList = parameterService.getRentParameterByContractId(contractId, vo.getId(), endDate);
        if (CollectionUtils.isEmpty(rentParameterList)) throw new BusinessException("未查询到当前合同下设备验收信息");
        logger.info("<<<<查询已入场设备台账信息end，查询结果：{}", JSONObject.toJSONString(rentParameterList));
        // 日期校验
//        List<Long> parameterIdList = rentParameterList.stream().map(OutRentParameterVO::getId).collect(Collectors
//        .toList());
//        parameterService.checkValidation(parameterIdList, RentParameterTypeEnum.租金计算.getCode(),
//                null, contractId, endDate);
        /*
         * 2. 查询合同变更及当前合同信息
         */
        // 查询主合同信息
        logger.info(">>>>查询合同信息start");
        OutRentContractEntity contractEntity = contractService.selectById(contractId);
        logger.info("主合同信息：{}", JSONObject.toJSONString(contractEntity));
        Map<String, Map<Long, List<OutRentRentalCacheVO>>> contractAllMap = this.getContractRecord(contractId,
                contractEntity, endDate);
        logger.info("<<<<查询合同信息end，查询结果：{}", JSONObject.toJSONString(contractAllMap));
        // 3. 根据租赁方式及变更日期，对操作日期再次进行排序
        logger.info(">>>>对查询数据进行操作");
        OutRentRentalEntity entity = new OutRentRentalEntity();
        List<OutRentRentalDayEntity> outRentRentalDayList = new ArrayList<>();
        List<OutRentRentalMonthEntity> outRentRentalMonthList = new ArrayList<>();
        List<OutRentRentalQuantitiesEntity> outRentRentalQuantitiesList = new ArrayList<>();
        List<OutRentRentalCacheVO> resultDayList = new ArrayList<>();
        List<OutRentRentalCacheVO> resultMonthList = new ArrayList<>();
        List<OutRentRentalCacheVO> resultQuantitiesList = new ArrayList<>();
        for (OutRentParameterVO parameterVO : rentParameterList) {
            // 日租
            if (RENT_TYPE_DAY.equals(parameterVO.getMeterRentType())) {
                // 循环比对日期
                this.packParameterDetailAndContract(resultDayList, contractAllMap, parameterVO, RENT_TYPE_DAY,
                        contractEntity.getMonthSettlement());
            }
            // 月租
            else if (RENT_TYPE_MONTH.equals(parameterVO.getMeterRentType())) {
                // 循环比对日期
                this.packParameterDetailAndContract(resultMonthList, contractAllMap, parameterVO, RENT_TYPE_MONTH,
                        contractEntity.getMonthSettlement());
            }
//            // 工程量租
//            else if (RENT_TYPE_QUANTITIES.equals(parameterVO.getRentTypeId())) {
//                // 循环比对日期
//                this.packParameterDetailAndContract(resultQuantitiesList, contractAllMap, parameterVO,
//                RENT_TYPE_QUANTITIES,
//                        contractEntity.getMonthSettlement());
//            }
        }
        this.setRentalDayDetailValue(resultDayList, outRentRentalDayList);
        this.setRentalMonthDetailValue(resultMonthList, outRentRentalMonthList);
        // 工程量查社保使用记录
//        this.setRentalQuantitiesDetailValue(resultQuantitiesList, outRentRentalQuantitiesList);
        this.setQuantitiesByUseRecord(outRentRentalQuantitiesList, contractEntity, endDate);

        // 4. 处理租金计算单
        if (null != vo.getId()) {
            entity = super.selectById(vo.getId());
            // 处理修改时页面上删除的列表
            if (CollectionUtils.isNotEmpty(vo.getRentRentalDayList())) {
                outRentRentalDayList.addAll(BeanMapper.mapList(vo.getRentRentalDayList(), OutRentRentalDayEntity.class));
            }
            if (CollectionUtils.isNotEmpty(vo.getRentRentalMonthList())) {
                outRentRentalMonthList
                        .addAll(BeanMapper.mapList(vo.getRentRentalMonthList(), OutRentRentalMonthEntity.class));
            }
            if (CollectionUtils.isNotEmpty(vo.getRentRentalQuantitiesList())) {
                outRentRentalQuantitiesList
                        .addAll(BeanMapper.mapList(vo.getRentRentalQuantitiesList(), OutRentRentalQuantitiesEntity.class));
            }
        }
        else {
            // 状态需要初始化
            entity.setRentalType("1");
            entity.setRelationFlag("0");
            entity.setProportionFlag("0");
            entity.setSettlementState(RentalSettlementStateEnum.未结算.getCode());
            entity.setEmployeeId(sessionManager.getUserContext().getEmployeeId());
            entity.setEmployeeName(sessionManager.getUserContext().getEmployeeName());
        }
        entity.setRentRentalDayList(outRentRentalDayList);
        entity.setRentRentalMonthList(outRentRentalMonthList);
        entity.setRentRentalQuantitiesList(outRentRentalQuantitiesList);
        this.setRentalValue(entity, contractEntity, endDate, vo);
        logger.info(">>>>保存租金计算：{}", JSONObject.toJSONString(entity));

        logger.info("租金自动计算结束，合同id：{}，租金计算日期：{}。>>>>>>>>>>>>>>>>>>>>>>>>>>", contractId, endDate);
        return BeanMapper.map(entity, OutRentRentalVO.class);
    }

    /**
     * 日租明细赋值
     *
     * @param resultList        日租组装数据
     * @param outRentRentalDayList 日租明细结果
     */
    private void setRentalDayDetailValue(List<OutRentRentalCacheVO> resultList,
                                         List<OutRentRentalDayEntity> outRentRentalDayList) {
        if (CollectionUtils.isEmpty(resultList)) return;
        for (OutRentRentalCacheVO vo : resultList) {
            OutRentDayRecordVO recordVO = vo.getRentDayRecord();
            OutRentRentalDayEntity dayEntity = new OutRentRentalDayEntity();
            dayEntity.setSourceDetailId(recordVO.getId());
            dayEntity.setSourceName("设备租赁日租-" + recordVO.getEquipmentCode());
            dayEntity.setSourceType(2);
            dayEntity.setSourceCode(recordVO.getCode());
            dayEntity.setEquipmentName(recordVO.getName());
            dayEntity.setDayFactoryCode(recordVO.getDayFactoryCode());
            dayEntity.setCategoryId(recordVO.getCategoryId());
            dayEntity.setCategoryName(recordVO.getCategoryName());
            dayEntity.setSpec(recordVO.getSpec());
            dayEntity.setUnitName(recordVO.getUnitName());
            dayEntity.setDayRentPrice(recordVO.getDayRentPrice());
            dayEntity.setStopRentPrice(recordVO.getStopRentPrice());
            dayEntity.setRentNum(1); // 修改数量需要重新计算下面的金额
            dayEntity.setTax(recordVO.getTax());
            dayEntity.setDayRentNotTaxPrice(recordVO.getDayRentNotTaxPrice());
            dayEntity.setStopRentNotTaxPrice(recordVO.getStopRentNotTaxPrice());
            dayEntity.setPlanIntoDate(recordVO.getPlanIntoDate());
            dayEntity.setPlanOutDate(recordVO.getPlanOutDate());
            dayEntity.setProductionManufactor(recordVO.getProductionManufactor());
//            dayEntity.setMemo();
//            dayEntity.setRentalId();
            dayEntity.setEquipmentCode(recordVO.getEquipmentCode());
            dayEntity.setEquipmentId(recordVO.getEquipmentId());
//            dayEntity.setTaxMny(); // 含税金额
//            dayEntity.setSourceId(recordVO.getPid());
            dayEntity.setSourceId(vo.getParameterId()); // 来源id取设备台账id
            dayEntity.setChargingStartDate(vo.getStartDate());
            dayEntity.setChargingEndDate(vo.getEndDate());
            // 租赁天数
            dayEntity.setRentDayDate(this.daysBetween(this.calculationDay(vo.getStartDate(), -1), vo.getEndDate()));
            if (OutRentEquipmentStateEnum.启用.getCode().equals(vo.getEquipmentState())) {
                dayEntity.setRentDayMny(this.getMny(dayEntity.getDayRentNotTaxPrice(),
                        dayEntity.getRentDayDate(), dayEntity.getRentNum())); // 租赁金额(无税)
                dayEntity.setRentDayTaxMny(this.getMny(dayEntity.getDayRentPrice(),
                        dayEntity.getRentDayDate(), dayEntity.getRentNum())); // // 租赁金额

            }
            else if (OutRentEquipmentStateEnum.停用.getCode().equals(vo.getEquipmentState())) {
                dayEntity.setRentDayMny(this.getMny(dayEntity.getStopRentNotTaxPrice(),
                        dayEntity.getRentDayDate(), dayEntity.getRentNum())); // 租赁金额(无税)
                dayEntity.setRentDayTaxMny(this.getMny(dayEntity.getStopRentPrice(),
                        dayEntity.getRentDayDate(), dayEntity.getRentNum())); // // 租赁金额
            }
            dayEntity.setRentDayTax(dayEntity.getRentDayTaxMny().subtract(dayEntity.getRentDayMny())); // 租赁税额
//            dayEntity.setId();
            dayEntity.setEquipmentState(vo.getEquipmentState());
            dayEntity.setRowState("add");
            dayEntity.setId(IdWorker.getId());
            outRentRentalDayList.add(dayEntity);
        }
        // 按照设备、开始时间排序
        if (CollectionUtils.isNotEmpty(outRentRentalDayList)) {
            outRentRentalDayList.sort(Comparator.comparing(OutRentRentalDayEntity::getSourceId)
                    .thenComparing(OutRentRentalDayEntity::getChargingStartDate));
        }
    }

    /**
     * 月租明细赋值
     *
     * @param resultList          月租组装数据
     * @param outRentRentalMonthList 月租明细结果
     */
    private void setRentalMonthDetailValue(List<OutRentRentalCacheVO> resultList,
                                           List<OutRentRentalMonthEntity> outRentRentalMonthList) {
        if (CollectionUtils.isEmpty(resultList)) return;
        List<OutRentRentalMonthEntity> rstList = new ArrayList<>();
        for (OutRentRentalCacheVO vo : resultList) {
            OutRentMonthRecordVO recordVO = vo.getRentMonthRecord();
            OutRentRentalMonthEntity monthEntity = new OutRentRentalMonthEntity();
            monthEntity.setSourceDetailId(recordVO.getId());
            monthEntity.setSourceName("设备租赁月租-" + recordVO.getEquipmentCode());
            monthEntity.setSourceType(2);
            monthEntity.setSourceCode(recordVO.getCode());
            monthEntity.setEquipmentName(recordVO.getName());
            monthEntity.setMonthFactoryCode(recordVO.getMonthFactoryCode());
            monthEntity.setCategoryId(recordVO.getCategoryId());
            monthEntity.setCategoryName(recordVO.getCategoryName());
            monthEntity.setSpec(recordVO.getSpec());
            monthEntity.setUnitName(recordVO.getUnitName());
            monthEntity.setMonthRentPrice(recordVO.getMonthRentPrice());
            monthEntity.setInsufficientMonthDayRentPrice(recordVO.getInsufficientMonthDayRentPrice());
            monthEntity.setStopRentPrice(recordVO.getStopRentPrice());
            monthEntity.setRentNum(1);
            monthEntity.setTax(recordVO.getTax());
            monthEntity.setMonthRentNotTaxPrice(recordVO.getMonthRentNotTaxPrice());
            monthEntity.setInsufficientMonthNotTaxRentPrice(recordVO.getInsufficientMonthNotTaxRentPrice());
            monthEntity.setPlanIntoDate(recordVO.getPlanIntoDate());
            monthEntity.setPlanOutDate(recordVO.getPlanOutDate());
            monthEntity.setProductionManufactor(recordVO.getProductionManufactor());
//            monthEntity.setMemo();
//            monthEntity.setRentalId();
            monthEntity.setEquipmentCode(recordVO.getEquipmentCode());
            monthEntity.setEquipmentId(recordVO.getEquipmentId());
            monthEntity.setDayTaxPrice(recordVO.getDayTaxPrice());
            monthEntity.setTaxMny(recordVO.getTaxMny());
            monthEntity.setNotTaxMonthPrice(recordVO.getNotTaxMonthPrice());
            monthEntity.setDayRentNotTaxPrice(recordVO.getDayRentNotTaxPrice());
            monthEntity.setNotTaxStopPrice(recordVO.getNotTaxStopPrice());
            monthEntity.setSourceId(vo.getParameterId());
            monthEntity.setChargingStartDate(vo.getStartDate());
            monthEntity.setChargingEndDate(vo.getEndDate());

            // 1. 判断是不是满月，满月取月租单价
            // 2. 剩下日期取不足月单价
            // 3. 停租没有满月概念
            if (OutRentEquipmentStateEnum.停用.getCode().equals(vo.getEquipmentState())) {
                Integer days = this.daysBetween(vo.getStartDate(), vo.getEndDate());
                monthEntity.setRentMonthMny(this.getMny(monthEntity.getNotTaxStopPrice(), days,
                        monthEntity.getRentNum())); // 租赁金额(无税)
                monthEntity.setRentMonthTaxMny(this.getMny(monthEntity.getStopRentPrice(), days,
                        monthEntity.getRentNum())); // 租赁金额
                monthEntity.setRentDayDate(days);
            }
            else {
                this.monthSum(monthEntity, vo);
            }
            monthEntity.setRentMonthTax(monthEntity.getRentMonthTaxMny().subtract(monthEntity.getRentMonthMny()));
            monthEntity.setEquipmentState(vo.getEquipmentState());
            monthEntity.setRowState("add");
            monthEntity.setId(IdWorker.getId());
            rstList.add(monthEntity);
        }
        rstList.sort(Comparator.comparing(OutRentRentalMonthEntity::getChargingStartDate));
        logger.info("合并前数据：{}", JSONObject.toJSONString(rstList));
        // 对月租明细进行处理，同一台设备如果两个相邻的月租明细，都为启用状态，月租单价相同，则合并为一条，重新计算租赁金额
        outRentRentalMonthList.addAll(rstList);
        // 按照设备、开始时间排序
        if (CollectionUtils.isNotEmpty(outRentRentalMonthList)) {
            outRentRentalMonthList.sort(Comparator.comparing(OutRentRentalMonthEntity::getSourceId)
                    .thenComparing(OutRentRentalMonthEntity::getChargingStartDate));
        }
//        Map<Long, List<OutRentRentalMonthEntity>> sourceMap = rstList.stream().collect(Collectors
//                .groupingBy(OutRentRentalMonthEntity::getSourceId));
//        for (Map.Entry<Long, List<OutRentRentalMonthEntity>> entry : sourceMap.entrySet()) {
//            Map<Long, OutRentRentalMonthEntity> map = new HashMap<>();
//            List<OutRentRentalMonthEntity> mapList = entry.getValue();
//            mapList.sort(Comparator.comparing(OutRentRentalMonthEntity::getChargingStartDate));
//            for (OutRentRentalMonthEntity entity : mapList) {
//                if (OutRentEquipmentStateEnum.启用.getCode().equals(entity.getEquipmentState())) {
//                    // 启用状态且map中不存在，加入map
//                    if (!map.containsKey(entity.getSourceId())) {
//                        map.put(entity.getSourceId(), entity);
//                    }
//                    // map中存在，则需要看map中数据是否需要合并
//                    else {
//                        OutRentRentalMonthEntity oldEntity = map.get(entity.getSourceId());
//                        // 如果单价相同，则两个合为一条，老数据startDate， 新数据endDate
//                        if (oldEntity.getMonthRentPrice().equals(entity.getMonthRentPrice())) {
//                            entity.setChargingStartDate(oldEntity.getChargingStartDate());
//                            this.monthSum(entity);
//                            // 使用新值覆盖老值
//                            map.put(entity.getSourceId(), entity);
//                        }
//                        // 否则做两条计算
//                        else {
//                            outRentRentalMonthList.add(oldEntity);
//                            outRentRentalMonthList.add(entity);
//                        }
//                    }
//                }
//                // 如果非启用且map中有数据，则需要将map中数据加入list中
//                else {
//                    if (map.containsKey(entity.getSourceId())) {
//                        outRentRentalMonthList.add(map.get(entity.getSourceId()));
//                        map.remove(entity.getSourceId());
//                    }
//                    outRentRentalMonthList.add(entity);
//                }
//            }
//            // 将map中的未处理的加入
//            if (!map.isEmpty()) {
//                for (Map.Entry<Long, OutRentRentalMonthEntity> entityEntry : map.entrySet()) {
//                    outRentRentalMonthList.add(entityEntry.getValue());
//                }
//            }
//        }
    }

    /**
     * 根据设备使用记录计算工程量租明细
     *
     * @param outRentRentalQuantitiesList 工程量租明细
     * @param contractEntity           合同信息
     * @param endDate                  租金计算日期
     */
    private void setQuantitiesByUseRecord(List<OutRentRentalQuantitiesEntity> outRentRentalQuantitiesList,
                                          OutRentContractEntity contractEntity,
                                          Date endDate) {
        logger.info(">>>>开始计算工程量租");
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractEntity.getId()));
        queryParam.getParams().put("createTime", new Parameter(QueryParam.LE, endDate));
        queryParam.getParams().put("rentalFlag", new Parameter(QueryParam.NE, 1));
        List<UseRecordEntity> useRecordEntityList = useRecordService.queryList(queryParam, false);
        if (CollectionUtils.isEmpty(useRecordEntityList)) return;
        List<Long> useIdList = useRecordEntityList.stream().map(UseRecordEntity::getId).collect(Collectors.toList());
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("pid", new Parameter(QueryParam.IN, useIdList));
        List<UseRecordSubEntity> useDetailList = useRecordSubService.queryList(detailParam, false);
        // 组装查询结果
        Map<Long, List<UseRecordSubEntity>> map = new HashMap<>();
        for (UseRecordSubEntity detailEntity : useDetailList) {
            if (map.containsKey(detailEntity.getPid())) {
                map.get(detailEntity.getPid()).add(detailEntity);
            }
            else {
                List<UseRecordSubEntity> packList = new ArrayList<>();
                packList.add(detailEntity);
                map.put(detailEntity.getPid(), packList);
            }
        }
        // 组装工程量租明细
        for (UseRecordEntity use : useRecordEntityList) {
            List<UseRecordSubEntity> detailList = map.get(use.getId());
            // 每个设备明细一个租金计算明细
            for (UseRecordSubEntity detail : detailList) {
                OutRentRentalQuantitiesEntity entity = new OutRentRentalQuantitiesEntity();
                entity.setSourceDetailId(detail.getId());
                entity.setSourceName("设备租赁工程量租-" + detail.getEquipmentId());
                entity.setSourceType(2);
                entity.setSourceId(use.getId());
//                entity.setSourceCode(recordVO.getCode());
                entity.setEquipmentName(detail.getEquipmentName());
                entity.setQuantitiesFactoryCode(detail.getEquipmentExitCode());

                entity.setCategoryId(detail.getEquipmentTypeId());
                entity.setCategoryName(detail.getEquipmentType());
                entity.setSpec(detail.getSpec());
                entity.setUnitName(detail.getUnit());
                entity.setQuantitiesNum(detail.getBillingWorkload().intValue()); // 工程数量，取计费工作量
                entity.setQuantitiesPrice(detail.getContractTaxPrice()); // 工程量单价
                entity.setRentNum(1);
                entity.setTax(contractEntity.getContractTax()); // 税率取合同税率
//                entity.setPlanIntoDate(recordVO.getPlanIntoDate());
//                entity.setPlanOutDate(recordVO.getPlanOutDate());
//                entity.setProductionManufactor(recordVO.getProductionManufactor());
//            entity.setMemo();
//            entity.setRentalId();
//                entity.setEquipmentCode(recordVO.getEquipmentCode());
                entity.setEquipmentId(detail.getEquipmentId());
                entity.setNotTaxQuantitiesPrice(detail.getContractPrice());
//                entity.setNotTaxQuantitiesMny(recordVO.getNotTaxQuantitiesMny());
//                entity.setBillingUnitId(StringUtils.isEmpty(detail.getBillingUnit()) ? null : Long.valueOf(detail
//                .getBillingUnit()));
                entity.setBillingUnitName(detail.getBillingUnit());
                entity.setChargingStartDate(use.getStartDate());
                entity.setChargingEndDate(use.getEndDate());

                entity.setRentQuantitiesMny(detail.getMny());// 租赁金额(无税)
                entity.setRentQuantitiesTaxMny(detail.getTaxMny());// 租赁金额
                entity.setRentQuantitiesTax(detail.getTax());// 租赁税额
//                entity.setEquipmentState(vo.getEquipmentState());
                entity.setRowState("add");
                entity.setId(IdWorker.getId());
                outRentRentalQuantitiesList.add(entity);
            }
        }
        // 按照设备、开始时间排序
        if (CollectionUtils.isNotEmpty(outRentRentalQuantitiesList)) {
            outRentRentalQuantitiesList.sort(Comparator.comparing(OutRentRentalQuantitiesEntity::getEquipmentId)
                    .thenComparing(OutRentRentalQuantitiesEntity::getChargingStartDate));
        }
        logger.info("<<<<计算工程量租结束，计算结果：{}", JSONObject.toJSONString(outRentRentalQuantitiesList));
    }

//    /**
//     * 工程量租明细赋值
//     *
//     * @param resultList               工程量租数据
//     * @param outRentRentalQuantitiesList 工程量租明细
//     */
//    private void setRentalQuantitiesDetailValue(List<OutRentRentalCacheVO> resultList,
//                                                List<OutRentRentalQuantitiesEntity> outRentRentalQuantitiesList) {
//        if (CollectionUtils.isEmpty(resultList)) return;
//        for (OutRentRentalCacheVO vo : resultList) {
//            RentQuantitiesRecordVO recordVO = vo.getRentQuantitiesRecord();
//            OutRentRentalQuantitiesEntity entity = new OutRentRentalQuantitiesEntity();
//            entity.setSourceDetailId(recordVO.getId());
//            entity.setSourceName("设备租赁工程量租-" + recordVO.getEquipmentCode());
//            entity.setSourceType(2);
//            entity.setSourceCode(recordVO.getCode());
//            entity.setEquipmentName(recordVO.getName());
//            entity.setQuantitiesFactoryCode(recordVO.getQuantitiesFactoryCode());
//            entity.setCategoryId(recordVO.getCategoryId());
//            entity.setCategoryName(recordVO.getCategoryName());
//            entity.setSpec(recordVO.getSpec());
//            entity.setUnitName(recordVO.getUnitName());
//            entity.setQuantitiesNum(recordVO.getQuantitiesNum());
//            entity.setQuantitiesPrice(recordVO.getQuantitiesPrice());
//            entity.setRentNum(1);
//            entity.setTax(recordVO.getTax());
//            entity.setPlanIntoDate(recordVO.getPlanIntoDate());
//            entity.setPlanOutDate(recordVO.getPlanOutDate());
//            entity.setProductionManufactor(recordVO.getProductionManufactor());
////            entity.setMemo();
////            entity.setRentalId();
//            entity.setEquipmentCode(recordVO.getEquipmentCode());
//            entity.setEquipmentId(recordVO.getEquipmentId());
//            entity.setNotTaxQuantitiesPrice(recordVO.getNotTaxQuantitiesPrice());
//            entity.setNotTaxQuantitiesMny(recordVO.getNotTaxQuantitiesMny());
//            entity.setChangeBid(recordVO.getChangeBid());
//            entity.setBillingUnitId(recordVO.getBillingUnitId());
//            entity.setBillingUnitName(recordVO.getBillingUnitName());
//            entity.setSourceId(vo.getParameterId());
//            entity.setChargingStartDate(vo.getStartDate());
//            entity.setChargingEndDate(vo.getEndDate());
//
//            entity.setRentQuantitiesMny(this.getMny(entity.getNotTaxQuantitiesPrice(),
//                    entity.getQuantitiesNum(), entity.getRentNum()));// 租赁金额(无税)
//            entity.setRentQuantitiesTaxMny(this.getMny(entity.getQuantitiesPrice(),
//                    entity.getQuantitiesNum(), entity.getRentNum()));// 租赁金额
//            entity.setRentQuantitiesTax(entity.getRentQuantitiesTaxMny()
//                    .subtract(entity.getRentQuantitiesMny()));// 租赁税额
//            entity.setEquipmentState(vo.getEquipmentState());
//            entity.setRowState("add");
//            entity.setId(IdWorker.getId());
//            outRentRentalQuantitiesList.add(entity);
//        }
//        // 按照设备、开始时间排序
//        if (CollectionUtils.isNotEmpty(outRentRentalQuantitiesList)) {
//            outRentRentalQuantitiesList.sort(Comparator.comparing(OutRentRentalQuantitiesEntity::getEquipmentId)
//                    .thenComparing(OutRentRentalQuantitiesEntity::getChargingStartDate));
//        }
//    }

    /**
     * 计算月租租金
     *
     * @param monthEntity 月租明细
     * @param vo          参数
     */
    private void monthSum(OutRentRentalMonthEntity monthEntity, OutRentRentalCacheVO vo) {
        Date startDate = monthEntity.getChargingStartDate();
        // 包头包尾  例如  2022-05-02  到 2022-05-04   为2,3,4三天
        // 例如2022-05-04  到2022-06-03  这是一个月。
//        if (!RentParameterTypeEnum.验收单.getCode().equals(vo.getParameterType())) {
//            startDate = this.calculationDay(startDate, -1);
//        }
        startDate = this.calculationDay(startDate, -1);
        int[] mo = this.dayCompare(startDate, monthEntity.getChargingEndDate());
        int month = mo[0];
        int day = mo[1];
        Integer rentNum = monthEntity.getRentNum();
        // 月租无税
        BigDecimal monthMny = this.getMny(monthEntity.getMonthRentNotTaxPrice(), month, rentNum);
        // 月租含税
        BigDecimal monthTaxMny = this.getMny(monthEntity.getMonthRentPrice(), month, rentNum);
        // 不足月无税
        BigDecimal dayMny = this.getMny(monthEntity.getInsufficientMonthNotTaxRentPrice(), day, rentNum);
        // 不足月含税
        BigDecimal dayTaxMny = this.getMny(monthEntity.getInsufficientMonthDayRentPrice(), day, rentNum);
        monthEntity.setRentMonthMny(monthMny.add(dayMny)); // 租赁金额(无税)
        monthEntity.setRentMonthTaxMny(monthTaxMny.add(dayTaxMny)); // 租赁金额
        monthEntity.setRentMonthDate(month);
        monthEntity.setRentDayDate(day);
    }


    /**
     * 租金计算主单据赋默认值
     *
     * @param entity         租金计算单据
     * @param contractEntity 合同信息
     * @param date           租金计算日期
     * @param vo             页面传入数据
     */
    private void setRentalValue(OutRentRentalEntity entity, OutRentContractEntity contractEntity,
                                Date date, OutRentRentalVO vo) {
        entity.setProjectId(vo.getProjectId());
        entity.setProjectCode(vo.getProjectCode());
        entity.setProjectName(vo.getProjectName());
        entity.setOrgId(vo.getOrgId());
        entity.setOrgCode(vo.getOrgCode());
        entity.setOrgName(vo.getOrgName());
        entity.setParentOrgId(vo.getParentOrgId());
        entity.setParentOrgCode(vo.getParentOrgCode());
        entity.setParentOrgName(vo.getParentOrgName());
        entity.setContractId(contractEntity.getId());
        entity.setContractName(contractEntity.getContractName());
        entity.setContractCode(contractEntity.getContractCode());
        entity.setSupplierId(contractEntity.getSupplierId());
        entity.setSupplierName(contractEntity.getSupplierName());
        entity.setRentalDate(date);
//        entity.setDepartmentId();
//        entity.setDepartmentName();
        entity.setMeterRentType(contractEntity.getMeterRentType());
        entity.setMeterRentTypeName(contractEntity.getMeterRentTypeName());
//        entity.setMemo();
        BigDecimal rentTotalMny = BigDecimal.ZERO; // 租赁金额无税
        BigDecimal rentTotalTaxMny = BigDecimal.ZERO;
        BigDecimal rentTotalTax = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(entity.getRentRentalDayList())) {
            for (OutRentRentalDayEntity detail : entity.getRentRentalDayList()) {
                if (!isDetailDel(detail.getRowState())) {
                    rentTotalMny = rentTotalMny.add(detail.getRentDayMny());
                    rentTotalTaxMny = rentTotalTaxMny.add(detail.getRentDayTaxMny());
                    rentTotalTax = rentTotalTax.add(detail.getRentDayTax());
                }
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getRentRentalMonthList())) {
            for (OutRentRentalMonthEntity detail : entity.getRentRentalMonthList()) {
                if (!isDetailDel(detail.getRowState())) {
                    rentTotalMny = rentTotalMny.add(detail.getRentMonthMny());
                    rentTotalTaxMny = rentTotalTaxMny.add(detail.getRentMonthTaxMny());
                    rentTotalTax = rentTotalTax.add(detail.getRentMonthTax());
                }
            }
        }
        if (CollectionUtils.isNotEmpty(entity.getRentRentalQuantitiesList())) {
            for (OutRentRentalQuantitiesEntity detail : entity.getRentRentalQuantitiesList()) {
                if (!isDetailDel(detail.getRowState())) {
                    rentTotalMny = rentTotalMny.add(detail.getRentQuantitiesMny());
                    rentTotalTaxMny = rentTotalTaxMny.add(detail.getRentQuantitiesTaxMny());
                    rentTotalTax = rentTotalTax.add(detail.getRentQuantitiesTax());
                }
            }
        }

        entity.setRentTotalMny(rentTotalMny);
        entity.setRentTotalTaxMny(rentTotalTaxMny);
        entity.setRentTotalTax(rentTotalTax);
//        entity.setRentRentalDayList();
//        entity.setRentRentalMonthList();
//        entity.setRentRentalQuantitiesList();
//        entity.setId();
    }

    /**
     * 组装设备台账记录明细及合同变更明细
     *
     * @param resultList      组装后结果
     * @param contractAllMap  合同变更明细
     * @param parameterVO     设备台账
     * @param rentType        租赁方式
     * @param monthSettlement 月结算日
     */
    private void packParameterDetailAndContract(List<OutRentRentalCacheVO> resultList,
                                                Map<String, Map<Long, List<OutRentRentalCacheVO>>> contractAllMap,
                                                OutRentParameterVO parameterVO,
                                                String rentType, String monthSettlement) {
        // 日租明细
        Map<Long, List<OutRentRentalCacheVO>> map = contractAllMap.get(rentType);
        // 取出当前设备id变更历史
        List<OutRentRentalCacheVO> cacheList = map.get(parameterVO.getEquipmentId());
        // 按照开始日期升序排序
        cacheList.sort(Comparator.comparing(OutRentRentalCacheVO::getStartDate));
        // 获取设备操作记录
        List<OutRentParameterDetailVO> parameterDetailList = parameterVO.getRentParameterDetailList();
        List<OutRentRentalCacheVO> resultList2 = new ArrayList<>();
        // 按照操作日期升序排序
        parameterDetailList.sort(Comparator.comparing(OutRentParameterDetailVO::getOperationDate));
        for (OutRentRentalCacheVO cacheVO : cacheList) {
            // 设备台账只有一条，代表只有验收入场，设备一直处于启用状态，未做启用。停用。退场。租金计算等操作
            if (parameterDetailList.size() == 1) {
                OutRentParameterDetailVO detailVO = parameterDetailList.get(0);
                // 操作日期小于等于开始日期
                if (!detailVO.getOperationDate().after(cacheVO.getStartDate())) {
                    OutRentRentalCacheVO rstVo = new OutRentRentalCacheVO();
                    this.setRecordByRentType(cacheVO, rstVo, rentType);
                    rstVo.setRentType(rentType);
                    rstVo.setParameterId(parameterVO.getId());
                    rstVo.setStartDate(detailVO.getOperationDate());
                    rstVo.setEndDate(cacheVO.getStartDate());
                    rstVo.setEquipmentState(detailVO.getEquipmentState());
                    rstVo.setParameterType(detailVO.getSourceType());
                    resultList2.add(rstVo);

                    if (!OutRentEquipmentStateEnum.退场.getCode().equals(detailVO.getEquipmentState())) {
                        OutRentRentalCacheVO rstvo2 = new OutRentRentalCacheVO();
                        rstvo2.setStartDate(this.dayAddOne(cacheVO.getStartDate()));
                        rstvo2.setEndDate(cacheVO.getEndDate());
                        rstvo2.setEquipmentState(detailVO.getEquipmentState());
                        rstvo2.setRentType(rentType);
                        rstvo2.setParameterId(parameterVO.getId());
                        rstvo2.setParameterType(detailVO.getSourceType());
                        this.setRecordByRentType(cacheVO, rstvo2, rentType);
                        if (this.checkCacheVoIsMerge(rstVo, rstvo2)) {
                            resultList2.add(rstvo2);
                        }
                    }
                }
                // 操作日期大于开始日期并且小于结束日期
                else if (detailVO.getOperationDate().after(cacheVO.getStartDate())
                        && !detailVO.getOperationDate().after(cacheVO.getEndDate())) {
                    OutRentRentalCacheVO rstVo = new OutRentRentalCacheVO();
                    this.setRecordByRentType(cacheVO, rstVo, rentType);
                    rstVo.setRentType(rentType);
                    rstVo.setParameterId(parameterVO.getId());
                    rstVo.setStartDate(detailVO.getOperationDate());
                    rstVo.setEndDate(cacheVO.getEndDate());
                    rstVo.setEquipmentState(detailVO.getEquipmentState());
                    rstVo.setParameterType(detailVO.getSourceType());
                    resultList2.add(rstVo);
                }
                continue;
            }
            // 明细长度
            int parameterListLength = parameterDetailList.size() - 1;
            for (int i = 0; i < parameterListLength; i++) {
                OutRentParameterDetailVO detailVO = parameterDetailList.get(i);
                OutRentParameterDetailVO detailVO1 = parameterDetailList.get(i + 1);
                logger.info("cacheVo:【{}】，detail:【{}】，detail1：【{}】",
                        JSONObject.toJSONString(cacheVO), JSONObject.toJSONString(detailVO),
                        JSONObject.toJSONString(detailVO1));
                OutRentRentalCacheVO rstVo = new OutRentRentalCacheVO();
                this.setRecordByRentType(cacheVO, rstVo, rentType);
                rstVo.setRentType(rentType);
                rstVo.setParameterId(parameterVO.getId());
                // 操作日期小于等于开始日期
                if (!detailVO.getOperationDate().after(cacheVO.getStartDate())) {
                    rstVo.setStartDate(detailVO.getOperationDate());
                    rstVo.setEndDate(cacheVO.getStartDate());
                    rstVo.setEquipmentState(detailVO.getEquipmentState());
                    rstVo.setParameterType(detailVO.getSourceType());
                    resultList2.add(rstVo);

                    if (!OutRentEquipmentStateEnum.退场.getCode().equals(detailVO.getEquipmentState())) {
                        OutRentRentalCacheVO rstvo2 = new OutRentRentalCacheVO();
                        rstvo2.setStartDate(this.dayAddOne(cacheVO.getStartDate()));
                        rstvo2.setEndDate(cacheVO.getEndDate());
                        rstvo2.setEquipmentState(detailVO.getEquipmentState());
                        rstvo2.setRentType(rentType);
                        rstvo2.setParameterId(parameterVO.getId());
                        rstvo2.setParameterType(detailVO.getSourceType());
                        this.setRecordByRentType(cacheVO, rstvo2, rentType);
                        if (this.checkCacheVoIsMerge(rstVo, rstvo2)) {
                            resultList2.add(rstvo2);
                        }
                    }
                }
                // 操作日期大于开始日期并且第二次操作日期小于结束日期
                else if (!detailVO.getOperationDate().before(cacheVO.getStartDate())
                        && !detailVO1.getOperationDate().after(cacheVO.getEndDate())) {
                    // 如果不是第一次操作日期，则需要去第一次操作日期和开始日期之间的天数
                    // 例如 变更日期为8号，第一次入场为10号，则8-10号之间不计算租金
                    // 如果变更日期为8号，第二次进入，则需要计算8-10号之间的租金
                    Date detailStartDate = detailVO.getOperationDate();
                    // 20220617修改：开始计费日期应该取入场日期，注释掉下面代码
//                    if (i != 0) {
//                        OutRentRentalCacheVO rstvo1 = new OutRentRentalCacheVO();
//                        rstvo1.setStartDate(cacheVO.getStartDate());
//                        rstvo1.setEndDate(detailVO.getOperationDate());
//                        rstvo1.setEquipmentState(detailVO.getEquipmentState());
//                        rstvo1.setRentType(rentType);
//                        rstvo1.setParameterId(parameterVO.getId());
//                        rstvo1.setParameterType(detailVO.getSourceType());
//                        this.setRecordByRentType(cacheVO, rstvo1, rentType);
//                        resultList2.add(rstvo1);
//                        detailStartDate = this.dayAddOne(detailVO.getOperationDate());
//                    }
                    rstVo.setStartDate(detailStartDate);
                    rstVo.setEndDate(detailVO1.getOperationDate());
                    rstVo.setEquipmentState(detailVO.getEquipmentState());
                    rstVo.setParameterType(detailVO.getSourceType());
                    resultList2.add(rstVo);
                    // 最后才添加endDate
                    if (!OutRentEquipmentStateEnum.退场.getCode().equals(detailVO1.getEquipmentState())
                            && (i == parameterListLength - 1)) {
                        OutRentRentalCacheVO rstvo2 = new OutRentRentalCacheVO();
                        rstvo2.setStartDate(this.dayAddOne(detailVO1.getOperationDate()));
                        rstvo2.setEndDate(cacheVO.getEndDate());
                        rstvo2.setEquipmentState(detailVO1.getEquipmentState());
                        rstvo2.setRentType(rentType);
                        rstvo2.setParameterId(parameterVO.getId());
                        rstvo2.setParameterType(detailVO1.getSourceType());
                        this.setRecordByRentType(cacheVO, rstvo2, rentType);
                        resultList2.add(rstvo2);
                    }
                }
                // 操作日期大于开始日期并且第二次操作日期大于结束日期
                else if (!detailVO.getOperationDate().before(cacheVO.getStartDate())
                        && !detailVO1.getOperationDate().before(cacheVO.getEndDate())) {
                    if (i != 0) {
                        OutRentRentalCacheVO rstvo1 = new OutRentRentalCacheVO();
                        rstvo1.setStartDate(cacheVO.getStartDate());
                        rstvo1.setEndDate(detailVO.getOperationDate());
                        rstvo1.setEquipmentState(detailVO.getEquipmentState());
                        rstvo1.setRentType(rentType);
                        rstvo1.setParameterId(parameterVO.getId());
                        rstvo1.setParameterType(detailVO.getSourceType());
                        this.setRecordByRentType(cacheVO, rstvo1, rentType);
                        resultList2.add(rstvo1);
                    }
                    rstVo.setStartDate(detailVO.getOperationDate());
                    rstVo.setEndDate(cacheVO.getEndDate());
                    rstVo.setEquipmentState(detailVO.getEquipmentState());
                    rstVo.setParameterType(detailVO.getSourceType());
                    resultList2.add(rstVo);

                    OutRentRentalCacheVO rstvo2 = new OutRentRentalCacheVO();
                    rstvo2.setStartDate(cacheVO.getEndDate());
                    rstvo2.setEndDate(detailVO1.getOperationDate());
                    rstvo2.setEquipmentState(detailVO1.getEquipmentState());
                    rstvo2.setRentType(rentType);
                    rstvo2.setParameterId(parameterVO.getId());
                    rstvo2.setParameterType(detailVO1.getSourceType());
                    this.setRecordByRentType(cacheVO, rstvo2, rentType);
                    resultList2.add(rstvo2);
                }
                // 操作日期大于结束日期，则不需要进行任何操作
                else {
                    rstVo.setStartDate(detailVO.getOperationDate());
                    rstVo.setEndDate(detailVO1.getOperationDate());
                    rstVo.setEquipmentState(detailVO.getEquipmentState());
                    rstVo.setParameterType(detailVO.getSourceType());
                    resultList2.add(rstVo);
                }
            }
        }
//        resultList.sort(Comparator.comparing(OutRentRentalCacheVO::getStartDate));
        resultList2 = this.packResultCacheVo(resultList2, monthSettlement);
        resultList.addAll(resultList2);
        logger.info("租赁方式：{}，组装结果：{}", rentType, JSONObject.toJSONString(resultList));
    }

    /**
     * 校验两个vo是否需要合并，如果需要合并，则合并入vo1中
     *
     * @param vo1 vo1
     * @param vo2 vo2
     * @return true 不需要合并，false需要合并
     */
    private boolean checkCacheVoIsMerge(OutRentRentalCacheVO vo1, OutRentRentalCacheVO vo2) {
        BigDecimal price1;
        BigDecimal price2;
        if (!vo1.getEquipmentState().equals(vo2.getEquipmentState())) {
            return true;
        }
        // vo1和vo2 的租赁方式一定相同
        if (RENT_TYPE_DAY.equals(vo1.getRentType())) {
            if (OutRentEquipmentStateEnum.启用.getCode().equals(vo1.getEquipmentState())) {
                price1 = vo1.getRentDayRecord().getDayRentPrice();
                price2 = vo2.getRentDayRecord().getDayRentPrice();
            }
            else {
                price1 = vo1.getRentDayRecord().getStopRentPrice();
                price2 = vo2.getRentDayRecord().getStopRentPrice();
            }
        }
        else if (RENT_TYPE_MONTH.equals(vo1.getRentType())) {
            if (OutRentEquipmentStateEnum.启用.getCode().equals(vo1.getEquipmentState())) {
                price1 = vo1.getRentMonthRecord().getMonthRentPrice();
                price2 = vo2.getRentMonthRecord().getMonthRentPrice();
            }
            else {
                price1 = vo1.getRentMonthRecord().getStopRentPrice();
                price2 = vo2.getRentMonthRecord().getStopRentPrice();
            }
        }
        else if (RENT_TYPE_QUANTITIES.equals(vo1.getRentType())) {
            price1 = vo1.getRentQuantitiesRecord().getQuantitiesPrice();
            price2 = vo2.getRentQuantitiesRecord().getQuantitiesPrice();
        }
        else {
            return true;
        }
        if (price1.equals(price2)) {
            vo1.setEndDate(vo2.getEndDate());
            return false;
        }
        return true;
    }

    /**
     * 根据月结算日组装月租数据
     *
     * @param resultList      组装结果
     * @param monthSettlement 月结算日
     */
    private List<OutRentRentalCacheVO> packResultCacheVo(List<OutRentRentalCacheVO> resultList, String monthSettlement) {
        List<OutRentRentalCacheVO> rtnList = new ArrayList<>();
        for (OutRentRentalCacheVO vo : resultList) {
            // 如果是月租
            if (RENT_TYPE_MONTH.equals(vo.getRentType())) {
                // 开始日期当月结算日  例如 开始日期2022-05-24  月结算日15  则日期为2022-05-15
                Date startBeginDate = this.monthDay(vo.getStartDate(), monthSettlement);
                // 开始日期下月结算日  例如 开始日期2022-05-24  月结算日15  则日期为2022-06-15
                Date startEndDate = this.monthDay(this.monthAddOne(vo.getStartDate()), monthSettlement);
                // 结束日期当月结算日  例如 结束日期2022-05-24  月结算日15  则日期为2022-05-15
                Date endBeginDate = this.monthDay(vo.getEndDate(), monthSettlement);
                // 结束日期下月结算日  例如 结束日期2022-05-24  月结算日15  则日期为2022-06-15
                Date endEndDate = this.monthDay(this.monthAddOne(vo.getEndDate()), monthSettlement);
                // 时间段对比以下几种情况中情况
                // 开始时间A，结束时间B，开始当月结算日A1，开始当月结算日A2，结束当月结算日B1，结束当月结算日B2
                // 1. A<B<A1   例如  开始2022-05-13，结束2022-05-14，月结算日2022-05-15
                // 2. 开始时间<开始月结算日<结束时间<开始下月结算日 例如  开始2022-05-13，结束2022-06-14，
                // 月结算日2022-05-15，下月结算日2022-06-15 截取时间 2022-05-13到2022-05-15,2022-05-16到2022-06-14
                // 3. 开始<开结<开下结<结束  例如 开始2022-05-13，结束2022-06-17，月结算日2022-05-15，下月结算日2022-06-15
                // 截取时间  13-15  05-16到06-15  06-16到06-17
                // 4. 开结<开始<结束<开下结
                // 开始日期、结束日期在月结算日之前
                // 月结算日15   开始10  结束13，不做处理
                if (!vo.getStartDate().after(startBeginDate)) {
                    // 1. a < b < a1 < a2
                    if (!vo.getEndDate().after(startBeginDate)) {
                        rtnList.add(vo);
                    }
                    // 2. A < A1 < B < A2
                    else if (!vo.getEndDate().before(startBeginDate) && !vo.getEndDate().after(startEndDate)) {
                        // 开始-月结算日
                        this.setRstValue(vo.getStartDate(), startBeginDate, vo, rtnList);
                        // 月结算日-结束
                        this.setRstValue(this.dayAddOne(startBeginDate), vo.getEndDate(), vo, rtnList);
                    }
                    // 3. A < A1 < A2 < B < B1
                    else if (!vo.getEndDate().before(startEndDate) && !vo.getEndDate().after(endBeginDate)) {
                        // 结束日期上月结算日
                        // 开始-月结算日
                        this.setRstValue(vo.getStartDate(), startBeginDate, vo, rtnList);
                        // 3.1 A < A1 < A2 < B0 < B < B1
                        Date endUpDate = this.monthDay(this.calculationMonth(vo.getEndDate(), -1), monthSettlement);
                        Date ed;
                        // 3.1 A < A1 < A2 < B0 < B < B1
                        if (endUpDate.after(startEndDate)) {
                            // 月结算日-月结算日
                            this.setRstValue(this.dayAddOne(startBeginDate), endUpDate, vo, rtnList);
                            ed = endUpDate;
                        }
                        // 3.2 A < A1 < B0 <= A2 < B < B1
                        else {
                            // 月结算日-月结算日
                            this.setRstValue(this.dayAddOne(startBeginDate), startEndDate, vo, rtnList);
                            ed = startEndDate;
                        }
                        // 月结算日 - 结束日期
                        this.setRstValue(this.dayAddOne(ed), vo.getEndDate(), vo, rtnList);
                    }
                    // 4. A < A1 < A2 < B1 < B < B2
                    else if (!vo.getEndDate().before(startEndDate) && !vo.getEndDate().before(endBeginDate)) {
                        // 开始-月结算日
                        this.setRstValue(vo.getStartDate(), startBeginDate, vo, rtnList);
                        // 极端情况，endBeginDate=startEndDate，此时需要加入
                        if (!endBeginDate.before(startEndDate)) {
                            // 月结算日-月结算日
                            this.setRstValue(this.dayAddOne(startBeginDate), endBeginDate, vo, rtnList);
                        }
                        // 月结算日 - 结束日期
                        this.setRstValue(this.dayAddOne(endBeginDate), vo.getEndDate(), vo, rtnList);
                    }
                    else {
                        rtnList.add(vo);
                    }
                }
                // 开始日期在月结算日之后，结束日期在下月结算日之前
                // 例如月结算日15   开始日期2022-05-17，结束日期2022-06-14，则不足月，不按一个月算 中间插入 月结算日2022-05-15
                else if (vo.getStartDate().after(startBeginDate)) {
                    // 5. A1 < A < B < A2
                    if (!vo.getEndDate().after(startEndDate)) {
                        rtnList.add(vo);
                    }
                    // 6. A1 < A < A2 < B < B1
                    else if (!vo.getEndDate().before(startEndDate) && !vo.getEndDate().after(endBeginDate)) {
                        // 开始-下月结算日
                        this.setRstValue(vo.getStartDate(), startEndDate, vo, rtnList);
                        Date endUpDate = this.monthDay(this.calculationMonth(vo.getEndDate(), -1), monthSettlement);
                        Date ed;
                        // 6.1 A1 < A < A2 < B0 < B < B1
                        if (endUpDate.after(startEndDate)) {
                            // 月结算日-月结算日
                            this.setRstValue(this.dayAddOne(startEndDate), endUpDate, vo, rtnList);
                            ed = endUpDate;
                        }
                        // 6.2 A1 < A < B0 <= A2 < B < B1
                        else {
                            ed = startEndDate;
                        }
                        // 月结算日 - 结束日期
                        this.setRstValue(this.dayAddOne(ed), vo.getEndDate(), vo, rtnList);
                    }
                    // 7. A1 < A < A2 < B1 < B < B2
                    else if (!vo.getEndDate().before(startEndDate) && !vo.getEndDate().before(endBeginDate)) {
                        // 开始-下月结算日
                        this.setRstValue(vo.getStartDate(), startEndDate, vo, rtnList);
                        // endBeginDate >= startEndDate   只可能出现这一种情况
                        if (endBeginDate.after(startEndDate)) {
                            // 开始下月结算日 - 结束月结算日
                            this.setRstValue(this.dayAddOne(startEndDate), endBeginDate, vo, rtnList);
                        }
                        // 月结算日 - 结束日期
                        this.setRstValue(this.dayAddOne(endBeginDate), vo.getEndDate(), vo, rtnList);
                    }
                    else {
                        rtnList.add(vo);
                    }
                }
                // 开始日期等于月结算日
                else {
                    rtnList.add(vo);
                }
            }
            else {
                rtnList.add(vo);
            }
        }
        rtnList.sort(Comparator.comparing(OutRentRentalCacheVO::getStartDate));
        return rtnList;
    }

    /**
     * 给结果赋值
     *
     * @param start   开始日期
     * @param end     结束日期
     * @param vo      vo
     * @param rtnList 结果列表
     */
    private void setRstValue(Date start, Date end, OutRentRentalCacheVO vo, List<OutRentRentalCacheVO> rtnList) {
        OutRentRentalCacheVO rstvo1 = new OutRentRentalCacheVO();
        rstvo1.setStartDate(start);
        rstvo1.setEndDate(end);
        rstvo1.setEquipmentState(vo.getEquipmentState());
        rstvo1.setRentType(vo.getRentType());
        rstvo1.setRentMonthRecord(vo.getRentMonthRecord());
        rstvo1.setParameterId(vo.getParameterId());
        rstvo1.setParameterType(vo.getParameterType());
        rtnList.add(rstvo1);
    }

    /**
     * 根据租赁方式赋值不同结果
     *
     * @param cacheVO  查询结果
     * @param rstVo    需要赋值的对象
     * @param rentType 租赁方式
     */
    private void setRecordByRentType(OutRentRentalCacheVO cacheVO, OutRentRentalCacheVO rstVo, String rentType) {
        if (RENT_TYPE_DAY.equals(rentType)) {
            rstVo.setRentDayRecord(cacheVO.getRentDayRecord());
        }
        else if (RENT_TYPE_MONTH.equals(rentType)) {
            rstVo.setRentMonthRecord(cacheVO.getRentMonthRecord());
        }
        else if (RENT_TYPE_QUANTITIES.equals(rentType)) {
            rstVo.setRentQuantitiesRecord(cacheVO.getRentQuantitiesRecord());
        }
    }

    /**
     * 查询合同及合同记录信息
     *
     * @param contractId     合同id
     * @param contractEntity 合同信息
     * @param endDate        变更截止日期
     */
    private Map<String, Map<Long, List<OutRentRentalCacheVO>>> getContractRecord(Long contractId,
                                                                               OutRentContractEntity contractEntity,
                                                                               Date endDate) {

        Map<String, Map<Long, List<OutRentRentalCacheVO>>> rtnMap = new HashMap<>();
        // 查询合同记录信息,按照变更日期升序排序
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        queryParam.getParams().put("changeDate", new Parameter(QueryParam.LE, endDate));
        queryParam.getOrderMap().put("changeDate", QueryParam.ASC);
        List<OutRentContractRecordEntity> recordList = contractRecordService.queryList(queryParam, false);
        // 没有合同变更记录，则返回主合同取的信息
        if (CollectionUtils.isEmpty(recordList)) {
            // 没有合同变更记录，则合同是从签订日期开始生效
            this.packContractMap(contractEntity, rtnMap, contractEntity.getSignedDate(), endDate);
            logger.info("合同未查询到变更记录，返回信息：{}", JSONObject.toJSONString(rtnMap));
            return rtnMap;
        }

        List<Long> recordIdList = recordList.stream().map(OutRentContractRecordEntity::getId)
                .collect(Collectors.toList());
        QueryParam detailParam = new QueryParam();
        detailParam.getParams().put("recordId", new Parameter(QueryParam.IN, recordIdList));
        // 日租明细
        List<OutRentDayRecordEntity> dayRecordEntityList = dayRecordService.queryList(detailParam, false);
        // 月租明细
        List<OutRentMonthRecordEntity> monthRecordEntityList = monthRecordService.queryList(detailParam, false);
        // 工程Out量租
        List<OutRentQuantitiesRecordEntity> quantitiesRecordEntityList = quantitiesRecordService
                .queryList(detailParam, false);
        // 明细与记录匹配
        // 日租
        Map<Long, List<OutRentDayRecordEntity>> dayMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(dayRecordEntityList)) {
            for (OutRentDayRecordEntity dayRecordEntity : dayRecordEntityList) {
                if (dayMap.containsKey(dayRecordEntity.getRecordId())) {
                    dayMap.get(dayRecordEntity.getRecordId()).add(dayRecordEntity);
                }
                else {
                    List<OutRentDayRecordEntity> packList = new ArrayList<>();
                    packList.add(dayRecordEntity);
                    dayMap.put(dayRecordEntity.getRecordId(), packList);
                }
            }
        }
        // 月租
        Map<Long, List<OutRentMonthRecordEntity>> monthMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(monthRecordEntityList)) {
            for (OutRentMonthRecordEntity monthRecordEntity : monthRecordEntityList) {
                if (monthMap.containsKey(monthRecordEntity.getRecordId())) {
                    monthMap.get(monthRecordEntity.getRecordId()).add(monthRecordEntity);
                }
                else {
                    List<OutRentMonthRecordEntity> packList = new ArrayList<>();
                    packList.add(monthRecordEntity);
                    monthMap.put(monthRecordEntity.getRecordId(), packList);
                }
            }
        }
        // 工程量租
        Map<Long, List<OutRentQuantitiesRecordEntity>> quantitiesMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(quantitiesRecordEntityList)) {
            for (OutRentQuantitiesRecordEntity quantitiesRecordEntity : quantitiesRecordEntityList) {
                if (quantitiesMap.containsKey(quantitiesRecordEntity.getRecordId())) {
                    quantitiesMap.get(quantitiesRecordEntity.getRecordId()).add(quantitiesRecordEntity);
                }
                else {
                    List<OutRentQuantitiesRecordEntity> packList = new ArrayList<>();
                    packList.add(quantitiesRecordEntity);
                    quantitiesMap.put(quantitiesRecordEntity.getRecordId(), packList);
                }
            }
        }

        Date startDate = null;
        Date recordEndDate = null;
        for (int i = 0; i < recordList.size(); i++) {
            OutRentContractRecordEntity recordEntity = recordList.get(i);
            recordEntity.setRentDayDetailedList(dayMap.get(recordEntity.getId()));
            recordEntity.setRentMonthDetailedList(monthMap.get(recordEntity.getId()));
            recordEntity.setRentQuantitiesDetailedList(quantitiesMap.get(recordEntity.getId()));
            if (startDate == null) startDate = recordEntity.getSignedDate();
            recordEndDate = recordEntity.getChangeDate();
            // 如果开始日期在结束日期之后，跳过此次循环
            if (!startDate.after(recordEndDate)) continue;
            // 处理合同记录日租明细
            if (CollectionUtils.isNotEmpty(recordEntity.getRentDayDetailedList())) {
                Map<Long, List<OutRentRentalCacheVO>> recordDayMap = rtnMap.get(RENT_TYPE_DAY);
                if (recordDayMap == null) recordDayMap = new HashMap<>();
                for (OutRentDayRecordEntity detailEntity : recordEntity.getRentDayDetailedList()) {
                    // 组装数据
                    OutRentRentalCacheVO cacheVO = new OutRentRentalCacheVO();
                    cacheVO.setRentType(RENT_TYPE_DAY);
                    cacheVO.setEquipmentId(detailEntity.getEquipmentId());
                    // 如果中间有发生变更，则变更日期优先
                    cacheVO.setStartDate(startDate); // 主合同生效范围为签订日期到当前租金计算日期
                    cacheVO.setEndDate(recordEndDate);
                    cacheVO.setContractType(1);
                    cacheVO.setRentDayRecord(BeanMapper.map(detailEntity, OutRentDayRecordVO.class));
                    this.packCacheMap(cacheVO, recordDayMap);
                }
                rtnMap.put(RENT_TYPE_DAY, recordDayMap);
            }
            // 处理合同记录月租明细
            if (CollectionUtils.isNotEmpty(recordEntity.getRentMonthDetailedList())) {
                Map<Long, List<OutRentRentalCacheVO>> detailMap = rtnMap.get(RENT_TYPE_MONTH);
                if (detailMap == null) detailMap = new HashMap<>();
                for (OutRentMonthRecordEntity detailEntity : recordEntity.getRentMonthDetailedList()) {
                    // 组装数据
                    OutRentRentalCacheVO cacheVO = new OutRentRentalCacheVO();
                    cacheVO.setRentType(RENT_TYPE_MONTH);
                    cacheVO.setEquipmentId(detailEntity.getEquipmentId());
                    // 如果中间有发生变更，则变更日期优先
                    cacheVO.setStartDate(startDate); // 主合同生效范围为签订日期到当前租金计算日期
                    cacheVO.setEndDate(recordEndDate);
                    cacheVO.setContractType(1);
                    cacheVO.setRentMonthRecord(BeanMapper.map(detailEntity, OutRentMonthRecordVO.class));
                    this.packCacheMap(cacheVO, detailMap);
                }
                rtnMap.put(RENT_TYPE_MONTH, detailMap);
            }
            // 处理合同记录工程量租明细
            if (CollectionUtils.isNotEmpty(recordEntity.getRentQuantitiesDetailedList())) {
                Map<Long, List<OutRentRentalCacheVO>> detailMap = rtnMap.get(RENT_TYPE_QUANTITIES);
                if (detailMap == null) detailMap = new HashMap<>();
                for (OutRentQuantitiesRecordEntity detailEntity : recordEntity.getRentQuantitiesDetailedList()) {
                    // 组装数据
                    OutRentRentalCacheVO cacheVO = new OutRentRentalCacheVO();
                    cacheVO.setRentType(RENT_TYPE_QUANTITIES);
                    cacheVO.setEquipmentId(detailEntity.getEquipmentId());
                    // 如果中间有发生变更，则变更日期优先
                    cacheVO.setStartDate(startDate); // 主合同生效范围为签订日期到当前租金计算日期
                    cacheVO.setEndDate(recordEndDate);
                    cacheVO.setContractType(1);
                    cacheVO.setRentQuantitiesRecord(BeanMapper.map(detailEntity, OutRentQuantitiesRecordVO.class));
                    this.packCacheMap(cacheVO, detailMap);
                }
                rtnMap.put(RENT_TYPE_QUANTITIES, detailMap);
            }
            // 下次起始日期为本次变更日期+1
            startDate = this.dayAddOne(recordEntity.getChangeDate());
        }
        // 有合同变更记录时，主合同生效范围起始日期为查询出的最后一次变更日期
        this.packContractMap(contractEntity, rtnMap, this.dayAddOne(recordEndDate), endDate);
        logger.info("处理合同信息结束，处理结果：{}", JSONObject.toJSONString(rtnMap));
        return rtnMap;
    }

    /**
     * 组装数据
     *
     * @param cacheVO 租金自动计算临时数据
     * @param map     map
     */
    private void packCacheMap(OutRentRentalCacheVO cacheVO, Map<Long, List<OutRentRentalCacheVO>> map) {
        if (map == null) map = new HashMap<>();
        if (map.containsKey(cacheVO.getEquipmentId())) {
            map.get(cacheVO.getEquipmentId()).add(cacheVO);
        }
        else {
            List<OutRentRentalCacheVO> packList = new ArrayList<>();
            packList.add(cacheVO);
            map.put(cacheVO.getEquipmentId(), packList);
        }
    }

    /**
     * 组装主合同数据
     *
     * @param contractEntity 主合同信息
     * @param rtnMap         需要返回结果
     * @param startDate      生效起始日期
     * @param endDate        生效结束日期
     */
    private void packContractMap(OutRentContractEntity contractEntity, Map<String,
            Map<Long, List<OutRentRentalCacheVO>>> rtnMap, Date startDate, Date endDate) {
        // 如果起始日期大于结束日期，则说明不需要主合同信息
        if (endDate.before(startDate)) return;
        // 处理日租明细
        if (CollectionUtils.isNotEmpty(contractEntity.getRentDayDetailedList())) {
            Map<Long, List<OutRentRentalCacheVO>> detailMap = rtnMap.get(RENT_TYPE_DAY);
            if (detailMap == null) detailMap = new HashMap<>();
            for (OutRentDayDetailedEntity detailedEntity : contractEntity.getRentDayDetailedList()) {
                // 组装数据
                OutRentRentalCacheVO cacheVO = new OutRentRentalCacheVO();
                cacheVO.setRentType(RENT_TYPE_DAY);
                cacheVO.setEquipmentId(detailedEntity.getEquipmentId());
                // 如果中间有发生变更，则变更日期优先
                cacheVO.setStartDate(startDate); // 主合同生效范围为签订日期到当前租金计算日期
                cacheVO.setEndDate(endDate);
                cacheVO.setContractType(0);
                cacheVO.setRentDayRecord(BeanMapper.map(detailedEntity, OutRentDayRecordVO.class));
                this.packCacheMap(cacheVO, detailMap);
            }
            rtnMap.put(RENT_TYPE_DAY, detailMap);
        }
        // 处理月租明细
        if (CollectionUtils.isNotEmpty(contractEntity.getRentMonthDetailedList())) {
            Map<Long, List<OutRentRentalCacheVO>> detailMap = rtnMap.get(RENT_TYPE_MONTH);
            if (detailMap == null) detailMap = new HashMap<>();
            for (OutRentMonthDetailedEntity detailedEntity : contractEntity.getRentMonthDetailedList()) {
                // 组装数据
                OutRentRentalCacheVO cacheVO = new OutRentRentalCacheVO();
                cacheVO.setRentType(RENT_TYPE_MONTH);
                cacheVO.setEquipmentId(detailedEntity.getEquipmentId());
                // 如果中间有发生变更，则变更日期优先
                cacheVO.setStartDate(startDate); // 主合同生效范围为签订日期到当前租金计算日期
                cacheVO.setEndDate(endDate);
                cacheVO.setContractType(0);
                cacheVO.setRentMonthRecord(BeanMapper.map(detailedEntity, OutRentMonthRecordVO.class));
                this.packCacheMap(cacheVO, detailMap);
            }
            rtnMap.put(RENT_TYPE_MONTH, detailMap);
        }
        // 处理工程量租明细
        if (CollectionUtils.isNotEmpty(contractEntity.getRentQuantitiesDetailedList())) {
            Map<Long, List<OutRentRentalCacheVO>> detailMap = rtnMap.get(RENT_TYPE_QUANTITIES);
            if (detailMap == null) detailMap = new HashMap<>();
            for (OutRentQuantitiesDetailedEntity detailedEntity : contractEntity.getRentQuantitiesDetailedList()) {
                // 组装数据
                OutRentRentalCacheVO cacheVO = new OutRentRentalCacheVO();
                cacheVO.setRentType(RENT_TYPE_QUANTITIES);
                cacheVO.setEquipmentId(detailedEntity.getEquipmentId());
                // 如果中间有发生变更，则变更日期优先
                cacheVO.setStartDate(startDate); // 主合同生效范围为签订日期到当前租金计算日期
                cacheVO.setEndDate(endDate);
                cacheVO.setContractType(0);
                cacheVO.setRentQuantitiesRecord(BeanMapper.map(detailedEntity, OutRentQuantitiesRecordVO.class));
                this.packCacheMap(cacheVO, detailMap);
            }
            rtnMap.put(RENT_TYPE_QUANTITIES, detailMap);
        }
    }

    /**
     * 计算两个日期之间相差的天数
     *
     * @param smdate 较小的时间
     * @param bdate  较大的时间
     * @return 相差天数
     */
    private Integer daysBetween(Date smdate, Date bdate) {
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            smdate = sdf.parse(sdf.format(smdate));
            bdate = sdf.parse(sdf.format(bdate));
            Calendar cal = Calendar.getInstance();
            cal.setTime(smdate);
            long time1 = cal.getTimeInMillis();
            cal.setTime(bdate);
            long time2 = cal.getTimeInMillis();
            long between_days = (time2 - time1) / (1000 * 3600 * 24);
            return Integer.parseInt(String.valueOf(between_days));
        }
        catch (Exception e) {
            logger.error("日期计算错误，错误信息：{}", e.getMessage(), e);
            return null;
        }
    }

    /**
     * 根据月结算日计算日期
     * 例如月结算日为15，日期为2022/05/13，则创建时间2022/05/15
     *
     * @param date            日期
     * @param monthSettlement 月结算日
     * @return 返回结果
     */
    private Date monthDay(Date date, String monthSettlement) {
        Calendar from = Calendar.getInstance();
        from.setTime(date);
        int fromYear = from.get(Calendar.YEAR);
        int fromMonth = from.get(Calendar.MONTH);
//        int fromDay = from.get(Calendar.DAY_OF_MONTH);
        int settlement = Integer.parseInt(monthSettlement);
        Calendar myCalendar = new GregorianCalendar(fromYear, fromMonth, settlement);
        return myCalendar.getTime();
    }

    /**
     * 日期加一天
     *
     * @param date 需要计算的日期
     * @return 计算后结果
     */
    private Date dayAddOne(Date date) {
        return this.calculationDay(date, 1);
    }

    /**
     * 计算日期，加几天或者减几天  整数  往后推,负数往前移动
     *
     * @param date 需要计算的日期
     * @param days 计算天数
     * @return 计算结果
     */
    private Date calculationDay(Date date, Integer days) {
        Calendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.add(Calendar.DATE, days); //把日期往后增加一天,整数  往后推,负数往前移动
        return calendar.getTime(); //这个时间就是日期往后推一天的结果
    }

    /**
     * 月份加一月
     *
     * @param date 需要计算的日期
     * @return 计算结果
     */
    private Date monthAddOne(Date date) {
        return this.calculationMonth(date, 1);
    }

    /**
     * 计算月份，加几月或者减几月  整数  往后推,负数往前移动
     *
     * @param date  需要计算的日期
     * @param month 计算月数
     * @return 计算结果
     */
    private Date calculationMonth(Date date, Integer month) {
        Calendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        calendar.add(Calendar.MONTH, month); //把日期往后增加一天,整数  往后推,负数往前移动
        return calendar.getTime(); //这个时间就是日期往后推一天的结果
    }


    /**
     * 计算金额
     *
     * @param bigDecimal 单价
     * @param days       天数
     * @param nums       数量
     * @return 计算结果
     */
    private BigDecimal getMny(BigDecimal bigDecimal, Integer days, Integer nums) {
        if (bigDecimal == null) return BigDecimal.ZERO;
        return bigDecimal.multiply(new BigDecimal(days)).multiply(new BigDecimal(nums));
    }

    /**
     * 计算2个日期之间相差的  以年、月、日为单位，各自计算结果是多少
     * 比如：2011-02-02 到  2017-03-03
     * 计算结果为 1,1  一个月零一天
     *
     * @param fromDate 开始日期
     * @param toDate   结束日期
     * @return 计算结果
     */
    public int[] dayCompare(Date fromDate, Date toDate) {
        Instant instant = fromDate.toInstant();
        Instant instant1 = toDate.toInstant();
        ZoneId zoneId = ZoneId.systemDefault();
        LocalDate one = instant.atZone(zoneId).toLocalDate();
        LocalDate two = instant1.atZone(zoneId).toLocalDate();
        int year = Period.between(one, two).getYears();
        int month = Period.between(one, two).getMonths();
        int day = Period.between(one, two).getDays();
        month = year * 12 + month;
        return new int[]{month, day};
    }

    /**
     * 是否为删除列表明细
     *
     * @param rowState 列表字段
     * @return true 删除   false 非删除
     */
    private boolean isDetailDel(String rowState) {
        return "del".equals(rowState);
    }
}
