package com.ejianc.business.proequipmentcorppur.asset.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

/**
 * 设备采购-固定资产调整单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_proequipmentcorp_asset_adjust")
public class AssetAdjustEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 
    @TableField(value="org_id")
    private Long orgId; // 所属单位ID
    @TableField(value="org_name")
    private String orgName; // 所属单位
    @TableField(value="bill_state")
    private Integer billState; // 单据状态
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_code")
    private String projectCode; // 项目编码
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="org_code")
    private String orgCode; // 项目组织编码
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="department_name")
    private String departmentName; // 经办人部门
    @TableField(value="department_id")
    private Long departmentId; // 经办人部门id
    @TableField(value="adjust_time")
    private Date adjustTime; // 调整日期
    @TableField(value="assessment_before_original")
    private BigDecimal assessmentBeforeOriginal; // 评估前原值
    @TableField(value="assessment_after_original")
    private BigDecimal assessmentAfterOriginal; // 评估后原值


    @TableField(value="material_type_name")
    private String materialTypeName; // 设备分类
    @TableField(exist=false)
    @SubEntity(serviceName="assetAdjustDetailService",pidName ="adjustId")
    private List<AssetAdjustDetailEntity> adjustDetailEntityList = new ArrayList<>();

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getDepartmentName() {
        return departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }
    public Long getDepartmentId() {
        return departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }
    public Date getAdjustTime() {
        return adjustTime;
    }

    public void setAdjustTime(Date adjustTime) {
        this.adjustTime = adjustTime;
    }
    public BigDecimal getAssessmentBeforeOriginal() {
        return assessmentBeforeOriginal;
    }

    public void setAssessmentBeforeOriginal(BigDecimal assessmentBeforeOriginal) {
        this.assessmentBeforeOriginal = assessmentBeforeOriginal;
    }
    public BigDecimal getAssessmentAfterOriginal() {
        return assessmentAfterOriginal;
    }

    public void setAssessmentAfterOriginal(BigDecimal assessmentAfterOriginal) {
        this.assessmentAfterOriginal = assessmentAfterOriginal;
    }

    public String getMaterialTypeName() {
        return materialTypeName;
    }

    public void setMaterialTypeName(String materialTypeName) {
        this.materialTypeName = materialTypeName;
    }

    public List<AssetAdjustDetailEntity> getAdjustDetailEntityList() {
        return adjustDetailEntityList;
    }

    public void setAdjustDetailEntityList(List<AssetAdjustDetailEntity> adjustDetailEntityList) {
        this.adjustDetailEntityList = adjustDetailEntityList;
    }
}
