package com.ejianc.business.proequipmentcorppur.asset.service;

import com.ejianc.business.proequipmentcorppur.decorator.IAssetRecord;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetRecordEntity;
import org.apache.poi.ss.formula.functions.T;

/**
 * 固定资产流转记录表
 *
 * @author generator
 */
public interface IAssetRecordService extends IBaseService<AssetRecordEntity> {

    /**
     * @param assetRecord
     * @description: 保存流转记录
     * @return: boolean
     * @author songlx
     * @date: 2022/6/25
     */
    boolean saveRecord(IAssetRecord assetRecord);

    /**
     * @param sourceId 业务单据主键
     * @description: 删除流转记录
     * @return: boolean
     * @author songlx
     * @date: 2022/6/25
     */
    boolean delRecord(Long sourceId);


}
