package com.ejianc.business.proequipmentcorprent.rent.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorprent.ac.bean.ContractEntity;
import com.ejianc.business.proequipmentcorprent.ac.enums.BillPushStatusEnum;
import com.ejianc.business.proequipmentcorprent.appearance.vo.PushAppearanceSubVO;
import com.ejianc.business.proequipmentcorprent.appearance.vo.PushAppearanceVO;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentAcceptanceEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentAcceptanceSubEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentParameterEntity;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentAcceptanceService;
import com.ejianc.business.proequipmentcorprent.rent.service.impl.RentAcceptanceBpmServiceImpl;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentAcceptanceSubVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentAcceptanceVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentParameterDetailVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentParameterVO;
import com.ejianc.business.promaterial.plan.vo.PlanDetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.foundation.share.vo.CooperateVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

/**
 * 租赁设备验收
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("rentAcceptance")
public class RentAcceptanceController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IShareCooperateApi shareCooperateApi;
    @Autowired
    private RentAcceptanceBpmServiceImpl rentAcceptanceBpmService;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "CORP_RENT_CHECK";//此处需要根据实际修改
    private static final String BILL_TYPE = "EJCBT202210000025";//此处需要根据实际修改

    @Autowired
    private IRentAcceptanceService service;

    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IProSupplierApi proSupplierApi;
    private static final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/rentAcceptance/saveCheck";
    /**
     * 单据分享移动端前端路由地址
     */
    private final String mobileBillShareFrontUrl = "/ejc-supbusiness-mobile/#/proEquipments/check/card";

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<RentAcceptanceVO> saveOrUpdate(@RequestBody RentAcceptanceVO saveOrUpdateVO) {
        // parentOrgCode如果是空的，则需要查询赋值
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(saveOrUpdateVO.getParentOrgCode()) && saveOrUpdateVO.getParentOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(saveOrUpdateVO.getParentOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                saveOrUpdateVO.setParentOrgCode(orgVO.getCode());
            }
        }
        // orgCode如果是空的，则需要查询赋值
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty(saveOrUpdateVO.getOrgCode()) && saveOrUpdateVO.getOrgId() != null) {
            CommonResponse<OrgVO> orgResponse = iOrgApi.getOneById(saveOrUpdateVO.getOrgId());
            if (orgResponse.isSuccess()) {
                OrgVO orgVO = orgResponse.getData();
                saveOrUpdateVO.setOrgCode(orgVO.getCode());
            }
        }
    	RentAcceptanceEntity entity = BeanMapper.map(saveOrUpdateVO, RentAcceptanceEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(entity.getNotSignature() == null){
            entity.setNotSignature(false);
        }
        entity.setBillPushFlag(BillPushStatusEnum.未成功推送.getStatus());
    	entity.setSignStatus(0);
        if(CollectionUtils.isNotEmpty(entity.getRentAcceptanceSubList())){
            for (RentAcceptanceSubEntity rentAcceptanceSubEntity : entity.getRentAcceptanceSubList()) {
                rentAcceptanceSubEntity.setCheckAfterFlag(0);
                rentAcceptanceSubEntity.setContractId(entity.getContractId());
            }
        }
        service.saveOrUpdates(entity);
    	RentAcceptanceVO vo = BeanMapper.map(entity, RentAcceptanceVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * 供方签字确认信息回写
     *
     * @param request
     * @return
     */
    @PostMapping(value = "/supSignSync")
    @ResponseBody
    public CommonResponse<String> supSignSync(HttpServletRequest request) {
        String msg = service.updateBillSupSignSyncInfo(request);
        if (StringUtils.isNotBlank(msg)) {
            return CommonResponse.error(msg);
        }
        return CommonResponse.success("签字状态回写成功！");
    }
    /**
     * 供方签字确认信息回写
     *
     * @return
     */
    @GetMapping(value = "/rentAcceptanceBpmService")
    @ResponseBody
    public CommonResponse<String> rentAcceptanceBpmService() {
        rentAcceptanceBpmService.afterApprovalProcessor(579994856613511229L,null,null);
        return CommonResponse.success("签字状态回写成功！");
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<RentAcceptanceVO> queryDetail(Long id) {
    	RentAcceptanceEntity entity = service.selectById(id);

    	RentAcceptanceVO vo = BeanMapper.map(entity, RentAcceptanceVO.class);

        return CommonResponse.success("查询详情数据成功！",vo);
    }
    @ApiOperation("获取协同链接")
    @RequestMapping(value = "/getBillShareLink", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<JSONObject> getBillShareLink(@RequestParam Long id) {
        RentAcceptanceEntity entity = service.selectById(id);
        //校验供应商
        CommonResponse<Boolean> supplierResp = proSupplierApi.whetherSupplierCoo(entity.getSupplierId());
        if (!supplierResp.isSuccess()) {
            logger.error("根据供应商主键-{}查询失败，{}", entity.getSupplierId(), supplierResp.getMsg());
            return CommonResponse.error("获取供应商信息失败！");
        }
        Boolean flag = supplierResp.getData();
        if(!flag){
            return CommonResponse.error("该供应商未开通协同权限，无法协同验收。 请先到供应商库—生成协同账号再进行订单操作。");
        }

        // 没有推送成功，则需要重新推送数据
        if (BillPushStatusEnum.未成功推送.getStatus().equals(entity.getBillPushFlag())) {
            //查询该单据是否支持协同分享，则向供方协同服务推送该单据
            CommonResponse<CooperateVO> cooperateResp = shareCooperateApi.queryCooperateBybillTypeCode(BILL_TYPE);
            if (!cooperateResp.isSuccess()) {
                logger.error("根据单据类型-{}查询其协同配置信息失败, 不进行单据推送操作，{}", BILL_TYPE, cooperateResp.getMsg());
                return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
            }
            else {
                //未曾成功推送单据，则先向供方推送单据
                //推送供方处理
                PushAppearanceVO supplierPushCheckVO = BeanMapper.map(entity, PushAppearanceVO.class);
                supplierPushCheckVO.setSourceId(entity.getId());
                List<PushAppearanceSubVO> checkDetailList = supplierPushCheckVO.getRentAcceptanceDetailList();
                for (PushAppearanceSubVO supplierPushCheckDetailVO : checkDetailList) {
                    supplierPushCheckDetailVO.setSourceId(entity.getId());
                    supplierPushCheckDetailVO.setSourceDetailId(supplierPushCheckDetailVO.getId());
                    supplierPushCheckDetailVO.setId(null);
                }
                //设置单据当前系统信息
                CommonResponse<String> ejcCloudSystemCode = proSupplierApi.getEjcCloudSystemCode();
                if (!ejcCloudSystemCode.isSuccess()) {
                    return CommonResponse.error("获取当前系统编码失败" + ejcCloudSystemCode.getMsg());
                }
                //设置当前系统ID
                supplierPushCheckVO.setSystemId(ejcCloudSystemCode.getData());
                String dataInfo = JSONObject.toJSONString(supplierPushCheckVO);
                boolean pushResult = service
                        .pushBillToSupCenter(dataInfo, entity.getSupplierId(), entity.getId(), BILL_TYPE, cooperateResp
                                .getData(), PUSH_SAVE_URL);
                if (!pushResult) {
                    logger.error("单据-{}推送给供应商supplierId-{}失败！", id, entity.getSupplierId());
                    return CommonResponse.error("单据推送供方失败，生成分享连接失败！");
                }
                else {
                    entity.setBillPushFlag(BillPushStatusEnum.推送成功.getStatus());
                    service.saveOrUpdate(entity, false);
                }
            }
        }
        return shareCooperateApi
                .getShareLink(id, BILL_TYPE, entity.getSupplierId().toString(), mobileBillShareFrontUrl, null);
    }


    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<RentAcceptanceVO> vos) {
        service.deletes(vos);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<RentAcceptanceVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("code");
        fuzzyFields.add("projectName");
        fuzzyFields.add("contractName");
        fuzzyFields.add("supplierName");
        fuzzyFields.add("acceptanceUserName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (!param.getParams().containsKey("orgId")) {
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        logger.info("authOrgIds" + authOrgIds);
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            logger.info("移动端" + orgVOList.toString());
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            logger.info("pc端" + orgVOList.toString());
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
//         *//** 要求主表有orgId字段，保存单据所属组织 *//*
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            logger.info("orgId" + commonOrgIds.toString());
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
//            *//** 要求主表有projectDepartmentId字段，保存单据所属项目部 *//*
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
            logger.info("projectDepartmentId" + departmentIds.toString());
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
    }
        IPage<RentAcceptanceEntity> page = service.queryPage(param,false);
        IPage<RentAcceptanceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentAcceptanceVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        logger.info("authOrgIds"+authOrgIds);
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
            logger.info("移动端"+orgVOList.toString());
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
            logger.info("pc端"+orgVOList.toString());
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
//         *//** 要求主表有orgId字段，保存单据所属组织 *//*
            param.getParams().put("parentOrgId", new Parameter(QueryParam.IN, commonOrgIds));
            logger.info("orgId"+commonOrgIds.toString());
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
//            *//** 要求主表有projectDepartmentId字段，保存单据所属项目部 *//*
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
            logger.info("projectDepartmentId"+departmentIds.toString());
        }
        List<RentAcceptanceEntity> list = service.queryList(param);
        List<RentAcceptanceVO> listVo =  new ArrayList<>();
        if (CollectionUtils.isNotEmpty(list)){
            listVo = BeanMapper.mapList(list, RentAcceptanceVO.class);
            for (RentAcceptanceVO rentAcceptanceVO : listVo){
                rentAcceptanceVO.setBillStateName(BillStateEnum.getEnumByStateCode(rentAcceptanceVO.getBillState()).getDescription());
                rentAcceptanceVO.setSignStatusName(rentAcceptanceVO.getSignStatus() == 0 ?"未签字":"已签字");
            }
        }


        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", listVo);
        ExcelExport.getInstance().export("RentAcceptance-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refRentAcceptanceData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RentAcceptanceVO>> refRentAcceptanceData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<RentAcceptanceEntity> page = service.queryPage(param,false);
        IPage<RentAcceptanceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), RentAcceptanceVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }

    /**
     * @Description 参照
     * @Return void 用于安装后验收
     */
    @RequestMapping(value = "/refRentAcceptanceDataDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<RentAcceptanceSubVO>> refRentAcceptanceDataDetail(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                  String condition,
                                                                                  String searchObject,
                                                                                  String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("equipmentAppearanceCode");
        fuzzyFields.add("categoryName");
        fuzzyFields.add("equipmentName");
        fuzzyFields.add("unitName");
        fuzzyFields.add("factoryCode");
        fuzzyFields.add("equipmentCode");
        fuzzyFields.add("specs");
        Long contractId = null;
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.getParams().put("checkAfterFlag", new Parameter(QueryParam.EQ, 0));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            contractId = _con.getLong("contractId");
        }

        if (contractId != null) {
            param.getParams().put("contractId", new Parameter(QueryParam.EQ, contractId));
        } else {
            throw new BusinessException("合同id不能为空！");
        }
        Page<RentAcceptanceSubVO> page = new Page<>((long)param.getPageIndex(), (long)param.getPageSize());
        QueryWrapper wrapper = changeToQueryWrapper(param);
        List<RentAcceptanceSubVO> list = service.refRentAcceptanceDataDetail(page,wrapper);
        IPage<RentAcceptanceSubVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

}
