package com.ejianc.business.proequipmentcorprent.rent.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;

import com.ejianc.business.contractbase.filing.enums.FilingStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractChangeEntity;
import com.ejianc.business.proequipmentcorprent.rent.bean.RentContractEntity;
import com.ejianc.business.proequipmentcorprent.rent.enums.PerformanceStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.enums.SignatureStatusEnum;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentContractChangeService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentContractService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentSignatureService;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentContractVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service("rentSignatureService")
public class RentSignatureServiceImpl implements IRentSignatureService {
    @Autowired
    private IRentContractService contractService;

    @Autowired
    private IRentContractChangeService changeService;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IAttachmentApi attachmentApi;

    @Value("${rentContract.mainContract}")
    private String mainContarct;

    @Value("${rentContract.changeContract}")
    private String changeContract;


    /**
     * 签章流程
     * 单据签章状态修改逻辑
     * 1.主合同若签章状态为已签章，则修改主合同签章状态和合同状态以及生效时间，否则只修改签章状态
     * 2.变更合同
     * 若签章状态为已签章则将变更信息回写主合同，生成变更记录，改变变更合同签章状态
     * 否则改变变更合同签章状态，修改主合同的变更合同签章状态
     *
     * @param id
     * @param signatureStatus
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> changeStatus(Long id, int signatureStatus, String refCode) {
        logger.info("进入签章状态修改流程------------->{}", refCode);
        RentContractEntity contractEntity = contractService.selectById(id);
        if (contractEntity != null) {
            if (signatureStatus == Integer.valueOf(SignatureStatusEnum.已签章.getCode())) {
                contractEntity.setSignatureState(SignatureStatusEnum.已签章.getCode());
                contractEntity.setContractPerformanceState(PerformanceStatusEnum.履约中.getCode());
                contractEntity.setFilingStatus(FilingStatusEnum.已归档.getTypeCode());
                contractEntity.setFilingRef(0);
                contractEntity.setEffectiveDate(new Date());
                // 推送合同池
                contractService.pushContract(BeanMapper.map(contractEntity, RentContractVO.class));
            } else {
                contractEntity.setSignatureState(String.valueOf(signatureStatus));
            }
            contractService.saveOrUpdate(contractEntity, false);

            logger.info("主合同签章状态已修改---------------->");
        } else {
            return CommonResponse.error("找不到合同，请检查合同主键！");
        }

        return CommonResponse.success("签章状态修改成功！");
    }
}