package com.ejianc.business.proequipmentcorprent.temporary.userecord.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.proequipmentcorprent.temporary.userecord.mapper.TemporaryUseRecordSubMapper;
import com.ejianc.business.proequipmentcorprent.temporary.userecord.bean.TemporaryUseRecordSubEntity;
import com.ejianc.business.proequipmentcorprent.temporary.userecord.service.ITemporaryUseRecordSubService;

import java.util.List;

/**
 * 临时设备使用记录-设备明细
 * 
 * @author generator
 * 
 */
@Service("temporaryUseRecordSubService")
public class TemporaryUseRecordSubServiceImpl extends BaseServiceImpl<TemporaryUseRecordSubMapper, TemporaryUseRecordSubEntity> implements ITemporaryUseRecordSubService{

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    /*修对结算状态
           @param: ids 要修改子表id集合
           @param: settleFlag 是否被结算(0-否，1-是)
           */
    @Override
    public void updateSettleFlag(List ids, Integer settleFlag) {
        if(CollectionUtils.isNotEmpty(ids)){
            logger.info("子表键值:"+ JSONObject.toJSONString(ids));
            LambdaQueryWrapper<TemporaryUseRecordSubEntity> wrapper = new LambdaQueryWrapper<>();
            wrapper.in(TemporaryUseRecordSubEntity::getId, ids);
            List<TemporaryUseRecordSubEntity> list = super.list(wrapper);
            if(CollectionUtils.isNotEmpty(list)){
                logger.info("子表数据:"+JSONObject.toJSONString(list));
                list.forEach(item->{
                    item.setSettleFlag(settleFlag);
                });
                super.saveOrUpdateBatch(list, list.size(), false);
                logger.info("修改状态成功--"+JSONObject.toJSONString(list));
            }
        }
    }
}
