/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorpout.order.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.order.api.IRentReceiptsApi;
import com.ejianc.business.order.enums.RentReceiptsEnum;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.business.proequipmentcorpout.order.bean.OutOrderDetailEntity;
import com.ejianc.business.proequipmentcorpout.order.bean.OutOrderEntity;
import com.ejianc.business.proequipmentcorpout.order.mapper.OutOrderMapper;
import com.ejianc.business.proequipmentcorpout.order.service.IOutOrderDetailService;
import com.ejianc.business.proequipmentcorpout.order.service.IOutOrderService;
import com.ejianc.business.proequipmentcorpout.order.vo.CommonConstant;
import com.ejianc.business.proequipmentcorpout.order.vo.OutOrderDetailVO;
import com.ejianc.business.proequipmentcorpout.order.vo.OutOrderVO;
import com.ejianc.business.proequipmentcorpout.outStore.bean.OutStoreDetailEntity;
import com.ejianc.business.proequipmentcorpout.outStore.bean.OutStoreEntity;
import com.ejianc.business.proequipmentcorpout.outStore.service.IOutStoreDetailService;
import com.ejianc.business.proequipmentcorpout.outStore.service.IOutStoreService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="outOrderService")
public class OutOrderServiceImpl
extends BaseServiceImpl<OutOrderMapper, OutOrderEntity>
implements IOutOrderService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOutOrderDetailService detailService;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IOutRentContractService outContractService;
    @Autowired
    private IOutStoreDetailService outStoreDetailService;
    @Autowired
    private IOutStoreService outStoreService;
    @Autowired
    private IRentReceiptsApi receiptsApi;
    private final String FILE_TYPE = "outOrder";
    private static final String OPERATE = "ORDER_BILL_SYNC";
    private static final String BILL_TYPE = "EJCBT202210000055";
    private static final String BILL_NAME = "\u79df\u51fa\u8ba2\u5355";

    @Override
    public void saveOrder(OutOrderVO saveOrUpdateVO) {
        OutRentContractEntity outContractEntity;
        this.logger.info("\u8fdb\u5165\u8ba2\u5355\u4fdd\u5b58\u63a5\u53e3>>>>>>>>>>>>>>>>>>>>>>>>");
        this.logger.info("\u63a5\u6536\u5230\u6570\u636e\uff1a{}", (Object)saveOrUpdateVO);
        OutOrderEntity entity = (OutOrderEntity)((Object)BeanMapper.map((Object)saveOrUpdateVO, OutOrderEntity.class));
        if (CollectionUtils.isEmpty(entity.getOutOrderDetailList())) {
            throw new BusinessException("\u660e\u7ec6\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        OutOrderEntity orderEntity = (OutOrderEntity)((Object)super.selectById((Serializable)saveOrUpdateVO.getId()));
        if (null != orderEntity) {
            this.logger.info("\u5b58\u5728\u76f8\u540csourceID\u7684\u6570\u636e\uff0c\u539f\u6570\u636e:{}", (Object)JSONObject.toJSONString((Object)((Object)orderEntity)));
        }
        entity.setOrderFlag(CommonConstant.ORDER_FlAG_NO);
        entity.setBillState(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        entity.setReceiveState(CommonConstant.ORDER_RECEIVE_WAIT);
        CommonResponse copyContractFileResp = this.attachmentApi.copyFilesFromSourceBillToTargetBill(saveOrUpdateVO.getId().toString(), saveOrUpdateVO.getSourceBillCode(), saveOrUpdateVO.getSourceFileType(), saveOrUpdateVO.getId().toString(), BILL_TYPE, "outOrder");
        if (!copyContractFileResp.isSuccess()) {
            this.logger.info("\u540c\u6b65\u9644\u4ef6\u5931\u8d25--------------->srcBillId-{},srcBillTypeCode-{},srcSourceType-{},targetBillId-{},targetBillTypeCode-{},targetSourceType-{},\uff1a{}", new Object[]{saveOrUpdateVO.getId(), saveOrUpdateVO.getSourceBillCode(), saveOrUpdateVO.getSourceFileType(), saveOrUpdateVO.getId(), BILL_TYPE, "outOrder", copyContractFileResp.getMsg()});
            this.logger.info("\u540c\u6b65\u9644\u4ef6\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\uff1a" + copyContractFileResp.getMsg());
        }
        if (null == (outContractEntity = (OutRentContractEntity)((Object)this.outContractService.selectById(entity.getContractId())))) {
            throw new BusinessException("\u67e5\u8be2\u5408\u540c\u5931\u8d25\uff01");
        }
        entity.setRentHarborType(outContractEntity.getRentHarborType());
        entity.setRentOrgId(outContractEntity.getRentOrgId());
        entity.setRentOrgCode(outContractEntity.getRentOrgCode());
        entity.setRentOrgName(outContractEntity.getRentOrgName());
        entity.setRentProjectAddr(outContractEntity.getRentProjectAddr());
        entity.setRentProjectCode(outContractEntity.getRentProjectCode());
        entity.setRentProjectId(outContractEntity.getRentProjectId());
        entity.setRentProjectName(outContractEntity.getRentProjectName());
        entity.setRentProjectType(outContractEntity.getRentProjectType());
        entity.setOutOrgId(outContractEntity.getOutOrgId());
        entity.setOutOrgCode(outContractEntity.getOutOrgCode());
        entity.setOutOrgName(outContractEntity.getOutOrgName());
        boolean flag = super.saveOrUpdate((Object)entity, false);
        if (!flag) {
            throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff01");
        }
        this.logger.info("\u4fdd\u5b58\u6210\u529f\uff0c\u8ba2\u5355\u4fdd\u5b58\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<<<<<<<<<<");
    }

    @Override
    public void deleteOrder(OutOrderVO vo) {
        boolean flag;
        this.logger.info("\u8fdb\u5165\u65bd\u5de5\u65b9\u64a4\u56de\u8ba2\u5355\u63a5\u53e3>>>>>>>>>>>>>>>>>>>");
        this.logger.info("\u63a5\u6536\u5230\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)vo));
        if (null == vo.getId()) {
            throw new BusinessException("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        OutOrderEntity orderEntity = (OutOrderEntity)((Object)super.selectById((Serializable)vo.getId()));
        if (null == orderEntity) {
            throw new BusinessException("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (!CommonConstant.ORDER_RECEIVE_WAIT.equals(orderEntity.getReceiveState())) {
            throw new BusinessException("\u8ba2\u5355\u5df2\u88ab\u5904\u7406\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        CommonResponse fileResp = this.attachmentApi.queryListBySourceId(orderEntity.getId(), BILL_TYPE, "outOrder", null);
        if (fileResp.isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)fileResp.getData()))) {
            this.logger.info("\u5220\u9664\u6587\u4ef6\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)fileResp.getData()));
            String ids = ((List)fileResp.getData()).stream().map(AttachmentVO::getId).map(String::valueOf).collect(Collectors.joining(","));
            this.attachmentApi.delete(ids);
        }
        boolean bl = flag = ((OutOrderMapper)this.baseMapper).deleteOrder(vo.getId()) != false && this.detailService.deleteOrderDetailByOrderId(vo.getId()) != false;
        if (!flag) {
            throw new BusinessException("\u5220\u9664\u5931\u8d25\uff01");
        }
        this.logger.info("\u65bd\u5de5\u65b9\u64a4\u56de\u8ba2\u5355\u6210\u529f<<<<<<<<<<<<<<<<<<<<<<<");
    }

    @Override
    public String updateOrderCloseFlag(OutOrderVO vo) {
        this.logger.info("\u8fdb\u5165\u65bd\u5de5\u65b9\u5173\u95ed\u8ba2\u5355\u63a5\u53e3>>>>>>>>>>>>>>>>>>>");
        this.logger.info("\u63a5\u6536\u5230\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)vo));
        if (null == vo.getId()) {
            throw new BusinessException("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        OutOrderEntity orderEntity = (OutOrderEntity)((Object)super.selectById((Serializable)vo.getId()));
        if (CommonConstant.ORDER_FlAG_YES.equals(orderEntity.getOrderFlag())) {
            throw new BusinessException("\u8ba2\u5355\u5df2\u88ab\u5173\u95ed\uff01");
        }
        StringBuilder errorBillCode = new StringBuilder();
        QueryParam queryParam = new QueryParam();
        queryParam.getParams().put("orderId", new Parameter("eq", (Object)orderEntity.getId()));
        List orderDeliveryEntities = this.outStoreDetailService.queryList(queryParam);
        Map<Long, List<OutStoreDetailEntity>> collect = orderDeliveryEntities.stream().collect(Collectors.groupingBy(OutStoreDetailEntity::getDeliveryId));
        if (MapUtils.isNotEmpty(collect)) {
            Set<Long> longs = collect.keySet();
            ArrayList<Integer> integers = new ArrayList<Integer>();
            integers.add(1);
            integers.add(3);
            QueryParam param = new QueryParam();
            param.getParams().put("id", new Parameter("in", longs));
            param.getParams().put("billState", new Parameter("ne", integers));
            List outDeliveryEntities = this.outStoreService.queryList(param);
            if (CollectionUtils.isNotEmpty((Collection)outDeliveryEntities)) {
                errorBillCode.append("\u53d1\u8d27\u5355[");
                this.logger.error("\u5b58\u5728\u672a\u751f\u6548\u7684\u9001\u8d27\u5355\uff0c\u9001\u8d27\u5355\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)outDeliveryEntities));
                for (OutStoreEntity outDeliveryEntity : outDeliveryEntities) {
                    errorBillCode.append(outDeliveryEntity.getBillCode()).append(",");
                }
                errorBillCode.delete(errorBillCode.length() - 1, errorBillCode.length());
                errorBillCode.append("]\u8fd8\u672a\u5b8c\u6210\u9a8c\u6536\u6216\u5173\u95ed\uff0c\u4e0d\u80fd\u5173\u95ed\u8ba2\u5355");
            }
        }
        orderEntity.setOrderFlag(CommonConstant.ORDER_FlAG_YES);
        boolean b = super.saveOrUpdate((Object)orderEntity, false);
        if (!b) {
            throw new BusinessException("\u8ba2\u5355\u5173\u95ed\u5f02\u5e38\uff01");
        }
        this.logger.info("\u65bd\u5de5\u65b9\u5173\u95ed\u8ba2\u5355\u6210\u529f>>>>>>>>>>>>>>>>>>>");
        return errorBillCode.toString();
    }

    @Override
    public OutOrderVO saveOrUpdate(OutOrderVO saveOrUpdateVO) {
        if (saveOrUpdateVO.getId() == null) {
            throw new BusinessException("\u8ba2\u5355\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
        if (saveOrUpdateVO.getReceiveState() == null || CommonConstant.ORDER_RECEIVE_STATE.get(saveOrUpdateVO.getReceiveState()) == null) {
            throw new BusinessException("\u63a5\u6536\u7c7b\u578b\u4e0d\u6b63\u786e");
        }
        OutOrderEntity entity = (OutOrderEntity)((Object)super.selectById((Serializable)saveOrUpdateVO.getId()));
        entity.setSupOperatorName(saveOrUpdateVO.getSupOperatorName());
        entity.setSupOperateTime(saveOrUpdateVO.getSupOperateTime());
        entity.setSupOperatorPhone(saveOrUpdateVO.getSupOperatorPhone());
        entity.setSupOperatorUserCode(saveOrUpdateVO.getSupOperatorUserCode());
        entity.setReceiveReason(saveOrUpdateVO.getReceiveReason());
        entity.setReceiveState(saveOrUpdateVO.getReceiveState());
        if (!CommonConstant.ORDER_RECEIVE_NOT.equals(saveOrUpdateVO.getReceiveState()) && CollectionUtils.isEmpty((Collection)saveOrUpdateVO.getOutOrderDetailList())) {
            throw new BusinessException("\u6e05\u5355\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashMap<Long, BigDecimal> voReceiveMap = new HashMap<Long, BigDecimal>();
        for (OutOrderDetailVO detailVO : saveOrUpdateVO.getOutOrderDetailList()) {
            voReceiveMap.put(detailVO.getId(), detailVO.getReceiveNumsSum());
        }
        if (CollectionUtils.isNotEmpty(entity.getOutOrderDetailList())) {
            for (OutOrderDetailEntity detail : entity.getOutOrderDetailList()) {
                if (CommonConstant.ORDER_RECEIVE_ALL.equals(saveOrUpdateVO.getReceiveState())) {
                    detail.setReceiveNumsSum(detail.getOrderNumsSum());
                } else if (CommonConstant.ORDER_RECEIVE_PART.equals(saveOrUpdateVO.getReceiveState())) {
                    detail.setReceiveNumsSum(ComputeUtil.safeAdd((BigDecimal)((BigDecimal)voReceiveMap.get(detail.getId())), (BigDecimal)BigDecimal.ZERO));
                } else if (CommonConstant.ORDER_RECEIVE_NOT.equals(saveOrUpdateVO.getReceiveState())) {
                    detail.setReceiveNumsSum(BigDecimal.ZERO);
                }
                detail.setNotDeliveredNumsSum(detail.getReceiveNumsSum());
                detail.setDeliverNumsSum(BigDecimal.ZERO);
            }
            entity.setDeliverState(CommonConstant.ORDER_DELIVER_WAIT);
        }
        this.logger.info("\u5f00\u59cb\u901a\u77e5\u65bd\u5de5\u65b9\u8ba2\u5355\u4fe1\u606f>>>>>>>>>>>>>>>>>>>");
        OutOrderVO vo = new OutOrderVO();
        vo.setId(entity.getId());
        vo.setReceiveState(entity.getReceiveState());
        ArrayList<OutOrderDetailVO> detailList = new ArrayList<OutOrderDetailVO>();
        for (OutOrderDetailEntity detail : entity.getOutOrderDetailList()) {
            OutOrderDetailVO detailVO = new OutOrderDetailVO();
            detailVO.setId(detail.getId());
            detailVO.setOrderId(detail.getOrderId());
            detailVO.setReceiveNumsSum(detail.getReceiveNumsSum());
            detailList.add(detailVO);
        }
        vo.setOutOrderDetailList(BeanMapper.mapList(detailList, OutOrderDetailVO.class));
        vo.setRentOrderDetailList(BeanMapper.mapList(detailList, OutOrderDetailVO.class));
        this.logger.info("\u63a8\u9001\u6570\u636e\uff1a" + JSONObject.toJSONString((Object)vo));
        CommonResponse response = this.receiptsApi.receiptsSync(JSONObject.parseObject((String)JSONObject.toJSONString((Object)vo)), RentReceiptsEnum.\u79df\u8d41\u8ba2\u5355.getName());
        if (!response.isSuccess()) {
            throw new BusinessException(response.getMsg());
        }
        this.logger.info("\u901a\u77e5\u65bd\u5de5\u65b9\u8ba2\u5355\u4fe1\u606f\u7ed3\u675f<<<<<<<<<<<<<<<<<<<<<<");
        super.saveOrUpdate((Object)entity, false);
        OutOrderVO orderVO = (OutOrderVO)BeanMapper.map((Object)((Object)entity), OutOrderVO.class);
        return orderVO;
    }
}

