package com.ejianc.business.proequipmentcorpout.outStore.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.contractpub.util.BeanConvertorUtil;
import com.ejianc.business.order.api.IRentReceiptsApi;
import com.ejianc.business.order.enums.RentReceiptsEnum;
import com.ejianc.business.proequipmentcorpout.constants.RentOutParamSourceBillTypeEnum;
import com.ejianc.business.proequipmentcorpout.constants.RentOutStatusEnum;
import com.ejianc.business.proequipmentcorpout.contract.bean.OutRentContractEntity;
import com.ejianc.business.proequipmentcorpout.contract.service.IOutRentContractService;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterDetailEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterDetailService;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterService;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterDetailVO;
import com.ejianc.business.proequipmentcorpout.outLedger.vo.OutRentParameterVO;
import com.ejianc.business.proequipmentcorpout.outStore.bean.OutStoreDetailEntity;
import com.ejianc.business.proequipmentcorpout.outStore.bean.OutStoreEntity;
import com.ejianc.business.proequipmentcorpout.outStore.enums.RequireFlagEnum;
import com.ejianc.business.proequipmentcorpout.outStore.enums.WeighFlagEnum;
import com.ejianc.business.proequipmentcorpout.outStore.service.IOutStoreService;
import com.ejianc.business.proequipmentcorpout.outStore.vo.OutStoreDetailVO;
import com.ejianc.business.proequipmentcorpout.outStore.vo.OutStoreVO;
import com.ejianc.business.proequipmentcorpout.outrent.Enums.OutRentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetEntity;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetService;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentAcceptanceVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;


@Service("outStore")
public class OutStoreBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IOutStoreService service;
	@Autowired
	private IOutRentParameterService outRentParameterService;
	@Autowired
	private IOutRentParameterDetailService outRentParameterDetailService;
	@Autowired
	private IOutRentContractService outRentContractService;
	@Autowired
	private IRentReceiptsApi rentReceiptsApi;


	@Autowired
	private IAssetService assetService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		OutStoreEntity outStoreEntity = service.selectById(billId);
		if (outStoreEntity.getWeighFlag().equals(WeighFlagEnum.是.getCode())){
			if (outStoreEntity.getRequireFlag().equals(RequireFlagEnum.否.getCode())){
				return CommonResponse.error("地磅称重不符合要求,无法提交");
			}
		}
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		if (state == 0){
			OutStoreEntity outStoreEntity = service.selectById(billId);
			if (outStoreEntity.getWeighFlag().equals(WeighFlagEnum.是.getCode())){
				if (outStoreEntity.getRequireFlag().equals(RequireFlagEnum.否.getCode())){
					return CommonResponse.error("地磅称重不符合要求,无法提交");
				}
			}
		}

		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		OutStoreEntity entity = service.selectById(billId);
		OutStoreVO outStoreVO = BeanMapper.map(entity, OutStoreVO.class);
		OutRentParameterVO pushParamVO = null;
		OutRentContractEntity contract = outRentContractService.selectById(entity.getContractId());

		List<OutRentParameterVO> saveList = new ArrayList<>();
		for(OutStoreDetailVO outStoreDetailVO : outStoreVO.getOutStoreDetailList()) {
			//推送租出台账
			try {
				pushParamVO = BeanConvertorUtil.convert(outStoreVO, OutRentParameterVO.class);
				logger.info("pushParamVO: {}", JSONObject.toJSONString(pushParamVO));
			} catch (Exception e) {
				logger.error("出库单推送租出设备台账失败, 出库转换台账单异常: ", e);
				return CommonResponse.error("出库单推送租出设备台账失败！");
			}

			//维护设备信息
			//出厂编码
			pushParamVO.setFactoryCode(outStoreDetailVO.getEquipLeaveFactoryCode());
			//单据审批状态设置为生效
			pushParamVO.setBillState(1);
			//设备基本信息
			pushParamVO.setCategoryId(outStoreDetailVO.getMaterialTypeId());
			pushParamVO.setCategoryName(outStoreDetailVO.getMaterialTypeName());
			pushParamVO.setEquipmentId(outStoreDetailVO.getMaterialId());
			pushParamVO.setEquipmentCode(outStoreDetailVO.getMaterialCode());
			pushParamVO.setEquipmentName(outStoreDetailVO.getMaterialName());
			pushParamVO.setUnitId(outStoreDetailVO.getRentUnitId());
			pushParamVO.setUnitName(outStoreDetailVO.getRentUnitName());
			//计租日期
			pushParamVO.setMeterRentDate(outStoreDetailVO.getRentDetailDate());
			//计租方式
			pushParamVO.setMeterRentType(outStoreDetailVO.getRentCalculationType());
			//设备状态
			pushParamVO.setEquipmentState(OutRentEquipmentStateEnum.启用.getCode());
			pushParamVO.setEquipmentStateName(OutRentEquipmentStateEnum.启用.getDescription());
			//使用状态- 在用
            pushParamVO.setUseType(2);
			//设备台账Id
			pushParamVO.setEquipLedgerId(outStoreDetailVO.getStoreEquipId());
			//设备台账出厂编码
			pushParamVO.setEquipLedgerFactoryCode(outStoreDetailVO.getStoreEquipCode());

			//使用项目-- 从出库单的项目信息获取
			pushParamVO.setUseProjectCode(pushParamVO.getProjectCode());
			pushParamVO.setUseProjectId(pushParamVO.getProjectId());
			pushParamVO.setUseProjectName(pushParamVO.getProjectName());
			pushParamVO.setUseOrgCode(pushParamVO.getUseOrgCode());
			pushParamVO.setUseOrgName(pushParamVO.getUseOrgName());
			pushParamVO.setUseOrgId(pushParamVO.getUseOrgId());
			//合同供应商
			pushParamVO.setSupplierId(contract.getSupplierId());
			pushParamVO.setSupplierName(contract.getSupplierName());
			pushParamVO.setSourceId(outStoreVO.getId());
			pushParamVO.setSourceBillType(entity.getRentHarborType() == 0 ? RentOutParamSourceBillTypeEnum.设备租出自购.getCode() : RentOutParamSourceBillTypeEnum.设备租出租赁.getCode());

			pushParamVO.setMemo(outStoreDetailVO.getMemo());

			//合同税率
			pushParamVO.setContractTaxRate(contract.getContractTax());
			pushParamVO.setContractCode(contract.getContractCode());

			OutRentParameterDetailVO paramDetailVO = new OutRentParameterDetailVO();
			paramDetailVO.setEquipmentState(OutRentEquipmentStateEnum.启用.getCode());
			paramDetailVO.setOperationDate(outStoreDetailVO.getRentDetailDate());
			paramDetailVO.setSourceId(outStoreDetailVO.getId());
			paramDetailVO.setSourceType(OutRentParameterDetailVO.SOURCE_TYPE_OUT_STORE); //出库单

			List<OutRentParameterDetailVO> paramSubList =new ArrayList<>();
			paramSubList.add(paramDetailVO);
			pushParamVO.setRentParameterDetailList(paramSubList);
			logger.info("pushParamVO: {}", JSONObject.toJSONString(pushParamVO));

			saveList.add(pushParamVO);
		}

		//修改设备绑定的仓库设备状态，将其设备状态改为再用，租出状态改为启用
		QueryWrapper<AssetEntity> assetQuery = new QueryWrapper<>();
		assetQuery.in("id", entity.getOutStoreDetailList().stream().map(OutStoreDetailEntity::getStoreEquipId).collect(Collectors.toList()));
			List<AssetEntity> assetEntities = assetService.list(assetQuery);
		for(AssetEntity asset : assetEntities) {
			asset.setRentState(1); //租出状态为启用
			asset.setEquipmentStatus(1); //设置状态为在用
			if(StringUtils.isBlank(asset.getProjectName())) {
				asset.setProjectId(entity.getProjectId());
				asset.setProjectName(entity.getProjectName());
			}
		}

		outRentParameterService.saveOrUpdateOutRentParams(saveList);
		if(entity.getRentHarborType() == 1) { //内租 推项目验收
            JSONObject data = JSONObject.parseObject(JSONObject.toJSONString(BeanMapper.map(entity, RentAcceptanceVO.class)));
			data.put("orgId", outStoreVO.getOutOrgId());// 项目部Id
			data.put("orgCode", outStoreVO.getOutOrgCode());//项目部编码
			data.put("orgName", outStoreVO.getOutOrgName()); //项目部名称
			data.put("outOrgId", outStoreVO.getOrgId());// 租出单位Id
			data.put("outOrgCode", outStoreVO.getOrgCode());//租出单位编码
			data.put("outOrgName", outStoreVO.getOrgName()); //租出单位名称
            data.put("supplierId", contract.getSupplierId());// 供应商
            data.put("supplierName", contract.getSupplierName());//供应商
            data.put("acceptanceDate", entity.getOutstoreDate()); //验收日期
            data.put("acceptanceUserName", entity.getEmployeeName()); //验收人名称
            data.put("acceptanceUserId", entity.getEmployeeId()); //验收人Id
            data.put("rentDate", entity.getRentDate()); //计租日期
            data.put("acceptanceSource", "出库单["+entity.getId().toString()+"]"); //验收来源 1-自制,2-送货单
            data.put("acceptanceSourceId", 1); //验收来源
            data.put("sourceType", 0); //验收来源，0-自制验收,1-发货验收
            data.put("signStatus", 0); //签字状态：0-未签字,1-已签字
            data.put("carCode", entity.getLicensePlate()); //车牌号
            data.put("companyId", entity.getParentOrgId()); //所属单位Id
            data.put("companyName", entity.getParentOrgName()); //所属单位名称
            data.put("rentType", 1); //租赁方式(0-外租，1-内租)

			CommonResponse<String> response = rentReceiptsApi.receiptsSync(data, RentReceiptsEnum.验收单.getName());
			if(!response.isSuccess()){
				logger.error("内租出库单推项目验收失败：{}", JSONObject.toJSONString(response));
				throw new BusinessException(response.getMsg());
			}
		}

		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		OutStoreEntity entity = service.selectById(billId);


		//查询对应租出台账
		QueryWrapper<OutRentParameterEntity> query = new QueryWrapper<>();
		query.eq("source_id", billId);
		query.eq("dr", BaseVO.DR_UNDELETE);
		OutRentParameterEntity outRentParameterEntity = outRentParameterService.getOne(query);

		QueryWrapper<OutRentParameterDetailEntity> detailQuery = new QueryWrapper<>();
		detailQuery.eq("parameter_id", outRentParameterEntity.getId());
		detailQuery.ne("source_type", OutRentParameterDetailVO.SOURCE_TYPE_OUT_STORE);

		List<OutRentParameterDetailEntity> list = outRentParameterDetailService.list(detailQuery);
		if(CollectionUtils.isNotEmpty(list)) {
			return CommonResponse.error("弃审失败，设备已进行下游业务！");
		}

		String result = outRentParameterService.removeBySourceId(entity.getId(), entity.getRentHarborType() == 0 ? RentOutParamSourceBillTypeEnum.设备租出自购.getCode() : RentOutParamSourceBillTypeEnum.设备租出租赁.getCode());
		if(StringUtils.isNotBlank(result)) {
			return CommonResponse.error("弃审失败，删除租出台账失败，原因："+result);
		}

		// 内阻推送供方
		if(entity.getRentHarborType() == 1) { //内租 删除掉推送的验收单
			//修改设备绑定的仓库设备状态，将其设备状态改为闲置，租出状态改为停用
			assetService.updateEquipState(entity.getOutStoreDetailList().stream().map(OutStoreDetailEntity::getStoreEquipId).collect(Collectors.toList()),
					3, 2);

			CommonResponse<String> response = rentReceiptsApi.delReceipts(entity.getId(), RentReceiptsEnum.验收单.getName());
			if (!response.isSuccess()) {
				logger.error("出库单弃审异常，删除内租验收单失败：{}", JSONObject.toJSONString(response));
				throw new BusinessException(response.getMsg());
			}
		}

		return CommonResponse.success("操作成功！");
	}

}
