package com.ejianc.business.proequipmentcorpout.outrent.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 设备租出-设备停用
 * 
 * @author generator
 * 
 */
 @TableName("ejc_outequipmentcorp_rent_equipment_stop")
public class OutRentEquipmentStopEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="code")
    private String code; // 单据编号
    @TableField(value="name")
    private String name; // 费用项目名称
    @TableField(value="bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_name")
    private String contractName; // 合同名称
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="company_id")
    private Long companyId; // 所属单位id
    @TableField(value="company_name")
    private String companyName; // 所属单位名称
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="employee_id")
    private Long employeeId; // 经办人
    @TableField(value="employee_name")
    private String employeeName; // 经办人名称
    @TableField(value="type_date")
    private Date typeDate; // 启动时间
    @TableField(value="memo")
    private String memo; // 备注
    @TableField(value="sign_state")
    private Integer signState; // 签字状态:1--未签字,2---已签字
    @TableField(value="organization_date")
    private Date organizationDate; // 编制日期
    @TableField(value="type")
    private Integer type; // 状态:1---启用---2--停用
    @TableField(value="acceptance_id")
    private Long acceptanceId;//验收单id

    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部ID
    @TableField(value="project_department_name")
    private String projectDepartmentName; // 项目部名称

    @TableField(value="project_code")
    private String projectCode; // 项目编号
    @TableField(value="org_id")
    private Long orgId; // 组织id
    @TableField(value="org_name")
    private String orgName; // 项目部名称
    @TableField(value="parent_org_id")
    private Long parentOrgId; // 项目部上级组织Id
    @TableField(value="parent_org_name")
    private String parentOrgName; // 项目部上级组织名称
    @TableField(value="parent_org_code")
    private String parentOrgCode; // 项目部上级组织编码
    @TableField(value="org_code")
    private String orgCode; // 项目部编码
    /**
     * 单据推送标识：unSucPush-未成功推送供方，sucPushed-已成功推送供方
     */
    @TableField(value = "bill_push_flag")
    private String billPushFlag;
    /**
     * 供方经办人名称
     */
    @TableField(value = "sup_operator_name")
    private String supOperatorName;

    /**
     * 供方经办人手机号
     */
    @TableField(value = "sup_operator_phone")
    private String supOperatorPhone;

    /**
     * 供方经办人账号
     */
    @TableField(value = "sup_operator_user_code")
    private String supOperatorUserCode;

    /**
     * 供方经办人签字时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    @TableField(value = "sup_operate_time")
    private Date supOperateTime;
    @TableField(value="sign_status")
    private Integer signStatus; // 签字状态，0-未签字,1-已签字

    @TableField(value="rent_project_code")
    private String rentProjectCode; // 所属项目编号
    @TableField(value="rent_project_id")
    private Long rentProjectId; // 所属项目id
    @TableField(value="rent_project_name")
    private String rentProjectName; // 所属项目

    @TableField(value="rent_org_code")
    private String rentOrgCode; // 所属组织编号
    @TableField(value="rent_org_id")
    private Long rentOrgId; // 所属组织id
    @TableField(value="rent_org_name")
    private String rentOrgName; // 所属组织
    @TableField(value="rent_project_type")
    private Integer rentProjectType; // 项目类别，0-内部项目,1-外部项目
    @TableField(value="rent_project_addr")
    private String rentProjectAddr; // 所属项目地址
    @TableField("rent_harbor_type")
    private Integer rentHarborType;//0-外租 1-内租

    /**
     * 租赁方/合同甲方id
     */
    @TableField("first_party_id")
    private Long firstPartyId;
    /**
     * 租赁方/合同甲方名称
     */
    @TableField("first_party_name")
    private String firstPartyName;
    /**
     * 租出单位主键
     */
    @TableField("out_org_id")
    private Long outOrgId;
    /**
     * 租出单位名称
     */
    @TableField("out_org_name")
    private String outOrgName;
    /**
     * 租出单位编码
     */
    @TableField("out_org_code")
    private String outOrgCode;

    /**
     * 供方经办人签字文件id
     */
    @TableField(exist = false)
    private Long supOperateFileId;
    @TableField(exist=false)
    @SubEntity(serviceName="outRentEquipmentStopSubService")
    private List<OutRentEquipmentStopSubEntity> outRentEquipmentStopSubList = new ArrayList<>(); // 租赁设备停用明细

    public String getRentProjectCode() {
        return rentProjectCode;
    }

    public void setRentProjectCode(String rentProjectCode) {
        this.rentProjectCode = rentProjectCode;
    }

    public Long getRentProjectId() {
        return rentProjectId;
    }

    public void setRentProjectId(Long rentProjectId) {
        this.rentProjectId = rentProjectId;
    }

    public String getRentProjectName() {
        return rentProjectName;
    }

    public void setRentProjectName(String rentProjectName) {
        this.rentProjectName = rentProjectName;
    }

    public String getRentOrgCode() {
        return rentOrgCode;
    }

    public void setRentOrgCode(String rentOrgCode) {
        this.rentOrgCode = rentOrgCode;
    }

    public Long getRentOrgId() {
        return rentOrgId;
    }

    public void setRentOrgId(Long rentOrgId) {
        this.rentOrgId = rentOrgId;
    }

    public String getRentOrgName() {
        return rentOrgName;
    }

    public void setRentOrgName(String rentOrgName) {
        this.rentOrgName = rentOrgName;
    }

    public Integer getRentProjectType() {
        return rentProjectType;
    }

    public void setRentProjectType(Integer rentProjectType) {
        this.rentProjectType = rentProjectType;
    }

    public String getRentProjectAddr() {
        return rentProjectAddr;
    }

    public void setRentProjectAddr(String rentProjectAddr) {
        this.rentProjectAddr = rentProjectAddr;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }

    public String getSupOperatorName() {
        return supOperatorName;
    }

    public void setSupOperatorName(String supOperatorName) {
        this.supOperatorName = supOperatorName;
    }

    public String getSupOperatorPhone() {
        return supOperatorPhone;
    }

    public void setSupOperatorPhone(String supOperatorPhone) {
        this.supOperatorPhone = supOperatorPhone;
    }

    public String getSupOperatorUserCode() {
        return supOperatorUserCode;
    }

    public void setSupOperatorUserCode(String supOperatorUserCode) {
        this.supOperatorUserCode = supOperatorUserCode;
    }

    public Date getSupOperateTime() {
        return supOperateTime;
    }

    public void setSupOperateTime(Date supOperateTime) {
        this.supOperateTime = supOperateTime;
    }

    public Long getSupOperateFileId() {
        return supOperateFileId;
    }

    public void setSupOperateFileId(Long supOperateFileId) {
        this.supOperateFileId = supOperateFileId;
    }

    public String getBillPushFlag() {
        return billPushFlag;
    }

    public void setBillPushFlag(String billPushFlag) {
        this.billPushFlag = billPushFlag;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getContractId() {
        return contractId;
    }

    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getCompanyId() {
        return companyId;
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }
    public String getCompanyName() {
        return companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }
    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    public Long getEmployeeId() {
        return employeeId;
    }

    public void setEmployeeId(Long employeeId) {
        this.employeeId = employeeId;
    }
    public String getEmployeeName() {
        return employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public Date getTypeDate() {
        return typeDate;
    }

    public void setTypeDate(Date typeDate) {
        this.typeDate = typeDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public List<OutRentEquipmentStopSubEntity> getOutRentEquipmentStopSubList() {
        return outRentEquipmentStopSubList;
    }

    public void setOutRentEquipmentStopSubList(List<OutRentEquipmentStopSubEntity> outRentEquipmentStopSubList) {
        this.outRentEquipmentStopSubList = outRentEquipmentStopSubList;
    }

    public Integer getSignState() {
        return signState;
    }

    public void setSignState(Integer signState) {
        this.signState = signState;
    }

    public Date getOrganizationDate() {
        return organizationDate;
    }

    public void setOrganizationDate(Date organizationDate) {
        this.organizationDate = organizationDate;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Long getAcceptanceId() {
        return acceptanceId;
    }

    public void setAcceptanceId(Long acceptanceId) {
        this.acceptanceId = acceptanceId;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public String getProjectDepartmentName() {
        return projectDepartmentName;
    }

    public void setProjectDepartmentName(String projectDepartmentName) {
        this.projectDepartmentName = projectDepartmentName;
    }

    public Integer getRentHarborType() {
        return rentHarborType;
    }

    public void setRentHarborType(Integer rentHarborType) {
        this.rentHarborType = rentHarborType;
    }

    public Long getFirstPartyId() {
        return firstPartyId;
    }

    public void setFirstPartyId(Long firstPartyId) {
        this.firstPartyId = firstPartyId;
    }

    public String getFirstPartyName() {
        return firstPartyName;
    }

    public void setFirstPartyName(String firstPartyName) {
        this.firstPartyName = firstPartyName;
    }

    public Long getOutOrgId() {
        return outOrgId;
    }

    public void setOutOrgId(Long outOrgId) {
        this.outOrgId = outOrgId;
    }

    public String getOutOrgName() {
        return outOrgName;
    }

    public void setOutOrgName(String outOrgName) {
        this.outOrgName = outOrgName;
    }

    public String getOutOrgCode() {
        return outOrgCode;
    }

    public void setOutOrgCode(String outOrgCode) {
        this.outOrgCode = outOrgCode;
    }
}
