package com.ejianc.business.proequipmentcorpout.outrent.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.order.api.IRentReceiptsApi;
import com.ejianc.business.order.enums.RentReceiptsEnum;
import com.ejianc.business.proequipmentcorpout.contract.enums.RentParameterTypeEnum;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterDetailEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.bean.OutRentParameterEntity;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterDetailService;
import com.ejianc.business.proequipmentcorpout.outLedger.service.IOutRentParameterService;
import com.ejianc.business.proequipmentcorpout.outrent.Enums.OutRentEquipmentStateEnum;
import com.ejianc.business.proequipmentcorpout.outrent.bean.OutRentEquipmentStopEntity;
import com.ejianc.business.proequipmentcorpout.outrent.bean.OutRentEquipmentStopSubEntity;
import com.ejianc.business.proequipmentcorpout.outrent.service.IOutRentEquipmentStopService;
import com.ejianc.business.proequipmentcorpout.outrent.vo.OutRentEquipmentStopSubVO;
import com.ejianc.business.proequipmentcorpout.outrent.vo.OutRentEquipmentStopVO;
import com.ejianc.business.proequipmentcorppur.asset.bean.AssetEntity;
import com.ejianc.business.proequipmentcorppur.asset.service.IAssetService;
import com.ejianc.business.proequipmentcorprent.rent.service.IRentAcceptanceService;
import com.ejianc.foundation.share.api.IProSupplierApi;
import com.ejianc.foundation.share.api.IShareCooperateApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

@Service("outRentEquipmentStop")
public class OutRentEquipmentStopBpmServiceImpl implements ICommonBusinessService {
	@Autowired
	private IOutRentParameterService outRentParameterService;
	@Autowired
	private IOutRentEquipmentStopService stopService;
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IOutRentEquipmentStopService outRentEquipmentStopService;
	@Autowired
	private IShareCooperateApi shareCooperateApi;
	@Autowired
	private IOutRentParameterDetailService outRentParameterDetailService;
	@Autowired
	private IProSupplierApi proSupplierApi;
	private final String PUSH_DELETE_URL = "/ejc-supbusiness-web/openapi/equipmentStop/deleteStop";
	private final String OPERATE = "RENT-PROEQUIPMENT-ASTOP";
	@Autowired
	private IRentAcceptanceService rentAcceptanceService;
	private static final String BILL_TYPE = "BT220221000000004";//停用单 单据类型
	private static final String PUSH_SAVE_URL = "/ejc-supbusiness-web/openapi/equipmentStop/saveStop";

	@Autowired
	private IRentReceiptsApi receiptsApi;
	@Autowired
	private IAssetService assetService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//更新台账租出状态
		OutRentEquipmentStopEntity entity = outRentEquipmentStopService.selectById(billId);

		List<OutRentEquipmentStopSubEntity> subEntityList = entity.getOutRentEquipmentStopSubList();
		List<OutRentParameterEntity> parameterList = new ArrayList<>();
		for(OutRentEquipmentStopSubEntity subEntity:subEntityList) {
			// 主表赋值
			OutRentParameterEntity parameterEntity = new OutRentParameterEntity();
			parameterEntity.setId(subEntity.getSourceId());
			parameterEntity.setStopDate(entity.getTypeDate());
			parameterEntity.setOperationDate(new Date());
			parameterEntity.setEquipmentState(OutRentEquipmentStateEnum.停用.getCode());//启动状态
			parameterEntity.setEquipmentStateName(OutRentEquipmentStateEnum.停用.getDescription());//启动状态
			// 处理子表
			List<OutRentParameterDetailEntity> parameterDetailList = new ArrayList<>();
			OutRentParameterDetailEntity detailEntity = new OutRentParameterDetailEntity();
			detailEntity.setSourceType(RentParameterTypeEnum.停用单.getCode());
			detailEntity.setSourceId(entity.getId());
			detailEntity.setOperationDate(subEntity.getTypeDate());
			detailEntity.setEquipmentState(OutRentEquipmentStateEnum.停用.getCode());
			detailEntity.setParameterId(subEntity.getSourceId());
			parameterDetailList.add(detailEntity);

			parameterEntity.setRentParameterDetailList(parameterDetailList);
			parameterList.add(parameterEntity);
		}
		logger.info("推送台账数据parameterList：{}", JSONObject.toJSONString(parameterList));
		outRentParameterService.changeParameter(parameterList, RentParameterTypeEnum.停用单.getCode());

		//判断是否自购设备，是：修改自有设备台账设备 停启用状态
		List<Long> outRentParameterIds = subEntityList.stream().map(OutRentEquipmentStopSubEntity::getSourceId).collect(Collectors.toList());
		List<OutRentParameterEntity> outRentParameterEntityList = (List<OutRentParameterEntity>) outRentParameterService.listByIds(outRentParameterIds);
		if (CollectionUtils.isNotEmpty(outRentParameterEntityList)){
			logger.info("通过停用子表：{}，取到租出设备台账数据：{}", JSONObject.toJSONString(subEntityList), JSONObject.toJSONString(outRentParameterEntityList));
			List<Long> equipLedgerIds = outRentParameterEntityList.stream().filter(item -> item.getSourceType() == 0).map(OutRentParameterEntity::getEquipLedgerId).collect(Collectors.toList());
			if (CollectionUtils.isNotEmpty(equipLedgerIds)){
				logger.info("获取到租出设备台账的自有设备来源数据id集合：{}", JSONObject.toJSONString(equipLedgerIds));
				List<AssetEntity> assetEntityList = (List<AssetEntity>) assetService.listByIds(equipLedgerIds);
				if (CollectionUtils.isNotEmpty(assetEntityList)){
					logger.info("获取到租出设备台账的自有设备来源数据：{}", JSONObject.toJSONString(assetEntityList));
					for (AssetEntity assetEntity : assetEntityList) {
						assetEntity.setRentState(2);//租出状态 启用 1 停用 2
					}
					assetService.saveOrUpdateBatch(assetEntityList, assetEntityList.size(), false);
				}
			}else {
				logger.info("未获取到自购设备来源的设备");
			}
		}

		logger.info("推送项目方数据entity：{}", JSONObject.toJSONString(entity));

		if(entity.getRentHarborType() == 1) { //内租 推项目验收
			OutRentEquipmentStopVO stopVO = BeanMapper.map(entity, OutRentEquipmentStopVO.class);

			//设置项目方需要字段
			//将租出单位信息赋值给组织
			stopVO.setOrgId(entity.getOutOrgId());
			stopVO.setOrgName(entity.getOutOrgName());
			stopVO.setOrgCode(entity.getOutOrgCode());

			//设置项目方所属单位
			stopVO.setCompanyId(entity.getParentOrgId());
			stopVO.setCompanyName(entity.getParentOrgName());
			stopVO.setOrganizationDate(entity.getCreateTime());

			logger.info("stopVO：{}", JSONObject.toJSONString(stopVO));
			stopVO.setRentEquipmentStopSubList(BeanMapper.mapList(entity.getOutRentEquipmentStopSubList(), OutRentEquipmentStopSubVO.class));
			for (OutRentEquipmentStopSubVO stopSubVO : stopVO.getRentEquipmentStopSubList()) {
				stopSubVO.setCategoryName(stopSubVO.getEquipmentType());
				stopSubVO.setName(stopSubVO.getEquipmentName());
			}
			CommonResponse<String> response = receiptsApi.receiptsSync((JSONObject) JSONObject.toJSON(stopVO), RentReceiptsEnum.停用单.getName());
			if(!response.isSuccess()){
				throw new BusinessException(response.getMsg());
			}else {
				logger.info("推送项目方数据成功，结果信息：{}", JSONObject.toJSONString(response.getMsg()));
			}
		}
		return CommonResponse.success("审批回调成功！");
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//更新台账租出状态
		OutRentEquipmentStopEntity entity = outRentEquipmentStopService.selectById(billId);
		if(entity.getSignStatus()==1){
			throw new BusinessException("已签字不能撤回！");
		}

//		logger.info("获取启用单id：{}的子表数据：{}", entity.getId(), JSONObject.toJSONString(entity.getOutRentEquipmentStopSubList()));
//		List<Long> outRentParameterIds = entity.getOutRentEquipmentStopSubList().stream().map(OutRentEquipmentStopSubEntity::getSourceId).collect(Collectors.toList());
//		//停用单子表id集合
//		List<Long> outRentEquipmentStopSubIds = entity.getOutRentEquipmentStopSubList().stream().map(OutRentEquipmentStopSubEntity::getId).collect(Collectors.toList());
//		//修改合同台账租出状态
//		QueryParam outRentParameterQuery = new QueryParam();
//		outRentParameterQuery.getParams().put("id", new Parameter(QueryParam.IN, outRentParameterIds));
//		List<OutRentParameterVO> updateList = BeanMapper.mapList(outRentParameterService.queryList(outRentParameterQuery), OutRentParameterVO.class);
//		logger.info("通过启用单子表sourceId获取台账数据：{}", JSONObject.toJSONString(updateList));
//		if (CollectionUtils.isNotEmpty(updateList)){
//			for (OutRentParameterVO outRentParameterVO : updateList) {
//				if (outRentParameterVO.getRentOutStatus().equals(RentOutStatusEnum.停用.getCode())){
//					outRentParameterVO.setRentOutStatus(RentOutStatusEnum.启用.getCode());
//				}else {
//					throw new BusinessException("当前设备"+ outRentParameterVO.getName() +"在台账中的租出状态已经不是停用状态，不能撤回！");
//				}
//			}
//		}
//		outRentParameterService.saveOrUpdateBatch(BeanMapper.mapList(updateList, OutRentParameterEntity.class), updateList.size(), false);
//		//删除合同台账子表记录信息
//		outRentParameterDetailService.delParameterDetailList(outRentEquipmentStopSubIds, RentParameterTypeEnum.停用单.getCode());

		//撤回台账数据
		List<OutRentEquipmentStopSubEntity> outRentEquipmentStopSubEntityList = entity.getOutRentEquipmentStopSubList();
		List<Long> parameterIdList = outRentEquipmentStopSubEntityList.stream().map(OutRentEquipmentStopSubEntity::getSourceId).collect(Collectors.toList());
		logger.info("推送台账数据parameterIdList：{}", JSONObject.toJSONString(parameterIdList));
		outRentParameterService.cancelParameter(parameterIdList, RentParameterTypeEnum.停用单.getCode(), entity.getId());

		//判断是否自购设备，是：修改自有设备台账设备 停启用状态
		List<Long> outRentParameterIds = outRentEquipmentStopSubEntityList.stream().map(OutRentEquipmentStopSubEntity::getSourceId).collect(Collectors.toList());
		List<OutRentParameterEntity> outRentParameterEntityList = (List<OutRentParameterEntity>) outRentParameterService.listByIds(outRentParameterIds);
		if (CollectionUtils.isNotEmpty(outRentParameterEntityList)){
			logger.info("通过停用子表：{}，取到租出设备台账数据：{}", JSONObject.toJSONString(outRentEquipmentStopSubEntityList), JSONObject.toJSONString(outRentParameterEntityList));
			List<Long> equipLedgerIds = outRentParameterEntityList.stream().filter(item -> item.getSourceType() == 0).map(OutRentParameterEntity::getEquipLedgerId).collect(Collectors.toList());
			if (CollectionUtils.isNotEmpty(equipLedgerIds)){
				logger.info("获取到租出设备台账的自有设备来源数据id集合：{}", JSONObject.toJSONString(equipLedgerIds));
				List<AssetEntity> assetEntityList = (List<AssetEntity>) assetService.listByIds(equipLedgerIds);
				if (CollectionUtils.isNotEmpty(assetEntityList)){
					logger.info("获取到租出设备台账的自有设备来源数据：{}", JSONObject.toJSONString(assetEntityList));
					for (AssetEntity assetEntity : assetEntityList) {
						assetEntity.setRentState(1);//租出状态 启用 1 停用 2
					}
					assetService.saveOrUpdateBatch(assetEntityList, assetEntityList.size(), false);
				}
			}else {
				logger.info("未获取到自购设备来源的设备");
			}
		}

		if(entity.getRentHarborType() == 1) { //内租 推项目验收
			CommonResponse<String> response = receiptsApi.delReceipts(entity.getId(), RentReceiptsEnum.停用单.getName());
			if(!response.isSuccess()){
				throw new BusinessException(response.getMsg());
			}else {
				logger.info("推送项目方数据成功，结果信息：{}", JSONObject.toJSONString(response.getMsg()));
			}
		}

		return CommonResponse.success("审批回调成功！");
	}

}
