package com.ejianc.business.proequipmentcorprent.ac.service;

import com.ejianc.business.proequipmentcorprent.ac.vo.ChangeVO;
import com.ejianc.business.proequipmentcorprent.ac.vo.ContractVO;
import com.ejianc.business.proequipmentcorprent.rent.vo.RentContractChangeVO;
import com.ejianc.business.targetcost.vo.ExecutionVO;
import com.ejianc.business.targetcost.vo.ParamsCheckVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.IBaseService;
import com.ejianc.business.proequipmentcorprent.ac.bean.ChangeEntity;

import java.util.List;
import java.util.Map;

/**
 * 安拆合同变更主实体
 * 
 * @author generator
 * 
 */
public interface IChangeService extends IBaseService<ChangeEntity> {

    ChangeVO queryDetailRecord(Long id);

    Boolean editChangeFlag(Long id);

    ChangeVO insertOrUpdate(ChangeVO saveorUpdateVO);

    ChangeVO queryDetail(Long id);

    ChangeVO addConvertByConId(Long contractId, Long changeId);

    CommonResponse<String> deleteById(Long changeBillId);

    Map<String, Object> queryChangeCompare(Long id);

    ChangeVO queryChangeRecord(Long contractId, Long changeId);

    CommonResponse<String> effectiveSaveWriteContract(Long changeBillId, String billTypeCode, Boolean commitState,Boolean filingFlag);

    ParamsCheckVO targetCostCtrl(ChangeVO changeVo);

    ParamsCheckVO viewTargetCostCtrlInfo(Long id);

    ExecutionVO targetCost(ChangeVO changeVO, String linkUrl, Integer contractType);
    ParamsCheckVO checkParams(ChangeVO vo, ParamsCheckVO paramsCheckVO2);
    /**
     * 单据管控-累计变更金额大于合同金额
     * @return
     */
    List<ParamsCheckVO> checkParamsMny(ChangeVO vo);

    /*施工合同 控 变更
     *        @param 变更合同vo

     * */
    List<ParamsCheckVO> checkParamsConstruction(ChangeVO vo);


    /**
     * 根据变更合同id给水印文件赋值
     *
     * @param id 变更合同id
     */
    void asyncWatermarkById(Long id);

    void updateTotalChangeDataByContractId(ChangeEntity changeEntity, String type);
}
