/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.proequipmentcorppur.purchaseApply.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ejianc.business.proequipmentcorppur.purchaseApply.bean.PurchaseApplyDetailedEntity;
import com.ejianc.business.proequipmentcorppur.purchaseApply.bean.PurchaseApplyEntity;
import com.ejianc.business.proequipmentcorppur.purchaseApply.mapper.PurchaseApplyMapper;
import com.ejianc.business.proequipmentcorppur.purchaseApply.service.IPurchaseApplyDetailedService;
import com.ejianc.business.proequipmentcorppur.purchaseApply.service.IPurchaseApplyService;
import com.ejianc.business.proequipmentcorppur.purchaseApply.vo.PurchaseApplyVO;
import com.ejianc.business.proequipmentcorppur.purchaseplan.bean.PurchasePlanDetailedEntity;
import com.ejianc.business.proequipmentcorppur.purchaseplan.service.IPurchasePlanDetailedService;
import com.ejianc.business.proequipmentcorppur.purchaseplan.vo.PurchasePlanEnum;
import com.ejianc.business.promaterial.plan.vo.BatPlanEnum;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.CollectionUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="purchaseApplyService")
public class PurchaseApplyServiceImpl
extends BaseServiceImpl<PurchaseApplyMapper, PurchaseApplyEntity>
implements IPurchaseApplyService {
    @Autowired
    private PurchaseApplyMapper mapper;
    @Autowired
    private IPurchasePlanDetailedService purchasePlanDetailedService;
    @Autowired
    private IPurchaseApplyDetailedService purchaseApplyDetailedService;

    @Override
    public void saveOrUpdates(PurchaseApplyEntity entity) {
        List<PurchaseApplyDetailedEntity> listbs = entity.getDetailList();
        if (CollectionUtil.isNotEmpty(listbs)) {
            ArrayList<Long> planSubIds = new ArrayList<Long>();
            StringBuilder equipmentTypes = new StringBuilder();
            HashMap<Long, Long> idMap = new HashMap<Long, Long>();
            for (PurchaseApplyDetailedEntity cdEntity : listbs) {
                planSubIds.add(cdEntity.getSourceId());
                if (!"del".equals(cdEntity.getRowState())) {
                    equipmentTypes.append(cdEntity.getEquipmentName()).append(",");
                }
                if (null != cdEntity.getParentId()) continue;
                idMap.put(cdEntity.getDocCategoryId(), cdEntity.getId());
            }
            PurchasePlanDetailedEntity tmp = null;
            QueryWrapper planSubQuery = new QueryWrapper();
            planSubQuery.in((Object)"id", planSubIds);
            List planSubList = this.purchasePlanDetailedService.list((Wrapper)planSubQuery);
            Map<Long, PurchasePlanDetailedEntity> planSubMap = planSubList.stream().collect(Collectors.toMap(BaseEntity::getId, item -> item));
            if (null != entity.getId()) {
                PurchaseApplyEntity dbEntity = (PurchaseApplyEntity)((Object)super.selectById((Serializable)entity.getId()));
                for (PurchaseApplyDetailedEntity cdEntity : dbEntity.getDetailList()) {
                    tmp = planSubMap.get(cdEntity.getSourceId());
                    tmp.setAppliedNum(tmp.getAppliedNum() - cdEntity.getPlanNum());
                    tmp.setRemainingNum(tmp.getPlanNum() - tmp.getAppliedNum());
                }
            }
            for (PurchaseApplyDetailedEntity cdEntity : listbs) {
                if (null != cdEntity.getParentId()) {
                    cdEntity.setParentId((Long)idMap.get(cdEntity.getDocCategoryId()));
                    cdEntity.setTid(cdEntity.getId());
                } else {
                    cdEntity.setTid(cdEntity.getId());
                }
                if ("del".equals(cdEntity.getRowState())) continue;
                tmp = planSubMap.get(cdEntity.getSourceId());
                tmp.setAppliedNum(tmp.getAppliedNum() + cdEntity.getPlanNum());
                tmp.setRemainingNum(tmp.getPlanNum() - tmp.getAppliedNum());
            }
            boolean updateResult = this.purchasePlanDetailedService.saveOrUpdateBatch(planSubList);
            if (!updateResult) {
                throw new BusinessException("\u4fdd\u5b58\u5931\u8d25\uff0c\u66f4\u65b0\u8ba1\u5212\u5df2\u7533\u8bf7\u6570\u91cf\u5931\u8d25\uff01");
            }
            entity.setEquipmentTypes(equipmentTypes.substring(0, equipmentTypes.length() - 1));
        }
        super.saveOrUpdate((Object)entity, false);
    }

    @Override
    public List<PurchaseApplyVO> queryApplyListByOrgId(Long orgId) {
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"org_id", (Object)orgId);
        List entities = super.list((Wrapper)query);
        return BeanMapper.mapList((Iterable)entities, PurchaseApplyVO.class);
    }

    @Override
    public Boolean checkSameBillCode(PurchaseApplyVO contractVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.eq(PurchaseApplyEntity::getBillCode, (Object)contractVO.getBillCode());
        lambda.eq(BaseEntity::getTenantId, (Object)tenantId);
        if (null != contractVO.getId() && contractVO.getId() > 0L) {
            lambda.ne(BaseEntity::getId, (Object)contractVO.getId());
        }
        return super.list((Wrapper)lambda).size() > 0;
    }

    @Override
    public void updateBatApplyByQuoteType(List<String> idList, Integer planState) {
        List entityList;
        if (StringUtils.isEmpty((CharSequence)PurchasePlanEnum.getDescriptionByStateCode((Integer)planState))) {
            throw new BusinessException("\u8ba1\u5212\u72b6\u6001\u9519\u8bef");
        }
        if (CollectionUtils.isNotEmpty(idList) && CollectionUtils.isNotEmpty((Collection)(entityList = (List)super.listByIds(idList)))) {
            for (PurchaseApplyEntity entity : entityList) {
                if (BatPlanEnum.PLAN_STATE_OVER.getPlanState().equals(entity.getPlanState())) {
                    throw new BusinessException("\u91c7\u8d2d\u8ba1\u5212\u7f16\u7801\u3010" + entity.getBillCode() + "\u3011\u5df2\u91c7\u8d2d\u5b8c\u6210\uff01");
                }
                entity.setPlanState(planState);
            }
            super.saveOrUpdateBatch((Collection)entityList);
        }
    }

    @Override
    public void removeBatch(List<Long> applyIds) {
        QueryWrapper detailQuery = new QueryWrapper();
        detailQuery.in((Object)"apply_id", applyIds);
        detailQuery.eq((Object)"dr", (Object)0);
        List detailList = this.purchaseApplyDetailedService.list((Wrapper)detailQuery);
        PurchasePlanDetailedEntity tmp = null;
        QueryWrapper planSubQuery = new QueryWrapper();
        planSubQuery.in((Object)"id", (Collection)detailList.stream().map(PurchaseApplyDetailedEntity::getSourceId).collect(Collectors.toList()));
        List planSubList = this.purchasePlanDetailedService.list((Wrapper)planSubQuery);
        Map<Long, PurchasePlanDetailedEntity> planSubMap = planSubList.stream().collect(Collectors.toMap(BaseEntity::getId, item -> item));
        for (PurchaseApplyDetailedEntity detail : detailList) {
            tmp = planSubMap.get(detail.getSourceId());
            tmp.setAppliedNum(tmp.getAppliedNum() - detail.getPlanNum());
            tmp.setRemainingNum(tmp.getPlanNum() - tmp.getAppliedNum());
        }
        boolean updateResult = this.purchasePlanDetailedService.saveOrUpdateBatch(planSubList);
        if (!updateResult) {
            throw new BusinessException("\u66f4\u65b0\u8ba1\u5212\u5df2\u7533\u8bf7\u6570\u91cf\u5931\u8d25\uff01");
        }
        super.removeByIds(applyIds, false);
    }
}

