package com.ejianc.business.proequipmentcorppur.acceptance.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.proequipmentcorppur.acceptance.bean.PurchaseAcceptanceEntity;
import com.ejianc.business.proequipmentcorppur.acceptance.bean.PurchaseAcceptanceSubEntity;
import com.ejianc.business.proequipmentcorppur.acceptance.mapper.PurchaseAcceptanceMapper;
import com.ejianc.business.proequipmentcorppur.acceptance.service.IPurchaseAcceptanceService;
import com.ejianc.business.proequipmentcorppur.acceptance.service.IPurchaseAcceptanceSubService;
import com.ejianc.business.proequipmentcorppur.acceptance.vo.PurchaseAcceptanceVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 购置验收表
 * 
 * @author generator
 * 
 */
@Service("purchaseAcceptanceService")
public class PurchaseAcceptanceServiceImpl extends BaseServiceImpl<PurchaseAcceptanceMapper, PurchaseAcceptanceEntity> implements IPurchaseAcceptanceService{

    @Autowired
    private IPurchaseAcceptanceSubService purchaseAcceptanceSubService;

    @Override
    public IPage<PurchaseAcceptanceVO> refPurchaseAcceptanceData(QueryParam param, Long contractId, Integer pageNumber, Integer pageSize) {
        IPage<PurchaseAcceptanceVO> page = new Page<>(param.getPageIndex(), param.getPageSize());
        List<PurchaseAcceptanceVO> list = baseMapper.refPurchaseAcceptanceData(changeToQueryWrapper(param),contractId, page);
        IPage<PurchaseAcceptanceVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(list);
        return pageData;
    }


    /**
     * 根据项目id、验收日期查询设备采购单据数量
     *
     * @param projectId 项目id
     * @param checkDate 验收日期
     *
     * @return Integer
     */
    @Override
    public Integer countBillNum(Long projectId, Date checkDate) {
        LambdaQueryWrapper<PurchaseAcceptanceEntity> lambdaQuery = Wrappers.lambdaQuery();
        lambdaQuery.eq(PurchaseAcceptanceEntity::getProjectId, projectId)
                .eq(PurchaseAcceptanceEntity::getAcceptanceDate, checkDate);
        return super.count(lambdaQuery);
    }

    @Override
    public PurchaseAcceptanceVO saveOrUpdateAccepts(PurchaseAcceptanceEntity entity) {
        //保存前校验
        this.validateSave(entity);
        this.saveOrUpdate(entity, false);
        return BeanMapper.map(entity, PurchaseAcceptanceVO.class);
    }

    /**
     * 保存前校验
     *
     * @param entity
     * @return
     */
    private String validateSave(PurchaseAcceptanceEntity entity) {
        if(entity.getAcceptanceStandardSectionFlag() == 0) {
            //新增设备验收的时候 验证设备编码是否重复
            List<PurchaseAcceptanceSubEntity> subList = entity.getPurchaseAcceptanceSubList();
            if (CollectionUtils.isNotEmpty(entity.getPurchaseAcceptanceSubList())) {
                List<Long> delRowIds = new ArrayList<>();
                for (int i = 0; i < subList.size(); i++) {
                    PurchaseAcceptanceSubEntity sub = entity.getPurchaseAcceptanceSubList().get(i);
                    if("del".equals(sub.getRowState())) {
                        delRowIds.add(sub.getId());
                        continue;
                    }

                    if (StringUtils.isEmpty(sub.getEquipmentFactoryCode())) {
                        sub.setEquipmentFactoryCode(randomCode() + "");
                    }
                    for (int j = i + 1; j < subList.size(); j++) {
                        PurchaseAcceptanceSubEntity subEntity = subList.get(j);

                        if (sub.getEquipmentFactoryCode().equals(subEntity.getEquipmentFactoryCode())) {
                            throw new BusinessException("设备出厂编码重复" + subEntity.getEquipmentFactoryCode());
                        }
                    }
                    List<PurchaseAcceptanceSubEntity> dbByCodeList = this.selectFactoryCode(sub.getEquipmentFactoryCode());
                    for(PurchaseAcceptanceSubEntity acceptanceSubEntity : dbByCodeList) {
                        if(delRowIds.contains(acceptanceSubEntity.getId()) || (null != sub.getId() && acceptanceSubEntity.getId().equals(sub.getId()))) {
                            continue;
                        }
                        throw new BusinessException("设备出厂编码-[" + acceptanceSubEntity.getEquipmentFactoryCode() + "]重复" );
                    }
                }
            }
        } else {
            //标准节则校验是否存在对应出厂编码的已验收的设备
            if (CollectionUtils.isNotEmpty(entity.getPurchaseAcceptanceSubList())) {
                List<String> factoryCodes = entity.getPurchaseAcceptanceSubList().stream().filter(item -> !"del".equals(item.getRowState())).map(PurchaseAcceptanceSubEntity::getEquipmentFactoryCode).collect(Collectors.toList());
                QueryWrapper<PurchaseAcceptanceSubEntity> query = new QueryWrapper<>();
                query.eq("tenant_id", InvocationInfoProxy.getTenantid());
                query.eq("dr", BaseVO.DR_UNDELETE);
                query.in("equipment_factory_code", factoryCodes);

                List<PurchaseAcceptanceSubEntity> equipList = purchaseAcceptanceSubService.list(query);
                for(PurchaseAcceptanceSubEntity equip : equipList) {
                    factoryCodes.remove(equip.getEquipmentFactoryCode());
                }
                if(CollectionUtils.isNotEmpty(factoryCodes)) {
                    throw new BusinessException("设备出厂编码-[" + StringUtils.join(factoryCodes, ",") + "]无对匹配的已验收设备");
                }
            }
        }


        return null;
    }

    private static Long randomCode()  {
        SecureRandom secureRandom = null;
        try {
            secureRandom = SecureRandom.getInstance("SHA1PRNG");
        } catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        secureRandom.setSeed(1000000L);
        return secureRandom.nextInt(10000)+System.currentTimeMillis();
    }

    /**
     * 根据出场编码查询匹配的采购设备验收列表
     * @return
     */
    public List<PurchaseAcceptanceSubEntity> selectFactoryCode(String factoryCode){
        QueryWrapper<PurchaseAcceptanceSubEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr","0");
        queryWrapper.eq("equipment_factory_code",factoryCode);
        return purchaseAcceptanceSubService.list(queryWrapper);
    }
}
