package com.ejianc.business.proequipmentcorppur.asset.service;

import com.ejianc.business.proequipmentcorppur.asset.bean.AssetAllotInEntity;
import com.ejianc.business.proequipmentcorppur.consts.NoticeEnum;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/**
 * @author jiangyikai
 * @version 1.0
 * @description: 微信公众号消息通知
 * @date 2021/10/20
 */
@Service
public class AssetAllotInMessageService {

    private final Logger logger = LoggerFactory.getLogger(getClass());


    @Value("${common.env.base-host}")
    private String baseHost;

    @Autowired
    private IPushMessageApi pushMessageApi;


    public CommonResponse<String> sendMsg(AssetAllotInEntity allotinentity, String[] receivers, NoticeEnum notice) {
        if (allotinentity != null) {
            PushMsgParameter parameter = new PushMsgParameter();
            List<String> channel = new ArrayList<>();
            channel.add(PushMsgParameter.CHANNEL_TYPE_SYS);

            HashMap<String, String> keyMap = new HashMap<>();
            keyMap.put("#BILLCODE#", allotinentity.getBillCode());
            keyMap.put("#ID#", String.valueOf(allotinentity.getId()));
            keyMap.put("#BASEHOST#", baseHost);

            parameter.setReceivers(receivers);// 收信人
            parameter.setChannel(channel.toArray(new String[channel.size()]));// 消息类型
            parameter.setMsgType("notice");
            parameter.setSubject(notice.getSubject());// 标题
            logger.info("==============================系统消息===================================================");
            String sysContent = NoticeEnum.getPcContent(notice, keyMap);
            logger.info("sysContent = "+ sysContent);
            parameter.setContent(sysContent);// 内容
            parameter.setTenantId(InvocationInfoProxy.getTenantid().toString());
            parameter.setSendUserId(InvocationInfoProxy.getUserid());
            try {
                CommonResponse<String> result = pushMessageApi.pushMessage(parameter);
                if (result.isSuccess()) {
                    logger.error("消息发送成功---------------->" + result.getMsg());
                } else {
                    logger.error("消息发送失败---------------->" + result.getMsg());
                }
            } catch (Exception e) {
                logger.error("调用消息中心RPC服务异常--------------" + e);
            }
        }
        return CommonResponse.success();
    }

    ;
}
